/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.StoreAlreadyCloseException;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class StoreUtil {
    public static StoreSession getCurrentStoreSession() {
        return StoreSessionDAO.getInstance().getLastStoreSession();
    }

    public static boolean isStoreOpen() {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        return storeSession != null && storeSession.isOpen();
    }

    public static void openStore(User user) {
        Outlet outlet = DataProvider.get().getOutlet();
        StoreUtil.openStore(user, outlet == null ? null : outlet.getId());
    }

    public static void openStore(User user, String string) {
        if (StoreUtil.isStoreOpen()) {
            throw new StoreAlreadyOpenException(Messages.getString("StoreUtil.0"));
        }
        StoreSession storeSession = new StoreSession();
        storeSession.setOpenedBy(user);
        storeSession.setOpenTime(new Date());
        storeSession.setOutletId(string);
        SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get("TICKET_TOKEN_NUMBER");
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber("TICKET_TOKEN_NUMBER");
        }
        Store store = DataProvider.get().getStore();
        boolean bl = store.getBooleanProperty("reset.token", true);
        String string2 = store.getProperty("token_no.start");
        Integer n = POSUtil.parseInteger(string2);
        if (bl) {
            if (n > 0) {
                sequenceNumber.setNextSequenceNumber(n);
            } else {
                sequenceNumber.setNextSequenceNumber(1);
            }
        }
        StoreSessionDAO.getInstance().save(storeSession);
        DataProvider.get().setStoreSession(storeSession);
        StoreSessionControl storeSessionControl = StoreUtil.a();
        if (storeSessionControl != null) {
            storeSessionControl.setCurrentData(storeSession);
        }
        TerminalDAO.getInstance().performBatchSave(sequenceNumber, storeSessionControl);
    }

    public static void closeStore(User user) throws Exception {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        if (!storeSession.isOpen()) {
            throw new StoreAlreadyCloseException("Store is already closed.");
        }
        StoreDAO.getInstance().closeStore(storeSession, user);
        DataProvider.get().setStoreSession(null);
    }

    @Deprecated
    private static StoreSessionControl a() {
        return StoreSessionControlDAO.getInstance().getCurrent();
    }

    public static void closeStore(Session session, User user) throws Exception {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        if (!storeSession.isOpen()) {
            throw new StoreAlreadyCloseException("Store is already closed.");
        }
        StoreDAO.getInstance().closeStore(session, storeSession, user);
        DataProvider.get().setStoreSession(null);
    }

    public static int getQuickTenderButtonValue(int n, int n2, Store store) {
        return POSUtil.parseInteger(store.getProperty("quick_tender_input.button_value" + n, String.valueOf(n2)));
    }

    public static void setQuickTenderButtonValue(int n, String string, Store store) {
        store.addProperty("quick_tender_input.button_value" + n, string);
    }

    public static String getQuickTenderButtonText(int n, String string, Store store) {
        return store.getProperty("quick_tender_input.button_text" + n, string);
    }

    public static void setQuickTenderButtonText(int n, String string, Store store) {
        store.addProperty("quick_tender_input.button_text" + n, string);
    }

    public static void setQuickTenderButtonFontSize(int n, Store store) {
        store.addProperty("quick_tender_input.button_font_size", String.valueOf(n));
    }

    public static int getQuickTenderButtonFontSize(Store store) {
        String string = store.getProperty("quick_tender_input.button_font_size");
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return 24;
            }
        }
        return 24;
    }
}

