/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeletedData;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.ImageUtil;
import com.floreantpos.util.XMLTransientUtil;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;

public class CloudDataUploader {
    private static Logger a = Logger.getLogger(CloudDataUploader.class);
    private ProgressObserver b;
    private PosWebService c;
    private boolean d;
    private boolean e;
    private boolean f;
    private int g;
    private Date h;
    private Date i;
    private Integer j = 1;
    private Integer k = 0;
    private List<DataSyncInfo> l = new ArrayList<DataSyncInfo>();

    public CloudDataUploader(ProgressObserver progressObserver, Date date, Date date2) {
        this.b = progressObserver;
        this.c = PosWebService.get();
        this.h = date;
        this.i = date2;
    }

    public void uploadLocalSettings() throws Exception {
        this.e = true;
        this.d = true;
        this.k = 0;
        this.a(Messages.getString("SyncService.76"));
        this.uploadAddress();
        this.uploadStore();
        this.R();
        this.uploadCurrency();
        this.uploadTaxes();
    }

    public Integer uploadAllData(boolean bl, Integer n) throws Exception {
        this.d = bl;
        this.k = n;
        this.g = 0;
        this.j = 1;
        return this.a();
    }

    private Integer a() throws Exception {
        this.f = false;
        List<Department> list = null;
        List<OrderType> list2 = null;
        List<TerminalType> list3 = null;
        PosLog.info(this.getClass(), "  =======================Starting Upload=======================");
        if (!this.e) {
            this.R();
        }
        this.W();
        this.i();
        if (!this.e) {
            this.uploadCurrency();
        }
        this.uploadShift();
        this.z();
        this.b();
        this.A();
        list3 = this.x();
        this.y();
        if (!this.e) {
            this.uploadTaxes();
        }
        list2 = this.U();
        list = this.V();
        this.al();
        this.am();
        this.T();
        this.S();
        this.h();
        this.C();
        this.g();
        this.d();
        this.O();
        this.N();
        this.Q();
        this.P();
        this.w();
        this.v();
        this.G();
        this.H();
        this.D();
        this.B();
        this.I();
        this.J();
        this.E();
        this.F();
        this.K();
        this.L();
        this.uploadShopTablesStatus();
        this.M();
        this.uploadBookingInfos();
        this.uploadTickets();
        if (!this.e) {
            this.uploadAddress();
        }
        this.ao();
        this.t();
        this.s();
        this.r();
        this.q();
        this.p();
        this.o();
        this.n();
        this.l();
        this.m();
        this.k();
        this.Y();
        this.X();
        this.Z();
        this.aa();
        this.ab();
        this.ac();
        this.ad();
        this.ae();
        this.af();
        this.ag();
        this.ah();
        this.aj();
        this.j();
        this.ak();
        this.e();
        this.f();
        if (list != null && list.size() > 0) {
            this.e(list);
        }
        if (list2 != null && list2.size() > 0) {
            this.c(list2);
        }
        if (list3 != null && list3.size() > 0) {
            this.d(list3);
        }
        if (this.f) {
            GenericDAO.getInstance().updateOutletRelatedModelsIfNullExists(SyncService.getOutletRelatedModelClasses());
        }
        if (this.g == 0) {
            this.b("Nothing to upload. Everything is up to date.");
        } else {
            PosLog.info(this.getClass(), "=======================Upload Finished=======================");
        }
        return this.k;
    }

    public boolean uploadStore() throws Exception {
        this.a(this.k, Messages.getString("CloudDataUploader.55"));
        PosLog.info(this.getClass(), "");
        List<Store> list = StoreDAO.getInstance().findAll();
        this.b(list, " store.");
        if (list != null && !list.isEmpty()) {
            try {
                for (TimedModel timedModel : list) {
                    timedModel.setLastUpdateTime(this.h);
                }
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Store>>(list){}, "store");
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("Connection refused")) {
                    throw new PosException("Connection failed.");
                }
                this.a(exception);
                return false;
            }
        }
        return true;
    }

    private void b() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(StoreSessionControl.class, this.d, this.i);
        this.a(list, " store session control.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.57"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StoreSessionControl storeSessionControl : list) {
                arrayList.add(storeSessionControl.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<StoreSessionControl>>(list){}, "storesessioncontrol");
                this.b(dataSyncInfo, arrayList, StoreSessionControl.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void c() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(MenuPage.class, this.d, this.i);
        this.a(list, " menu page.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.53"));
            for (MenuPage menuPage : list) {
                arrayList.add(menuPage.getId());
                XMLTransientUtil.makeXMLTransient(menuPage);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<MenuPage>>(list){}, "menuPage");
                this.b(dataSyncInfo, arrayList, MenuPage.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void d() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PizzaPrice.class, this.d, this.i);
        this.a(list, " pizza price.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.52"));
            for (PizzaPrice pizzaPrice : list) {
                arrayList.add(pizzaPrice.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PizzaPrice>>(list){}, "pizzaPrice");
                this.b(dataSyncInfo, arrayList, PizzaPrice.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void e() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PriceTable.class, this.d, this.i);
        this.a(list, " price table.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading price table");
            for (PriceTable priceTable : list) {
                if (StringUtils.isBlank((String)priceTable.getOutletId())) {
                    this.f = true;
                    priceTable.setOutletId(this.an());
                }
                priceTable.setPriceTableItems(PriceTableItemDAO.getInstance().getItemsByPriceTable(priceTable, true));
                arrayList.add(priceTable.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PriceTable>>(list){}, "priceTable");
                this.b(dataSyncInfo, arrayList, PriceTable.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void f() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PriceRule.class, this.d, this.i);
        this.a(list, " price rule.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading price rule");
            for (PriceRule priceRule : list) {
                if (StringUtils.isBlank((String)priceRule.getOutletId())) {
                    this.f = true;
                    priceRule.setOutletId(this.an());
                }
                arrayList.add(priceRule.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PriceRule>>(list){}, "priceRule");
                this.b(dataSyncInfo, arrayList, PriceRule.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void g() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PizzaCrust.class, this.d, this.i);
        this.a(list, Messages.getString("CloudDataUploader.66"));
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.51"));
            for (PizzaCrust pizzaCrust : list) {
                arrayList.add(pizzaCrust.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PizzaCrust>>(list){}, "pizzaCrust");
                this.b(dataSyncInfo, arrayList, PizzaCrust.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void h() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Multiplier.class, this.d, this.i);
        this.a(list, Messages.getString("CloudDataUploader.48"));
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.48"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Multiplier multiplier : list) {
                arrayList.add(multiplier.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Multiplier>>(list){}, "multiplier");
                this.b(dataSyncInfo, arrayList, Multiplier.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void i() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(ImageResource.class, this.d, this.i);
        this.a(list, " image resources.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.56"));
            for (ImageResource imageResource : list) {
                this.a(imageResource);
                arrayList.add(imageResource.getId());
                imageResource.setImageData(null);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ImageResource>>(list){}, "imageResources");
                this.b(dataSyncInfo, arrayList, ImageResource.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(ImageResource imageResource) {
        try {
            String string = imageResource.getProperty("imageFormat");
            if (!ImageUtil.IMAGE_FORMAT_PNG.equals(string)) {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageResource.getImageBytes()));
                byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage);
                if (byArray.length / 1024 > 1000) {
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    bufferedImage = ImageUtil.doScaleImageWithRatio(bufferedImage, true, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
                imageResource.setImageData(null);
                imageResource.addProperty("imageFormat", ImageUtil.IMAGE_FORMAT_PNG);
                imageResource.setImageBytes(ImageUtil.convertImageToByteArray(bufferedImage));
                ImageResourceDAO.getInstance().update(imageResource);
            }
        }
        catch (IOException iOException) {
            PosLog.error(this.getClass(), iOException);
        }
    }

    private void j() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(GratuityPaymentHistory.class, this.d, this.i);
        this.a(list, " gratuity payment history.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.46"));
            for (GratuityPaymentHistory gratuityPaymentHistory : list) {
                arrayList.add(gratuityPaymentHistory.getId());
                XMLTransientUtil.makeXMLTransient(gratuityPaymentHistory);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<GratuityPaymentHistory>>(list){}, "gratuityPaymentHistory");
                this.b(dataSyncInfo, arrayList, GratuityPaymentHistory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void k() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(GiftCard.class, this.d, this.i);
        this.a(list, " gift card.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.45"));
            for (GiftCard giftCard : list) {
                arrayList.add(giftCard.getCardNumber());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<GiftCard>>(list){}, "giftCard");
                this.b(dataSyncInfo, arrayList, GiftCard.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void l() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryInstruction.class, this.d, this.i);
        this.a(list, " delivery instruction.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.47"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryInstruction deliveryInstruction : list) {
                arrayList.add(deliveryInstruction.getId());
                XMLTransientUtil.makeXMLTransient(deliveryInstruction.getCustomer());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<DeliveryInstruction>>(list){}, "deliveryInstruction");
                this.b(dataSyncInfo, arrayList, DeliveryInstruction.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void m() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Discount.class, this.d, this.i);
        this.a(list, " discount.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.44"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Discount discount : list) {
                arrayList.add(discount.getId());
                XMLTransientUtil.makeLazy(discount);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Discount>>(list){}, "discount");
                this.b(dataSyncInfo, arrayList, Discount.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void n() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryCharge.class, this.d, this.i);
        this.a(list, " delivery charge.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.43"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryCharge deliveryCharge : list) {
                arrayList.add(deliveryCharge.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<DeliveryCharge>>(list){}, "deliveryCharge");
                this.b(dataSyncInfo, arrayList, DeliveryCharge.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void o() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryAddress.class, this.d, this.i);
        this.a(list, " delivery address.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.42"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryAddress deliveryAddress : list) {
                arrayList.add(deliveryAddress.getId());
                String string = deliveryAddress.getCustomerId();
                deliveryAddress.setCustomer(null);
                deliveryAddress.setCustomerId(string);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<DeliveryAddress>>(list){}, "deliveryAddress");
                this.b(dataSyncInfo, arrayList, DeliveryAddress.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void p() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeclaredTips.class, this.d, this.i);
        this.a(list, " declared tips.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.41"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeclaredTips declaredTips : list) {
                arrayList.add(declaredTips.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<DeclaredTips>>(list){}, "declaredTips");
                this.b(dataSyncInfo, arrayList, DeclaredTips.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void q() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CustomPayment.class, this.d, this.i);
        this.a(list, " custom payment.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.40"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CustomPayment customPayment : list) {
                arrayList.add(customPayment.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<CustomPayment>>(list){}, "customPayment");
                this.b(dataSyncInfo, arrayList, CustomPayment.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private Date a(DataSyncInfo dataSyncInfo) {
        return dataSyncInfo.getLastUpdateTime();
    }

    private void r() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CustomerGroup.class, this.d, this.i);
        this.a(list, " customer group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.39"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CustomerGroup customerGroup : list) {
                arrayList.add(customerGroup.getId());
                CustomerGroupDAO.getInstance().initialize(customerGroup);
                customerGroup.setLastUpdateTime(this.h);
                this.a(customerGroup.getCustomers());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<CustomerGroup>>(list){}, "customerGroup");
                this.b(dataSyncInfo, arrayList, CustomerGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(List<Customer> list) {
        if (list == null) {
            return;
        }
        for (Customer customer : list) {
            XMLTransientUtil.makeXMLTransient(customer);
        }
    }

    private void s() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Course.class, this.d, this.i);
        this.a(list, " course.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.38"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Course course : list) {
                arrayList.add(course.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Course>>(list){}, "course");
                this.b(dataSyncInfo, arrayList, Course.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void t() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CookingInstruction.class, this.d, this.i);
        this.a(list, " cooking instructions.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.37"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CookingInstruction cookingInstruction : list) {
                arrayList.add(cookingInstruction.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<CookingInstruction>>(list){}, "cookingInstruction");
                this.b(dataSyncInfo, arrayList, CookingInstruction.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void u() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeletedData.class, this.d, this.i);
        this.a(list, " deleted data.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading deleted data...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeletedData deletedData : list) {
                arrayList.add(deletedData.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<DeletedData>>(list){}, "deletedData");
                this.b(dataSyncInfo, arrayList, DeletedData.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void v() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Attribute.class, this.d, this.i);
        this.a(list, " attribute.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.17"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Attribute attribute : list) {
                arrayList.add(attribute.getId());
                XMLTransientUtil.makeXMLTransient(attribute.getGroup());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Attribute>>(list){}, "attribute");
                this.b(dataSyncInfo, arrayList, Attribute.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void w() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(AttributeGroup.class, this.d, this.i);
        this.a(list, " attribute group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.16"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttributeGroup attributeGroup : list) {
                arrayList.add(attributeGroup.getId());
                attributeGroup.setAttributes(null);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<AttributeGroup>>(list){}, "attributeGroup");
                this.b(dataSyncInfo, arrayList, AttributeGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private List<TerminalType> x() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(TerminalType.class, this.d, this.i);
        this.a(list, " terminal type.");
        ArrayList<TerminalType> arrayList = new ArrayList<TerminalType>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.4"));
            for (TerminalType terminalType : list) {
                TerminalTypeDAO.getInstance().initialize(terminalType);
                terminalType.setLastUpdateTime(this.h);
                TerminalType terminalType2 = XMLTransientUtil.getLazyData(terminalType);
                if (terminalType2 != null) {
                    arrayList.add(terminalType2);
                }
                arrayList2.add(terminalType.getId());
                XMLTransientUtil.makeXMLTransient(terminalType);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<TerminalType>>(list){}, "terminalType");
                this.b(dataSyncInfo, arrayList2, TerminalType.REF);
                this.a(arrayList2.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        return arrayList;
    }

    private void y() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Terminal.class, this.d, this.i);
        this.a(list, " terminal.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.4"));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Terminal terminal : list) {
                terminal.setProperties(null);
                arrayList.add(terminal.getId());
                if (!StringUtils.isBlank((String)terminal.getOutletId())) continue;
                this.f = true;
                terminal.setOutletId(this.an());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Terminal>>(list){}, "terminal");
                this.a(dataSyncInfo, arrayList, Terminal.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void z() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(StoreSession.class, this.d, this.i);
        this.a(list, " store session.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.2"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StoreSession storeSession : list) {
                if (StringUtils.isEmpty((String)storeSession.getOutletId())) {
                    this.f = true;
                    storeSession.setOutletId(this.an());
                }
                XMLTransientUtil.makeXMLTransient(storeSession.getClosedBy());
                XMLTransientUtil.makeXMLTransient(storeSession.getOpenedBy());
                arrayList.add(storeSession.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<StoreSession>>(list){}, "storesession");
                this.b(dataSyncInfo, arrayList, StoreSession.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadTickets() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Ticket.class, this.d, this.i);
        this.a(list, " ticket.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.h);
        calendar.set(14, calendar.getMinimum(14));
        Date date = calendar.getTime();
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.33"));
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (Ticket ticket : list) {
                TicketDAO.getInstance().loadFullTicket(ticket);
                Gratuity gratuity = ticket.getGratuity();
                if (StringUtils.isBlank((String)ticket.getOutletId())) {
                    this.f = true;
                    ticket.setOutletId(this.an());
                }
                if (gratuity != null) {
                    gratuity.setLastUpdateTime(date);
                    if (StringUtils.isBlank((String)gratuity.getOutletId())) {
                        this.f = true;
                        gratuity.setOutletId(this.an());
                    }
                }
                if (ticket.getTransactions() != null && ticket.getTransactions().size() > 0) {
                    for (PosTransaction posTransaction : ticket.getTransactions()) {
                        if (!StringUtils.isBlank((String)posTransaction.getOutletId())) continue;
                        this.f = true;
                        posTransaction.setOutletId(this.an());
                    }
                }
                XMLTransientUtil.makeXMLTransient(ticket);
                arrayList.add(ticket);
            }
            this.doSendTicketToCloud(arrayList);
        }
    }

    public void uploadTicketIfOnlineOrder(Ticket ticket) {
        if (ticket == null || !ticket.isShouldPublishMqtt() || ticket.getType().intValue() != TicketType.ONLINE.getTypeNo()) {
            return;
        }
        if (!this.c.isCloudConfigured()) {
            return;
        }
        AsyncAction.execute(() -> {
            try {
                Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                XMLTransientUtil.makeXMLTransient(ticket2);
                ticket2.setOutletId(DataProvider.get().getStore().getDefaultOutletId());
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                arrayList.add(ticket2);
                GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(arrayList){};
                PosLog.debug(CloudDataUploader.class, "Ticket uploading: " + ticket2.getId() + " Gratuity: " + ticket2.getGratuity());
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)genericEntity, "tickets", true);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), "Failed to upload ticket : " + ticket.getId() + " " + exception.getMessage());
            }
        });
    }

    public void doSendTicketToCloud(List<Ticket> list) throws Exception {
        try {
            GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(list){};
            DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)genericEntity, "tickets");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Ticket ticket : list) {
                arrayList.add(ticket.getId());
            }
            this.a(dataSyncInfo, arrayList);
            this.a(arrayList.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void A() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CashDrawer.class, this.d, this.i);
        this.a(list, " cash drawer.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.3"));
            this.b(list);
        }
    }

    private void b(List<CashDrawer> list) {
        try {
            DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<CashDrawer>>(list){}, "cashdrawers");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CashDrawer cashDrawer : list) {
                arrayList.add(cashDrawer.getId());
                if (!StringUtils.isBlank((String)cashDrawer.getOutletId())) continue;
                this.f = true;
                cashDrawer.setOutletId(this.an());
            }
            this.b(dataSyncInfo, arrayList, CashDrawer.REF);
            this.a(arrayList.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void B() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuItem.class, this.d, this.i);
        this.a(list, " menu item.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.18"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuItem menuItem : list) {
                menuItem.setAttributes(null);
                arrayList.add(menuItem.getId());
                XMLTransientUtil.makeXMLTransientMenuItem(menuItem);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<MenuItem>>(list){}, "menuitem");
                this.b(dataSyncInfo, arrayList, MenuItem.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void C() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuItemSize.class, this.d, this.i);
        this.a(list, " menu item size.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.19"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuItemSize menuItemSize : list) {
                arrayList.add(menuItemSize.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<MenuItemSize>>(list){}, "menuitemsizes");
                this.b(dataSyncInfo, arrayList, MenuItemSize.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void D() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PackagingUnit.class, this.d, this.i);
        this.a(list, " packaging unit.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.24"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PackagingUnit packagingUnit : list) {
                arrayList.add(packagingUnit.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PackagingUnit>>(list){}, "packagingunits");
                this.b(dataSyncInfo, arrayList, PackagingUnit.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void E() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryLocation.class, this.d, this.i);
        this.a(list, " inventory location.");
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = DataProvider.get().getCurrentOutletId();
            Object object = list.iterator();
            while (object.hasNext()) {
                InventoryLocation inventoryLocation = (InventoryLocation)object.next();
                if (StringUtils.isBlank((String)inventoryLocation.getOutletId())) {
                    this.f = true;
                } else if (inventoryLocation.isDeleted().booleanValue() && !inventoryLocation.getOutletId().equals(string)) {
                    object.remove();
                    continue;
                }
                inventoryLocation.setOutletId(string);
                arrayList.add(inventoryLocation.getId());
                XMLTransientUtil.makeXMLTransient(inventoryLocation);
            }
            if (list.size() > 0) {
                try {
                    this.c(Messages.getString("CloudDataUploader.26"));
                    object = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryLocation>>(list){}, "inventorylocation");
                    this.b((DataSyncInfo)object, arrayList, InventoryLocation.REF);
                    this.a(arrayList.size());
                }
                catch (Exception exception) {
                    this.a(exception);
                }
            }
        }
    }

    private void F() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryTransaction.class, this.d, this.i);
        this.a(list, " inventory transaction.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.27"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryTransaction inventoryTransaction : list) {
                arrayList.add(inventoryTransaction.getId());
                XMLTransientUtil.makeXMLTransient(inventoryTransaction);
                if (!StringUtils.isBlank((String)inventoryTransaction.getOutletId())) continue;
                this.f = true;
                inventoryTransaction.setOutletId(this.an());
            }
            this.doSendInventoryTransactions(arrayList, list);
        }
    }

    public void doSendInventoryTransactions(List<String> list, List<InventoryTransaction> list2) {
        try {
            DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryTransaction>>(list2){}, "inventorytransactions");
            this.b(dataSyncInfo, list, InventoryTransaction.REF);
            this.a(list.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void G() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryUnitGroup.class, this.d, this.i);
        this.a(list, " inventory unit group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.22"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnitGroup inventoryUnitGroup : list) {
                inventoryUnitGroup.setUnits(null);
                arrayList.add(inventoryUnitGroup.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryUnitGroup>>(list){}, "inventoryunitgroups");
                this.b(dataSyncInfo, arrayList, InventoryUnitGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void H() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryUnit.class, this.d, this.i);
        this.a(list, " inventory unit.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.23"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnit inventoryUnit : list) {
                arrayList.add(inventoryUnit.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryUnit>>(list){}, "inventoryunits");
                this.b(dataSyncInfo, arrayList, InventoryUnit.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void I() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryVendor.class, this.d, this.i);
        this.a(list, " inventory vendor.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.20"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryVendor inventoryVendor : list) {
                arrayList.add(inventoryVendor.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryVendor>>(list){}, "inventoryvendors");
                this.b(dataSyncInfo, arrayList, InventoryVendor.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void J() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryVendorItems.class, this.d, this.i);
        this.a(list, " inventory vendor item.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.21"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryVendorItems inventoryVendorItems : list) {
                arrayList.add(inventoryVendorItems.getId());
                XMLTransientUtil.makeXMLTransient(inventoryVendorItems);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryVendorItems>>(list){}, "inventoryvendoritems");
                this.b(dataSyncInfo, arrayList, InventoryVendorItems.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void K() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryClosingBalance.class, this.d, this.i);
        this.a(list, " inventory closing balance.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.29"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryClosingBalance inventoryClosingBalance : list) {
                arrayList.add(inventoryClosingBalance.getId());
                if (!StringUtils.isBlank((String)inventoryClosingBalance.getOutletId())) continue;
                this.f = true;
                inventoryClosingBalance.setOutletId(DataProvider.get().getCurrentOutletId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<InventoryClosingBalance>>(list){}, "inventoryclosingbalances");
                this.b(dataSyncInfo, arrayList, InventoryClosingBalance.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void L() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopFloor.class, this.d, this.i);
        this.a(list, " shop floor.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.30"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopFloor shopFloor : list) {
                if (StringUtils.isBlank((String)shopFloor.getOutletId())) {
                    this.f = true;
                    shopFloor.setOutletId(this.an());
                }
                arrayList.add(shopFloor.getId());
                XMLTransientUtil.makeXMLTransient(shopFloor);
                Set<ShopTable> set = shopFloor.getTables();
                if (set == null || set.size() <= 0) continue;
                for (ShopTable shopTable : set) {
                    if (!StringUtils.isBlank((String)shopTable.getOutletId())) continue;
                    shopTable.setOutletId(this.an());
                }
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ShopFloor>>(list){}, "shopfloors");
                this.b(dataSyncInfo, arrayList, ShopFloor.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void M() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTable.class, this.d, this.i);
        this.a(list, " shop table.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.31"));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTable shopTable : list) {
                arrayList.add(shopTable.getId());
                if (StringUtils.isBlank((String)shopTable.getOutletId())) {
                    this.f = true;
                    shopTable.setOutletId(this.an());
                }
                XMLTransientUtil.makeXMLTransient(shopTable);
                for (TimedModel timedModel : list) {
                    timedModel.setLastUpdateTime(this.h);
                }
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ShopTable>>(list){}, "shoptables");
                this.a(dataSyncInfo, arrayList, ShopTable.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadBookingInfos() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(BookingInfo.class, this.d, this.i);
        this.a(list, " booking info.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.32"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BookingInfo bookingInfo : list) {
                arrayList.add(bookingInfo.getId());
                if (StringUtils.isBlank((String)bookingInfo.getOutletId())) {
                    this.f = true;
                    bookingInfo.setOutletId(this.an());
                }
                XMLTransientUtil.makeXMLTransient(bookingInfo);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<BookingInfo>>(list){}, "bookinginfos");
                this.b(dataSyncInfo, arrayList, BookingInfo.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadCurrency() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Currency.class, this.d, this.i);
        this.a(list, " currency.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.1"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Currency currency : list) {
                arrayList.add(currency.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Currency>>(list){}, "currencies");
                this.b(dataSyncInfo, arrayList, Currency.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadCashBreakDown() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CashBreakdown.class, this.d, this.i);
        this.a(list, " cash breakdown.");
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CashBreakdown cashBreakdown : list) {
                arrayList.add(cashBreakdown.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<CashBreakdown>>(list){}, "cashbreakdowns");
                this.b(dataSyncInfo, arrayList, CashBreakdown.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadShift() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Shift.class, this.d, this.i);
        this.a(list, " shift.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.34"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Shift shift : list) {
                arrayList.add(shift.getId());
                if (!StringUtils.isBlank((String)shift.getOutletId())) continue;
                shift.setOutletId(this.an());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Shift>>(list){}, "shifts");
                this.b(dataSyncInfo, arrayList, Shift.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadShopTablesStatus() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTableStatus.class, this.d, this.i);
        this.a(list, " shop table status.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading shop table status...");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTableStatus shopTableStatus : list) {
                arrayList.add(shopTableStatus.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ShopTableStatus>>(list){}, "shoptablesstatus");
                this.a(dataSyncInfo, arrayList, ShopTableStatus.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void N() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ModifierGroup.class, this.d, this.i);
        this.a(list, " modifier group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.13"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ModifierGroup modifierGroup : list) {
                arrayList.add(modifierGroup.getId());
                XMLTransientUtil.makeXMLTransient(modifierGroup);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ModifierGroup>>(list){}, "modifiergroup");
                this.b(dataSyncInfo, arrayList, ModifierGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void O() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuModifier.class, this.d, this.i);
        this.a(list, " menu modifier.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.12"));
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuModifier menuModifier : list) {
                arrayList.add(menuModifier.getId());
                MenuModifierDAO.getInstance().initialize(menuModifier);
                menuModifier.setLastUpdateTime(this.h);
                List<ModifierGroup> list2 = menuModifier.getModifierGroups();
                if (list2 == null) continue;
                for (ModifierGroup modifierGroup : list2) {
                    hashSet.add(modifierGroup.getId());
                    modifierGroup.setModifiers(null);
                    modifierGroup.setModifierPages(null);
                }
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<MenuModifier>>(list){}, "modifier");
                this.b(dataSyncInfo, arrayList, MenuModifier.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void P() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuGroup.class, this.d, this.i);
        this.a(list, " menu group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.15"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuGroup menuGroup : list) {
                arrayList.add(menuGroup.getId());
                XMLTransientUtil.makeXMLTransient(menuGroup);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<MenuGroup>>(list){}, "menugroup");
                this.b(dataSyncInfo, arrayList, MenuGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void Q() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuCategory.class, this.d, this.i);
        this.a(list, " menu category.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.14"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuCategory menuCategory : list) {
                arrayList.add(menuCategory.getId());
                menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                menuCategory.setLastUpdateTime(this.h);
                XMLTransientUtil.makeXMLTransientCollection(menuCategory);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<MenuCategory>>(list){}, "menucategory");
                this.b(dataSyncInfo, arrayList, MenuCategory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void R() {
        OutletDAO outletDAO = OutletDAO.getInstance();
        Outlet outlet = DataProvider.get().getOutlet();
        boolean bl = outletDAO.isOutletSyncable(outlet.getId());
        if (!this.e && !bl) {
            return;
        }
        try {
            outletDAO.initialize(outlet);
            this.a(outlet);
            outlet.setLastUpdateTime(this.h);
            outlet.setDepartments(null);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Outlet> arrayList2 = new ArrayList<Outlet>();
            arrayList.add(outlet.getId());
            arrayList2.add(outlet);
            this.c(Messages.getString("CloudDataUploader.0"));
            DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Outlet>>(arrayList2){}, "outlet");
            this.b(dataSyncInfo, arrayList, Outlet.REF);
            this.a(arrayList.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void a(Outlet outlet) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Store store = StoreDAO.getRestaurant();
        Map<String, String> map = store.getProperties();
        if (map != null) {
            for (String string : map.keySet()) {
                try {
                    outlet.addProperty(string, map.get(string));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
    }

    private void a(String string) {
        if (this.b == null) {
            return;
        }
        this.b.printInfo("\n" + string);
    }

    public void uploadTaxes() {
        Object object;
        ArrayList<String> arrayList;
        List list = GenericDAO.getInstance().findAllUnSyncItem(Tax.class, this.d, this.i);
        this.a(list, " tax.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.10"));
            arrayList = new ArrayList();
            for (Object object2 : list) {
                arrayList.add(((BaseTax)object2).getId());
            }
            try {
                object = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Tax>>(list){}, "tax");
                this.b((DataSyncInfo)object, arrayList, Tax.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        arrayList = new ArrayList<String>();
        object = GenericDAO.getInstance().findAllUnSyncItem(TaxGroup.class, this.d, this.i);
        this.a((List<?>)object, " tax group.");
        if (object != null && !object.isEmpty()) {
            Object object2;
            this.c("Uploading tax groups...");
            object2 = object.iterator();
            while (object2.hasNext()) {
                TaxGroup taxGroup = (TaxGroup)object2.next();
                arrayList.add(taxGroup.getId());
            }
            try {
                object2 = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<TaxGroup>>((List)object){}, "taxgroup");
                this.b((DataSyncInfo)object2, arrayList, TaxGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void S() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Customer.class, this.d, this.i);
        this.a(list, " customer.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.11"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Customer customer : list) {
                CustomerDAO.getInstance().initialize(customer);
                customer.setLastUpdateTime(this.h);
                arrayList.add(customer.getId());
                XMLTransientUtil.makeXMLTransient(customer);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Customer>>(list){}, "customer");
                this.b(dataSyncInfo, arrayList, Customer.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void T() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(BalanceUpdateTransaction.class, this.d, this.i);
        this.a(list, " balance update transaction.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading balance update transaction");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BalanceUpdateTransaction balanceUpdateTransaction : list) {
                arrayList.add(balanceUpdateTransaction.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<BalanceUpdateTransaction>>(list){}, "balanceUpdateTransactions");
                this.b(dataSyncInfo, arrayList, BalanceUpdateTransaction.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private List<OrderType> U() {
        ArrayList<OrderType> arrayList = new ArrayList<OrderType>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(OrderType.class, this.d, this.i);
        this.a(list, " order type.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.6"));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (OrderType orderType : list) {
                OrderTypeDAO.getInstance().initialize(orderType);
                orderType.setLastUpdateTime(this.h);
                OrderType orderType2 = XMLTransientUtil.getLazyData(orderType);
                if (orderType2 != null) {
                    arrayList.add(orderType2);
                }
                arrayList2.add(orderType.getId());
                XMLTransientUtil.makeXMLTransient(orderType);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype");
                this.b(dataSyncInfo, arrayList2, OrderType.REF);
                this.a(arrayList2.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        return arrayList;
    }

    private void c(List<OrderType> list) {
        this.a(list, " order type -> terminal types and menu categories and departments");
        if (list != null && !list.isEmpty()) {
            this.c(" order type -> terminal types and menu categories and departments");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (OrderType orderType : list) {
                orderType = OrderTypeDAO.getInstance().initialize(orderType);
                arrayList.add(orderType.getId());
                XMLTransientUtil.makeLazy(orderType);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype/categories");
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void d(List<TerminalType> list) {
        this.a(list, " terminal type -> outlets and menu categories");
        if (list != null && !list.isEmpty()) {
            this.c(" terminal type -> outlets and menu categories");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TerminalType terminalType : list) {
                arrayList.add(terminalType.getId());
                XMLTransientUtil.makeLazy(terminalType);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<TerminalType>>(list){}, "terminalType/categories");
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private List<Department> V() {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(Department.class, this.d, this.i);
        this.a(list, " department.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading department");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Department department : list) {
                try (Object object = DepartmentDAO.getInstance().createNewSession();){
                    object.refresh((Object)department);
                    Hibernate.initialize(department.getOutlets());
                    Hibernate.initialize(department.getOrderTypes());
                }
                object = XMLTransientUtil.getLazyData(department);
                if (object != null) {
                    arrayList.add((Department)object);
                }
                arrayList2.add(department.getId());
                XMLTransientUtil.makeXMLTransient(department);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Department>>(list){}, "departments");
                this.b(dataSyncInfo, arrayList2, Department.REF);
                this.a(arrayList2.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        return arrayList;
    }

    private void e(List<Department> list) {
        this.a(list, " department -> outlets and order types");
        if (list != null && !list.isEmpty()) {
            this.c(" department -> outlets and order types");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Department department : list) {
                arrayList.add(department.getId());
                XMLTransientUtil.makeLazy(department);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Department>>(list){}, "departments/orderTypesAndOutlets");
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void W() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(SalesArea.class, this.d, this.i);
        this.a(list, " sales area.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading sales areas...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SalesArea salesArea : list) {
                arrayList.add(salesArea.getId());
                if (!StringUtils.isBlank((String)salesArea.getOutletId())) continue;
                salesArea.setOutletId(this.an());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<SalesArea>>(list){}, "salesAreas");
                this.b(dataSyncInfo, arrayList, SalesArea.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void X() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ReportGroup.class, this.d, this.i);
        this.a(list, " report group.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading report group...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ReportGroup reportGroup : list) {
                arrayList.add(reportGroup.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ReportGroup>>(list){}, "reportGroups");
                this.b(dataSyncInfo, arrayList, ReportGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void Y() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PrinterGroup.class, this.d, this.i);
        this.a(list, " printer group.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading printer group...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PrinterGroup printerGroup : list) {
                arrayList.add(printerGroup.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PrinterGroup>>(list){}, "printerGroups");
                this.b(dataSyncInfo, arrayList, PrinterGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void Z() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VoidReason.class, this.d, this.i);
        this.a(list, " void reason.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading void reason...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VoidReason voidReason : list) {
                arrayList.add(voidReason.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<VoidReason>>(list){}, "voidReasons");
                this.b(dataSyncInfo, arrayList, VoidReason.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void aa() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VirtualPrinter.class, this.d, this.i);
        this.a(list, " virtual printer.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading printers...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VirtualPrinter virtualPrinter : list) {
                arrayList.add(virtualPrinter.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<VirtualPrinter>>(list){}, "printers");
                this.b(dataSyncInfo, arrayList, VirtualPrinter.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ab() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTableType.class, this.d, this.i);
        this.a(list, " shop table type.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading table types...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopTableType shopTableType : list) {
                arrayList.add(shopTableType.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ShopTableType>>(list){}, "shopTableTypes");
                this.b(dataSyncInfo, arrayList, ShopTableType.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ac() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ActionHistory.class, this.d, this.i);
        this.a(list, " action history.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading action histories...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ActionHistory actionHistory : list) {
                if (StringUtils.isBlank((String)actionHistory.getOutletId())) {
                    this.f = true;
                    actionHistory.setOutletId(this.an());
                    if (actionHistory.getPerformer() != null) {
                        actionHistory.getPerformer().setOutletId(this.an());
                    }
                }
                XMLTransientUtil.makeXMLTransient(actionHistory.getPerformer());
                arrayList.add(actionHistory.getId());
            }
            try {
                int n = list.size();
                int n2 = 1000;
                if (n > n2) {
                    for (int i = 0; n > i; i += n2) {
                        List list2 = null;
                        list2 = n - i < n2 ? list.subList(i, n) : list.subList(i, i + n2);
                        DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ActionHistory>>(list2){}, "actionHistories");
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        for (ActionHistory actionHistory : list2) {
                            arrayList2.add(actionHistory.getId());
                        }
                        this.b(dataSyncInfo, arrayList2, ActionHistory.REF);
                    }
                } else {
                    DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ActionHistory>>(list){}, "actionHistories");
                    this.b(dataSyncInfo, arrayList, ActionHistory.REF);
                }
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(int n) {
        if (this.b == null) {
            return;
        }
        this.b.printInfo(" (" + n + ") : success");
    }

    private void ad() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VoidItem.class, this.d, this.i);
        this.a(list, " void item.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading void items...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VoidItem voidItem : list) {
                arrayList.add(voidItem.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<VoidItem>>(list){}, "voidItems");
                this.b(dataSyncInfo, arrayList, VoidItem.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ae() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Recepie.class, this.d, this.i);
        this.a(list, " recipe.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading recipes...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Recepie recepie : list) {
                XMLTransientUtil.makeLazy(recepie);
                arrayList.add(recepie.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Recepie>>(list){}, "recipes");
                this.b(dataSyncInfo, arrayList, Recepie.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void af() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PurchaseOrder.class, this.d, this.i);
        this.a(list, " purchase order.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading purchase orders...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PurchaseOrder purchaseOrder : list) {
                XMLTransientUtil.makeLazy(purchaseOrder);
                if (StringUtils.isBlank((String)purchaseOrder.getOutletId())) {
                    this.f = true;
                    purchaseOrder.setOutletId(this.an());
                }
                arrayList.add(purchaseOrder.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<PurchaseOrder>>(list){}, "purchaseOrders");
                this.b(dataSyncInfo, arrayList, PurchaseOrder.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ag() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(StockCount.class, this.d, this.i);
        this.a(list, " stock count.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading stock counts...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StockCount stockCount : list) {
                XMLTransientUtil.makeLazy(stockCount);
                arrayList.add(stockCount.getId());
                if (!StringUtils.isBlank((String)stockCount.getOutletId())) continue;
                this.f = true;
                stockCount.setOutletId(this.an());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<StockCount>>(list){}, "stockCounts");
                this.b(dataSyncInfo, arrayList, StockCount.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ah() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopFloorTemplate.class, this.d, this.i);
        this.a(list, " shop floor template.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading shop floor templates...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopFloorTemplate shopFloorTemplate : list) {
                XMLTransientUtil.makeXMLTransient(shopFloorTemplate);
                arrayList.add(shopFloorTemplate.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<ShopFloorTemplate>>(list){}, "shopFloorTemplates");
                this.b(dataSyncInfo, arrayList, ShopFloorTemplate.REF);
                this.a(list.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ai() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CronJob.class, this.d, this.i);
        this.a(list, " cron job.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading cron jobs...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CronJob cronJob : list) {
                arrayList.add(cronJob.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<CronJob>>(list){}, "cronJobs");
                this.b(dataSyncInfo, arrayList, CronJob.REF);
                this.a(list.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void aj() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Gratuity.class, this.d, this.i);
        this.a(list, " gratuity.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading gratuities...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Gratuity gratuity : list) {
                arrayList.add(gratuity.getId());
                if (!StringUtils.isBlank((String)gratuity.getOutletId())) continue;
                gratuity.setOutletId(DataProvider.get().getCurrentOutletId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Gratuity>>(list){}, "gratuity");
                this.b(dataSyncInfo, arrayList, Gratuity.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ak() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(SlideShowImage.class, this.d, this.i);
        this.a(list, " slide images.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading slide images...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SlideShowImage slideShowImage : list) {
                arrayList.add(slideShowImage.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<SlideShowImage>>(list){}, "slideShowImages");
                this.b(dataSyncInfo, arrayList, SlideShowImage.REF);
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void al() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(UserType.class, this.d, this.i);
        this.a(list, " user type.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.8"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UserType userType : list) {
                arrayList.add(userType.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<UserType>>(list){}, "usertypes");
                this.b(dataSyncInfo, arrayList, UserType.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void am() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(User.class, this.d, this.i);
        this.a(list, " user.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.9"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (User user : list) {
                arrayList.add(user.getId());
                if (StringUtils.isBlank((String)user.getOutletId())) {
                    this.f = true;
                    user.setOutletId(this.an());
                }
                XMLTransientUtil.makeXMLTransient(user);
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<User>>(list){}, "users");
                this.b(dataSyncInfo, arrayList, User.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private String an() {
        Outlet outlet = DataProvider.get().getOutlet();
        return outlet == null ? null : outlet.getId();
    }

    public static CloudDataUploader get() {
        Date date = new Date();
        return new CloudDataUploader(null, date, date);
    }

    public void uploadOnSaveBookingInfo(BookingInfo bookingInfo) {
        try {
            if (!Application.getInstance().isCloudConnected()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<BookingInfo> arrayList2 = new ArrayList<BookingInfo>();
            XMLTransientUtil.makeXMLTransient(bookingInfo);
            arrayList2.add(bookingInfo);
            arrayList.add(bookingInfo.getId());
            if (this.c == null) {
                this.c = PosWebService.get();
            }
            DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<BookingInfo>>(arrayList2){}, "bookinginfos");
            this.b(dataSyncInfo, arrayList, BookingInfo.REF);
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    public void sendTicketWithTransactions(String string) {
        if (!Application.getInstance().isCloudConnected()) {
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        AsyncAction.execute(() -> {
            try {
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(string);
                if (ticket == null) {
                    return;
                }
                this.c.doUploadTicketToCloud(ticket);
            }
            catch (Exception exception) {
                PosLog.error(PosWebService.class, "Uploading ticket/transaction/InvTransaction failed...", exception);
            }
        });
    }

    public void uploadAddress() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Address.class, this.d, this.i);
        this.a(list, " address.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.35"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Address address : list) {
                arrayList.add(address.getId());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<Address>>(list){}, "address");
                this.b(dataSyncInfo, arrayList, Address.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ao() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(AttendenceHistory.class, this.d, this.i);
        this.a(list, " attendence history.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.36"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttendenceHistory attendenceHistory : list) {
                arrayList.add(attendenceHistory.getId());
                Integer n = attendenceHistory.getTerminalId();
                attendenceHistory.setTerminal(null);
                attendenceHistory.setTerminalId(n);
                if (StringUtils.isBlank((String)attendenceHistory.getOutletId())) {
                    this.f = true;
                    attendenceHistory.setOutletId(this.an());
                }
                XMLTransientUtil.makeXMLTransient(attendenceHistory.getUser());
            }
            try {
                DataSyncInfo dataSyncInfo = this.c.uploadData(this.h, (GenericEntity)new GenericEntity<List<AttendenceHistory>>(list){}, "attendenceHistory");
                this.b(dataSyncInfo, arrayList, AttendenceHistory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void updateStoreLastUpdateTimeProperties(List<String> list) {
        Store store = StoreDAO.getRestaurant();
        GenericDAO genericDAO = GenericDAO.getInstance();
        for (DataSyncInfo dataSyncInfo : this.l) {
            if (list.contains(dataSyncInfo.getRef())) continue;
            genericDAO.updateLastUpdateTimeProperty(store, dataSyncInfo.getRef(), dataSyncInfo.getLastUpdateTime());
        }
        genericDAO.saveOrUpdate(store);
    }

    private void a(DataSyncInfo dataSyncInfo, List<Integer> list, String string) {
        GenericDAO genericDAO = GenericDAO.getInstance();
        Date date = this.a(dataSyncInfo);
        genericDAO.updateItemsLastSyncTimeByInt(date, list, string);
        dataSyncInfo.setRef(string);
        this.l.add(dataSyncInfo);
    }

    private void b(DataSyncInfo dataSyncInfo, List<String> list, String string) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        int n2 = 12000;
        GenericDAO genericDAO = GenericDAO.getInstance();
        if (n > n2) {
            for (int i = 0; n > i; i += n2) {
                List<String> list2 = null;
                list2 = n - i < n2 ? list.subList(i, n) : list.subList(i, i + n2);
                genericDAO.updateItemsLastSyncTime(this.i, list2, string);
            }
        } else {
            genericDAO.updateItemsLastSyncTime(this.i, list, string);
        }
        dataSyncInfo.setRef(string);
        this.l.add(dataSyncInfo);
    }

    private void a(DataSyncInfo dataSyncInfo, List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        int n2 = 12000;
        GenericDAO genericDAO = GenericDAO.getInstance();
        if (n > n2) {
            for (int i = 0; n > i; i += n2) {
                List<String> list2 = null;
                list2 = n - i < n2 ? list.subList(i, n) : list.subList(i, i + n2);
                genericDAO.updateTicketsLastSyncTime(this.i, list2);
            }
        } else {
            genericDAO.updateTicketsLastSyncTime(this.i, list);
        }
        dataSyncInfo.setRef(Ticket.REF);
        this.l.add(dataSyncInfo);
    }

    private void a(Exception exception) {
        if (this.b != null) {
            this.b.printError("failed");
        }
        PosLog.error(this.getClass(), exception);
        throw new RuntimeException(exception);
    }

    private void a(List<?> list, String string) {
        this.b(list, string);
    }

    private void b(List<?> list, String string) {
        if (list == null || list.size() == 0) {
            return;
        }
        a.info((Object)("  Uploading " + list.size() + string));
        this.g += list.size();
    }

    private void b(String string) {
        PosLog.info(this.getClass(), string);
        if (this.b == null) {
            return;
        }
        this.b.printInfo("\n" + string);
    }

    private void c(String string) {
        try {
            this.k = this.k + this.j;
            if (this.b == null) {
                return;
            }
            this.b.progress(this.k, string);
            this.b.printInfo("\n" + string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Integer n, String string) throws Exception {
        this.k = n;
        if (this.b == null) {
            return;
        }
        this.b.progress(n, string);
    }
}

