/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudSyncListener;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.sun.jersey.api.client.ClientHandlerException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class CloudLoginPanel
extends JPanel {
    public static final String VIEW_NAME = "login";
    private POSTextField a;
    private POSTextField b;
    private POSPasswordField c;
    private CloudSyncListener d;
    private boolean e;
    private JButton f;
    private JButton g;

    public CloudLoginPanel(CloudSyncListener cloudSyncListener) {
        this.d = cloudSyncListener;
        this.initComponents();
        this.updateView();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fillx,ins 20", "[][fill, grow]", ""));
        this.a = new POSTextField();
        this.b = new POSTextField();
        this.c = new POSPasswordField();
        if (Application.getInstance().isDevelopmentMode()) {
            jPanel.add(new JLabel(Messages.getString("ServerAddress") + ":"));
            jPanel.add((Component)this.a, "grow, wrap");
        }
        jPanel.add(new JLabel(Messages.getString("CloudLoginPanel.2") + ":"));
        jPanel.add((Component)this.b, "grow, wrap");
        jPanel.add(new JLabel(Messages.getString("PASSWORD") + ":"));
        jPanel.add((Component)this.c, "grow, wrap");
        this.g = new JButton(Messages.getString("TestConnection"));
        this.g.addActionListener(actionEvent -> this.checkConnection());
        JLabel jLabel = new JLabel(Messages.getString("CloudLoginPanel.7"));
        jLabel.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        jPanel.add((Component)jLabel, "newline,span 2,right");
        jPanel.add((Component)this.g, "newline,span,split 2,right");
        this.f = new JButton(Messages.getString("CloudLoginPanel.11"));
        this.f.setActionCommand("register");
        this.f.addActionListener(actionEvent -> this.d.registerButtonClicked());
        jPanel.add(this.f);
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        PosButton posButton = new PosButton();
        PosButton posButton2 = new PosButton();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout());
        posButton.setText(POSConstants.SAVE_BUTTON_TEXT);
        posButton.addActionListener(actionEvent -> this.doLogin());
        jPanel2.add(posButton);
        posButton2.setText(POSConstants.CANCEL);
        posButton2.addActionListener(actionEvent -> this.a(true));
        jPanel2.add(posButton2);
        jPanel3.add((Component)jSeparator, "North");
        jPanel3.add((Component)jPanel2, "Center");
        this.add(jPanel);
        this.add((Component)jPanel3, "South");
    }

    protected void checkConnection() {
        try {
            String string = this.a.getText();
            String string2 = this.b.getText();
            String string3 = new String(this.c.getPassword());
            String string4 = String.valueOf(DataProvider.get().getCurrentTerminal().getId());
            if (StringUtils.isEmpty((String)string)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.0"));
                return;
            }
            if (StringUtils.isEmpty((String)string2)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.1"));
                return;
            }
            if (!EmailValidator.getInstance().isValid(string2)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.3"));
                return;
            }
            if (StringUtils.isEmpty((String)string3)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.4"));
                return;
            }
            PosResponse posResponse = PosWebService.get().checkConnection(string, string2, AESencrp.encrypt(string3), string4);
            if (posResponse != null) {
                if (posResponse.getResponseCode() == 200) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.13"));
                } else {
                    POSMessageDialog.showError(posResponse.getMsg());
                }
            }
        }
        catch (ClientHandlerException clientHandlerException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.5"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    public void updateView() {
        try {
            Store store = StoreDAO.getRestaurant();
            String string = store.getProperty("web.service.url");
            String string2 = store.getProperty("web.service.password");
            String string3 = store.getProperty("web.service.username");
            if (StringUtils.isNotEmpty((String)string2)) {
                string2 = AESencrp.decrypt(string2);
            }
            this.a.setText(StringUtils.isEmpty((String)string) ? "https://menugreat.com/console" : string);
            this.b.setText(string3);
            this.c.setText(string2);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLogin() {
        try {
            String string = this.a.getText();
            String string2 = this.b.getText();
            String string3 = AESencrp.encrypt(new String(this.c.getPassword()));
            PosResponse posResponse = this.checkLogin(string, string2, string3);
            if (this.e && !PosWebService.get().isRemoteAccountEmty(string, string2, string3, posResponse.getCustomerId(), posResponse.getStoreId())) {
                throw new PosException(Messages.getString("CloudLoginPanel.6"));
            }
            Store store = StoreDAO.getRestaurant();
            store.addProperty("web.service.url", string);
            store.addProperty("web.service.username", string2);
            store.addProperty("web.service.password", string3);
            if (this.e) {
                StoreDAO.getInstance().removeLastUpdateTime(store);
            }
            store.addProperty("web.service.schema", posResponse.getStoreId());
            store.addProperty("web.service.customer.id", posResponse.getCustomerId());
            store.setUuid(posResponse.getStoreId());
            StoreDAO.getInstance().saveOrUpdate(store);
            Application.getInstance().refreshStore();
            OroMqttClient.getInstance().notifyDataUpdated(Store.class);
            this.a(false);
        }
        catch (ClientHandlerException clientHandlerException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudLoginPanel.5"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public PosResponse checkLogin(String string, String string2, String string3) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("CloudLoginPanel.0"));
        }
        if (StringUtils.isEmpty((String)string2)) {
            throw new PosException(Messages.getString("CloudLoginPanel.1"));
        }
        if (!EmailValidator.getInstance().isValid(string2)) {
            throw new PosException(Messages.getString("CloudLoginPanel.3"));
        }
        if (StringUtils.isEmpty((String)string3)) {
            throw new PosException(Messages.getString("CloudLoginPanel.4"));
        }
        String string4 = String.valueOf(DataProvider.get().getCurrentTerminal().getId());
        PosResponse posResponse = PosWebService.get().login(string, string2, string3, string4);
        if (posResponse != null && posResponse.getResponseCode() == 200) {
            Store store = StoreDAO.getRestaurant();
            String string5 = store.getProperty("web.service.url");
            String string6 = store.getProperty("web.service.username");
            this.e = StringUtils.isNotBlank((String)string5) && StringUtils.isNotBlank((String)string6) && (!string.equalsIgnoreCase(string5) || !string2.equals(string6));
            return posResponse;
        }
        throw new Exception(posResponse.getMsg());
    }
}

