/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.cronjob.CloudAutoSyncJob;
import com.floreantpos.extension.cronjob.CloudAutoSyncJobPlugin;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.Application;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudConfigurationDialog;
import com.floreantpos.webservice.OutletSelectionDialog;
import com.floreantpos.webservice.PosWebService;
import com.floreantpos.webservice.SyncService;
import com.orocube.rest.service.PosResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.net.URI;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronTrigger;

public class CloudSyncDialog
extends POSDialog
implements ProgressObserver {
    private static final Color a = new Color(126, 180, 69);
    private static final String b = "UND";
    private PosSmallButton c;
    private JButton d;
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JCheckBox i;
    private IntegerTextField j;
    private JProgressBar k;
    private JLabel l;
    private PosSmallButton m;
    private JLabel n;
    private JTextField o;
    private JButton p;
    private Worker q;
    private JPanel r;
    private JRadioButton s;
    private JRadioButton t;
    private JRadioButton u;
    private JTextArea v;
    private boolean w;
    private CronJob x;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow());
        this.setTitle(VersionInfo.getAppName());
        this.h();
        this.i();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(() -> this.l());
        }
        super.setVisible(bl);
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 0 0 10 0,fill,hidemode 3"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3", "", ""));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("CloudSyncDialog.0"));
        this.e = new JLabel();
        this.f = new JLabel();
        this.g = new JLabel();
        this.h = new JLabel();
        this.i = new JCheckBox(Messages.getString("CloudSyncDialog.4"));
        this.j = new IntegerTextField(8);
        this.j.setEditable(false);
        this.j.setHorizontalAlignment(4);
        this.k = new JProgressBar();
        this.k.setValue(0);
        this.k.setMaximum(100);
        this.k.setStringPainted(true);
        this.k.setPreferredSize(PosUIManager.getSize(0, 30));
        this.l = new JLabel("");
        this.k.setVisible(false);
        this.m = new PosSmallButton(Messages.getString("Cancel"));
        this.m.setVisible(false);
        this.d = new JButton(Messages.getString("Close"));
        this.n = new JLabel(Messages.getString("StoreId"));
        this.n.setVisible(false);
        this.o = new JTextField(11);
        this.o.setEditable(false);
        this.o.setBorder(BorderFactory.createEmptyBorder());
        this.c = new PosSmallButton(Messages.getString("Sync"));
        this.c.setEnabled(false);
        this.c.setActionCommand(b);
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.9")), "split 3");
        jPanel2.add((Component)this.e, "grow,wrap");
        this.e.setFocusable(true);
        jPanel2.add((Component)this.n, "split 2");
        jPanel2.add((Component)this.o, "wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.6")), "split 2");
        jPanel2.add((Component)this.f, "grow,wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.7")), "split 2");
        jPanel2.add((Component)this.g, "grow,wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.10")), "split 2");
        jPanel2.add((Component)this.h, "grow,wrap");
        jPanel2.add((Component)this.i, "grow,wrap");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.11")), "split 3");
        jPanel2.add((Component)this.j, "");
        jPanel2.add((Component)new JLabel(Messages.getString("CloudSyncDialog.12")), "wrap");
        jPanel.add((Component)jPanel2, "left,growx,split 2");
        JButton jButton = new JButton(Messages.getString("GoToWebConsole"));
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.b());
        jButton.setForeground(Color.RED);
        jButton.setFont(new Font(this.getFont().getName(), 1, 11));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("wrap 1,hidemode 3"));
        jPanel4.add((Component)this.c, "right");
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "top,wrap,gapafter 5");
        this.r = new JPanel((LayoutManager)new MigLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.s = new JRadioButton(Messages.getString("Merge"));
        this.t = new JRadioButton(Messages.getString("Ignore"));
        this.u = new JRadioButton(Messages.getString("TerminalConfig.0"));
        this.u.addActionListener(actionEvent -> this.a(Messages.getString("TerminalConfig.0")));
        this.t.addActionListener(actionEvent -> this.a(Messages.getString("Ignore")));
        this.s.addActionListener(actionEvent -> this.a(Messages.getString("Merge")));
        this.i.addChangeListener(changeEvent -> this.a());
        buttonGroup.add(this.u);
        buttonGroup.add(this.s);
        buttonGroup.add(this.t);
        this.r.add(new JLabel(Messages.getString("CloudSyncDialog.2")));
        this.r.add(this.s);
        this.r.add(this.t);
        this.r.add(this.u);
        this.c();
        this.v = new JTextArea();
        this.v.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.v.setEditable(false);
        this.v.setWrapStyleWord(true);
        this.v.setLineWrap(true);
        this.v.setBackground(Color.white);
        jPanel.add((Component)this.r, "growx,gaptop 0,gapbottom 0,wrap");
        jPanel.add((Component)new JSeparator(), "growx");
        jPanel.add((Component)this.l, "gapleft 5,right,newline,split 3,gapafter 5");
        jPanel.add((Component)this.k, "growx,h " + PosUIManager.getSize(35));
        jPanel.add((Component)this.m, "gapafter 5,h " + PosUIManager.getSize(35));
        jPanel.add((Component)new JScrollPane(this.v), "newline,grow,h 200!,span");
        this.p = new JButton(Messages.getString("CloudSyncDialog.8"));
        jPanel3.add((Component)this.p, "split 2,center");
        jPanel3.add(this.d);
        this.p.addActionListener(actionEvent -> this.d());
        this.c.addActionListener(actionEvent -> this.a(false));
        this.m.addActionListener(actionEvent -> this.e());
        this.add((Component)titlePanel, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel3, "South");
    }

    private void a() {
        this.j.setEditable(this.i.isSelected());
        if (this.x != null) {
            if (this.i.isSelected() && PosWebService.get().isConnected()) {
                CronTrigger cronTrigger = OroCronJobManager.getInstance().getCronTriggerFromCronJob(this.x, null);
                Date date = cronTrigger.getFireTimeAfter(new Date());
                this.h.setText(DateUtil.formatDateWithTime(date));
            } else {
                this.h.setText("");
            }
        } else {
            this.h.setText("");
        }
    }

    private void b() {
        try {
            URI uRI = new URI("https://menugreat.com/console");
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uRI);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(String string) {
        try {
            Store store = StoreDAO.getRestaurant();
            String string2 = store.getProperty("sync.conflict_resolve_option");
            if (string2 != null && string.equals(string2)) {
                return;
            }
            if (StringUtils.isBlank((String)string) || string.equalsIgnoreCase(Messages.getString("TerminalConfig.0"))) {
                Map<String, String> map = store.getProperties();
                map.remove("sync.conflict_resolve_option");
            } else {
                store.addProperty("sync.conflict_resolve_option", string);
            }
            StoreDAO.getInstance().update(store);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void c() {
        String string = StoreDAO.getRestaurant().getProperty("sync.conflict_resolve_option");
        boolean bl = StringUtils.isNotBlank((String)string);
        this.r.setVisible(bl);
        this.u.setSelected(StringUtils.isBlank((String)string));
        this.s.setSelected(bl && string.equals(Messages.getString("Merge")));
        this.t.setSelected(bl && string.equals(Messages.getString("Ignore")));
    }

    private void d() {
        CloudConfigurationDialog cloudConfigurationDialog = new CloudConfigurationDialog();
        cloudConfigurationDialog.setSize(PosUIManager.getSize(650, 400));
        cloudConfigurationDialog.open();
        if (!cloudConfigurationDialog.isCanceled()) {
            this.a(cloudConfigurationDialog.isRegistrationComplete());
        }
    }

    private void e() {
        this.q.cancel(true);
    }

    private void a(boolean bl) {
        try {
            this.w = bl;
            this.v.setText("");
            boolean bl2 = this.l();
            this.c.setEnabled(bl2);
            if (!bl2) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                return;
            }
            Outlet outlet = this.f();
            if (outlet == null) {
                return;
            }
            this.q = new Worker(this.w, outlet);
            this.q.setActionCommand(b);
            this.c.setEnabled(false);
            this.d.setEnabled(false);
            this.p.setEnabled(false);
            this.q.execute();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private Outlet f() throws Exception {
        Outlet outlet = DataProvider.get().getOutlet();
        OutletDAO.getInstance().initialize(outlet);
        boolean bl = PosWebService.get().isNewSchema();
        if (!bl) {
            return outlet;
        }
        List<Outlet> list = PosWebService.get().getOutlets();
        if (list == null || list.isEmpty()) {
            this.g();
            return outlet;
        }
        for (Outlet serializable2 : list) {
            if (!serializable2.getId().equals(DataProvider.get().getCurrentOutletId())) continue;
            this.g();
            if (!this.w) {
                OutletDAO.getInstance().saveOrUpdateOutlets(Arrays.asList(serializable2), serializable2.getId(), true, false, true);
            }
            return serializable2;
        }
        String string = POSMessageDialog.showOptionDialog(POSUtil.getFocusedWindow(), Messages.getString("WhatDoYouWant"), POSConstants.CONFIRM, "<html><center>" + Messages.getString("ConnectAs") + "<br><b>" + Messages.getString("NewOutlet") + "</b></center></html>", "<html><center>" + Messages.getString("ConnectTo") + "<br><b>" + Messages.getString("ExistingOutlet") + "</b></center></html>", POSConstants.CANCEL);
        if (string == null || string.equals(POSConstants.CANCEL)) {
            return null;
        }
        if (string.contains(Messages.getString("NewOutlet"))) {
            this.w = true;
            return outlet;
        }
        OutletSelectionDialog outletSelectionDialog = new OutletSelectionDialog(list);
        outletSelectionDialog.open();
        if (outletSelectionDialog.isCanceled()) {
            return null;
        }
        Outlet outlet2 = outletSelectionDialog.getSelectedOutlet();
        this.g();
        if (this.w) {
            this.a(outlet, outlet2);
        }
        return outlet2;
    }

    private void a(Outlet outlet, Outlet outlet2) throws Exception {
        String string = outlet2.getId();
        long l = outlet2.getVersion();
        PropertyUtils.copyProperties((Object)outlet2, (Object)outlet);
        outlet2.setId(string);
        outlet2.setVersion(l);
    }

    private void g() {
        if (this.w) {
            return;
        }
        this.w = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Which settings do you want to keep", Messages.getString("CONFIRM"), Messages.getString("Local"), Messages.getString("Cloud")) == 0;
    }

    private void h() {
        this.d.addActionListener(actionEvent -> this.k());
        this.setDefaultCloseOperation(2);
    }

    private void i() {
        try {
            boolean bl = PosWebService.get().isConnected();
            Boolean bl2 = DataProvider.get().getCurrentTerminal().isMasterTerminal() != false && bl;
            this.i.setEnabled(bl2);
            this.j.setEnabled(bl2);
            this.x = CronJobDAO.getInstance().get("cloud_auto_sync");
            if (this.x != null) {
                Boolean bl3 = this.x.isActive();
                this.i.setSelected(bl3);
                this.j.setEditable(bl3);
                String string = this.x.getExecutionTime().split(":")[1];
                this.j.setText(string);
                if (bl3.booleanValue() && bl) {
                    CronTrigger cronTrigger = OroCronJobManager.getInstance().getCronTriggerFromCronJob(this.x, null);
                    Date date = cronTrigger.getFireTimeAfter(new Date());
                    this.h.setText(DateUtil.formatDateWithTime(date));
                }
            } else {
                this.j.setText("30");
            }
            this.j();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void j() {
        try {
            Store store = DataProvider.get().getStore();
            StoreDAO.getInstance().refresh(store);
            this.f.setText(store.getName());
            String string = store.getProperty("Store.lastUpdateTime");
            Date date = DateUtil.parseSyncTime(string);
            if (date != null) {
                this.g.setText(DateUtil.formatDateWithTime(date));
            }
        }
        catch (ParseException parseException) {
            PosLog.error(this.getClass(), parseException);
        }
    }

    private void k() {
        try {
            Boolean bl = DataProvider.get().getCurrentTerminal().isMasterTerminal();
            if (bl.booleanValue()) {
                int n = this.j.getInteger();
                if (this.i.isSelected() && n < 10) {
                    POSMessageDialog.showError(Messages.getString("CloudSyncDialog.13"));
                    return;
                }
                if (this.i.isSelected() && n > 59) {
                    POSMessageDialog.showError(Messages.getString("CloudSyncDialog.14"));
                    return;
                }
                String string = "-1:" + n;
                boolean bl2 = Boolean.FALSE;
                if (this.x == null) {
                    this.x = new CloudAutoSyncJob();
                    bl2 = Boolean.TRUE;
                } else {
                    if (this.x.isActive().booleanValue() != this.i.isSelected()) {
                        bl2 = Boolean.TRUE;
                    }
                    if (!string.equals(this.x.getExecutionTime())) {
                        bl2 = Boolean.TRUE;
                    }
                }
                if (bl2) {
                    this.x.setExecutionTime(string);
                    this.x.setActive(this.i.isSelected());
                    CloudAutoSyncJobPlugin cloudAutoSyncJobPlugin = new CloudAutoSyncJobPlugin();
                    cloudAutoSyncJobPlugin.setCronJob(this.x);
                    OroCronJobManager.getInstance().reScheduleJob(((CronJobPlugin)cloudAutoSyncJobPlugin).convertToActualCronJob());
                    PosLog.debug(this.getClass(), "Cron Job saved successfully.");
                }
            }
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private boolean l() {
        Store store = DataProvider.get().getStore();
        StoreDAO.getInstance().refresh(store);
        String string = store.getProperty("web.service.url");
        if ("https://posdb.net/console".equals(string)) {
            string = "https://menugreat.com/console";
            store.addProperty("web.service.url", string);
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
        }
        PosResponse posResponse = null;
        try {
            posResponse = PosWebService.get().checkConnection();
            if (posResponse != null && posResponse.getResponseCode() == 200 && StringUtils.isEmpty((String)store.getProperty("web.service.customer.id"))) {
                String string2 = posResponse.getCustomerId();
                store.addProperty("web.service.customer.id", string2);
                StoreDAO.getInstance().saveOrUpdate(store);
            }
        }
        catch (Exception exception) {
            this.e.setText(this.b(Messages.getString("CloudSyncDialog.23")));
            this.b(false);
        }
        if (posResponse != null) {
            if (posResponse.getResponseCode() == 200) {
                PosLog.info(this.getClass(), "Connected");
                this.e.setText(this.b(Messages.getString("CloudSyncDialog.25")));
                this.b(true);
                this.o.setText(posResponse.getStoreId());
                Application.getInstance().setCloudConnected(true);
                return true;
            }
            this.e.setText(this.b(posResponse.getMsg()));
        }
        return false;
    }

    private void b(boolean bl) {
        this.n.setVisible(bl);
        this.c.setEnabled(bl);
    }

    private String b(String string) {
        return "<html><b><center>" + string + "</center></b></html>";
    }

    public static CloudSyncDialog show(Frame frame) {
        CloudSyncDialog cloudSyncDialog = new CloudSyncDialog();
        cloudSyncDialog.setMinimumSize(PosUIManager.getSize(650, 570));
        cloudSyncDialog.open();
        return cloudSyncDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl, Outlet outlet) {
        try {
            try {
                this.t.setEnabled(false);
                this.s.setEnabled(false);
                this.u.setEnabled(false);
                this.k.setMaximum(105);
                this.k.setVisible(true);
                this.m.setVisible(true);
                this.k.setValue(0);
                this.l.setForeground(Color.BLUE);
                SyncService.sync(this, bl, outlet);
                this.k.setValue(100);
                this.l.setText(Messages.getString("CloudSyncDialog.29"));
                this.l.setForeground(a);
            }
            catch (InterruptedException interruptedException) {
                PosLog.info(this.getClass(), Messages.getString("CloudSyncDialog.1"));
                this.l.setText(Messages.getString("CloudSyncDialog.1"));
                this.l.setForeground(Color.BLACK);
                this.c(true);
                this.q.cancel(true);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
                this.l.setText(Messages.getString("CloudSyncDialog.30"));
                this.l.setForeground(Color.RED);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("CloudSyncDialog.31"), exception);
        }
        finally {
            this.t.setEnabled(true);
            this.s.setEnabled(true);
            this.u.setEnabled(true);
            this.c();
        }
    }

    private void c(boolean bl) {
        this.k.setVisible(!bl);
        this.m.setVisible(!bl);
        this.c.setEnabled(bl);
        this.d.setEnabled(bl);
        this.p.setEnabled(bl);
        this.j();
    }

    @Override
    public void progress(int n) {
        this.k.setValue(n);
    }

    @Override
    public void progress(String string) {
        this.l.setText(string);
    }

    @Override
    public void progress(int n, String string) throws Exception {
        if (this.q.isCancelled()) {
            throw new InterruptedException(Messages.getString("CloudSyncDialog.1"));
        }
        this.k.setValue(n);
        this.l.setText(string);
    }

    @Override
    public void printInfo(String string) {
        this.v.append(string);
    }

    @Override
    public void printError(String string) {
        this.v.append(string);
    }

    @Override
    public Component getParentComponent() {
        return this;
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String a;
        boolean b;
        Outlet c;

        public Worker(boolean bl, Outlet outlet) {
            this.b = bl;
            this.c = outlet;
        }

        public void setActionCommand(String string) {
            this.a = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (this.a.equals(CloudSyncDialog.b)) {
                CloudSyncDialog.this.a(this.b, this.c);
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (CloudSyncDialog.this.q.isCancelled()) {
                return;
            }
            CloudSyncDialog.this.c(true);
        }
    }
}

