/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.main.Main;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.webservice.CloudDataDownloader;
import com.floreantpos.webservice.CloudDataUploader;
import com.floreantpos.webservice.PosWebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SyncService {
    public static final String Address = "Address";
    public static final String AttendenceHistory = "AttendenceHistory";
    public static final String AttributeGroup = "AttributeGroup";
    public static final String Attribute = "Attribute";
    public static final String BookingInfo = "BookingInfo";
    public static final String CashDrawer = "CashDrawer";
    public static final String CookingInstruction = "CookingInstruction";
    public static final String CustomerGroup = "CustomerGroup";
    public static final String Customer = "Customer";
    public static final String BalanceUpdateTransaction = "BalanceUpdateTransaction";
    public static final String CustomPayment = "CustomPayment";
    public static final String Currency = "Currency";
    public static final String Course = "Course";
    public static final String DeclaredTips = "DeclaredTips";
    public static final String DeliveryAddress = "DeliveryAddress";
    public static final String DeliveryCharge = "DeliveryCharge";
    public static final String DeliveryInstruction = "DeliveryInstruction";
    public static final String Department = "Department";
    public static final String Discount = "Discount";
    public static final String GiftCard = "GiftCard";
    public static final String GratuityPaymentHistory = "GratuityPaymentHistory";
    public static final String ImageResource = "ImageResource";
    public static final String InventoryClosingBalance = "InventoryClosingBalance";
    public static final String InventoryTransaction = "InventoryTransaction";
    public static final String InventoryLocation = "InventoryLocation";
    public static final String InventoryStock = "InventoryStock";
    public static final String InventoryUnitGroup = "InventoryUnitGroup";
    public static final String InventoryVendorItems = "InventoryVendorItems";
    public static final String InventoryVendor = "InventoryVendor";
    public static final String InventoryUnit = "InventoryUnit";
    public static final String MenuCategory = "MenuCategory";
    public static final String MenuGroup = "MenuGroup";
    public static final String MenuItemModifierPage = "MenuItemModifierPage";
    public static final String MenuItemModifierSpec = "MenuItemModifierSpec";
    public static final String MenuItem = "MenuItem";
    public static final String MenuItemSize = "MenuItemSize";
    public static final String MenuPage = "MenuPage";
    public static final String ModifierGroup = "ModifierGroup";
    public static final String MenuModifier = "MenuModifier";
    public static final String Multiplier = "Multiplier";
    public static final String Outlet = "Outlet";
    public static final String OrderType = "OrderType";
    public static final String PackagingUnit = "PackagingUnit";
    public static final String PizzaCrust = "PizzaCrust";
    public static final String PizzaPrice = "PizzaPrice";
    public static final String PriceTable = "PriceTable";
    public static final String PriceRule = "PriceRule";
    public static final String SalesArea = "SalesArea";
    public static final String Shift = "Shift";
    public static final String ShopFloor = "ShopFloor";
    public static final String ShopTable = "ShopTable";
    public static final String ShopTableStatus = "ShopTableStatus";
    public static final String StoreSessionControl = "StoreSessionControl";
    public static final String StoreSession = "StoreSession";
    public static final String Tax = "Tax";
    public static final String TaxGroup = "TaxGroup";
    public static final String Terminal = "Terminal";
    public static final String TerminalType = "TerminalType";
    public static final String Ticket = "Ticket";
    public static final String User = "User";
    public static final String UserType = "UserType";
    public static final String PrinterGroup = "PrinterGroup";
    public static final String VirtualPrinter = "VirtualPrinter";
    public static final String VoidReason = "VoidReason";
    public static final String ReportGroup = "ReportGroup";
    public static final String ShopTableType = "ShopTableType";
    public static final String ActionHistory = "ActionHistory";
    public static final String VoidItem = "VoidItem";
    public static final String Recipe = "Recepie";
    public static final String PurchaseOrder = "PurchaseOrder";
    public static final String StockCount = "StockCount";
    public static final String ShopFloorTemplate = "ShopFloorTemplate";
    public static final String CronJob = "CronJob";
    public static final String Gratuity = "Gratuity";
    public static final String SlideShowImage = "SlideShowImage";
    public static final String DeletedData = "DeletedData";

    public static void sync(ProgressObserver progressObserver) throws Exception {
        SyncService.sync(progressObserver, false);
    }

    public static void sync(ProgressObserver progressObserver, boolean bl) throws Exception {
        SyncService.sync(progressObserver, bl, DataProvider.get().getOutlet());
    }

    public static void sync(ProgressObserver progressObserver, boolean bl, Outlet outlet) throws Exception {
        String string = outlet.getId();
        String string2 = DataProvider.get().getCurrentOutletId();
        boolean bl2 = PosWebService.get().isNewSchema();
        Date date = PosWebService.get().getCurrentServerTime();
        Date date2 = StoreDAO.getServerTimestamp();
        CloudDataDownloader cloudDataDownloader = new CloudDataDownloader(progressObserver, date, date2);
        CloudDataUploader cloudDataUploader = new CloudDataUploader(progressObserver, date, date2);
        if (bl2) {
            SyncService.a(date2, outlet, !bl);
            if (bl) {
                cloudDataUploader.uploadLocalSettings();
            } else {
                progressObserver.progress(Messages.getString("SyncService.77"));
                cloudDataDownloader.downloadCloudSettings();
            }
        } else {
            cloudDataDownloader.downloadStore(false);
            cloudDataUploader.uploadStore();
        }
        cloudDataDownloader.downloadAllData(0);
        cloudDataUploader.uploadAllData(bl2, 51);
        cloudDataUploader.updateStoreLastUpdateTimeProperties(cloudDataDownloader.getSyncErrorModels());
        SyncService.a(cloudDataUploader, date);
        DataProvider.get().initialize();
        progressObserver.progressComplete(Boolean.TRUE);
        if (!string.equals(string2)) {
            POSMessageDialog.showMessage(Messages.getString("OutletChangeRestartMsg"));
            Main.restart();
        }
    }

    private static void a(Date date, Outlet outlet, boolean bl) throws Exception {
        GenericDAO genericDAO = GenericDAO.getInstance();
        if (!outlet.getId().equals(DataProvider.get().getCurrentOutletId())) {
            genericDAO.changeCurrentOutletAndRelatedModels(SyncService.getOutletRelatedModelClasses(), outlet);
            DataProvider.get().initialize();
        } else {
            genericDAO.updateOutletRelatedModelsIfNullExists(SyncService.getOutletRelatedModelClasses());
        }
        for (DataSyncInfo dataSyncInfo : SyncService.getSyncModelClasses()) {
            genericDAO.updateLastUpdateTimeIfNull(dataSyncInfo.getRef(), date);
        }
    }

    private static void a(CloudDataUploader cloudDataUploader, Date date) throws Exception {
        Store store = StoreDAO.getRestaurant();
        if (store.getBooleanProperty("setup_complete", false)) {
            GenericDAO.getInstance().updateLastUpdateTimeProperty(store, Store.class, date);
            GenericDAO.getInstance().saveOrUpdate(store);
            return;
        }
        store.addProperty("setup_complete", "true");
        GenericDAO.getInstance().updateLastUpdateTimeProperty(store, Store.class, date);
        GenericDAO.getInstance().saveOrUpdate(store);
        cloudDataUploader.uploadStore();
    }

    public static List<DataSyncInfo> getSyncModelClasses() {
        Outlet outlet = DataProvider.get().getOutlet();
        String string = outlet == null ? null : outlet.getId();
        ArrayList<DataSyncInfo> arrayList = new ArrayList<DataSyncInfo>();
        arrayList.add(new DataSyncInfo(Address.class, Address));
        arrayList.add(new DataSyncInfo(Outlet.class, Outlet));
        arrayList.add(new DataSyncInfo(StoreSession.class, StoreSession, string));
        arrayList.add(new DataSyncInfo(ImageResource.class, ImageResource));
        arrayList.add(new DataSyncInfo(Currency.class, Currency, string));
        arrayList.add(new DataSyncInfo(Shift.class, Shift, string));
        arrayList.add(new DataSyncInfo(CashDrawer.class, CashDrawer, string));
        arrayList.add(new DataSyncInfo(Terminal.class, Terminal, string));
        arrayList.add(new DataSyncInfo(TaxGroup.class, TaxGroup, string));
        arrayList.add(new DataSyncInfo(Tax.class, Tax, string));
        arrayList.add(new DataSyncInfo(OrderType.class, OrderType, string));
        arrayList.add(new DataSyncInfo(Department.class, Department));
        arrayList.add(new DataSyncInfo(UserType.class, UserType));
        arrayList.add(new DataSyncInfo(User.class, User, string));
        arrayList.add(new DataSyncInfo(AttendenceHistory.class, AttendenceHistory, string));
        arrayList.add(new DataSyncInfo(BalanceUpdateTransaction.class, BalanceUpdateTransaction));
        arrayList.add(new DataSyncInfo(Customer.class, Customer));
        arrayList.add(new DataSyncInfo(Multiplier.class, Multiplier));
        arrayList.add(new DataSyncInfo(MenuItemSize.class, MenuItemSize));
        arrayList.add(new DataSyncInfo(PizzaCrust.class, PizzaCrust));
        arrayList.add(new DataSyncInfo(PizzaPrice.class, PizzaPrice));
        arrayList.add(new DataSyncInfo(PriceTable.class, PriceTable, string));
        arrayList.add(new DataSyncInfo(PriceRule.class, PriceRule, string));
        arrayList.add(new DataSyncInfo(MenuModifier.class, MenuModifier));
        arrayList.add(new DataSyncInfo(ModifierGroup.class, ModifierGroup));
        arrayList.add(new DataSyncInfo(MenuCategory.class, MenuCategory));
        arrayList.add(new DataSyncInfo(MenuGroup.class, MenuGroup));
        arrayList.add(new DataSyncInfo(AttributeGroup.class, AttributeGroup));
        arrayList.add(new DataSyncInfo(Attribute.class, Attribute));
        arrayList.add(new DataSyncInfo(CookingInstruction.class, CookingInstruction));
        arrayList.add(new DataSyncInfo(Course.class, Course));
        arrayList.add(new DataSyncInfo(InventoryUnitGroup.class, InventoryUnitGroup));
        arrayList.add(new DataSyncInfo(InventoryUnit.class, InventoryUnit));
        arrayList.add(new DataSyncInfo(PackagingUnit.class, PackagingUnit));
        arrayList.add(new DataSyncInfo(InventoryLocation.class, InventoryLocation));
        arrayList.add(new DataSyncInfo(MenuItem.class, MenuItem));
        arrayList.add(new DataSyncInfo(InventoryVendor.class, InventoryVendor));
        arrayList.add(new DataSyncInfo(InventoryVendorItems.class, InventoryVendorItems));
        arrayList.add(new DataSyncInfo(InventoryClosingBalance.class, InventoryClosingBalance, string));
        arrayList.add(new DataSyncInfo(ShopFloor.class, ShopFloor, string));
        arrayList.add(new DataSyncInfo(ShopTableStatus.class, ShopTableStatus, string));
        arrayList.add(new DataSyncInfo(ShopTable.class, ShopTable, string));
        arrayList.add(new DataSyncInfo(BookingInfo.class, BookingInfo, string));
        arrayList.add(new DataSyncInfo(Ticket.class, Ticket, string));
        arrayList.add(new DataSyncInfo(CustomerGroup.class, CustomerGroup));
        arrayList.add(new DataSyncInfo(CustomPayment.class, CustomPayment, string));
        arrayList.add(new DataSyncInfo(DeclaredTips.class, DeclaredTips));
        arrayList.add(new DataSyncInfo(DeliveryAddress.class, DeliveryAddress));
        arrayList.add(new DataSyncInfo(DeliveryCharge.class, DeliveryCharge, string));
        arrayList.add(new DataSyncInfo(DeliveryInstruction.class, DeliveryInstruction));
        arrayList.add(new DataSyncInfo(Discount.class, Discount));
        arrayList.add(new DataSyncInfo(GiftCard.class, GiftCard));
        arrayList.add(new DataSyncInfo(SalesArea.class, SalesArea));
        arrayList.add(new DataSyncInfo(TerminalType.class, TerminalType, string));
        arrayList.add(new DataSyncInfo(InventoryTransaction.class, InventoryTransaction, string));
        arrayList.add(new DataSyncInfo(PrinterGroup.class, PrinterGroup));
        arrayList.add(new DataSyncInfo(VirtualPrinter.class, VirtualPrinter));
        arrayList.add(new DataSyncInfo(VoidReason.class, VoidReason));
        arrayList.add(new DataSyncInfo(ReportGroup.class, ReportGroup));
        arrayList.add(new DataSyncInfo(ShopTableType.class, ShopTableType));
        arrayList.add(new DataSyncInfo(ActionHistory.class, ActionHistory, string));
        arrayList.add(new DataSyncInfo(VoidItem.class, VoidItem, string));
        arrayList.add(new DataSyncInfo(Recepie.class, Recipe));
        arrayList.add(new DataSyncInfo(PurchaseOrder.class, PurchaseOrder, string));
        arrayList.add(new DataSyncInfo(StockCount.class, StockCount, string));
        arrayList.add(new DataSyncInfo(ShopFloorTemplate.class, ShopFloorTemplate, string));
        arrayList.add(new DataSyncInfo(Gratuity.class, Gratuity, string));
        arrayList.add(new DataSyncInfo(GratuityPaymentHistory.class, GratuityPaymentHistory, string));
        arrayList.add(new DataSyncInfo(SlideShowImage.class, SlideShowImage));
        return arrayList;
    }

    public static List<String> getOutletRelatedModelClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ActionHistory);
        arrayList.add(AttendenceHistory);
        arrayList.add(BookingInfo);
        arrayList.add(CashDrawer);
        arrayList.add(Gratuity);
        arrayList.add(InventoryClosingBalance);
        arrayList.add(InventoryLocation);
        arrayList.add(InventoryTransaction);
        arrayList.add(InventoryVendor);
        arrayList.add(InventoryVendorItems);
        arrayList.add(PosTransaction.REF);
        arrayList.add(PriceRule);
        arrayList.add(PriceTable);
        arrayList.add(PurchaseOrder);
        arrayList.add(ShopFloor);
        arrayList.add(ShopTable);
        arrayList.add(StockCount);
        arrayList.add(StoreSession);
        arrayList.add(Terminal);
        arrayList.add(Ticket);
        arrayList.add(User);
        return arrayList;
    }

    public static List<String> getNotReplaceableStoreKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("database.version");
        arrayList.add("software.version");
        arrayList.add("software.numeric.version");
        arrayList.add("web.service.url");
        arrayList.add("web.service.username");
        arrayList.add("web.service.password");
        arrayList.add("subscription.plan");
        arrayList.add("subscription.ticket_limit");
        return arrayList;
    }
}

