/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.server;

import com.floreantpos.PosLog;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Discount;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.BaseUserDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.ComboGroupDAO;
import com.floreantpos.model.dao.ComboItemDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.ModifierMultiplierPriceDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PizzaModifierPriceDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.dao._BaseRootDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.StoreUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.server.TicketDataServiceDao;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONObject;

public class BaseDataServiceDao {
    private static final String GSON_PARSING_DATE_FORMAT = "MMM dd, yyyy HH:mm:ss.SSSZ";
    public static final String DATA = "data";
    private static Logger LOGGER = Logger.getLogger(BaseDataServiceDao.class);
    private static BaseDataServiceDao instance;

    private BaseDataServiceDao() {
    }

    public void saveOrUpdateTickets(String string) throws Exception {
        this.saveOrUpdateTickets(string, true);
    }

    public List<Ticket> saveOrUpdateTickets(String string, boolean bl) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        this.debug("Request received: " + string);
        List<Ticket> list = this.populateTickets(jSONArray.toString());
        HashMap<String, CashDrawer> hashMap = new HashMap<String, CashDrawer>();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        for (Ticket timedModel : list) {
            if (timedModel.getTerminalId() == 0 && terminal != null) {
                timedModel.setTerminalId(terminal.getId());
            }
            timedModel.setShouldPublishMqtt(bl);
            HashSet<PosTransaction> hashSet = new HashSet<PosTransaction>();
            Set<PosTransaction> set = timedModel.getTransactions();
            if (set == null || set.isEmpty()) continue;
            for (PosTransaction posTransaction : set) {
                try {
                    CashDrawer cashDrawer;
                    PosTransaction posTransaction2 = ServiceUtils.convertPosTransactionUsingClassType(posTransaction);
                    hashSet.add(posTransaction2);
                    if (!StringUtils.isNotEmpty((String)posTransaction2.getCashDrawerId()) || (cashDrawer = (CashDrawer)hashMap.get(posTransaction2.getCashDrawerId())) != null || (cashDrawer = posTransaction2.getCashDrawer()) == null) continue;
                    hashMap.put(cashDrawer.getId(), cashDrawer);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
            }
            timedModel.setTransactions(hashSet);
        }
        if (hashMap.size() > 0) {
            for (CashDrawer cashDrawer : hashMap.values()) {
                BaseDataServiceDao.get().saveOrUpdateCashDrawer(cashDrawer);
            }
        }
        this.saveOrUpdateTickets(list, true, true);
        this.debug("Successfully saved ticket");
        if (jSONObject.has("linkedData")) {
            this.saveOrUpdateInventoryTransactions(jSONObject.getJSONArray("linkedData"));
        }
        return list;
    }

    public void saveOrUpdateInventoryTransactions(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = new JSONArray(jSONObject.getJSONArray(DATA).toString());
        this.saveOrUpdateInventoryTransactions(jSONArray);
    }

    private void saveOrUpdateInventoryTransactions(JSONArray jSONArray) throws Exception {
        ArrayList<InventoryTransaction> arrayList = new ArrayList<InventoryTransaction>();
        if (jSONArray.length() > 0) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                InventoryTransaction inventoryTransaction = (InventoryTransaction)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), InventoryTransaction.class);
                if (inventoryTransaction == null) continue;
                arrayList.add(inventoryTransaction);
            }
        }
        this.saveOrUpdateInventoryTransactions(arrayList, false, true);
    }

    private List<Ticket> populateTickets(String string) {
        try {
            if (string == null) {
                return null;
            }
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                this.populateMap(jSONObject, "orderType", hashMap, OrderType.class);
                this.populateMap(jSONObject, "terminal", hashMap3, Terminal.class);
                this.populateMap(jSONObject, "owner", hashMap2, User.class);
                HashMap<String, List<TicketItemModifier>> hashMap4 = new HashMap<String, List<TicketItemModifier>>();
                BaseDataServiceDao.populateTicketItemModifiers(jSONObject, hashMap4);
                HashMap<String, List<TicketItem>> hashMap5 = new HashMap<String, List<TicketItem>>();
                BaseDataServiceDao.populateComboTicketItems(jSONObject, hashMap5);
                HashMap<String, TicketItemModifier> hashMap6 = new HashMap<String, TicketItemModifier>();
                BaseDataServiceDao.populatePizzaTicketItemModifiers(jSONObject, hashMap6);
                Ticket ticket = (Ticket)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), Ticket.class);
                ticket.convertDiscountPropertyToList();
                StoreSession storeSession = StoreUtil.getCurrentStoreSession();
                if (storeSession != null) {
                    ticket.setStoreSessionId(storeSession.getId());
                }
                this.populateTicketItems(hashMap4, ticket);
                this.populateComboTicketItems(hashMap5, hashMap4, ticket);
                this.populatePizzaSizeModifier(hashMap6, ticket);
                arrayList.add(ticket);
            }
            this.saveOrderTypesIfNotExists(new ArrayList<OrderType>(hashMap.values()));
            this.saveTerminalsIfNotExists(new ArrayList<Terminal>(hashMap3.values()));
            this.saveUserIfNotExists(new ArrayList<User>(hashMap2.values()));
            return arrayList;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    private void saveOrderTypesIfNotExists(List<OrderType> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (OrderType orderType : list) {
            OrderType orderType2 = DataProvider.get().getOrderType(orderType.getId());
            if (orderType2 != null) continue;
            OrderTypeDAO.getInstance().save(orderType);
            this.debug("New order type " + orderType.getId() + " " + orderType.getName() + " has been created.");
        }
    }

    private void saveTerminalsIfNotExists(List<Terminal> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Terminal terminal : list) {
            Terminal terminal2 = TerminalDAO.getInstance().getByTerminalKey(terminal.getTerminalKey());
            if (terminal2 != null) continue;
            terminal.setCurrentCashDrawer(null);
            TerminalDAO.getInstance().save(terminal);
            this.debug("New terminal " + terminal.getId() + " " + terminal.getName() + " has been created.");
        }
    }

    private void saveUserIfNotExists(List<User> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (User user : list) {
            User user2 = DataProvider.get().getUserById(user.getId());
            if (user2 != null) continue;
            UserDAO.getInstance().save(user);
            this.debug("New user " + user.getId() + " " + user.getFirstName() + " has been created.");
        }
    }

    private void populateMap(JSONObject jSONObject, String string, Map map, Class clazz) throws Exception {
        if (!jSONObject.has(string)) {
            return;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(string);
        Object object = this.convertJson(jSONObject2.toString(), clazz);
        if (object != null) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor("id", object.getClass());
            map.put(propertyDescriptor.getReadMethod().invoke(object, new Object[0]), object);
        }
    }

    private Object convertJson(String string, Class clazz) throws Exception {
        return BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create().fromJson(string, clazz);
    }

    private void populateTicketItems(Map<String, List<TicketItemModifier>> map, Ticket ticket) {
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            ticketItem.convertCookingInstructionPropertyToList();
            if (!ticketItem.isComboItem().booleanValue()) {
                List<TicketItemModifier> list = map.get(ticketItem.getId());
                if (list != null) {
                    ModifiableTicketItem modifiableTicketItem = new ModifiableTicketItem(ticketItem.getId());
                    try {
                        PropertyUtils.copyProperties((Object)modifiableTicketItem, (Object)ticketItem);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    modifiableTicketItem.setId(ticketItem.getId());
                    modifiableTicketItem.setTicketItemModifiers(list);
                    arrayList.add(modifiableTicketItem);
                    continue;
                }
                arrayList.add(ticketItem);
                continue;
            }
            arrayList.add(ticketItem);
        }
        ticket.setTicketItems(arrayList);
    }

    private void populateComboTicketItems(Map<String, List<TicketItem>> map, Map<String, List<TicketItemModifier>> map2, Ticket ticket) {
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.isComboItem().booleanValue()) {
                ComboTicketItem comboTicketItem = new ComboTicketItem(ticketItem.getId());
                try {
                    PropertyUtils.copyProperties((Object)comboTicketItem, (Object)ticketItem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                List<TicketItem> list = map.get(ticketItem.getId());
                if (list != null && list.size() > 0) {
                    comboTicketItem.setComboItems(list);
                } else {
                    comboTicketItem.setComboItems(null);
                }
                List<TicketItemModifier> list2 = map2.get(ticketItem.getId());
                if (list2 != null && !list2.isEmpty()) {
                    comboTicketItem.setTicketItemModifiers(list2);
                } else {
                    comboTicketItem.setTicketItemModifiers(null);
                }
                arrayList.add(comboTicketItem);
            } else {
                arrayList.add(ticketItem);
            }
            ticket.setTicketItems(arrayList);
        }
    }

    private void populatePizzaSizeModifier(Map<String, TicketItemModifier> map, Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            TicketItemModifier ticketItemModifier = map.get(ticketItem.getId());
            if (ticketItemModifier == null) continue;
            ticketItem.setSizeModifier(ticketItemModifier);
        }
    }

    public static void populateTicketItemModifiers(JSONObject jSONObject, Map<String, List<TicketItemModifier>> map) throws NoSuchFieldException, ClassNotFoundException {
        if (!jSONObject.has("ticketItems")) {
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("ticketItems");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.has("ticketItemModifiers")) continue;
            BaseDataServiceDao.populateTicketItemModifiersToMap(jSONObject2.getString(TicketItem.PROP_ID), map, jSONObject2.getJSONArray("ticketItemModifiers"));
        }
    }

    public static void populatePizzaTicketItemModifiers(JSONObject jSONObject, Map<String, TicketItemModifier> map) throws NoSuchFieldException, ClassNotFoundException {
        if (!jSONObject.has("ticketItems")) {
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("ticketItems");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.has("sizeModifier")) continue;
            BaseDataServiceDao.populateSizeModifierToMap(jSONObject2.getString(TicketItem.PROP_ID), map, jSONObject2.getJSONObject("sizeModifier"));
        }
    }

    public static void populateComboTicketItems(JSONObject jSONObject, Map<String, List<TicketItem>> map) throws NoSuchFieldException, ClassNotFoundException {
        if (!jSONObject.has("ticketItems")) {
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("ticketItems");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.has("comboItems")) continue;
            BaseDataServiceDao.populateComboTicketItemToMap(jSONObject2.getString(TicketItem.PROP_ID), map, jSONObject2.getJSONArray("comboItems"));
        }
    }

    private static void populateTicketItemModifiersToMap(String string, Map<String, List<TicketItemModifier>> map, JSONArray jSONArray) throws NoSuchFieldException, ClassNotFoundException {
        if (jSONArray == null || jSONArray.length() == 0) {
            List<TicketItemModifier> list = map.get(string);
            if (list == null) {
                list = new ArrayList<TicketItemModifier>();
                map.put(string, list);
            }
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            TicketItemModifier ticketItemModifier = (TicketItemModifier)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), TicketItemModifier.class);
            if (string == null && ticketItemModifier.getTicketItem() != null) {
                string = ticketItemModifier.getTicketItem().getId();
            }
            if (string == null) continue;
            List<TicketItemModifier> list = map.get(string);
            if (list == null) {
                list = new ArrayList<TicketItemModifier>();
                map.put(string, list);
            }
            list.add(ticketItemModifier);
        }
    }

    private static void populateComboTicketItemToMap(String string, Map<String, List<TicketItem>> map, JSONArray jSONArray) throws NoSuchFieldException, ClassNotFoundException {
        if (jSONArray == null || jSONArray.length() == 0) {
            return;
        }
        TicketItem ticketItem = null;
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            ticketItem = jSONObject.has("ticketItemModifiers") ? (ModifiableTicketItem)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), ModifiableTicketItem.class) : (ComboTicketItem)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), ComboTicketItem.class);
            if (string == null) continue;
            List<TicketItem> list = map.get(string);
            if (list == null) {
                list = new ArrayList<TicketItem>();
                map.put(string, list);
            }
            list.add(ticketItem);
        }
    }

    private static void populateSizeModifierToMap(String string, Map<String, TicketItemModifier> map, JSONObject jSONObject) throws NoSuchFieldException, ClassNotFoundException {
        TicketItemModifier ticketItemModifier;
        if (jSONObject == null || jSONObject.length() == 0) {
            return;
        }
        TicketItemModifier ticketItemModifier2 = (TicketItemModifier)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), TicketItemModifier.class);
        if (string != null && (ticketItemModifier = map.get(string)) == null) {
            map.put(string, ticketItemModifier2);
        }
    }

    public void saveOrUpdateTickets(List<Ticket> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Ticket ticket : list) {
            TicketDataServiceDao.get().saveOrUpdateTicket(ticket, bl, bl2);
        }
    }

    public void saveOrUpdateCashDrawers(String string) {
        this.saveOrUpdateCashDrawers(string, this.getOutletId(string));
    }

    private String getOutletId(String string) {
        String string2;
        JSONObject jSONObject = new JSONObject(string);
        String string3 = string2 = jSONObject.has("deviceId") ? jSONObject.getString("deviceId") : null;
        if (StringUtils.isNotEmpty((String)string2)) {
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(string2);
            return terminal.getOutletId();
        }
        return StoreDAO.getRestaurant().getDefaultOutletId();
    }

    public void saveOrUpdateCashDrawers(String string, String string2) {
        try {
            Gson gson;
            Object object;
            Object object2;
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject(string);
            JSONArray jSONArray = jSONObject2.getJSONArray(DATA);
            if (jSONArray != null && jSONArray.length() > 0) {
                jSONObject = new ArrayList();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object2 = jSONArray.getJSONObject(i);
                    object = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create();
                    CashDrawer cashDrawer = (CashDrawer)object.fromJson(object2.toString(), CashDrawer.class);
                    if (cashDrawer == null) continue;
                    jSONObject.add(cashDrawer);
                }
                gson = jSONObject.iterator();
                while (gson.hasNext()) {
                    object2 = (CashDrawer)gson.next();
                    ((BaseCashDrawer)object2).setOutletId(string2);
                    this.saveOrUpdateCashDrawer((CashDrawer)object2, true);
                }
            }
            JSONObject jSONObject3 = jSONObject = jSONObject2.has("linkedData") ? jSONObject2.getJSONObject("linkedData") : null;
            if (jSONObject != null && (object2 = (Terminal)(gson = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create()).fromJson(jSONObject.toString(), Terminal.class)) != null && (object = TerminalDAO.getInstance().get(((BaseTerminal)object2).getId())) != null) {
                ((Terminal)object).setAssignedUser(((Terminal)object2).getAssignedUser());
                ((BaseTerminal)object).setCurrentCashDrawer(((BaseTerminal)object2).getCurrentCashDrawer());
                TerminalDAO.getInstance().update((Terminal)object);
            }
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
        }
    }

    private void saveOrUpdateCashDrawer(CashDrawer cashDrawer) {
        this.saveOrUpdateCashDrawer(cashDrawer, false);
    }

    private void saveOrUpdateCashDrawer(CashDrawer cashDrawer, boolean bl) {
        Session session = null;
        Transaction transaction = null;
        CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
        try {
            session = cashDrawerDAO.createNewSession();
            transaction = session.beginTransaction();
            cashDrawer.setStoreSession(StoreUtil.getCurrentStoreSession());
            CashDrawer cashDrawer2 = CashDrawerDAO.getInstance().get(cashDrawer.getId());
            if (cashDrawer2 == null) {
                cashDrawerDAO.save(cashDrawer);
                this.debug("New cash drawer " + cashDrawer.getId() + ", asssignd user " + cashDrawer.getAssignedUserId() + " has been created.");
            } else {
                if (bl) {
                    cashDrawer.setVersion(cashDrawer2.getVersion());
                    cashDrawerDAO.update(cashDrawer);
                }
                BaseDataServiceDao.updateTerminal(session, cashDrawer.getTerminalId(), cashDrawer.getAssignedUser(), cashDrawer);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            cashDrawerDAO.closeSession(session);
        }
    }

    private static void updateTerminal(Session session, Integer n, User user, CashDrawer cashDrawer) {
        TerminalDAO terminalDAO = new TerminalDAO();
        Terminal terminal = terminalDAO.get(n, session);
        if (terminal != null) {
            CashDrawer cashDrawer2 = terminal.getCurrentCashDrawer();
            if (cashDrawer.isClosed() && cashDrawer2 != null && cashDrawer2.getId().equals(cashDrawer.getId())) {
                user = null;
                cashDrawer = null;
            }
            terminal.setAssignedUser(user);
            terminal.setCurrentCashDrawer(cashDrawer);
            terminal.setActive(true);
            terminalDAO.saveOrUpdate(terminal, session);
        }
    }

    public static BaseDataServiceDao get() {
        return BaseDataServiceDao.getInstance();
    }

    public void saveOrUpdateMenuItems(String string) throws Exception {
        this.saveOrUpdateMenuItemDataList(string, MenuItem.class);
    }

    public void saveOrUpdateMenuGroups(String string) throws Exception {
        this.saveOrUpdateDataList(string, MenuGroup.class);
    }

    public void saveOrUpdateMenuCategories(String string) throws Exception {
        this.saveOrUpdateDataList(string, MenuCategory.class);
    }

    public void saveOrUpdateTerminals(String string) throws Exception {
        List list = this.getDataListFromJson(string, Terminal.class);
        if (list != null && list.size() > 0) {
            for (Terminal terminal : list) {
                Terminal terminal2 = TerminalDAO.getInstance().get(terminal.getId());
                if (terminal2 == null) {
                    TerminalDAO.getInstance().save(terminal);
                    continue;
                }
                terminal2.setName(terminal.getName());
                terminal2.setActive(terminal.isActive());
                terminal2.setDepartmentId(terminal.getDepartmentId());
                terminal2.setHasCashDrawer(terminal.isHasCashDrawer());
                TerminalDAO.getInstance().update(terminal2);
            }
        }
    }

    public void saveOrUpdateMenuItemDataList(String string, Class clazz) throws Exception {
        List list = this.getDataListFromJson(string, clazz);
        for (MenuItem menuItem : list) {
            this.saveOrUpdateMenuItems(Arrays.asList(menuItem), false, false);
        }
    }

    public List saveOrUpdateDataList(String string, Class clazz) throws Exception {
        TerminalDAO terminalDAO = new TerminalDAO();
        Session session = null;
        Transaction transaction = null;
        try {
            session = terminalDAO.createNewSession();
            transaction = session.beginTransaction();
            List list = this.saveOrUpdateDataList(string, clazz, session);
            transaction.commit();
            List list2 = list;
            return list2;
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            terminalDAO.closeSession(session);
        }
    }

    public List saveOrUpdateDataList(String string, Class clazz, Session session) throws Exception {
        List list = this.getDataListFromJson(string, clazz);
        for (Object e : list) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor("id", e.getClass());
            Object object = propertyDescriptor.getReadMethod().invoke(e, new Object[0]);
            Object object2 = this.getExistingData(e.getClass(), object);
            if (object2 == null) {
                session.save(e);
                continue;
            }
            PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor("version", e.getClass());
            long l = (Long)propertyDescriptor2.getReadMethod().invoke(object2, new Object[0]);
            propertyDescriptor2.getWriteMethod().invoke(e, l);
            session.update(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getExistingData(Class<? extends Object> clazz, Object object) {
        TerminalDAO terminalDAO = new TerminalDAO();
        Session session = null;
        try {
            session = terminalDAO.createNewSession();
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)object));
            Object object2 = criteria.uniqueResult();
            return object2;
        }
        finally {
            terminalDAO.closeSession(session);
        }
    }

    public List getDataListFromJson(String string, Class clazz) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            arrayList.add(this.toObject(jSONObject2, clazz));
        }
        return arrayList;
    }

    public Object toObject(JSONObject jSONObject, Class<?> clazz) throws Exception {
        Gson gson = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create();
        return gson.fromJson(jSONObject.toString(), clazz);
    }

    private void debug(String string) {
        PosLog.debug(this.getClass(), string);
    }

    public void saveOrUpdateInventoryTransactions(List<InventoryTransaction> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        InventoryTransactionDAO inventoryTransactionDAO = new InventoryTransactionDAO();
        Transaction transaction = null;
        Session session = null;
        HashMap<String, MenuItem> hashMap = new HashMap<String, MenuItem>();
        try {
            session = inventoryTransactionDAO.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryTransaction inventoryTransaction : list) {
                Comparable comparable;
                MenuItem menuItem = inventoryTransaction.getMenuItem();
                if (menuItem != null) {
                    comparable = (MenuItem)hashMap.get(menuItem.getId());
                    if (comparable != null) {
                        inventoryTransaction.setMenuItem((MenuItem)comparable);
                    } else {
                        MenuItemDAO.getInstance().initialize(menuItem);
                        hashMap.put(menuItem.getId(), menuItem);
                    }
                }
                comparable = null;
                if (StringUtils.isNotEmpty((String)inventoryTransaction.getId())) {
                    comparable = inventoryTransactionDAO.get(inventoryTransaction.getId(), session);
                }
                if (comparable != null) continue;
                inventoryTransaction.setUpdateLastUpdateTime(bl);
                inventoryTransaction.setUpdateSyncTime(bl2);
                inventoryTransactionDAO.save(inventoryTransaction, session);
                inventoryTransactionDAO.adjustInventoryStock(inventoryTransaction, session);
            }
            transaction.commit();
            this.debug("Successfully inventory adjusted");
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            inventoryTransactionDAO.closeSession(session);
        }
    }

    public void saveOrUpdateMenuModifiers(List<MenuModifier> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        MenuModifierDAO menuModifierDAO = MenuModifierDAO.getInstance();
        Transaction transaction = null;
        Session session = null;
        try {
            session = menuModifierDAO.createNewSession();
            transaction = session.beginTransaction();
            for (MenuModifier menuModifier : list) {
                MenuModifier menuModifier2 = menuModifierDAO.loadFullModifier(menuModifier.getId());
                List<PizzaModifierPrice> list2 = menuModifier.getPizzaModifierPriceList();
                List<ModifierMultiplierPrice> list3 = menuModifier.getMultiplierPriceList();
                List<ModifierGroup> list4 = menuModifier.getModifierGroups();
                menuModifier.setUpdateLastUpdateTime(bl);
                menuModifier.setUpdateSyncTime(bl2);
                menuModifier.setPizzaModifierPriceList(null);
                menuModifier.setMultiplierPriceList(null);
                menuModifier.setModifierGroups(null);
                this.saveOrUpdateVerMenuModifier(session, menuModifier, menuModifier2);
                this.saveOrUpdatePizzaModifierPrice(session, menuModifier2, list2);
                this.saveOrUpdateModifierMultiplierPrice(session, menuModifier, menuModifier2, list3);
                this.saveOrUpdateModifierGroup(session, menuModifier2, list4, bl, bl2);
                menuModifier.setPizzaModifierPriceList(list2);
                menuModifier.setMultiplierPriceList(list3);
                menuModifier.setModifierGroups(list4);
                menuModifierDAO.saveOrUpdate(menuModifier, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            menuModifierDAO.closeSession(session);
        }
    }

    private void saveOrUpdateModifierGroup(Session session, MenuModifier menuModifier, List<ModifierGroup> list, boolean bl, boolean bl2) {
        if (list == null) {
            return;
        }
        List<ModifierGroup> list2 = null;
        if (menuModifier != null) {
            list2 = menuModifier.getModifierGroups();
        }
        for (ModifierGroup modifierGroup : list) {
            this.saveOrUpdateModifierGroup(session, modifierGroup, list2, bl, bl2);
        }
    }

    private void saveOrUpdateModifierGroup(Session session, ModifierGroup modifierGroup, List<ModifierGroup> list, boolean bl, boolean bl2) {
        ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
        ModifierGroup modifierGroup2 = null;
        modifierGroup.setUpdateLastUpdateTime(bl);
        modifierGroup.setUpdateSyncTime(bl2);
        if (list == null || list.isEmpty()) {
            this.saveOrSetVersionModifierGroup(session, modifierGroup, modifierGroupDAO);
        } else {
            int n = list.indexOf(modifierGroup);
            if (n != -1) {
                modifierGroup2 = list.get(n);
                if (modifierGroup2 == null) {
                    modifierGroupDAO.save(modifierGroup, session);
                } else {
                    modifierGroup.setVersion(modifierGroup2.getVersion());
                }
            } else {
                this.saveOrSetVersionModifierGroup(session, modifierGroup, modifierGroupDAO);
            }
        }
    }

    private void saveOrSetVersionModifierGroup(Session session, ModifierGroup modifierGroup, ModifierGroupDAO modifierGroupDAO) {
        ModifierGroup modifierGroup2 = modifierGroupDAO.get(modifierGroup.getId(), session);
        if (modifierGroup2 == null) {
            modifierGroupDAO.save(modifierGroup, session);
        } else {
            modifierGroup.setVersion(modifierGroup2.getVersion());
        }
    }

    private void saveOrUpdatePizzaModifierPrice(Session session, MenuModifier menuModifier, List<PizzaModifierPrice> list) {
        if (list == null) {
            return;
        }
        List<PizzaModifierPrice> list2 = null;
        if (menuModifier != null) {
            list2 = menuModifier.getPizzaModifierPriceList();
        }
        for (PizzaModifierPrice pizzaModifierPrice : list) {
            PizzaModifierPrice pizzaModifierPrice2 = PizzaModifierPriceDAO.getInstance().get(pizzaModifierPrice.getId());
            List<ModifierMultiplierPrice> list3 = pizzaModifierPrice.getMultiplierPriceList();
            pizzaModifierPrice.setMultiplierPriceList(null);
            this.saveOrUpdateVerPizzaModifierPrice(session, pizzaModifierPrice, pizzaModifierPrice2);
            if (list3 != null) {
                this.saveOrUpdateModifierMultiplierPrice(session, pizzaModifierPrice, pizzaModifierPrice2, list3);
                pizzaModifierPrice.setMultiplierPriceList(list3);
            }
            this.saveOrUpdatePizzaModifierPrice(session, pizzaModifierPrice, list2);
        }
    }

    private void saveOrUpdateVerPizzaModifierPrice(Session session, PizzaModifierPrice pizzaModifierPrice, PizzaModifierPrice pizzaModifierPrice2) {
        if (pizzaModifierPrice2 == null) {
            PizzaModifierPriceDAO.getInstance().save(pizzaModifierPrice, session);
        } else {
            pizzaModifierPrice.setVersion(pizzaModifierPrice2.getVersion());
        }
    }

    private void saveOrUpdateModifierMultiplierPrice(Session session, PizzaModifierPrice pizzaModifierPrice, PizzaModifierPrice pizzaModifierPrice2, List<ModifierMultiplierPrice> list) {
        List<ModifierMultiplierPrice> list2 = null;
        if (pizzaModifierPrice2 != null) {
            list2 = pizzaModifierPrice2.getMultiplierPriceList();
        }
        for (ModifierMultiplierPrice modifierMultiplierPrice : list) {
            modifierMultiplierPrice.setPizzaModifierPriceId(pizzaModifierPrice.getId());
            this.saveOrUpdateModifierMultiplierPrice(session, modifierMultiplierPrice, list2);
        }
    }

    private void saveOrUpdateModifierMultiplierPrice(Session session, MenuModifier menuModifier, MenuModifier menuModifier2, List<ModifierMultiplierPrice> list) {
        if (list == null) {
            return;
        }
        List<ModifierMultiplierPrice> list2 = null;
        if (menuModifier2 != null) {
            list2 = menuModifier2.getMultiplierPriceList();
        }
        for (ModifierMultiplierPrice modifierMultiplierPrice : list) {
            modifierMultiplierPrice.setModifierId(menuModifier.getId());
            this.saveOrUpdateModifierMultiplierPrice(session, modifierMultiplierPrice, list2);
        }
    }

    private void saveOrUpdatePizzaModifierPrice(Session session, PizzaModifierPrice pizzaModifierPrice, List<PizzaModifierPrice> list) {
        PizzaModifierPriceDAO pizzaModifierPriceDAO = new PizzaModifierPriceDAO();
        PizzaModifierPrice pizzaModifierPrice2 = null;
        if (list == null || list.isEmpty()) {
            pizzaModifierPriceDAO.save(pizzaModifierPrice, session);
        } else {
            int n = list.indexOf(pizzaModifierPrice);
            if (n != -1) {
                pizzaModifierPrice2 = list.get(n);
                if (pizzaModifierPrice2 == null) {
                    pizzaModifierPriceDAO.save(pizzaModifierPrice, session);
                } else {
                    pizzaModifierPrice.setVersion(pizzaModifierPrice2.getVersion());
                }
            } else {
                pizzaModifierPriceDAO.save(pizzaModifierPrice, session);
            }
        }
    }

    private void saveOrUpdateModifierMultiplierPrice(Session session, ModifierMultiplierPrice modifierMultiplierPrice, List<ModifierMultiplierPrice> list) {
        ModifierMultiplierPriceDAO modifierMultiplierPriceDAO = new ModifierMultiplierPriceDAO();
        ModifierMultiplierPrice modifierMultiplierPrice2 = null;
        if (list == null || list.isEmpty()) {
            modifierMultiplierPrice.setVersion(0L);
            modifierMultiplierPriceDAO.save(modifierMultiplierPrice, session);
        } else {
            int n = list.indexOf(modifierMultiplierPrice);
            if (n != -1) {
                modifierMultiplierPrice2 = list.get(n);
                if (modifierMultiplierPrice2 == null) {
                    modifierMultiplierPriceDAO.save(modifierMultiplierPrice, session);
                } else {
                    modifierMultiplierPrice.setVersion(modifierMultiplierPrice2.getVersion());
                }
            } else {
                modifierMultiplierPriceDAO.save(modifierMultiplierPrice, session);
            }
        }
    }

    private void saveOrUpdateVerMenuModifier(Session session, MenuModifier menuModifier, MenuModifier menuModifier2) {
        if (menuModifier2 == null) {
            MenuModifierDAO.getInstance().save(menuModifier, session);
        } else {
            menuModifier.setVersion(menuModifier2.getVersion());
        }
    }

    public void saveOrUpdateUsers(List<User> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        ArrayList<User> arrayList2 = new ArrayList<User>();
        UserDAO userDAO = UserDAO.getInstance();
        for (User user : list) {
            if (user.isRoot().booleanValue()) {
                arrayList.add(user);
                continue;
            }
            arrayList2.add(user);
        }
        this.saveUser(arrayList, bl, bl2, userDAO);
        this.saveUser(arrayList2, bl, bl2, userDAO);
    }

    private void saveUser(List<User> list, boolean bl, boolean bl2, UserDAO userDAO) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = userDAO.createNewSession();
            transaction = session.beginTransaction();
            for (User user : list) {
                User user2 = userDAO.get(user.getId());
                if (user2 != null && !this.shouldSave(user.getLastUpdateTime(), user2.getLastUpdateTime())) {
                    this.printAreadyUpdated(user.getFullName());
                    continue;
                }
                if (!bl && user2 != null && user2.getLastClockInTime() != null && (user.getLastClockInTime() == null || user2.getLastClockInTime().after(user.getLastClockInTime()))) {
                    user.setLastClockInTime(user2.getLastClockInTime());
                    user.setClockedIn(user2.getClockedIn());
                }
                this.saveOrSetVersionUsers(bl, bl2, session, user, user2, userDAO);
                userDAO.saveOrUpdate(user, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            userDAO.closeSession(session);
        }
    }

    private void saveOrSetVersionUsers(boolean bl, boolean bl2, Session session, User user, User user2, UserDAO userDAO) {
        User user3 = user.getParentUser();
        user.setUpdateLastUpdateTime(bl);
        user.setUpdateSyncTime(bl2);
        user.setParentUser(null);
        this.saveOrSetVersionUsers(session, user, user2, userDAO);
        user.setParentUser(user3);
    }

    private void saveOrSetVersionUsers(Session session, User user, User user2, UserDAO userDAO) {
        if (user2 == null) {
            User user3 = userDAO.get(user.getId(), session);
            if (user3 == null) {
                userDAO.save(user, session);
            } else {
                user.setVersion(user3.getVersion());
            }
        } else {
            user.setVersion(user2.getVersion());
        }
    }

    public List<MenuItem> saveOrUpdateMenuItems(List<MenuItem> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        ArrayList<MenuItem> arrayList2 = new ArrayList<MenuItem>();
        ArrayList<MenuItem> arrayList3 = new ArrayList<MenuItem>();
        ArrayList<MenuItem> arrayList4 = new ArrayList<MenuItem>();
        for (MenuItem menuItem : list) {
            if (menuItem.isComboItem().booleanValue()) {
                arrayList3.add(menuItem);
                continue;
            }
            if (!menuItem.isVariant().booleanValue()) {
                arrayList.add(menuItem);
                continue;
            }
            arrayList2.add(menuItem);
        }
        for (MenuItem menuItem : arrayList) {
            try {
                this.saveMenuItem(menuItem, bl, bl2);
            }
            catch (Exception exception) {
                arrayList4.add(menuItem);
            }
        }
        for (MenuItem menuItem : arrayList2) {
            try {
                this.saveMenuItem(menuItem, bl, bl2);
            }
            catch (Exception exception) {
                arrayList4.add(menuItem);
            }
        }
        for (MenuItem menuItem : arrayList3) {
            try {
                this.saveMenuItem(menuItem, bl, bl2);
            }
            catch (Exception exception) {
                arrayList4.add(menuItem);
            }
        }
        if (arrayList4.size() == 0) {
            return null;
        }
        Iterator<MenuItem> iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem;
            menuItem = iterator.next();
            try {
                this.saveMenuItem(menuItem, bl, bl2);
                iterator.remove();
            }
            catch (Exception exception) {
                PosLog.info(this.getClass(), "Failed to update menu item: " + menuItem.toString());
            }
        }
        return arrayList4;
    }

    private void saveMenuItem(MenuItem menuItem, boolean bl, boolean bl2) throws Exception {
        if (menuItem == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = MenuItemDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            this.saveMenuItem(bl, bl2, session, menuItem);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            MenuItemDAO.getInstance().closeSession(session);
        }
    }

    public void saveMenuItem(boolean bl, boolean bl2, Session session, MenuItem menuItem) throws Exception {
        String string = menuItem.getId();
        MenuItem menuItem2 = null;
        MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
        if (string != null) {
            menuItem2 = menuItemDAO.get(string);
        }
        if (menuItem2 != null && !this.shouldSave(menuItem.getLastUpdateTime(), menuItem2.getLastUpdateTime())) {
            this.printAreadyUpdated(menuItem.getDisplayName());
            return;
        }
        this.saveOrSetVersionMenuItem(bl, bl2, session, menuItem, menuItem2);
        menuItemDAO.saveOrUpdate(menuItem, session);
    }

    private void saveOrSetVersionMenuItem(boolean bl, boolean bl2, Session session, MenuItem menuItem, MenuItem menuItem2) throws Exception {
        MenuItemDAO.getInstance().initialize(menuItem2);
        List<Attribute> list = menuItem.getAttributes();
        List<Discount> list2 = menuItem.getDiscounts();
        List<MenuItemModifierSpec> list3 = menuItem.getMenuItemModiferSpecs();
        List<ComboGroup> list4 = menuItem.getComboGroups();
        List<ComboItem> list5 = menuItem.getComboItems();
        List<InventoryStockUnit> list6 = menuItem.getStockUnits();
        List<PizzaPrice> list7 = menuItem.getPizzaPriceList();
        List<MenuItem> list8 = menuItem.getVariants();
        menuItem.setUpdateLastUpdateTime(bl);
        menuItem.setUpdateSyncTime(bl2);
        menuItem.setAttributes(null);
        menuItem.setDiscounts(null);
        menuItem.setMenuItemModiferSpecs(null);
        menuItem.setComboGroups(null);
        menuItem.setComboItems(null);
        menuItem.setStockUnits(null);
        menuItem.setPizzaPriceList(null);
        menuItem.setVariants(null);
        this.saveOrSetVersionMenuItem(session, menuItem, menuItem2);
        this.saveOrSetVersionComboItems(session, menuItem, menuItem2, list5);
        this.saveOrSetVersionAttributes(session, menuItem2, list);
        this.saveOrSetVersionDiscounts(session, menuItem2, list2);
        this.saveOrSetVersionMenuItemModifierSpecs(session, menuItem2, list3, bl, bl2);
        this.saveOrSetVersionComboGroups(session, menuItem2, list4);
        this.saveOrSetVersionInvStockUnits(session, menuItem2, list6);
        this.saveOrSetVersionPizzaPrices(session, menuItem2, list7);
        this.saveOrSetVersionVariants(session, menuItem2, list8);
        menuItem.setAttributes(list);
        menuItem.setDiscounts(list2);
        menuItem.setMenuItemModiferSpecs(list3);
        menuItem.setComboGroups(list4);
        menuItem.setComboItems(list5);
        menuItem.setStockUnits(list6);
        menuItem.setPizzaPriceList(list7);
        menuItem.setVariants(list8);
    }

    private void saveOrSetVersionVariants(Session session, MenuItem menuItem, List<MenuItem> list) throws Exception {
        if (list == null) {
            return;
        }
        this.info(list.size(), " variants found");
        for (MenuItem menuItem2 : list) {
            MenuItem menuItem3 = MenuItemDAO.getInstance().get(menuItem2.getId());
            if (menuItem3 != null && !this.shouldSave(menuItem2.getLastUpdateTime(), menuItem3.getLastUpdateTime())) {
                this.printAreadyUpdated(menuItem2.getDisplayName());
                continue;
            }
            this.saveOrSetVersionMenuItem(false, false, session, menuItem2, menuItem3);
        }
    }

    private void saveOrSetVersionPizzaPrices(Session session, MenuItem menuItem, List<PizzaPrice> list) {
        if (list == null) {
            return;
        }
        this.info(list.size(), " PizzaPrices found");
        List<PizzaPrice> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getPizzaPriceList();
        }
        for (PizzaPrice pizzaPrice : list) {
            PizzaPriceDAO pizzaPriceDAO = new PizzaPriceDAO();
            PizzaPrice pizzaPrice2 = null;
            if (list2 == null || list2.isEmpty()) {
                pizzaPrice2 = pizzaPriceDAO.get(pizzaPrice.getId(), session);
                if (pizzaPrice2 == null) {
                    pizzaPriceDAO.save(pizzaPrice, session);
                    continue;
                }
                session.evict((Object)pizzaPrice2);
                pizzaPrice.setVersion(pizzaPrice2.getVersion());
                continue;
            }
            pizzaPrice2 = pizzaPriceDAO.get(pizzaPrice.getId());
            if (pizzaPrice2 != null) {
                pizzaPrice.setVersion(pizzaPrice2.getVersion());
                continue;
            }
            pizzaPriceDAO.save(pizzaPrice, session);
        }
    }

    private void saveOrSetVersionInvStockUnits(Session session, MenuItem menuItem, List<InventoryStockUnit> list) {
        if (list == null) {
            return;
        }
        this.info(list.size(), " stockUnits found");
        List<InventoryStockUnit> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getStockUnits();
        }
        for (InventoryStockUnit inventoryStockUnit : list) {
            InventoryStockUnitDAO inventoryStockUnitDAO = new InventoryStockUnitDAO();
            InventoryStockUnit inventoryStockUnit2 = null;
            if (list2 == null || list2.isEmpty()) {
                inventoryStockUnit2 = inventoryStockUnitDAO.get(inventoryStockUnit.getId(), session);
                if (inventoryStockUnit2 == null) {
                    inventoryStockUnitDAO.save(inventoryStockUnit, session);
                    continue;
                }
                session.evict((Object)inventoryStockUnit2);
                inventoryStockUnit.setVersion(inventoryStockUnit2.getVersion());
                continue;
            }
            int n = list2.indexOf(inventoryStockUnit);
            if (n != -1) {
                inventoryStockUnit2 = list2.get(n);
                if (inventoryStockUnit2 == null) {
                    inventoryStockUnitDAO.save(inventoryStockUnit, session);
                    continue;
                }
                inventoryStockUnit.setVersion(inventoryStockUnit2.getVersion());
                continue;
            }
            inventoryStockUnitDAO.save(inventoryStockUnit, session);
        }
    }

    private void saveOrSetVersionComboItems(Session session, MenuItem menuItem, MenuItem menuItem2, List<ComboItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.info(list.size(), " comboItems found");
        List<ComboItem> list2 = null;
        if (menuItem2 != null) {
            list2 = menuItem2.getComboItems();
        }
        for (ComboItem comboItem : list) {
            comboItem.setMenuItemId(menuItem.getId());
            ComboItemDAO comboItemDAO = new ComboItemDAO();
            ComboItem comboItem2 = null;
            if (list2 == null || list2.isEmpty()) {
                comboItem2 = comboItemDAO.get(comboItem.getId(), session);
                if (comboItem2 == null) {
                    comboItemDAO.save(comboItem, session);
                    continue;
                }
                session.evict((Object)comboItem2);
                comboItem.setVersion(comboItem2.getVersion());
                continue;
            }
            int n = list2.indexOf(comboItem);
            if (n != -1) {
                comboItem2 = list2.get(n);
                if (comboItem2 == null) {
                    comboItemDAO.save(comboItem, session);
                    continue;
                }
                comboItem.setVersion(comboItem2.getVersion());
                continue;
            }
            comboItemDAO.save(comboItem, session);
        }
    }

    private void saveOrSetVersionComboGroups(Session session, MenuItem menuItem, List<ComboGroup> list) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.info(list.size(), " comboGroup found");
        List<ComboGroup> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getComboGroups();
        }
        for (ComboGroup comboGroup : list) {
            List<MenuItem> list3 = comboGroup.getItems();
            comboGroup.setItems(null);
            if (list3 != null && list3.size() > 0) {
                for (MenuItem menuItem2 : list3) {
                    MenuItemDAO.getInstance().initialize(menuItem2);
                    comboGroup.addToitems(menuItem2);
                }
            }
            ComboGroupDAO comboGroupDAO = new ComboGroupDAO();
            Object var9_12 = null;
            if (list2 == null || list2.isEmpty()) {
                ComboGroup comboGroup2 = comboGroupDAO.get(comboGroup.getId(), session);
                if (comboGroup2 == null) {
                    comboGroupDAO.save(comboGroup, session);
                    continue;
                }
                session.evict((Object)comboGroup2);
                comboGroup.setVersion(comboGroup2.getVersion());
                continue;
            }
            int n = list2.indexOf(comboGroup);
            if (n != -1) {
                ComboGroup comboGroup3 = list2.get(n);
                if (comboGroup3 == null) {
                    comboGroupDAO.save(comboGroup, session);
                    continue;
                }
                comboGroup.setVersion(comboGroup3.getVersion());
                continue;
            }
            comboGroupDAO.save(comboGroup, session);
        }
    }

    private void saveOrSetVersionMenuItemModifierSpecs(Session session, MenuItem menuItem, List<MenuItemModifierSpec> list, boolean bl, boolean bl2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.info(list.size(), " menuItemModiferSpec found");
        List<MenuItemModifierSpec> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getMenuItemModiferSpecs();
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            this.saveOrSetVersionMenuItemModifierSpecs(session, bl, bl2, list2, menuItemModifierSpec);
        }
    }

    public void saveOrSetVersionMenuItemModifierSpecs(Session session, boolean bl, boolean bl2, List<MenuItemModifierSpec> list, MenuItemModifierSpec menuItemModifierSpec) {
        Set<MenuItemModifierPage> set = menuItemModifierSpec.getModifierPages();
        menuItemModifierSpec.setUpdateLastUpdateTime(bl);
        menuItemModifierSpec.setUpdateSyncTime(bl2);
        menuItemModifierSpec.setModifierPages(null);
        this.saveOrSetVersionMenuItemModifierSpec(session, menuItemModifierSpec);
        menuItemModifierSpec.setModifierPages(set);
        if (set != null && !set.isEmpty()) {
            for (MenuItemModifierPage comparable2 : set) {
                this.saveOrSetVersionMenuItemModiPage(session, comparable2);
            }
        }
        MenuItemModifierSpecDAO menuItemModifierSpecDAO = new MenuItemModifierSpecDAO();
        Object var8_9 = null;
        if (list == null || list.isEmpty()) {
            MenuItemModifierSpec menuItemModifierSpec2 = menuItemModifierSpecDAO.get(menuItemModifierSpec.getId(), session);
            if (menuItemModifierSpec2 == null) {
                menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
            } else {
                session.evict((Object)menuItemModifierSpec2);
                menuItemModifierSpec.setVersion(menuItemModifierSpec2.getVersion());
            }
        } else {
            int n = list.indexOf(menuItemModifierSpec);
            if (n != -1) {
                MenuItemModifierSpec menuItemModifierSpec3 = list.get(n);
                if (menuItemModifierSpec3 == null) {
                    menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
                } else {
                    menuItemModifierSpec.setVersion(menuItemModifierSpec3.getVersion());
                }
            } else {
                menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
            }
        }
    }

    public void saveOrSetVersionMenuItemModiPage(Session session, MenuItemModifierPage menuItemModifierPage) {
        List<MenuItemModifierPageItem> list = menuItemModifierPage.getPageItems();
        menuItemModifierPage.setPageItems(null);
        this.saveOrSetVersionMenuItemModifierPage(session, menuItemModifierPage);
        this.saveOrSetVersionMenuItemModifierPageItem(session, menuItemModifierPage, list);
        menuItemModifierPage.setPageItems(list);
    }

    private void saveOrSetVersionMenuItemModifierPageItem(Session session, MenuItemModifierPage menuItemModifierPage, List<MenuItemModifierPageItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.info(list.size(), " page items found");
        MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = new MenuItemModifierPageItemDAO();
        MenuItemModifierPageItem menuItemModifierPageItem = null;
        for (MenuItemModifierPageItem menuItemModifierPageItem2 : list) {
            menuItemModifierPageItem = menuItemModifierPageItemDAO.get(menuItemModifierPageItem2.getId(), session);
            menuItemModifierPageItem2.setParentPageId(menuItemModifierPage.getId());
            if (menuItemModifierPageItem == null) {
                menuItemModifierPageItemDAO.save(menuItemModifierPageItem2, session);
                continue;
            }
            session.evict((Object)menuItemModifierPageItem);
            menuItemModifierPageItem2.setVersion(menuItemModifierPageItem.getVersion());
        }
    }

    private void saveOrSetVersionMenuItemModifierSpec(Session session, MenuItemModifierSpec menuItemModifierSpec) {
        MenuItemModifierSpecDAO menuItemModifierSpecDAO = MenuItemModifierSpecDAO.getInstance();
        MenuItemModifierSpec menuItemModifierSpec2 = menuItemModifierSpecDAO.get(menuItemModifierSpec.getId(), session);
        if (menuItemModifierSpec2 == null) {
            menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
        } else {
            session.evict((Object)menuItemModifierSpec2);
            menuItemModifierSpec.setVersion(menuItemModifierSpec2.getVersion());
        }
    }

    private void saveOrSetVersionMenuItemModifierPage(Session session, MenuItemModifierPage menuItemModifierPage) {
        MenuItemModifierPageDAO menuItemModifierPageDAO = MenuItemModifierPageDAO.getInstance();
        MenuItemModifierPage menuItemModifierPage2 = menuItemModifierPageDAO.get(menuItemModifierPage.getId(), session);
        if (menuItemModifierPage2 == null) {
            menuItemModifierPageDAO.save(menuItemModifierPage, session);
        } else {
            session.evict((Object)menuItemModifierPage2);
            menuItemModifierPage.setVersion(menuItemModifierPage2.getVersion());
        }
    }

    private void saveOrSetVersionDiscounts(Session session, MenuItem menuItem, List<Discount> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.info(list.size(), " discount found");
        List<Discount> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getDiscounts();
        }
        for (Discount discount : list) {
            DiscountDAO discountDAO = new DiscountDAO();
            Discount discount2 = null;
            if (list2 == null || list2.isEmpty()) {
                discount2 = discountDAO.get(discount.getId(), session);
                if (discount2 == null) {
                    discountDAO.save(discount, session);
                    continue;
                }
                session.evict((Object)discount2);
                discount.setVersion(discount2.getVersion());
                continue;
            }
            int n = list2.indexOf(discount);
            if (n != -1) {
                discount2 = list2.get(n);
                if (discount2 == null) {
                    discountDAO.save(discount, session);
                    continue;
                }
                discount.setVersion(discount2.getVersion());
                continue;
            }
            discountDAO.save(discount, session);
        }
    }

    private void saveOrSetVersionAttributes(Session session, MenuItem menuItem, List<Attribute> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.info(list.size(), " attribute found");
        List<Attribute> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getAttributes();
        }
        for (Attribute attribute : list) {
            AttributeDAO attributeDAO = new AttributeDAO();
            Attribute attribute2 = null;
            if (list2 == null || list2.isEmpty()) {
                attribute2 = attributeDAO.get(attribute.getId(), session);
                if (attribute2 == null) {
                    attributeDAO.save(attribute, session);
                    continue;
                }
                session.evict((Object)attribute2);
                attribute.setVersion(attribute2.getVersion());
                continue;
            }
            int n = list2.indexOf(attribute);
            if (n != -1) {
                attribute2 = list2.get(n);
                if (attribute2 == null) {
                    attributeDAO.save(attribute, session);
                    continue;
                }
                attribute.setVersion(attribute2.getVersion());
                continue;
            }
            attributeDAO.save(attribute, session);
        }
    }

    private void info(int n, String string) {
        if (n == 0) {
            return;
        }
        LOGGER.info((Object)(n + " " + string));
    }

    private void printAreadyUpdated(String string) {
        if (string == null) {
            return;
        }
        LOGGER.info((Object)("  " + string.toLowerCase() + " already updated."));
    }

    private void saveOrSetVersionMenuItem(Session session, MenuItem menuItem, MenuItem menuItem2) {
        if (menuItem2 == null) {
            session.save((Object)menuItem);
        } else {
            menuItem.setVersion(menuItem2.getVersion());
        }
    }

    public boolean shouldSave(Date date, Date date2) {
        if (date == null || date2 == null) {
            return true;
        }
        return date.after(date2);
    }

    public static BaseDataServiceDao getInstance() {
        if (instance == null) {
            instance = new BaseDataServiceDao();
        }
        return instance;
    }

    public void saveOrUpdateKitchenTickets(String string) {
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = jSONObject.getJSONArray(DATA);
            this.debug("Request received: " + string);
            String string3 = string2 = jSONObject.has("deviceId") ? jSONObject.getString("deviceId") : null;
            if (StringUtils.isEmpty((String)string2)) {
                return;
            }
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(string2);
            Terminal terminal2 = DataProvider.get().getCurrentTerminal();
            if (terminal == null || terminal2 == null) {
                return;
            }
            if (terminal2.getId().equals(terminal.getId())) {
                return;
            }
            if (terminal2.isMasterTerminal().booleanValue()) {
                ArrayList<KitchenTicket> arrayList = new ArrayList<KitchenTicket>();
                if (jSONArray != null && jSONArray.length() > 0) {
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                        try {
                            KitchenTicket kitchenTicket = (KitchenTicket)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create().fromJson(jSONObject2.toString(), KitchenTicket.class);
                            arrayList.add(kitchenTicket);
                            continue;
                        }
                        catch (Exception exception) {
                            PosLog.error(this.getClass(), exception);
                        }
                    }
                }
                this.saveOrUpdateKitTickets(arrayList);
            }
            this.debug("Successfully saved kitchen tickets");
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void saveOrUpdateKitTickets(List<KitchenTicket> list) {
        Transaction transaction = null;
        try (Session session = null;){
            KitchenTicketDAO kitchenTicketDAO = KitchenTicketDAO.getInstance();
            session = kitchenTicketDAO.createNewSession();
            transaction = session.beginTransaction();
            for (KitchenTicket kitchenTicket : list) {
                if (kitchenTicket == null || kitchenTicket.getId() == null) continue;
                KitchenStatus kitchenStatus = kitchenTicket.getKitchenStatusValue();
                if (kitchenStatus != null && kitchenStatus.equals((Object)KitchenStatus.DISPATCHED)) {
                    this.doPerformDispatchKitchenTicket(session, kitchenTicketDAO, kitchenTicket);
                    continue;
                }
                this.doSaveOrUpdateKitchenTicket(session, kitchenTicketDAO, kitchenTicket);
            }
            transaction.commit();
        }
    }

    private void doPerformDispatchKitchenTicket(Session session, KitchenTicketDAO kitchenTicketDAO, KitchenTicket kitchenTicket) {
        KitchenTicket kitchenTicket2 = kitchenTicketDAO.get(kitchenTicket.getId());
        if (kitchenTicket2 == null) {
            return;
        }
        kitchenTicketDAO.delete(kitchenTicket2, session);
    }

    private void doSaveOrUpdateKitchenTicket(Session session, KitchenTicketDAO kitchenTicketDAO, KitchenTicket kitchenTicket) {
        List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
        KitchenTicket kitchenTicket2 = kitchenTicketDAO.get(kitchenTicket.getId());
        kitchenTicket.setTicketItems(null);
        if (kitchenTicket2 == null) {
            kitchenTicketDAO.save(kitchenTicket, session);
        } else {
            kitchenTicket.setVersion(kitchenTicket2.getVersion());
        }
        List<KitchenTicketItem> list2 = null;
        if (kitchenTicket2 != null) {
            list2 = kitchenTicket2.getTicketItems();
        }
        for (KitchenTicketItem kitchenTicketItem : list) {
            if (list2 == null || list2.isEmpty()) {
                KitchenTicketItemDAO.getInstance().save(kitchenTicketItem, session);
                continue;
            }
            int n = list2.indexOf(kitchenTicketItem);
            if (n != -1) {
                KitchenTicketItem kitchenTicketItem2 = list2.get(n);
                kitchenTicketItem.setVersion(kitchenTicketItem2.getVersion());
                continue;
            }
            KitchenTicketItemDAO.getInstance().save(kitchenTicketItem, session);
        }
        kitchenTicket.setTicketItems(list);
        kitchenTicketDAO.saveOrUpdate(kitchenTicket, session);
    }

    public void saveOrUpdateVoidItems(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        ArrayList<VoidItem> arrayList = new ArrayList<VoidItem>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            VoidItem voidItem = (VoidItem)BaseDataServiceDao.getGsonBuilder().create().fromJson(jSONObject2.toString(), VoidItem.class);
            if (voidItem == null) continue;
            arrayList.add(voidItem);
        }
        this.saveOrUpdateVoidItems(arrayList);
    }

    public void saveOrUpdateVoidItems(List<VoidItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            VoidItemDAO voidItemDAO = VoidItemDAO.getInstance();
            session = voidItemDAO.createNewSession();
            transaction = session.beginTransaction();
            for (VoidItem voidItem : list) {
                VoidItem voidItem2 = voidItemDAO.get(voidItem.getId());
                if (voidItem2 == null) {
                    voidItemDAO.save(voidItem, session);
                } else {
                    voidItem.setVersion(voidItem2.getVersion());
                    voidItemDAO.update(voidItem, session);
                }
                VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem, session);
            }
            transaction.commit();
        }
    }

    public void saveOrUpdateAttendanceHistory(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        ArrayList<AttendenceHistory> arrayList = new ArrayList<AttendenceHistory>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            AttendenceHistory attendenceHistory = (AttendenceHistory)BaseDataServiceDao.getGsonBuilder().create().fromJson(jSONObject2.toString(), AttendenceHistory.class);
            if (attendenceHistory == null) continue;
            arrayList.add(attendenceHistory);
        }
        this.saveOrUpdateAttendanceHistory(arrayList);
    }

    public void saveOrUpdateAttendanceHistory(List<AttendenceHistory> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            AttendenceHistoryDAO attendenceHistoryDAO = AttendenceHistoryDAO.getInstance();
            session = attendenceHistoryDAO.createNewSession();
            transaction = session.beginTransaction();
            for (AttendenceHistory attendenceHistory : list) {
                AttendenceHistory attendenceHistory2 = attendenceHistoryDAO.get(attendenceHistory.getId());
                if (attendenceHistory2 == null) {
                    attendenceHistoryDAO.save(attendenceHistory, session);
                    continue;
                }
                attendenceHistory.setVersion(attendenceHistory2.getVersion());
                attendenceHistoryDAO.update(attendenceHistory, session);
            }
            transaction.commit();
        }
    }

    public void saveOrUpdateUsersClockInOutTime(String string) {
        Object object;
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject(string);
        JSONArray jSONArray = jSONObject2.getJSONArray(DATA);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONObject = jSONArray.getJSONObject(i);
            object = (User)BaseDataServiceDao.getGsonBuilder().create().fromJson(jSONObject.toString(), User.class);
            if (object == null) continue;
            arrayList.add(object);
        }
        jSONObject = null;
        try (Session session = null;){
            object = UserDAO.getInstance();
            session = ((_BaseRootDAO)object).createNewSession();
            jSONObject = session.beginTransaction();
            for (User user : arrayList) {
                User user2 = ((BaseUserDAO)object).get(user.getId());
                if (user2 == null) continue;
                user2.setClockedIn(user.isClockedIn());
                user2.setLastClockInTime(user.getLastClockInTime());
                user2.setLastClockOutTime(user.getLastClockOutTime());
                ((BaseUserDAO)object).update(user2);
            }
            jSONObject.commit();
        }
    }

    public static GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setDateFormat(GSON_PARSING_DATE_FORMAT);
    }

    public void saveOrSetVersionModifierGroup(Session session, boolean bl, boolean bl2, ModifierGroup modifierGroup) throws Exception {
        Set<MenuItemModifierPage> set = modifierGroup.getModifierPages();
        modifierGroup.setUpdateLastUpdateTime(bl);
        modifierGroup.setUpdateSyncTime(bl2);
        modifierGroup.setModifierPages(null);
        this.saveOrSetVersionModifierGroup(session, modifierGroup);
        modifierGroup.setModifierPages(set);
        if (set != null && !set.isEmpty()) {
            for (MenuItemModifierPage menuItemModifierPage : set) {
                this.saveOrSetVersionMenuItemModiPage(session, menuItemModifierPage);
            }
        }
    }

    private void saveOrSetVersionModifierGroup(Session session, ModifierGroup modifierGroup) {
        ModifierGroupDAO modifierGroupDAO = ModifierGroupDAO.getInstance();
        ModifierGroup modifierGroup2 = modifierGroupDAO.get(modifierGroup.getId(), session);
        if (modifierGroup2 == null) {
            modifierGroupDAO.save(modifierGroup, session);
        } else {
            session.evict((Object)modifierGroup2);
            modifierGroup.setVersion(modifierGroup2.getVersion());
        }
    }

    private boolean isModifiable(JSONObject jSONObject) {
        return jSONObject.has("ticketItemModifiers");
    }
}

