/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Date;
import java.util.List;

public class DrawerAssignmentAction
extends PosAction {
    private Terminal a;
    private User b;
    private CashDrawer c;
    private boolean d;

    public DrawerAssignmentAction(Terminal terminal, User user) {
        this(terminal, null, user);
    }

    public DrawerAssignmentAction(Terminal terminal, CashDrawer cashDrawer, User user) {
        this(terminal, null, user, false);
    }

    public DrawerAssignmentAction(Terminal terminal, CashDrawer cashDrawer, User user, boolean bl) {
        super(Messages.getString("DrawerAssignmentAction.0"), UserPermission.DRAWER_ASSIGNMENT);
        this.a = terminal;
        this.c = cashDrawer;
        this.b = user;
        this.d = bl;
        this.updateActionText();
    }

    public void updateActionText() {
        if (this.a.isCashDrawerAssigned()) {
            if (this.d) {
                this.putValue("Name", Messages.getString("DrawerAssignmentAction.1"));
            } else if (this.a.isTwoCashDrawersEnable()) {
                this.putValue("Name", Messages.getString("DrawerAssignmentAction.5"));
            } else {
                this.putValue("Name", Messages.getString("DrawerAssignmentAction.12"));
            }
        } else if (this.d) {
            this.putValue("Name", Messages.getString("DrawerAssignmentAction.3"));
        } else if (this.a.isTwoCashDrawersEnable()) {
            this.putValue("Name", Messages.getString("DrawerAssignmentAction.9"));
        } else {
            this.putValue("Name", Messages.getString("DrawerAssignmentAction.2"));
        }
    }

    @Override
    public void execute() throws Exception {
        int n;
        TerminalDAO.getInstance().refresh(this.a);
        if (this.d) {
            if (this.a.isSecondCashDrawerAssigned()) {
                n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.13"), Messages.getString("CONFIRM"));
                if (n != 0) {
                    return;
                }
                this.performDrawerClose();
            } else {
                if (this.a.getDeviceType().intValue() == DeviceType.ANDROID.getDeviceType()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.15"));
                    return;
                }
                this.performAssignment();
            }
        } else if (this.a.isCashDrawerAssigned()) {
            n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.13"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return;
            }
            this.performDrawerClose();
        } else {
            if (this.a.getDeviceType().intValue() == DeviceType.ANDROID.getDeviceType()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.15"));
                return;
            }
            this.performAssignment();
        }
        int n2 = n = Application.getInstance().getTerminal().getId().intValue() == this.a.getId().intValue() ? 1 : 0;
        if (n != 0) {
            Application.getInstance().refreshAndGetTerminal();
        }
    }

    public void performAssignment() throws Exception {
        Object object;
        DrawerUtil.kickDrawer();
        UserListDialog userListDialog = new UserListDialog(true, true);
        userListDialog.pack();
        userListDialog.open();
        if (userListDialog.isCanceled()) {
            return;
        }
        User user = userListDialog.getSelectedUser();
        if (!user.isClockedIn().booleanValue()) {
            POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.16"));
            return;
        }
        CashDrawer cashDrawer = new CashDrawer();
        if (userListDialog.isLockCashDrawer()) {
            if (!PosAction.checkPermission(this.b, UserPermission.LOCK_DRAWER)) {
                return;
            }
            cashDrawer.setLocked(userListDialog.isLockCashDrawer());
        }
        double d = TerminalConfig.getDeafultDrawerAmount();
        List<Currency> list = CurrencyUtil.getAllCurrency();
        if (this.a.isEnableMultiCurrency().booleanValue() && list.size() > 1) {
            object = new MultiCurrencyAmountSelectionDialog(cashDrawer, d, list);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.17"));
                return;
            }
            d = ((MultiCurrencyAmountSelectionDialog)object).getTotalAmount();
        } else {
            String string;
            object = Messages.getString("DrawerAssignmentAction.6");
            d = NumberSelectionDialog2.takeDoubleInput((String)object, string = Messages.getString("DrawerAssignmentAction.7"), d);
            if (Double.isNaN(d)) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.18"));
                return;
            }
        }
        if (!this.d) {
            this.a.setAssignedUser(user);
        }
        cashDrawer.setStartTime(new Date());
        cashDrawer.setAssignedUser(user);
        cashDrawer.setTerminal(this.a);
        cashDrawer.setStoreSession(StoreUtil.getCurrentStoreSession());
        cashDrawer.setDrawerType(DrawerType.DRAWER);
        cashDrawer.setBeginCash(d);
        cashDrawer.setAssignedBy(this.b);
        cashDrawer.setOutletId(DataProvider.get().getCurrentOutletId());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer);
        if (this.d) {
            this.a.setSecondCashDrawerId(cashDrawer.getId());
        } else {
            this.a.setCurrentCashDrawer(cashDrawer);
        }
        CashDrawerDAO.getInstance().saveDrawerAssignment(cashDrawer, this.a);
        object = Messages.getString("DrawerAssignmentAction.8");
        if (this.d) {
            object = Messages.getString("DrawerAssignmentAction.4");
        }
        POSMessageDialog.showMessage((String)object + " " + user.getFullName());
        this.updateActionText();
    }

    public void performDrawerClose() throws Exception {
        Object object;
        if (this.c == null) {
            this.c = this.d ? this.a.getSecondCashDrawer() : this.a.getCurrentCashDrawer();
        }
        DrawerUtil.kickDrawer(this.c);
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.c);
        cashDrawerReportService.populateReport();
        Double d = 0.0;
        Application application = Application.getInstance();
        if (application.getStore().isUseDetailedReconciliation().booleanValue()) {
            object = new CashReconciliationDialog(this.c);
            ((Window)object).pack();
            ((CashReconciliationDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((CashReconciliationDialog)object).getTotalReconcilieAmount();
        } else if (application.getTerminal().isEnableMultiCurrency().booleanValue()) {
            object = new MultiCurrencyAmountSelectionDialog(this.c, this.c.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            ((Dialog)object).setTitle(Messages.getString("DrawerAssignmentAction.20"));
            ((OkCancelOptionDialog)object).setCaption(Messages.getString("DrawerAssignmentAction.20"));
            ((MultiCurrencyAmountSelectionDialog)object).setReconcile(true);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((MultiCurrencyAmountSelectionDialog)object).getTotalAmount();
        } else {
            d = this.a(this.c);
            if (d.isNaN()) {
                return;
            }
        }
        this.c.setCashToDeposit(d);
        object = new TerminalDAO();
        ((TerminalDAO)object).resetCashDrawer(this.c, this.a, this.b, 0.0, this.d);
        if (this.a.isEnableMultiCurrency().booleanValue()) {
            // empty if block
        }
        try {
            PosPrintService.printCashDrawerReport(this.c);
        }
        catch (PrinterIsNotConfiguredException printerIsNotConfiguredException) {
            // empty catch block
        }
        POSMessageDialog.showMessage(Messages.getString("DrawerAssignmentAction.10"));
        this.updateActionText();
    }

    private Double a(CashDrawer cashDrawer) {
        Double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("DrawerAssignmentAction.22"), Messages.getString("DrawerAssignmentAction.22"), NumberUtil.round(cashDrawer.getDrawerAccountable()));
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < cashDrawer.getDrawerAccountable()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DrawerAssignmentAction.24"), Messages.getString("CONFIRM")) == 0) {
                return d;
            }
            return this.a(cashDrawer);
        }
        return d;
    }
}

