/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.GroupSettleTicketDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public class GroupSettleTicketAction
extends PosAction {
    private List<Ticket> a;
    private User b;

    public GroupSettleTicketAction(User user) {
        this.b = user;
    }

    public GroupSettleTicketAction(List<Ticket> list, User user) {
        this.a = list;
        this.b = user;
    }

    public GroupSettleTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.GROUP_SETTLE_BUTTON_TEXT, dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            Object object;
            User user;
            if (!POSUtil.checkDrawerAssignment(DataProvider.get().getCurrentTerminal(), this.getCurrentUser())) {
                return;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            if (this.a == null || this.a.isEmpty()) {
                user = Application.getCurrentUser();
                object = TicketDAO.getInstance().findTicketsForGroupSettle(user, true);
                StyledTicketSelectionDialog styledTicketSelectionDialog = new StyledTicketSelectionDialog((List<Ticket>)object);
                styledTicketSelectionDialog.setCaption(Messages.getString("GroupSettleTicketSelectionWindow.0"));
                styledTicketSelectionDialog.openFullScreen();
                if (styledTicketSelectionDialog.isCanceled()) {
                    return;
                }
                List<Ticket> list = styledTicketSelectionDialog.getSelectedTickets();
                if (list == null) {
                    return;
                }
                for (Ticket ticket : list) {
                    arrayList.add(ticket);
                }
            } else {
                arrayList.addAll(this.a);
            }
            user = this.b;
            if (user == null) {
                user = Application.getCurrentUser();
            }
            object = new GroupSettleTicketDialog(arrayList, user);
            ((Window)object).setSize(Application.getPosWindow().getSize());
            ((JDialog)object).setDefaultCloseOperation(2);
            ((POSDialog)object).openUndecoratedFullScreen();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            this.a(arrayList);
            if (this.listener != null) {
                this.listener.dataSetUpdated();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    protected User getCurrentUser() {
        if (this.b == null) {
            return Application.getCurrentUser();
        }
        return this.b;
    }

    private void a(List<Ticket> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Group settle tickets: ");
        Object object = list.iterator();
        while (object.hasNext()) {
            Ticket ticket = object.next();
            stringBuilder.append(ticket.getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 255) {
            object = ((String)object).substring(0, 255);
        }
        ActionHistoryDAO.saveHistory("Group settle", (String)object);
    }
}

