/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.MergeTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.List;

public class MergeTicketsAction
extends PosAction {
    private DataChangeListener a;

    public MergeTicketsAction() {
        super(Messages.getString("MergeTicketsAction.0"));
        this.setRequiredPermission(UserPermission.SPLIT_TICKET);
    }

    public MergeTicketsAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("MergeTicketsAction.0"));
        this.setRequiredPermission(UserPermission.SPLIT_TICKET);
        this.a = dataChangeListener;
    }

    @Override
    public void execute() {
        try {
            List<Ticket> list = TicketDAO.getInstance().findMergableTickets(authorizedUser, true);
            StyledTicketSelectionDialog styledTicketSelectionDialog = new StyledTicketSelectionDialog(list);
            styledTicketSelectionDialog.setMerge(true);
            styledTicketSelectionDialog.setRequiredNumber(2);
            styledTicketSelectionDialog.openFullScreen();
            if (styledTicketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> list2 = styledTicketSelectionDialog.getSelectedTickets();
            if (list2.size() <= 0) {
                return;
            }
            MergeTicketDialog mergeTicketDialog = new MergeTicketDialog(list2, styledTicketSelectionDialog.getMainTicket());
            mergeTicketDialog.setTitle(Messages.getString("MergeTicketsAction.1"));
            mergeTicketDialog.setSize(PosUIManager.getSize(750, 600));
            mergeTicketDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            mergeTicketDialog.setVisible(true);
            if (mergeTicketDialog.isCanceled()) {
                return;
            }
            Ticket ticket = mergeTicketDialog.getMainTicket();
            this.a(ticket, list2);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MergeTicketsAction.2") + ticket.getTokenNo());
            if (this.a != null) {
                this.a.dataChanged(ticket);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, List<Ticket> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tickets: ");
        Object object = list.iterator();
        while (object.hasNext()) {
            Ticket ticket2 = object.next();
            stringBuilder.append(ticket2.getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 255) {
            object = ((String)object).substring(0, 255);
        }
        ActionHistoryDAO.saveHistory(ticket, "Merge ticket", (String)object);
    }
}

