/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.MenuGroupExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class GroupExplorerAction
extends AbstractAction {
    public GroupExplorerAction() {
        super(POSConstants.MENU_GROUPS);
    }

    public GroupExplorerAction(String string) {
        super(string);
    }

    public GroupExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            MenuGroupExplorer menuGroupExplorer;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.GROUP_EXPLORER);
            if (n == -1) {
                menuGroupExplorer = new MenuGroupExplorer();
                jTabbedPane.addTab(POSConstants.GROUP_EXPLORER, menuGroupExplorer);
            } else {
                menuGroupExplorer = (MenuGroupExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(menuGroupExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

