/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.TaxTab;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class TaxExplorerAction
extends AbstractAction {
    public TaxExplorerAction() {
        super(POSConstants.TAX);
    }

    public TaxExplorerAction(String string) {
        super(string);
    }

    public TaxExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            TaxTab taxTab = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.TAX_EXPLORER);
            if (n == -1) {
                taxTab = new TaxTab();
                jTabbedPane.addTab(POSConstants.TAX_EXPLORER, taxTab);
            } else {
                taxTab = (TaxTab)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(taxTab);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

