/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.model.BusinessHourForm;
import javax.swing.table.DefaultTableCellRenderer;

public class BusinessHourExplorer
extends BeanTableExplorerView<DayPart> {
    public BusinessHourExplorer() {
        super(DayPart.class);
    }

    @Override
    public void initData() {
        this.setRows(new DayPartDAO().findAll());
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public void initTableModel(BeanTableModel<DayPart> beanTableModel) {
        beanTableModel.addColumn(POSConstants.ID, DayPart.PROP_ID);
        beanTableModel.addColumn(POSConstants.NAME, DayPart.PROP_NAME);
        beanTableModel.addColumn(POSConstants.START_TIME, "formattedStartTime");
        beanTableModel.addColumn(POSConstants.END_TIME, "formattedEndTime");
    }

    @Override
    public DayPart createNew() {
        return this.openNewForm(new BusinessHourForm());
    }

    @Override
    public DayPart editSelectedRow(DayPart dayPart) {
        DayPartDAO.getInstance().refresh(dayPart);
        this.checkDataValidation(dayPart.isDeleted(), dayPart.getName());
        return this.openEditForm(new BusinessHourForm(dayPart));
    }

    @Override
    public boolean delete(DayPart dayPart) {
        DayPartDAO.getInstance().refresh(dayPart);
        this.checkDataValidation(dayPart.isDeleted(), dayPart.getName());
        ShiftDAO.getInstance().delete(dayPart);
        return true;
    }
}

