/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.model.CurrencyForm;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;

public class CurrencyExplorer
extends BeanTableExplorerView<Currency> {
    public CurrencyExplorer() {
        super(Currency.class);
    }

    @Override
    public void initTableModel(BeanTableModel<Currency> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, Currency.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("CurrencyExplorer.0"), Currency.PROP_CODE);
        beanTableModel.addColumn(Messages.getString("CurrencyExplorer.2"), Currency.PROP_SYMBOL);
        beanTableModel.addColumn(Messages.getString("CurrencyExplorer.4"), Currency.PROP_EXCHANGE_RATE, 4, BeanTableModel.DataType.NUMBER);
        beanTableModel.addColumn(Messages.getString("CurrencyExplorer.6"), Currency.PROP_MAIN);
        beanTableModel.addColumn(Messages.getString("CurrencyExplorer.8"), Currency.PROP_TOLERANCE, 4, BeanTableModel.DataType.MONEY);
    }

    @Override
    public void initData() {
        this.setRows(CurrencyDAO.getInstance().findAll());
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public Currency createNew() {
        Currency currency = this.openNewForm(new CurrencyForm());
        this.a(currency);
        return currency;
    }

    @Override
    public Currency editSelectedRow(Currency currency) {
        currency = CurrencyDAO.getInstance().get(currency.getId());
        this.checkDataValidation(currency.isDeleted(), currency.getName());
        Currency currency2 = this.openEditForm(new CurrencyForm(currency));
        this.a(currency2);
        return currency2;
    }

    private void a(Currency currency) {
        List list;
        if (currency == null || currency.getId() == null) {
            return;
        }
        if (currency.isMain().booleanValue() && (list = this.getRows()) != null && list.size() > 0) {
            for (Currency currency2 : list) {
                if (currency2.getId().equals(currency.getId()) || !currency2.isMain().booleanValue()) continue;
                CurrencyDAO.getInstance().refresh(currency2);
                this.getTable().repaint();
                break;
            }
        }
    }

    @Override
    public boolean delete(Currency currency) {
        CurrencyDAO.getInstance().refresh(currency);
        this.checkDataValidation(currency.isDeleted(), currency.getName());
        CurrencyDAO.getInstance().delete(currency);
        return true;
    }
}

