/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.MultiroleUserComboRenderer;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.DrawerPullReportDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class DrawerPullReportExplorer
extends TransparentPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JButton d = new JButton(Messages.getString("DrawerPullReportExplorer.43"));
    private JButton e = new JButton(POSConstants.DETAILS);
    private TableColumnModelExt f;
    private PosTable g;
    private JButton h;
    private JButton i;
    private JLabel j;
    private DrawerPullExplorerTableModel k;
    private JComboBox l;

    public DrawerPullReportExplorer() {
        super(new BorderLayout());
        this.a();
        this.b();
    }

    private void a() {
        this.k = new DrawerPullExplorerTableModel();
        this.k.addColumn(POSConstants.START_TIME, CashDrawer.PROP_START_TIME, 11, BeanTableModel.DataType.DATE);
        this.k.addColumn(POSConstants.END_TIME, CashDrawer.PROP_REPORT_TIME, 11, BeanTableModel.DataType.DATE);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.3"), "assignedUser");
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.4"), CashDrawer.PROP_TERMINAL_ID);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.5"), CashDrawer.PROP_BEGIN_CASH, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.10"), CashDrawer.PROP_GROSS_RECEIPTS, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("CashAccountable"), CashDrawer.PROP_DRAWER_ACCOUNTABLE, 11, BeanTableModel.DataType.MONEY);
        this.k.addColumn(Messages.getString("DrawerPullReportExplorer.44"), CashDrawer.PROP_CASH_TO_DEPOSIT, 11, BeanTableModel.DataType.MONEY);
        this.k.setPageSize(50);
        this.g = new PosTable(this.k);
        this.g.getSelectionModel().setSelectionMode(0);
        this.g.setRowHeight(PosUIManager.getSize(30));
        this.g.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.add(new JScrollPane((Component)((Object)this.g)));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.l = new JComboBox();
        List<User> list = UserDAO.getInstance().findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.l.setModel(new DefaultComboBoxModel(vector));
        this.l.setRenderer(new MultiroleUserComboRenderer());
        jPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO), "grow,gapleft 3");
        jPanel.add((Component)this.b);
        jPanel.add((Component)new JLabel(POSConstants.USER + ":"), "grow,gapleft 3");
        jPanel.add(this.l);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        this.h = new JButton(Messages.getString("DrawerPullReportExplorer.85"));
        this.i = new JButton(Messages.getString("DrawerPullReportExplorer.86"));
        this.j = new JLabel();
        this.h.addActionListener(actionEvent -> this.a(this.k.getPreviousRowIndex()));
        this.i.addActionListener(actionEvent -> this.a(this.k.getNextRowIndex()));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.j);
        jPanel2.add(this.h);
        jPanel2.add(this.i);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.d);
        jPanel3.add(this.e);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "East");
        this.add((Component)jPanel4, "South");
        this.e.addActionListener(actionEvent -> this.h());
        this.c.addActionListener(actionEvent -> this.g());
        this.d.addActionListener(actionEvent -> this.f());
    }

    private void b() {
        this.a(0);
    }

    private void a(int n) {
        try {
            this.k.setCurrentRowIndex(n);
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            User user = null;
            if (!this.l.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.l.getSelectedItem();
            }
            CashDrawerDAO.getInstance().loadCashDrawerReport(this.k, date, date2, user);
            int n2 = this.k.getCurrentRowIndex() + 1;
            int n3 = this.k.getNextRowIndex();
            int n4 = this.k.getNumRows();
            if (n3 > n4) {
                n3 = n4;
            }
            this.j.setText(String.format(Messages.getString("DrawerPullReportExplorer.87"), n2, n3, n4));
            this.h.setEnabled(this.k.hasPrevious());
            this.i.setEnabled(this.k.hasNext());
            this.resizeColumnWidth((JTable)((Object)this.g));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void c() {
        String string = TerminalConfig.getDrawerPullReportHiddenColumns();
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.g.getColumnModel();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("\\*");
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = Integer.parseInt(stringArray[i]);
            tableColumnModelExt.getColumnExt(n - i).setVisible(false);
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n;
            int n2 = this.b(jTable, i);
            if (n2 > (n = this.a(jTable, i))) {
                tableColumnModel.getColumn(i).setPreferredWidth(n2);
                continue;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n);
        }
    }

    private int a(JTable jTable, int n) {
        int n2 = 50;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, n);
        n2 = Math.max(n2, component.getPreferredSize().width);
        return n2 + 20;
    }

    private int b(JTable jTable, int n) {
        int n2 = 50;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n);
            Component component = jTable.prepareRenderer(tableCellRenderer, i, n);
            n2 = Math.max(component.getPreferredSize().width + 1, n2);
        }
        return n2 + 20;
    }

    private void d() {
        List list = this.f.getColumns(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableColumn tableColumn : list) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            if (tableColumnExt.isVisible()) continue;
            arrayList.add(tableColumnExt.getModelIndex());
        }
        this.a(arrayList);
    }

    private void a(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(iterator.next());
            string = string + string2;
            if (!iterator.hasNext()) continue;
            string = string + "*";
        }
        TerminalConfig.setDrawerPullReportHiddenColumns(string);
    }

    private void e() {
        this.f = (TableColumnModelExt)this.g.getColumnModel();
        this.f.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                DrawerPullReportExplorer.this.d();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                DrawerPullReportExplorer.this.d();
            }
        });
    }

    private void f() {
        try {
            int n = this.g.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("DrawerPullReportExplorer.1"));
                return;
            }
            CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
            int n2 = this.g.convertRowIndexToModel(n);
            DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)this.g.getModel();
            CashDrawer cashDrawer = drawerPullExplorerTableModel.getRowData(n2);
            cashDrawer = cashDrawerDAO.get(cashDrawer.getId());
            double d = NumberSelectionDialog2.takeDoubleInput(POSConstants.ENTER_ACTUAL_AMOUNT, VersionInfo.getAppName(), cashDrawer.getCashToDeposit(), Boolean.FALSE, Boolean.FALSE);
            if (Double.isNaN(d)) {
                return;
            }
            cashDrawer.setCashToDeposit(d);
            cashDrawerDAO.saveOrUpdate(cashDrawer);
            drawerPullExplorerTableModel.setRow(n, cashDrawer);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage(), posException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() {
        this.b();
    }

    private void h() {
        int n = this.g.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportExplorer.1"));
            return;
        }
        int n2 = this.g.convertRowIndexToModel(n);
        DrawerPullExplorerTableModel drawerPullExplorerTableModel = (DrawerPullExplorerTableModel)this.g.getModel();
        CashDrawer cashDrawer = drawerPullExplorerTableModel.getRowData(n2);
        try {
            DrawerPullReportDialog drawerPullReportDialog = new DrawerPullReportDialog(cashDrawer);
            drawerPullReportDialog.setTitle(Messages.getString("DrawerPullReportExplorer.45"));
            drawerPullReportDialog.createDrawerPullReport();
            drawerPullReportDialog.setDefaultCloseOperation(2);
            drawerPullReportDialog.open();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    class DrawerPullExplorerTableModel
    extends BeanTableModel<CashDrawer> {
        private SimpleDateFormat b;

        public DrawerPullExplorerTableModel() {
            super(CashDrawer.class);
            this.b = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
        }

        public CashDrawer getRowData(int n) {
            return (CashDrawer)super.getRow(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CashDrawer cashDrawer;
            if (n2 == 0) {
                return this.b.format(((CashDrawer)DrawerPullReportExplorer.this.k.getRow(n)).getStartTime());
            }
            if (n2 == 1 && ((CashDrawer)DrawerPullReportExplorer.this.k.getRow(n)).getReportTime() != null) {
                return this.b.format(((CashDrawer)DrawerPullReportExplorer.this.k.getRow(n)).getReportTime());
            }
            if (n2 == 3 && (cashDrawer = (CashDrawer)DrawerPullReportExplorer.this.k.getRow(n)) != null) {
                return cashDrawer.getTerminal().getName();
            }
            return super.getValueAt(n, n2);
        }
    }
}

