/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.customer.CustomerHistoryDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CustomerExplorer
extends TransparentPanel {
    private JTable a;
    private BeanTableModel<Customer> b;
    private JButton c;
    private JButton d;
    private JLabel e;
    private JTextField f;

    public CustomerExplorer() {
        this.b();
        this.a();
    }

    private void a() {
        String string = this.f.getText();
        CustomerDAO.getInstance().findByPhoneOrName(string, this.b, Boolean.TRUE, Boolean.TRUE);
        int n = this.b.getCurrentRowIndex() + 1;
        int n2 = this.b.getNextRowIndex();
        int n3 = this.b.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.e.setText(String.format(Messages.getString("CustomerExplorer.0"), n, n2, n3));
        this.c.setEnabled(this.b.hasPrevious());
        this.d.setEnabled(this.b.hasNext());
    }

    private void b() {
        this.b = new BeanTableModel(Customer.class, 50);
        this.b.addColumn(Messages.getString("CustomerExplorer.1"), Customer.PROP_NAME);
        this.b.addColumn(Messages.getString("CustomerExplorer.6"), Customer.PROP_MEMBER_ID);
        this.b.addColumn(Messages.getString("CustomerExplorer.3"), "mobileNo");
        this.b.addColumn(Messages.getString("CustomerExplorer.5"), "email");
        this.b.addColumn(Messages.getString("CustomerExplorer.7"), "address");
        this.b.addColumn(Messages.getString("CustomerExplorer.13"), "balance", 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(Messages.getString("CustomerExplorer.17"), Customer.PROP_LOYALTY_POINT, 11, BeanTableModel.DataType.NUMBER);
        this.b.addColumn(Messages.getString("CustomerExplorer.8"), Customer.PROP_ACTIVE);
        this.a = new JTable(this.b);
        this.b.initTableRenderer(this.a);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        PosGuiUtil.setColumnWidth(this.a, 0, 140);
        PosGuiUtil.setColumnWidth(this.a, 1, 100);
        PosGuiUtil.setColumnWidth(this.a, 2, 140);
        PosGuiUtil.setColumnWidth(this.a, 3, 120);
        PosGuiUtil.setColumnWidth(this.a, 4, 140);
        PosGuiUtil.setColumnWidth(this.a, 5, 35);
        PosGuiUtil.setColumnWidth(this.a, 6, 100);
        PosGuiUtil.setColumnWidth(this.a, 7, 30);
        this.setLayout(new BorderLayout(5, 0));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 10"));
        JLabel jLabel = new JLabel(Messages.getString("NameOrEmailOrCellOrLoyalty"));
        this.f = new JTextField(20);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.a();
            }
        });
        JButton jButton = new JButton(Messages.getString("Search"));
        jButton.addActionListener(actionEvent -> this.a());
        JButton jButton2 = new JButton(Messages.getString("CustomerExplorer.26"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.f.setText("");
                CustomerExplorer.this.a();
            }
        });
        jPanel.add((Component)jLabel, "split 4");
        jPanel.add((Component)this.f, "");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.a), "Center");
        JButton jButton3 = new JButton(POSConstants.ADD);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.f();
            }
        });
        JButton jButton4 = new JButton(POSConstants.EDIT);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.g();
            }
        });
        JButton jButton5 = new JButton(POSConstants.DELETE);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.h();
            }
        });
        JButton jButton6 = new JButton(Messages.getString("CustomerExplorer.2"));
        jButton6.addActionListener(actionEvent -> this.e());
        this.c = new JButton(Messages.getString("CustomerExplorer.30"));
        this.d = new JButton(Messages.getString("CustomerExplorer.31"));
        this.e = new JLabel();
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.b.setCurrentRowIndex(CustomerExplorer.this.b.getPreviousRowIndex());
                CustomerExplorer.this.a();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerExplorer.this.b.setCurrentRowIndex(CustomerExplorer.this.b.getNextRowIndex());
                CustomerExplorer.this.a();
            }
        });
        JButton jButton7 = new JButton(Messages.getString("CustomerExplorer.10"));
        jButton7.addActionListener(actionEvent -> {
            try {
                this.c();
            }
            catch (FileNotFoundException fileNotFoundException) {
                POSMessageDialog.showError(fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage(), exception);
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        transparentPanel.add((Component)jButton3, "right, split 5");
        transparentPanel.add(jButton4);
        transparentPanel.add(jButton5);
        transparentPanel.add(jButton6);
        transparentPanel.add(jButton7);
        transparentPanel.add((Component)this.e, "right, split 3");
        transparentPanel.add(this.c);
        transparentPanel.add(this.d);
        this.add((Component)transparentPanel, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() throws Exception {
        CSVPrinter cSVPrinter;
        block12: {
            FileWriter fileWriter;
            JFileChooser jFileChooser;
            List<Customer> list;
            block10: {
                block11: {
                    list = CustomerDAO.getInstance().findAll();
                    if (list == null) {
                        POSMessageDialog.showMessage(Messages.getString("CustomerExplorer.12"));
                        return;
                    }
                    jFileChooser = this.d();
                    Integer n = jFileChooser.showSaveDialog(this);
                    if (n != 0) {
                        return;
                    }
                    cSVPrinter = null;
                    fileWriter = null;
                    if (this.a(jFileChooser)) break block10;
                    if (fileWriter == null) break block11;
                    IOUtils.closeQuietly(fileWriter);
                }
                if (cSVPrinter != null) {
                    cSVPrinter.close();
                }
                return;
            }
            try {
                File file = jFileChooser.getSelectedFile();
                fileWriter = new FileWriter(file);
                CSVFormat cSVFormat = CSVFormat.DEFAULT.withRecordSeparator("\n");
                cSVPrinter = new CSVPrinter((Appendable)fileWriter, cSVFormat);
                Object[] objectArray = new Object[]{"Salutation", "First name", "Last name", "DoB", "Phone", "Email", "Balance", "Loyalty no", "Member id", "Member type", "Member since", "Membership expire", "Address", "Country", "State", "City", "Zip", "Tax exempt", "Active"};
                cSVPrinter.printRecord(objectArray);
                for (Customer customer : list) {
                    Object[] objectArray2 = new Object[]{customer.getSalutation(), customer.getFirstName(), customer.getLastName(), customer.getDob(), customer.getMobileNo(), customer.getEmail(), customer.getBalance(), customer.getLoyaltyNo(), customer.getMemberId() == null ? "" : customer.getMemberId(), StringUtils.isBlank((String)customer.getMembershipTypeDisplayString()) ? "" : customer.getMembershipTypeDisplayString(), customer.getMembershipStartDate() == null ? "" : DateUtil.formatFullDateAsString(customer.getMembershipStartDate()), customer.getMembershipExpiryDate() == null ? "" : DateUtil.formatFullDateAsString(customer.getMembershipExpiryDate()), customer.getAddress(), customer.getCountry(), customer.getState(), customer.getCity(), customer.getZipCode(), customer.isTaxExempt(), customer.isActive()};
                    cSVPrinter.printRecord(objectArray2);
                }
                if (fileWriter == null) break block12;
            }
            catch (Throwable throwable) {
                if (fileWriter != null) {
                    IOUtils.closeQuietly(fileWriter);
                }
                if (cSVPrinter != null) {
                    cSVPrinter.close();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        if (cSVPrinter != null) {
            cSVPrinter.close();
        }
    }

    private JFileChooser d() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
        jFileChooser.setSelectedFile(new File(Messages.getString("CustomerExplorer.14") + ".csv"));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("CustomerExplorer.16");
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".csv");
            }
        });
        return jFileChooser;
    }

    private boolean a(JFileChooser jFileChooser) {
        if (jFileChooser.getSelectedFile().exists() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("CustomerExplorer.18"), Messages.getString("CONFIRM")) != 0) {
            Integer n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return false;
            }
            return this.a(jFileChooser);
        }
        return true;
    }

    private void e() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerExplorer.4"));
            return;
        }
        Customer customer = this.b.getRow(n);
        if (customer != null) {
            CustomerHistoryDialog customerHistoryDialog = new CustomerHistoryDialog(customer.getId(), (boolean)Boolean.FALSE);
            customerHistoryDialog.openUndecoratedFullScreen();
        }
    }

    private void f() {
        try {
            boolean bl = true;
            CustomerForm customerForm = new CustomerForm(bl);
            customerForm.enableCustomerFields(true);
            Window window = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(window, (BeanEditor)customerForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(920, 700));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            Customer customer = (Customer)customerForm.getBean();
            this.b.addRow(0, customer);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.0"));
                return;
            }
            Customer customer = this.b.getRow(n);
            boolean bl = true;
            CustomerForm customerForm = new CustomerForm(bl);
            customerForm.enableCustomerFields(true);
            customerForm.setBean(customer);
            Window window = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(window, (BeanEditor)customerForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(920, 700));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void h() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.1"));
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                Customer customer = this.b.getRow(n);
                CustomerDAO customerDAO = CustomerDAO.getInstance();
                if (StringUtils.isNotBlank((String)customer.getId())) {
                    customerDAO.delete(customer.getId());
                }
                this.b.removeRow(customer);
                this.a();
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

