/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.licensing.ProductLicenseInfo;
import com.floreantpos.main.Application;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Customer;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.orocube.licensemanager.OroLicense;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataValidationJob
extends CronJob {
    public DataValidationJob() {
        this.setId("data-validation-job");
        this.setJobName("Data validation job");
        this.setFrequency("Every");
        this.setExecutionTime("1:-1");
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PosLog.debug(this.getClass(), "Starting data validation job");
        this.a();
        this.b();
        this.c();
        PosLog.debug(this.getClass(), "Data validation job end");
    }

    private void a() {
        PosLog.debug(this.getClass(), "Updating membership status");
        Date date = StoreDAO.getServerTimestamp();
        try (Session session = CustomerDAO.getInstance().createNewSession();){
            Transaction transaction = session.beginTransaction();
            String string = "update " + Customer.REF + " set " + Customer.PROP_MEMBERSHIP_ACTIVE + "=false where " + Customer.PROP_MEMBERSHIP_ACTIVE + "=true and " + Customer.PROP_MEMBERSHIP_EXPIRY_DATE + " < :fromDate";
            Query query = session.createQuery(string);
            query.setTimestamp("fromDate", DateUtil.toUTC(date));
            int n = query.executeUpdate();
            PosLog.debug(this.getClass(), "updated " + n + " customers");
            transaction.commit();
        }
    }

    private void b() {
        PosLog.debug(this.getClass(), "Updating GiftCard status");
        Date date = StoreDAO.getServerTimestamp();
        try (Session session = GiftCardDAO.getInstance().createNewSession();){
            Transaction transaction = session.beginTransaction();
            String string = "update " + GiftCard.REF + " set " + GiftCard.PROP_ACTIVE + "=false , " + GiftCard.PROP_DE_ACTIVATION_DATE + "=:deActivationDate where " + GiftCard.PROP_ACTIVE + "=true and " + GiftCard.PROP_EXPIRY_DATE + " < :expiryDate";
            Query query = session.createQuery(string);
            query.setTimestamp("deActivationDate", DateUtil.toUTC(date));
            query.setTimestamp("expiryDate", DateUtil.toUTC(date));
            int n = query.executeUpdate();
            PosLog.debug(this.getClass(), "updated " + n + " giftcards");
            transaction.commit();
        }
    }

    private void c() {
        PosLog.debug(this.getClass(), "Starting license checking job");
        OroLicense oroLicense = Application.getInstance().getLicense();
        ProductLicenseInfo productLicenseInfo = new ProductLicenseInfo(oroLicense);
        if (productLicenseInfo.willExpireInSevenDays() || productLicenseInfo.isExpired()) {
            Application.getPosWindow().updateVissabityOfLicenceInfo(true);
            return;
        }
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            ProductLicenseInfo productLicenseInfo2;
            OroLicense oroLicense2;
            if (!floreantPlugin.requireLicense() || !floreantPlugin.hasValidLicense() || (oroLicense2 = floreantPlugin.getLicense()) == null || !(productLicenseInfo2 = new ProductLicenseInfo(oroLicense2)).willExpireInSevenDays()) continue;
            Application.getPosWindow().updateVissabityOfLicenceInfo(true);
            return;
        }
        Application.getPosWindow().updateVissabityOfLicenceInfo(false);
    }
}

