/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;

public enum BalanceType {
    CUSTOMER("Customer"),
    GIFT_CARD("Gift Card"),
    LOYALTY("Loyalty");

    private String displayString;

    private BalanceType(String string2) {
        this.displayString = string2;
    }

    public String toString() {
        return this.displayString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String string) {
        this.displayString = string;
    }

    public BalanceUpdateTransaction createTransaction(PaymentType paymentType, TransactionType transactionType, double d) {
        BalanceUpdateTransaction balanceUpdateTransaction = new BalanceUpdateTransaction();
        balanceUpdateTransaction.setPaymentType(paymentType);
        balanceUpdateTransaction.setTransactionType(transactionType.name());
        balanceUpdateTransaction.setBalanceType(this);
        balanceUpdateTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        balanceUpdateTransaction.setAmount(transactionType == TransactionType.DEBIT ? -Math.abs(d) : Math.abs(d));
        balanceUpdateTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        return balanceUpdateTransaction;
    }
}

