/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.model.DataSync;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.EmployeeShift;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.MiscShift;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ReservationShift;
import com.floreantpos.model.StoreHour;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShift;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"dayOfWeekAsString"})
@XmlSeeAlso(value={PriceShift.class, DayPart.class, StoreHour.class, EmployeeShift.class, DataSync.class, MiscShift.class, MenuShift.class, ReservationShift.class})
@XmlRootElement(name="shift")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PriceShift.class), @JsonSubTypes.Type(value=DayPart.class), @JsonSubTypes.Type(value=StoreHour.class), @JsonSubTypes.Type(value=EmployeeShift.class), @JsonSubTypes.Type(value=DataSync.class), @JsonSubTypes.Type(value=MiscShift.class), @JsonSubTypes.Type(value=MenuShift.class), @JsonSubTypes.Type(value=ReservationShift.class)})
public class Shift
extends BaseShift
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private Date startTime;
    private Date endTime;
    private String classType;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public Shift() {
    }

    public Shift(String string) {
        super(string);
    }

    public Shift(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Long getShiftLength() {
        Long l = super.getShiftLength();
        if (l == null) {
            return Math.abs(this.getStartTime().getTime() - this.getEndTime().getTime());
        }
        return l;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(11, super.getStartHour());
            calendar.set(12, super.getStartMin());
            this.startTime = calendar.getTime();
        }
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            super.setStartHour(calendar.get(11));
            super.setStartMin(calendar.get(12));
        }
    }

    public Date getEndTime() {
        Date date = this.getStartTime();
        if (this.endTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(11, super.getEndHour());
            calendar.set(12, super.getEndMin());
            this.endTime = calendar.getTime();
            if (this.endTime.compareTo(date) < 0) {
                calendar.setTime(this.endTime);
                calendar.add(5, 1);
                this.endTime = calendar.getTime();
            }
        }
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            super.setEndHour(calendar.get(11));
            super.setEndMin(calendar.get(12));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Shift)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((Shift)object).getName());
    }

    public String getClassType() {
        if (this.classType == null) {
            this.classType = this.getClass().getSimpleName();
            return this.classType;
        }
        return this.classType;
    }

    public void setClassType(String string) {
        this.classType = string;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

