/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopTableStatus;
import com.floreantpos.model.base.BaseShopTableTicket;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"userName", "tableStatus", "ticketNumbers", "ticketId"})
@XmlRootElement
public class ShopTableStatus
extends BaseShopTableStatus
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String SEAT_TIME = "seat.time";
    private transient JsonObject propertiesContainer;
    private boolean shouldPublishMqtt = true;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public ShopTableStatus() {
    }

    public ShopTableStatus(Integer n) {
        super(n);
    }

    @XmlTransient
    public TableStatus getTableStatus() {
        Integer n = super.getTableStatusNum();
        return TableStatus.get(n);
    }

    public void setTableStatus(TableStatus tableStatus) {
        super.setTableStatusNum(tableStatus.getValue());
    }

    @XmlTransient
    public List<ShopTableTicket> getTicketNumbers() {
        String string = this.getTicketInformations();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Gson gson = new Gson();
        List list = (List)gson.fromJson(string, new TypeToken<List<ShopTableTicket>>(){}.getType());
        return list;
    }

    public void setTicketNumbers(List<ShopTableTicket> list) {
        if (list == null || list.size() == 0) {
            this.setTicketInformations(null);
            return;
        }
        JsonArray jsonArray = new JsonArray();
        for (ShopTableTicket shopTableTicket : list) {
            jsonArray.add(shopTableTicket.toJson());
        }
        this.setTicketInformations(jsonArray.toString());
    }

    public List<String> getListOfTicketNumbers() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (ShopTableTicket shopTableTicket : list) {
                arrayList.add(shopTableTicket.getTicketId());
            }
        }
        return arrayList;
    }

    public boolean hasMultipleTickets() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        return list != null && list.size() > 0;
    }

    @XmlTransient
    public String getTicketId() {
        List<String> list = this.getListOfTicketNumbers();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void setTicketId(String string) {
        this.setTableTicket(string, null, null, null);
    }

    public void setTableTicket(String string, Integer n, String string2, String string3) {
        this.setTableTicket(string, n, string2, string3, null);
    }

    public void setTableTicket(String string, Integer n, String string2, String string3, Date date) {
        if (string == null) {
            this.setTableStatus(TableStatus.Available);
            this.setTicketNumbers(null);
        } else {
            BaseShopTableTicket baseShopTableTicket = null;
            List<ShopTableTicket> list = this.getTicketNumbers();
            if (list != null && !list.isEmpty()) {
                for (ShopTableTicket shopTableTicket : list) {
                    if (!shopTableTicket.getTicketId().equals(string)) continue;
                    baseShopTableTicket = shopTableTicket;
                }
            } else {
                list = new ArrayList<ShopTableTicket>();
            }
            if (baseShopTableTicket == null) {
                baseShopTableTicket = new ShopTableTicket();
                list.add((ShopTableTicket)baseShopTableTicket);
            }
            baseShopTableTicket.setTicketId(string);
            baseShopTableTicket.setTokenNo(n);
            baseShopTableTicket.setUserId(string2);
            baseShopTableTicket.setUserName(string3);
            baseShopTableTicket.setTicketCreateTime(date);
            this.setTicketNumbers(list);
        }
    }

    public void addToTableTickets(List<Ticket> list) {
        Object object;
        if (list == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ShopTableTicket> list2 = this.getTicketNumbers();
        if (list2 == null) {
            list2 = new ArrayList<ShopTableTicket>();
        }
        for (ShopTableTicket comparable : list2) {
            object = comparable.getTicketId();
            if (object == null) continue;
            arrayList.add((String)object);
        }
        for (Ticket ticket : list) {
            if (arrayList.contains(ticket.getId())) continue;
            object = new ShopTableTicket();
            ((BaseShopTableTicket)object).setTicketId(ticket.getId());
            ((BaseShopTableTicket)object).setTokenNo(ticket.getTokenNo());
            ((BaseShopTableTicket)object).setUserId(ticket.getOwner().getId());
            ((BaseShopTableTicket)object).setUserName(ticket.getOwner().getFirstName());
            ((BaseShopTableTicket)object).setTicketCreateTime(ticket.getCreateDate());
            list2.add((ShopTableTicket)object);
        }
        this.setTicketNumbers(list2);
    }

    public String getUserId() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).getUserId();
    }

    public String getUserName() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        if (list == null || list.isEmpty()) {
            return "";
        }
        int n = list.size();
        if (n > 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopTableTicket shopTableTicket : list) {
                if (arrayList.contains(shopTableTicket.getUserId())) continue;
                arrayList.add(shopTableTicket.getUserId());
            }
            if (arrayList.size() > 1) {
                return Messages.getString("ShopTableStatus.2");
            }
        }
        return list.get(0).getUserName();
    }

    public String getTokenNo() {
        List<ShopTableTicket> list = this.getTicketNumbers();
        if (list == null || list.isEmpty()) {
            return "";
        }
        int n = list.size();
        if (n == 1) {
            return String.valueOf(list.get(0).getTokenNo());
        }
        String string = "";
        int n2 = 1;
        Iterator<ShopTableTicket> iterator = list.iterator();
        while (iterator.hasNext()) {
            ShopTableTicket shopTableTicket = iterator.next();
            string = string + String.valueOf(shopTableTicket.getTokenNo());
            if (n2 == 4) break;
            ++n2;
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }

    public Date getLastTicketCreateTime() {
        String string = this.getTicketInformations();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Gson gson = new Gson();
        List list = (List)gson.fromJson(string, new TypeToken<List<ShopTableTicket>>(){}.getType());
        if (list == null || list.isEmpty()) {
            return null;
        }
        Collections.sort(list, new Comparator<ShopTableTicket>(){

            @Override
            public int compare(ShopTableTicket shopTableTicket, ShopTableTicket shopTableTicket2) {
                if (shopTableTicket == null || shopTableTicket2 == null) {
                    return 1;
                }
                if (shopTableTicket.getTicketCreateTime() == null || shopTableTicket2.getTicketCreateTime() == null) {
                    return 1;
                }
                return shopTableTicket.getTicketCreateTime().compareTo(shopTableTicket2.getTicketCreateTime());
            }
        });
        return ((ShopTableTicket)list.get(0)).getTicketCreateTime();
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    public boolean isShouldPublishMqtt() {
        return this.shouldPublishMqtt;
    }

    public void setShouldPublishMqtt(boolean bl) {
        this.shouldPublishMqtt = bl;
    }
}

