/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.BaseCronJobDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class CronJobDAO
extends BaseCronJobDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        CronJob cronJob = (CronJob)object;
        if (cronJob == null) {
            throw new PosException(Messages.getString("CronJobDAO.0"));
        }
        cronJob.setDeleted(Boolean.TRUE);
        this.update(cronJob, session);
    }

    @Override
    public List<CronJob> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<CronJob> findAllWithoutId(String string, String string2) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add((Criterion)Restrictions.ne((String)CronJob.PROP_ID, (Object)string));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add(Restrictions.ilike((String)CronJob.PROP_JOB_NAME, (String)string2, (MatchMode)MatchMode.ANYWHERE));
            }
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<CronJob> findAllActive() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(CronJob.class);
            criteria.add((Criterion)Restrictions.eq((String)CronJob.PROP_ACTIVE, (Object)true));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CronJob> findCronJobByJobName(String string) {
        List list = null;
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(CronJob.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)CronJob.PROP_JOB_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            this.addDeletedFilter(criteria);
            list = criteria.list();
        }
        finally {
            this.closeSession(session);
        }
        return list;
    }

    @Override
    public void saveOrUpdate(CronJob cronJob) {
        try {
            CronJob cronJob2 = super.get(cronJob.getId());
            if (cronJob2 == null) {
                cronJob2 = new CronJob();
                cronJob2.setExecutionTime(cronJob.getExecutionTime());
                cronJob2.setFrequency(cronJob.getFrequency());
                cronJob2.setJobId(cronJob.getJobId());
                cronJob2.setJobName(cronJob.getJobName());
                cronJob2.setLastSyncTime(cronJob.getLastSyncTime());
                cronJob2.setLastUpdateTime(cronJob.getLastUpdateTime());
                cronJob2.setProperties(cronJob.getProperties());
                cronJob2.setId(cronJob.getId());
                cronJob2.setActive(cronJob.isActive());
                super.save(cronJob2);
            } else {
                cronJob2.setExecutionTime(cronJob.getExecutionTime());
                cronJob2.setFrequency(cronJob.getFrequency());
                cronJob2.setJobId(cronJob.getJobId());
                cronJob2.setJobName(cronJob.getJobName());
                cronJob2.setUpdateLastUpdateTime(cronJob.isUpdateLastUpdateTime());
                cronJob2.setUpdateSyncTime(cronJob.isUpdateSyncTime());
                cronJob2.setLastSyncTime(cronJob.getLastSyncTime());
                cronJob2.setLastUpdateTime(cronJob.getLastUpdateTime());
                cronJob2.setProperties(cronJob.getProperties());
                cronJob2.setActive(cronJob.isActive());
                super.update(cronJob2);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void saveOrUpdateCronJob(List<CronJob> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CronJob cronJob : list) {
                CronJobDAO cronJobDAO = CronJobDAO.getInstance();
                CronJob cronJob2 = cronJobDAO.get(cronJob.getId());
                if (cronJob2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(cronJob.getLastUpdateTime(), cronJob2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), cronJob.getJobName() + " already updated");
                        continue;
                    }
                    long l = cronJob2.getVersion();
                    PropertyUtils.copyProperties((Object)cronJob2, (Object)cronJob);
                    cronJob2.setVersion(l);
                    cronJob2.setUpdateLastUpdateTime(bl);
                    cronJob2.setUpdateSyncTime(bl2);
                    cronJobDAO.update(cronJob2);
                    continue;
                }
                cronJob.setVersion(0L);
                cronJob.setUpdateLastUpdateTime(bl);
                cronJob.setUpdateSyncTime(bl2);
                cronJobDAO.save(cronJob);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

