/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.BaseCustomerGroupDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class CustomerGroupDAO
extends BaseCustomerGroupDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        CustomerGroup customerGroup = (CustomerGroup)object;
        if (customerGroup == null) {
            throw new PosException(Messages.getString("CustomerGroupDAO.0"));
        }
        List<Customer> list = CustomerDAO.getInstance().getCustomerByCustomerGroup(customerGroup, session);
        if (list != null && !list.isEmpty()) {
            String string = customerGroup.getName() + Messages.getString("CustomerGroupDAO.1");
            String string2 = this.constructExceptionDetailsByCustomer(customerGroup, list);
            throw new PosException(string, string2);
        }
        customerGroup.setDeleted(true);
        this.update(customerGroup, session);
    }

    @Override
    public List<CustomerGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)CustomerGroup.PROP_NAME));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    private String constructExceptionDetailsByCustomer(CustomerGroup customerGroup, List<Customer> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(customerGroup.getName() + " " + Messages.getString("CustomerGroupDAO.3"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append("\n").append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public void initialize(CustomerGroup customerGroup) {
        if (customerGroup == null || customerGroup.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(customerGroup.getCustomers())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)customerGroup);
            Hibernate.initialize(customerGroup.getCustomers());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void loadCustomers(CustomerGroup customerGroup, PaginatedListModel paginatedListModel) {
        try (Session session = this.createNewSession();){
            String string = "c";
            Criteria criteria = session.createCriteria(this.getReferenceClass()).createAlias("customers", string);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)(string + "." + Customer.PROP_ID)), Customer.PROP_ID);
            projectionList.add((Projection)Projections.property((String)(string + "." + Customer.PROP_FIRST_NAME)), Customer.PROP_FIRST_NAME);
            projectionList.add((Projection)Projections.property((String)(string + "." + Customer.PROP_LAST_NAME)), Customer.PROP_LAST_NAME);
            projectionList.add((Projection)Projections.property((String)(string + "." + Customer.PROP_MOBILE_NO)), Customer.PROP_MOBILE_NO);
            projectionList.add((Projection)Projections.property((String)(string + "." + Customer.PROP_EMAIL)), Customer.PROP_EMAIL);
            this.addDeletedFilter(criteria);
            if (customerGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)CustomerGroup.PROP_ID, (Object)customerGroup.getId()));
            }
            paginatedListModel.setNumRows(this.rowCount(criteria));
            criteria.setProjection((Projection)projectionList);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            criteria.addOrder(Order.asc((String)(string + "." + Customer.PROP_NAME)).ignoreCase());
            criteria.setResultTransformer(Transformers.aliasToBean(Customer.class));
            paginatedListModel.setData(criteria.list());
        }
    }

    public void saveOrUpdateCustomerGroupList(List<CustomerGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CustomerGroup customerGroup : list) {
                CustomerGroup customerGroup2 = this.get(customerGroup.getId());
                if (customerGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(customerGroup.getLastUpdateTime(), customerGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), customerGroup.getName() + " already updated");
                        continue;
                    }
                    long l = customerGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)customerGroup2, (Object)customerGroup);
                    customerGroup2.setVersion(l);
                    customerGroup2.setUpdateLastUpdateTime(bl);
                    customerGroup2.setUpdateSyncTime(bl2);
                    this.update(customerGroup2, session);
                    continue;
                }
                customerGroup.setUpdateLastUpdateTime(bl);
                customerGroup.setUpdateSyncTime(bl2);
                this.save(customerGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

