/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.DeletedData;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseDeletedDataDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.DeletedDataType;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DeletedDataDAO
extends BaseDeletedDataDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateDeletedDataList(List<DeletedData> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (DeletedData deletedData : list) {
                Ticket ticket;
                DeletedDataType deletedDataType;
                DeletedData deletedData2 = this.get(deletedData.getId());
                if (deletedData2 != null) continue;
                deletedData.setUpdateLastUpdateTime(bl);
                deletedData.setUpdateSyncTime(bl2);
                this.save(deletedData, session);
                if (StringUtils.isBlank((String)deletedData.getDataId()) || (deletedDataType = DeletedDataType.fromDataTypeId(deletedData.getDataTypeId())) != DeletedDataType.TICKET || (ticket = TicketDAO.getInstance().get(deletedData.getDataId())) == null) continue;
                session.delete((Object)ticket);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

