/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseDiscount;
import com.floreantpos.model.dao.BaseDiscountDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.ext.DiscountCondition;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class DiscountDAO
extends BaseDiscountDAO {
    private static final String EMPTY_NEWLINE_STRING = "\n";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    private List<MenuItem> getMenuItemByDiscount(Discount discount, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuItems", "menuItem");
        criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discount.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)("menuItem." + MenuItem.PROP_NAME)), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class)).list();
    }

    private List<MenuGroup> getMenuGroupByDiscount(Discount discount, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuGroups", "menuGroup");
        criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discount.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)("menuGroup." + MenuGroup.PROP_NAME)), (String)MenuGroup.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean(MenuGroup.class)).list();
    }

    private List<MenuCategory> getMenuCategoryByDiscount(Discount discount, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuCategories", "menuCategory");
        criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discount.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)("menuCategory." + MenuCategory.PROP_NAME)), (String)MenuCategory.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean(MenuCategory.class)).list();
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof Discount) {
            List<MenuCategory> list;
            List<MenuGroup> list2;
            Discount discount = (Discount)object;
            StringBuilder stringBuilder = new StringBuilder();
            List<MenuItem> list3 = this.getMenuItemByDiscount(discount, session);
            if (list3 != null && !list3.isEmpty()) {
                stringBuilder.append(this.constructExceptionDetailsByMenuitem(discount, list3));
                stringBuilder.append(EMPTY_NEWLINE_STRING);
            }
            if ((list2 = this.getMenuGroupByDiscount(discount, session)) != null && !list2.isEmpty()) {
                stringBuilder.append(this.constructExceptionDetailsByMenuGroup(discount, list2));
                stringBuilder.append(EMPTY_NEWLINE_STRING);
            }
            if ((list = this.getMenuCategoryByDiscount(discount, session)) != null && !list.isEmpty()) {
                stringBuilder.append(this.constructExceptionDetailsByMenuCategory(discount, list));
                stringBuilder.append(EMPTY_NEWLINE_STRING);
            }
            String string = Messages.getString("DiscountDAO.0");
            String string2 = stringBuilder.toString();
            if (StringUtils.isNotBlank((CharSequence)string2)) {
                throw new PosException(string, string2);
            }
            discount.setDeleted(Boolean.TRUE);
            super.update(discount, session);
        } else {
            super.delete(object, session);
        }
    }

    private String constructExceptionDetailsByMenuitem(Discount discount, List<MenuItem> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(discount.getName() + " " + Messages.getString("DiscountDAO.3"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByMenuCategory(Discount discount, List<MenuCategory> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(discount.getName() + " " + Messages.getString("DiscountDAO.4"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByMenuGroup(Discount discount, List<MenuGroup> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(discount.getName() + " " + Messages.getString("DiscountDAO.5"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + ". " + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public List<Discount> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Discount.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    public Discount getInitialized(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)string));
            Discount discount = (Discount)criteria.uniqueResult();
            Hibernate.initialize(discount.getMenuItems());
            Hibernate.initialize(discount.getMenuGroups());
            Hibernate.initialize(discount.getMenuCategories());
            Discount discount2 = discount;
            return discount2;
        }
    }

    public List<Discount> findAllValidCoupons() {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
    }

    public List<Discount> getValidItemCoupons() {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
    }

    public List<Discount> getValidCoupon(MenuItem menuItem) {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
    }

    public List<Discount> getTicketValidCoupon() {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)1), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
    }

    public boolean isApplicable(String string, String string2) {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)string2));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
    }

    public Discount getDiscountById(String string, int n) {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Discount.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)(n == 0 ? 0 : 1)), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                Discount discount = null;
                return discount;
            }
            Discount discount = (Discount)list.get(0);
            return discount;
        }
    }

    public Discount getDiscountByBarcode(String string, int n) {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Discount.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.like((String)Discount.PROP_BARCODE, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)(n == 0 ? 0 : 1)), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                Discount discount = null;
                return discount;
            }
            Discount discount = (Discount)list.get(0);
            return discount;
        }
    }

    public void validateCouponConditions(Discount discount, String string) {
        if (discount == null || discount.getDiscountCondition() == null) {
            return;
        }
        if (discount.getDiscountCondition() == DiscountCondition.FIRST_ORDER_ON_STORE) {
            if (StringUtils.isBlank((CharSequence)string) || discount.getQualificationType() == 0) {
                throw new PosException(Messages.getString("DiscountDAO.1"));
            }
            try (Session session = this.createNewSession();){
                Criteria criteria = null;
                criteria = session.createCriteria(Ticket.class);
                criteria.setProjection(Projections.rowCount());
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
                Number number = (Number)criteria.uniqueResult();
                if (number != null && number.intValue() > 0) {
                    throw new PosException(Messages.getString("YouAreNotEligibleForThisCoupon"));
                }
            }
        }
    }

    public List<Discount> getDiscountsByMenuCategory(MenuCategory menuCategory, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuCategories", "menuCategory");
        criteria.add((Criterion)Restrictions.eq((String)("menuCategory." + MenuCategory.PROP_ID), (Object)menuCategory.getId()));
        return criteria.list();
    }

    public List<Discount> getDiscountsByMenuGroup(MenuGroup menuGroup, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuGroups", "menugroup");
        criteria.add((Criterion)Restrictions.eq((String)("menugroup." + MenuGroup.PROP_ID), (Object)menuGroup.getId()));
        return criteria.list();
    }

    public List<Discount> getDiscountsByMenuItem(MenuItem menuItem, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuItems", "menuItem");
        criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_ID), (Object)menuItem.getId()));
        return criteria.list();
    }

    public String getCurrentDayPropertyName(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = "";
        int n = calendar.get(7);
        switch (n) {
            case 7: {
                string = Discount.PROP_APPLY_TO_SATURDAY_ONLY;
                break;
            }
            case 1: {
                string = Discount.PROP_APPLY_TO_SUNDAY_ONLY;
                break;
            }
            case 2: {
                string = Discount.PROP_APPLY_TO_MONDAY_ONLY;
                break;
            }
            case 3: {
                string = Discount.PROP_APPLY_TO_TUESDAY_ONLY;
                break;
            }
            case 4: {
                string = Discount.PROP_APPLY_TO_WEDNESDAY_ONLY;
                break;
            }
            case 5: {
                string = Discount.PROP_APPLY_TO_THURSDAY_ONLY;
                break;
            }
            case 6: {
                string = Discount.PROP_APPLY_TO_FRIDAY_ONLY;
                break;
            }
        }
        return string;
    }

    public List<Discount> getValidCoupons() {
        Date date = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)date)));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateDiscountList(List<Discount> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        HashMap<String, MenuItem> hashMap = new HashMap<String, MenuItem>();
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Discount discount : list) {
                Object object;
                List<MenuItem> list2 = discount.getMenuItems();
                discount.setMenuItems(null);
                if (list2 != null && list2.size() > 0) {
                    object = list2.iterator();
                    while (object.hasNext()) {
                        MenuItem menuItem = (MenuItem)object.next();
                        MenuItem menuItem2 = (MenuItem)hashMap.get(menuItem.getId());
                        if (menuItem2 == null) {
                            menuItem2 = MenuItemDAO.getInstance().get(menuItem.getId());
                            if (menuItem2 == null) {
                                throw new Exception("No item found with id " + menuItem.getId());
                            }
                            hashMap.put(menuItem2.getId(), menuItem2);
                        }
                        discount.addTomenuItems(menuItem2);
                    }
                }
                if ((object = this.get(discount.getId())) != null) {
                    if (!BaseDataServiceDao.get().shouldSave(discount.getLastUpdateTime(), ((BaseDiscount)object).getLastUpdateTime())) {
                        PosLog.info(this.getClass(), discount.getName() + " already updated");
                        continue;
                    }
                    long l = ((BaseDiscount)object).getVersion();
                    PropertyUtils.copyProperties((Object)object, (Object)discount);
                    ((BaseDiscount)object).setVersion(l);
                    ((Discount)object).setUpdateLastUpdateTime(bl);
                    ((Discount)object).setUpdateSyncTime(bl2);
                    this.update((Discount)object, session);
                    continue;
                }
                discount.setUpdateLastUpdateTime(bl);
                discount.setUpdateSyncTime(bl2);
                this.save(discount, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

