/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.model.dao.BaseGiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;

public class GiftCardDAO
extends BaseGiftCardDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof GiftCard) {
            GiftCard giftCard = (GiftCard)object;
            giftCard.setDeleted(Boolean.TRUE);
            super.update(giftCard, session);
        } else {
            super.delete(object, session);
        }
    }

    @Override
    public List<GiftCard> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveAsList(List<GiftCard> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (GiftCard giftCard : list) {
                String string = giftCard.getCardNumber();
                if (string == null) {
                    throw new PosException(Messages.getString("GiftCardDAO.0"));
                }
                GiftCard giftCard2 = (GiftCard)session.get(GiftCard.class, (Serializable)((Object)string));
                if (giftCard2 == null) {
                    string = string.replaceAll("-", "");
                    giftCard.setCardNumber(string);
                    this.save(giftCard, session);
                    continue;
                }
                giftCard2.setOwnerName(giftCard.getOwnerName());
                giftCard2.setBalance(giftCard.getBalance());
                giftCard2.setIssueDate(giftCard.getIssueDate());
                giftCard2.setActivationDate(giftCard.getActivationDate());
                giftCard2.setDeActivationDate(giftCard.getDeActivationDate());
                giftCard2.setExpiryDate(giftCard.getExpiryDate());
                giftCard2.setActive(giftCard.isActive());
                giftCard2.setDisable(giftCard.isDisable());
                giftCard2.setDurationType(giftCard.getDurationType());
                giftCard2.setDuration(giftCard.getDuration());
                giftCard2.setPinNumber(giftCard.getPinNumber());
                giftCard2.setPoint(giftCard.getPoint());
                giftCard2.setBatchNo(giftCard.getBatchNo());
                giftCard2.setEmail(giftCard.getEmail());
                giftCard2.setType(giftCard.getType());
                this.update(giftCard2, session);
            }
            transaction.commit();
        }
    }

    public GiftCard findByCardNumber(Session session, String string) {
        Criteria criteria = session.createCriteria(GiftCard.class);
        this.addDeletedFilter(criteria);
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_CARD_NUMBER, (Object)string));
            if (criteria.list().isEmpty()) {
                return null;
            }
            return (GiftCard)criteria.list().get(0);
        }
        return null;
    }

    public GiftCard findByCardNumber(String string) {
        try (Session session = this.createNewSession();){
            GiftCard giftCard = this.findByCardNumber(session, string);
            return giftCard;
        }
    }

    public void searchByCardAndIssueDate(String string, String string2, Date date, Date date2, String string3, PaginationSupport paginationSupport) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (date != null && date2 != null) {
                criteria.add(Restrictions.between((String)GiftCard.PROP_ISSUE_DATE, (Object)date, (Object)date2));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)GiftCard.PROP_CARD_NUMBER, (String)POSUtil.formatGiftCardNo(string), (MatchMode)MatchMode.START));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string2));
            }
            if (string3.equalsIgnoreCase("ACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true));
            } else if (string3.equalsIgnoreCase("DEACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false));
            } else if (string3.equalsIgnoreCase("DISABLED")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)true));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)GiftCard.PROP_ISSUE_DATE));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            paginationSupport.setRows(criteria.list());
        }
    }

    public List<Date> findByDate() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)GiftCard.PROP_ISSUE_DATE)));
            List list = criteria.list();
            if (list.isEmpty()) {
                List<Date> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public List<GiftCard> findExceptDisable() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard initialize(GiftCard giftCard) {
        if (giftCard == null) {
            return giftCard;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)giftCard);
            GiftCard giftCard2 = giftCard;
            return giftCard2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean findActiveCardByBatchNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false), (Criterion)Restrictions.isNotNull((String)GiftCard.PROP_ACTIVATION_DATE))));
                boolean bl = !criteria.list().isEmpty();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean deleteCardListByBatchNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List list = null;
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
                list = criteria.list();
                if (list != null) {
                    for (GiftCard giftCard : list) {
                        this.delete(giftCard);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public List<GiftCard> findByBatchNumber(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    public boolean hasBatchNo(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)string));
            criteria.setMaxResults(1);
            boolean bl = criteria.list().size() > 0;
            return bl;
        }
    }

    public List<GiftCard> findGiftCards(Date date, Date date2, boolean bl, String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.between((String)GiftCard.PROP_ACTIVATION_DATE, (Object)date, (Object)date2));
            if (bl) {
                criteria.add((Criterion)Restrictions.lt((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            }
            if ("Owner".equals(string)) {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_OWNER_NAME));
            } else {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_ACTIVATION_DATE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void updateItemsLastSyncTime(List<String> list, String string) {
        String string2;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string3 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string2 = transaction.next();
            string3 = string3 + "'" + string2 + "'";
            if (!transaction.hasNext()) continue;
            string3 = string3 + ",";
        }
        string3 = string3 + ")";
        transaction = null;
        try {
            string2 = this.createNewSession();
            Throwable throwable = null;
            try {
                transaction = string2.beginTransaction();
                String string4 = "update " + string + " set %s=:lastSyncTime where %s in %s";
                string4 = String.format(string4, GiftCard.PROP_LAST_SYNC_TIME, GiftCard.PROP_CARD_NUMBER, string3);
                Query query = string2.createQuery(string4);
                Date date = new Date();
                query.setParameter("lastSyncTime", (Object)date);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (string2 != null) {
                    if (throwable != null) {
                        try {
                            string2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        string2.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public void saveOrUpdateGiftCardList(List<GiftCard> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (GiftCard giftCard : list) {
                GiftCard giftCard2 = this.get(giftCard.getCardNumber());
                if (giftCard2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(giftCard.getLastUpdateTime(), giftCard2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), giftCard.getBatchNo() + " already updated");
                        continue;
                    }
                    long l = giftCard2.getVersion();
                    double d = giftCard2.getBalance();
                    PropertyUtils.copyProperties((Object)giftCard2, (Object)giftCard);
                    giftCard2.setVersion(l);
                    giftCard2.setBalance(d);
                    giftCard2.setUpdateLastUpdateTime(bl);
                    giftCard2.setUpdateSyncTime(bl2);
                    this.update(giftCard2, session);
                    continue;
                }
                giftCard.setUpdateLastUpdateTime(bl);
                giftCard.setUpdateSyncTime(bl2);
                this.save(giftCard, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BalanceUpdateTransaction> findTransactionsByCardNumber(GiftCard giftCard, Date date, Date date2) {
        return this.findTransactionsByCardNumber(giftCard, date, date2, Boolean.FALSE);
    }

    public List<BalanceUpdateTransaction> findTransactionsByCardNumber(GiftCard giftCard, Date date, Date date2, boolean bl) {
        List<BalanceUpdateTransaction> list = this.findTransactionsV1(giftCard == null ? null : giftCard.getCardNumber(), date, date2, bl);
        List<BalanceUpdateTransaction> list2 = this.findTransactionsV2(giftCard == null ? null : giftCard.getCardNumber(), date, date2, bl);
        for (BalanceUpdateTransaction serializable2 : list2) {
            serializable2.setDataVersion(2);
        }
        list.addAll(list2);
        Comparator<BalanceUpdateTransaction> comparator = Comparator.comparing(BaseBalanceUpdateTransaction::getAccountNumber, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(BaseBalanceUpdateTransaction::getTransactionTime);
        list.sort(comparator);
        ArrayList<BalanceUpdateTransaction> arrayList = new ArrayList<BalanceUpdateTransaction>();
        if (bl) {
            arrayList.addAll(list);
        } else if (list != null && list.isEmpty() && giftCard != null) {
            if (giftCard.getActivationDate() != null && !giftCard.getActivationDate().after(date)) {
                arrayList.add(this.createForwardBalanceByTransction(giftCard.getCardNumber(), giftCard.getBalance(), null));
            }
        } else {
            String string = null;
            for (BalanceUpdateTransaction balanceUpdateTransaction : list) {
                if (balanceUpdateTransaction.getAccountNumber().equals(string)) {
                    arrayList.add(balanceUpdateTransaction);
                    continue;
                }
                string = balanceUpdateTransaction.getAccountNumber();
                arrayList.add(this.createForwardBalanceByTransction(string, null, balanceUpdateTransaction));
                arrayList.add(balanceUpdateTransaction);
            }
        }
        return arrayList;
    }

    private BalanceUpdateTransaction createForwardBalanceByTransction(String string, Double d, BalanceUpdateTransaction balanceUpdateTransaction) {
        BalanceForwardTransaction balanceForwardTransaction = new BalanceForwardTransaction();
        if (balanceUpdateTransaction != null) {
            balanceForwardTransaction.setAmount(balanceUpdateTransaction.getBalanceBefore());
            balanceForwardTransaction.setPaymentTypeString(balanceUpdateTransaction.getPaymentTypeString());
            balanceForwardTransaction.setTransactionType(balanceUpdateTransaction.getTransactionType());
            balanceForwardTransaction.setAccountNumber(string);
        } else {
            balanceForwardTransaction.setAmount(d);
            balanceForwardTransaction.setPaymentType(PaymentType.CASH);
            balanceForwardTransaction.setTransactionType(TransactionType.CREDIT.name());
            balanceForwardTransaction.setAccountNumber(string);
        }
        balanceForwardTransaction.setTicketId(Messages.getString("GiftCardDAO.1"));
        return balanceForwardTransaction;
    }

    private List<BalanceUpdateTransaction> findTransactionsV1(String string, Date date, Date date2, boolean bl) {
        try (Session session = this.createNewSession();){
            Criteria criteria = bl ? session.createCriteria(GiftCertificateTransaction.class) : session.createCriteria(PosTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            if (!StringUtils.isEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_GIFT_CERT_NUMBER, (Object)string));
            } else {
                criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_GIFT_CERT_NUMBER));
            }
            Disjunction disjunction = Restrictions.disjunction();
            Criterion criterion = Restrictions.isNull((String)PosTransaction.PROP_DATA_VERSION);
            SimpleExpression simpleExpression = Restrictions.eq((String)PosTransaction.PROP_DATA_VERSION, (Object)0);
            SimpleExpression simpleExpression2 = Restrictions.eq((String)PosTransaction.PROP_DATA_VERSION, (Object)1);
            disjunction.add(criterion);
            disjunction.add((Criterion)simpleExpression);
            disjunction.add((Criterion)simpleExpression2);
            criteria.add((Criterion)disjunction);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), BalanceUpdateTransaction.PROP_TRANSACTION_TIME);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), BalanceUpdateTransaction.PROP_AMOUNT);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_GIFT_CERT_FACE_VALUE), "giftCertFaceValue");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_GIFT_CERT_FACE_VALUE), "serviceChargeAmount");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TAX_AMOUNT), "taxAmount");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TIPS_AMOUNT), "tipsAmount");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_GIFT_CERT_NUMBER), BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER);
            projectionList.add((Projection)Projections.property((String)("ticket." + Ticket.PROP_ID)), BalanceUpdateTransaction.PROP_TICKET_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), BalanceUpdateTransaction.PROP_PAYMENT_TYPE_STRING);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TYPE), BalanceUpdateTransaction.PROP_TRANSACTION_TYPE);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_EXTRA_PROPERTIES), BalanceUpdateTransaction.PROP_EXTRA_PROPERTIES);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_DATA_VERSION), "dataVersion");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(BalanceUpdateTransaction.class));
            criteria.addOrder(Order.asc((String)BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER));
            criteria.addOrder(Order.asc((String)BalanceUpdateTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    public List<BalanceUpdateTransaction> findTransactionsV2(String string, Date date, Date date2, boolean bl) {
        try (Session session = this.createNewSession();){
            Object object;
            Criteria criteria = session.createCriteria(BalanceUpdateTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_BALANCE_TYPE_STRING, (Object)BalanceType.GIFT_CARD.name()));
            if (bl) {
                object = Restrictions.eq((String)BalanceUpdateTransaction.PROP_TRANSACTION_SUB_TYPE, (Object)TransactionSubType.SALES.name());
                SimpleExpression simpleExpression = Restrictions.eq((String)BalanceUpdateTransaction.PROP_TRANSACTION_SUB_TYPE, (Object)TransactionSubType.VOIDED_SALES.name());
                criteria.add((Criterion)Restrictions.or((Criterion)object, (Criterion)simpleExpression));
            }
            criteria.add(Restrictions.between((String)BalanceUpdateTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            if (!StringUtils.isEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER, (Object)string));
            }
            criteria.addOrder(Order.asc((String)BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER));
            criteria.addOrder(Order.asc((String)BalanceUpdateTransaction.PROP_TRANSACTION_TIME));
            object = criteria.list();
            return object;
        }
    }
}

