/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BasePayOutTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.PosTransactionService;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PayOutTransactionDAO
extends BasePayOutTransactionDAO {
    public void saveTransaction(PayOutTransaction payOutTransaction, Terminal terminal) throws Exception {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)payOutTransaction);
            session.saveOrUpdate((Object)terminal);
            PosTransactionService.getInstance();
            PosTransactionService.adjustMulticurrencyBalance(session, terminal, payOutTransaction.getCashDrawer(), null, payOutTransaction);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    public void createPayoutTransaction(PayoutReason payoutReason, PayoutRecepient payoutRecepient, String string, double d, User user, Terminal terminal) throws Exception {
        this.createPayoutTransaction(payoutReason, payoutRecepient, string, d, user, terminal, user.getActiveCashDrawer());
    }

    public void createPayoutTransaction(PayoutReason payoutReason, PayoutRecepient payoutRecepient, String string, double d, User user, Terminal terminal, CashDrawer cashDrawer) throws Exception {
        StoreSession storeSession = DataProvider.get().getStoreSession();
        if (storeSession == null && terminal.getActiveCashDrawer(user) != null) {
            storeSession = terminal.getActiveCashDrawer(user).getStoreSession();
        }
        PayOutTransaction payOutTransaction = new PayOutTransaction();
        payOutTransaction.setPaymentType(PaymentType.CASH);
        payOutTransaction.setTransactionType(TransactionType.OUT.name());
        payOutTransaction.setReason(payoutReason);
        payOutTransaction.setRecepient(payoutRecepient);
        payOutTransaction.setNote(string);
        payOutTransaction.setAmount(d);
        payOutTransaction.setCashDrawer(cashDrawer);
        if (storeSession != null) {
            payOutTransaction.setStoreSessionId(storeSession.getId());
        }
        payOutTransaction.setUser(user);
        payOutTransaction.setServer(user);
        payOutTransaction.setTransactionTime(new Date());
        payOutTransaction.setTerminal(terminal);
        this.saveTransaction(payOutTransaction, terminal);
    }

    public List<PayOutTransaction> getUnsettled(Terminal terminal, User user) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PayOutTransaction.PROP_DRAWER_RESETTED, (Object)Boolean.FALSE));
            if (user == null) {
                criteria.add((Criterion)Restrictions.eq((String)PayOutTransaction.PROP_TERMINAL_ID, (Object)(terminal == null ? null : terminal.getId())));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)PayOutTransaction.PROP_USER_ID, (Object)user.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }
}

