/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.BasePriceRuleDAO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PriceRuleDAO
extends BasePriceRuleDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.validateData((PriceRule)object, session);
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.validateData((PriceRule)object, session);
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.validateData((PriceRule)object, session);
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    private void validateData(PriceRule priceRule, Session session) {
        if (this.priceRuleExists(priceRule, session)) {
            throw new DuplicateDataException(Messages.getString("PriceRuleDAO.1"));
        }
    }

    private boolean priceRuleExists(PriceRule priceRule, Session session) {
        Object object;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        String string = priceRule.getId();
        if (StringUtils.isNotEmpty((String)string)) {
            object = Restrictions.ne((String)"id", (Object)string);
            criteria.add((Criterion)object);
        }
        this.addDeletedFilter(criteria);
        object = priceRule.getOutletId();
        Criterion criterion = object != null ? Restrictions.eq((String)PriceRule.PROP_OUTLET_ID, (Object)object) : Restrictions.isNull((String)PriceRule.PROP_OUTLET_ID);
        String string2 = priceRule.getDepartmentId();
        Criterion criterion2 = string2 != null ? Restrictions.eq((String)PriceRule.PROP_DEPARTMENT_ID, (Object)string2) : Restrictions.isNull((String)PriceRule.PROP_DEPARTMENT_ID);
        String string3 = priceRule.getSalesAreaId();
        Criterion criterion3 = string3 != null ? Restrictions.eq((String)PriceRule.PROP_SALES_AREA_ID, (Object)string3) : Restrictions.isNull((String)PriceRule.PROP_SALES_AREA_ID);
        String string4 = priceRule.getOrderTypeId();
        Criterion criterion4 = string4 != null ? Restrictions.eq((String)PriceRule.PROP_ORDER_TYPE_ID, (Object)string4) : Restrictions.isNull((String)PriceRule.PROP_ORDER_TYPE_ID);
        String string5 = priceRule.getCustomerGroupId();
        Criterion criterion5 = string5 != null ? Restrictions.eq((String)PriceRule.PROP_CUSTOMER_GROUP_ID, (Object)string5) : Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_GROUP_ID);
        String string6 = priceRule.getPriceShiftId();
        Criterion criterion6 = string6 != null ? Restrictions.eq((String)PriceRule.PROP_PRICE_SHIFT_ID, (Object)string6) : Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID);
        String string7 = priceRule.getPriceTableId();
        Criterion criterion7 = string7 != null ? Restrictions.eq((String)PriceRule.PROP_PRICE_TABLE_ID, (Object)string7) : Restrictions.isNull((String)PriceRule.PROP_PRICE_TABLE_ID);
        Conjunction conjunction = Restrictions.and((Criterion[])new Criterion[]{criterion, criterion2, criterion3, criterion4, criterion5, criterion6, criterion7});
        criteria.add((Criterion)conjunction);
        List list = criteria.list();
        return list != null && list.size() > 0;
    }

    @Override
    public List<PriceRule> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        if (!(object instanceof PriceRule)) {
            throw new PosException(Messages.getString("PriceRuleDAO.0"));
        }
        PriceRule priceRule = (PriceRule)object;
        priceRule.setDeleted(Boolean.TRUE);
        super.update(priceRule, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getPrice(MenuItem menuItem, PriceShift priceShift, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup) {
        Session session = null;
        try {
            session = this.createNewSession();
            Double d = this.getPrice(menuItem, priceShift, orderType, department, salesArea, customerGroup, session);
            return d;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Double getPrice(MenuItem menuItem, PriceShift priceShift, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.setProjection((Projection)Projections.property((String)PriceRule.PROP_PRICE_TABLE_ID));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_ORDER_TYPE_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId()))));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_DEPARTMENT_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_DEPARTMENT_ID, (Object)(department == null ? null : department.getId()))));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_SALES_AREA_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_SALES_AREA_ID, (Object)(salesArea == null ? null : salesArea.getId()))));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_GROUP_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_CUSTOMER_GROUP_ID, (Object)(customerGroup == null ? null : customerGroup.getId()))));
        if (priceShift != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_SHIFT_ID, (Object)priceShift.getId())));
        } else {
            criteria.add(Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID));
        }
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_ACTIVE, (Object)Boolean.TRUE));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        criteria = session.createCriteria(PriceTableItem.class);
        criteria.setProjection((Projection)Projections.property((String)PriceTableItem.PROP_PRICE));
        criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        criteria.add(Restrictions.in((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Collection)list));
        this.addDeletedFilter(criteria);
        List list2 = criteria.list();
        if (list2 != null && list2.size() > 0) {
            if (list2.size() == 1) {
                return (Double)list2.get(0);
            }
            return (Double)Collections.min(list2);
        }
        return null;
    }

    public List<PriceRule> findByPriceShiftId(String string, Session session) {
        return this.findByPriceShiftId(string, session, Boolean.FALSE);
    }

    public List<PriceRule> findByPriceShiftId(String string, Session session, boolean bl) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        if (bl) {
            this.addDeletedFilter(criteria);
        }
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_SHIFT_ID, (Object)string));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PriceRule.PROP_NAME), (String)PriceRule.PROP_NAME));
        criteria.setResultTransformer(Transformers.aliasToBean(PriceRule.class));
        return criteria.list();
    }

    public List<PriceRule> getPriceRulesByPriceTable(PriceTable priceTable, Session session) {
        if (priceTable == null || priceTable.getId() == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PriceRule.PROP_NAME), (String)PriceRule.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    public void saveOrUpdatePriceRuleList(List<PriceRule> list, boolean bl, boolean bl2) throws Exception {
        if (list != null && list.size() > 0) {
            for (PriceRule priceRule : list) {
                PriceRuleDAO priceRuleDAO = PriceRuleDAO.getInstance();
                PriceRule priceRule2 = priceRuleDAO.get(priceRule.getId());
                if (priceRule2 != null) {
                    String string = priceRule2.getId();
                    long l = priceRule2.getVersion();
                    PropertyUtils.copyProperties((Object)priceRule2, (Object)priceRule);
                    priceRule2.setId(string);
                    priceRule2.setVersion(l);
                    priceRule2.setUpdateLastUpdateTime(bl);
                    priceRule2.setUpdateSyncTime(bl2);
                    priceRuleDAO.update(priceRule2);
                    continue;
                }
                priceRule.setVersion(0L);
                priceRule.setUpdateLastUpdateTime(bl);
                priceRule.setUpdateSyncTime(bl2);
                priceRuleDAO.save(priceRule);
            }
        }
    }
}

