/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.dao.BasePriceTableDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PriceTableDAO
extends BasePriceTableDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PriceTable) {
            PriceTable priceTable = (PriceTable)object;
            this.checkForeignRelation(priceTable, session);
            priceTable.setDeleted(Boolean.TRUE);
            super.update(priceTable, session);
        } else {
            super.delete(object, session);
        }
    }

    private void checkForeignRelation(PriceTable priceTable, Session session) {
        List<PriceRule> list = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable, session);
        if (list != null && !list.isEmpty()) {
            String string = priceTable.getName() + EMPTY_SPACE_STRING + Messages.getString("PriceTableDAO.4");
            String string2 = this.constructExceptionDetailsByMenuItems(priceTable, list);
            throw new PosException(string, string2);
        }
    }

    private String constructExceptionDetailsByMenuItems(PriceTable priceTable, List<PriceRule> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(priceTable.getName() + EMPTY_SPACE_STRING + Messages.getString("PriceTableDAO.5"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<PriceTable> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Deprecated
    public void releaseParentAndDelete(PriceTable priceTable) {
        this.delete(priceTable);
    }

    public void saveOrUpdatePriceTableList(List<PriceTable> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (PriceTable priceTable : list) {
                PriceTable priceTable2 = this.get(priceTable.getId());
                if (priceTable2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(priceTable.getLastUpdateTime(), priceTable2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), priceTable.getId() + " already updated");
                        continue;
                    }
                    long l = priceTable2.getVersion();
                    PropertyUtils.copyProperties((Object)priceTable2, (Object)priceTable);
                    this.updatePriceTableItems(priceTable2, session);
                    priceTable2.setVersion(l);
                    priceTable2.setUpdateLastUpdateTime(bl);
                    priceTable2.setUpdateSyncTime(bl2);
                    this.update(priceTable2, session);
                    continue;
                }
                priceTable.setUpdateLastUpdateTime(bl);
                priceTable.setUpdateSyncTime(bl2);
                this.updatePriceTableItems(priceTable, session);
                this.save(priceTable, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updatePriceTableItems(PriceTable priceTable, Session session) throws Exception {
        if (priceTable.getPriceTableItems() == null || priceTable.getPriceTableItems().isEmpty()) {
            return;
        }
        for (PriceTableItem priceTableItem : priceTable.getPriceTableItems()) {
            PriceTableItem priceTableItem2 = PriceTableItemDAO.getInstance().get(priceTableItem.getId());
            if (priceTableItem2 != null) {
                if (!BaseDataServiceDao.get().shouldSave(priceTableItem.getLastUpdateTime(), priceTableItem2.getLastUpdateTime())) {
                    PosLog.info(this.getClass(), priceTableItem.getId() + " already updated");
                    continue;
                }
                long l = priceTableItem2.getVersion();
                PropertyUtils.copyProperties((Object)priceTableItem2, (Object)priceTableItem);
                priceTableItem2.setVersion(l);
                this.update(priceTableItem2, session);
                continue;
            }
            this.save(priceTableItem, session);
        }
    }
}

