/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.base.BasePurchaseOrderItem;
import com.floreantpos.model.dao.BasePurchaseOrderDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.InventoryService;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PurchaseOrderDAO
extends BasePurchaseOrderDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PurchaseOrder) {
            PurchaseOrder purchaseOrder = (PurchaseOrder)object;
            purchaseOrder.setDeleted(Boolean.TRUE);
            super.update(purchaseOrder, session);
        } else {
            super.delete(object, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(purchaseOrder, bl, session);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateWithItemAvailBalance(PurchaseOrder purchaseOrder) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.updateAvailableUnit(purchaseOrder, session);
            transaction.commit();
        }
    }

    private void updateAvailableUnit(PurchaseOrder purchaseOrder, Session session) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        if (list == null) {
            return;
        }
        for (PurchaseOrderItem purchaseOrderItem : list) {
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            Double d = purchaseOrderItem.getItemQuantity();
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), d, true, false, session);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, Session session) {
        if (purchaseOrder.getId() == null) {
            purchaseOrder.setCreatedDate(new Date());
            purchaseOrder.setStatus(0);
        }
        if (bl) {
            this.adjustInventoryItems(session, purchaseOrder);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveOrUpdate(PurchaseOrder purchaseOrder, boolean bl, boolean bl2) {
        try (Session session = this.createNewSession();){
            Transaction transaction = session.beginTransaction();
            if (purchaseOrder.getId() == null) {
                if (purchaseOrder.getCreatedDate() == null) {
                    purchaseOrder.setCreatedDate(new Date());
                }
                purchaseOrder.setStatus(0);
            }
            if (bl) {
                List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
                if (list != null) {
                    HashMap hashMap = new HashMap();
                    list.forEach(purchaseOrderItem -> {
                        MenuItem menuItem = (MenuItem)hashMap.get(purchaseOrderItem.getMenuItemId());
                        if (menuItem == null && (menuItem = MenuItemDAO.getInstance().get(purchaseOrderItem.getMenuItemId(), session)) != null) {
                            MenuItemDAO.getInstance().initialize(menuItem, session);
                            hashMap.put(menuItem.getId(), menuItem);
                        }
                        purchaseOrderItem.setMenuItem(menuItem);
                        String string = purchaseOrderItem.getItemUnitName();
                        IUnit iUnit = DataProvider.get().getUnitByCode(string);
                        InventoryUnit inventoryUnit = null;
                        if (iUnit instanceof InventoryUnit) {
                            inventoryUnit = (InventoryUnit)iUnit;
                        }
                        InventoryService.getInstance().adjustMenuItemCost(menuItem, purchaseOrderItem.getUnitPrice(), purchaseOrderItem.getItemQuantity(), inventoryUnit, session);
                    });
                    if (hashMap.size() > 0) {
                        for (MenuItem menuItem : hashMap.values()) {
                            MenuItemDAO.getInstance().saveOrUpdate(menuItem, session);
                        }
                    }
                }
                this.adjustInventoryItems(session, purchaseOrder, bl2);
            }
            session.saveOrUpdate((Object)purchaseOrder);
            transaction.commit();
        }
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder) {
        this.adjustInventoryItems(session, purchaseOrder, true);
    }

    private void adjustInventoryItems(Session session, PurchaseOrder purchaseOrder, boolean bl) {
        List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
        if (list == null) {
            return;
        }
        boolean bl2 = true;
        for (PurchaseOrderItem purchaseOrderItem : list) {
            purchaseOrderItem.setQuantityReceived(purchaseOrderItem.getQuantityReceived() + purchaseOrderItem.getQuantityToReceive());
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setQuantity(purchaseOrderItem.getQuantityToReceive());
            Double d = purchaseOrderItem.getUnitPrice();
            inventoryTransaction.setUnitCost(d);
            inventoryTransaction.setToInventoryLocation(purchaseOrder.getInventoryLocation());
            inventoryTransaction.setOutletId(purchaseOrder.getOutletId());
            inventoryTransaction.setTransactionDate(purchaseOrder.getReceivingDate());
            inventoryTransaction.setVendor(purchaseOrder.getVendor());
            inventoryTransaction.setUnit(purchaseOrderItem.getItemUnitName());
            inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * d);
            if (purchaseOrder.getType().equals(PurchaseOrder.DEBIT)) {
                inventoryTransaction.setReason("PURCHASE");
                inventoryTransaction.setTransactionType(InventoryTransactionType.IN);
            } else {
                inventoryTransaction.setReason("RETURN");
                inventoryTransaction.setTransactionType(InventoryTransactionType.OUT);
            }
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session, bl, true);
            if (purchaseOrderItem.getQuantityReceived().doubleValue() != purchaseOrderItem.getItemQuantity().doubleValue()) {
                bl2 = false;
            }
            purchaseOrderItem.setQuantityToReceive(0.0);
        }
        if (bl2) {
            purchaseOrder.setStatus(4);
        } else {
            purchaseOrder.setStatus(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextOrderSequenceNumber() {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)PurchaseOrder.PROP_ORDER_ID));
            this.addDeletedFilter(criteria);
            Object object = criteria.uniqueResult();
            if (object == null) {
                String string = "10001";
                return string;
            }
            String string = String.valueOf(Integer.parseInt((String)object) + 1);
            return string;
        }
    }

    public boolean exists(String string, String string2) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Number number;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_ORDER_ID, (Object)string));
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)string2)) {
                criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_ID, (Object)string2));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PurchaseOrder> findBy(String string, InventoryVendor inventoryVendor, Date date, Date date2, Boolean bl) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)PurchaseOrder.PROP_ORDER_ID, (String)string.trim(), (MatchMode)MatchMode.START));
            }
            if (inventoryVendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_VENDOR, (Object)inventoryVendor));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)PurchaseOrder.PROP_CREATED_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)PurchaseOrder.PROP_CREATED_DATE, (Object)date2));
            }
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_STATUS, (Object)4));
            }
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveOrUpdatePurchaseOrders(List<PurchaseOrder> list, boolean bl, boolean bl2) throws Exception {
        List list2;
        if (list == null) {
            return;
        }
        HashMap<String, Comparable> hashMap = new HashMap<String, Comparable>();
        try (Session session = this.createNewSession();){
            for (PurchaseOrder purchaseOrder : list) {
                PurchaseOrder purchaseOrder2 = PurchaseOrderDAO.getInstance().get(purchaseOrder.getId(), session);
                if (purchaseOrder2 == null) continue;
                hashMap.put(purchaseOrder.getId(), purchaseOrder);
                list2 = purchaseOrder2.getOrderItems();
                for (Object object : list2) {
                    hashMap.put(((BasePurchaseOrderItem)object).getId(), (Comparable)object);
                }
            }
        }
        session = null;
        var6_6 = this.createNewSession();
        Object object = null;
        try {
            for (PurchaseOrder purchaseOrder2 : list) {
                try {
                    session = var6_6.beginTransaction();
                    list2 = POSUtil.copyList(purchaseOrder2.getOrderItems());
                    POSUtil.clear(purchaseOrder2.getOrderItems());
                    purchaseOrder2.setUpdateLastUpdateTime(bl);
                    purchaseOrder2.setUpdateSyncTime(bl2);
                    PurchaseOrder purchaseOrder = (PurchaseOrder)hashMap.get(purchaseOrder2.getId());
                    if (purchaseOrder != null) {
                        if (!BaseDataServiceDao.get().shouldSave(purchaseOrder2.getLastUpdateTime(), purchaseOrder.getLastUpdateTime())) {
                            PosLog.debug(this.getClass(), purchaseOrder2.getId() + " already updated");
                            continue;
                        }
                        long l = purchaseOrder.getVersion();
                        purchaseOrder2.setVersion(l);
                    } else {
                        this.save(purchaseOrder2, (Session)var6_6);
                    }
                    for (PurchaseOrderItem purchaseOrderItem : list2) {
                        purchaseOrderItem.setPurchaseOrder(purchaseOrder2);
                        PurchaseOrderItem purchaseOrderItem2 = (PurchaseOrderItem)hashMap.get(purchaseOrderItem.getId());
                        if (purchaseOrderItem2 == null) {
                            purchaseOrderItem.setVersion(0L);
                            PurchaseOrderItemDAO.getInstance().save(purchaseOrderItem, (Session)var6_6);
                            continue;
                        }
                        purchaseOrderItem.setVersion(purchaseOrderItem2.getVersion());
                        PurchaseOrderItemDAO.getInstance().update(purchaseOrderItem, (Session)var6_6);
                    }
                    if (purchaseOrder2.getOrderItems() != null) {
                        purchaseOrder2.getOrderItems().addAll(list2);
                    } else {
                        purchaseOrder2.setOrderItems(list2);
                    }
                    this.update(purchaseOrder2, (Session)var6_6);
                    session.commit();
                }
                catch (Exception exception) {
                    PosLog.error(this.getReferenceClass(), "Error saving purchase order " + purchaseOrder2.getId());
                    if (session == null) throw exception;
                    session.rollback();
                    throw exception;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (var6_6 != null) {
                if (object != null) {
                    try {
                        var6_6.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    var6_6.close();
                }
            }
        }
    }

    public List<PurchaseOrder> getPurchaseOrderByInvLocation(InventoryLocation inventoryLocation, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_INVENTORY_LOCATION, (Object)inventoryLocation));
        criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_STATUS, (Object)4));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PurchaseOrder.PROP_ID), (String)PurchaseOrder.PROP_ID));
        this.addDeletedFilter(criteria);
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    public PurchaseOrder initializeData(String string) {
        try (Session session = this.createNewSession();){
            PurchaseOrder purchaseOrder = this.get(string, session);
            if (purchaseOrder.getOrderItems() != null) {
                for (PurchaseOrderItem purchaseOrderItem : purchaseOrder.getOrderItems()) {
                    MenuItem menuItem = purchaseOrderItem.getMenuItem();
                    if (!menuItem.isVariant().booleanValue()) continue;
                    MenuItem menuItem2 = menuItem.getParentMenuItem();
                    MenuItemDAO.getInstance().initializeUnits(menuItem2);
                }
            }
            PurchaseOrder purchaseOrder2 = purchaseOrder;
            return purchaseOrder2;
        }
    }
}

