/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseShift;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SalesSummaryDAO
extends _RootDAO {
    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object object) {
        return super.save(object);
    }

    @Override
    public void saveOrUpdate(Object object) {
        super.saveOrUpdate(object);
    }

    public List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> findSalesAnalysis(Date date, Date date2, UserType userType, Terminal terminal) {
        try (Session session = this.createNewSession();){
            double d;
            double d2;
            double d3;
            ArrayList<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> arrayList = new ArrayList<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData>();
            List<DayPart> list = DayPartDAO.getInstance().findAll(session);
            List<MenuCategory> list2 = MenuCategoryDAO.getInstance().findAll(session);
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(Messages.getString("SalesSummaryDAO.3"));
            list2.add(menuCategory);
            for (DayPart timedModel : list) {
                for (MenuCategory menuCategory2 : list2) {
                    d3 = this.getAmountWithoutIncludedTax(menuCategory2, timedModel, date, date2, userType, terminal, session);
                    d2 = this.getReturnAmountWithoutIncludedTax(menuCategory2, timedModel, date, date2, userType, terminal, session);
                    d = this.getItemCount(menuCategory2, timedModel, date, date2, userType, terminal, session);
                    double d4 = this.getDiscountAmount(menuCategory2, timedModel, date, date2, userType, terminal, session);
                    ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData shiftwiseSalesSummaryData = new ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData();
                    shiftwiseSalesSummaryData.setShiftName(timedModel.getName());
                    shiftwiseSalesSummaryData.setCategoryName(menuCategory2.getName());
                    shiftwiseSalesSummaryData.setCount(d);
                    shiftwiseSalesSummaryData.setGross(d3);
                    shiftwiseSalesSummaryData.setDiscount(d4);
                    shiftwiseSalesSummaryData.setReturnAmount(d2);
                    shiftwiseSalesSummaryData.setNetSales(shiftwiseSalesSummaryData.getGross() - shiftwiseSalesSummaryData.getDiscount() - shiftwiseSalesSummaryData.getReturnAmount());
                    arrayList.add(shiftwiseSalesSummaryData);
                }
            }
            for (MenuCategory menuCategory3 : list2) {
                double d5 = this.getAmountWithoutIncludedTax(menuCategory3, null, date, date2, userType, terminal, session);
                d3 = this.getReturnAmountWithoutIncludedTax(menuCategory3, null, date, date2, userType, terminal, session);
                d2 = this.getItemCount(menuCategory3, null, date, date2, userType, terminal, session);
                d = this.getDiscountAmount(menuCategory3, null, date, date2, userType, terminal, session);
                ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData shiftwiseSalesSummaryData = new ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData();
                shiftwiseSalesSummaryData.setShiftName(Messages.getString("SalesSummaryDAO.0"));
                shiftwiseSalesSummaryData.setCategoryName(menuCategory3.getName());
                shiftwiseSalesSummaryData.setCount(d2);
                shiftwiseSalesSummaryData.setGross(d5);
                shiftwiseSalesSummaryData.setDiscount(d);
                shiftwiseSalesSummaryData.setReturnAmount(d3);
                shiftwiseSalesSummaryData.setNetSales(shiftwiseSalesSummaryData.getGross() - shiftwiseSalesSummaryData.getDiscount() - shiftwiseSalesSummaryData.getReturnAmount());
                arrayList.add(shiftwiseSalesSummaryData);
            }
            ArrayList<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private double getAmountWithoutIncludedTax(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        return this.getAmount(menuCategory, shift, date, date2, userType, terminal, session) - this.getIncludedTaxAmount(menuCategory, shift, date, date2, userType, terminal, session);
    }

    private double getAmount(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
        this.buildCriteriaForTicketItem(criteria, menuCategory, shift, date, date2, Boolean.FALSE, userType, terminal);
        return Math.abs(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private double getReturnAmountWithoutIncludedTax(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        return this.getReturnAmount(menuCategory, shift, date, date2, userType, terminal, session) - this.getReturnAmountIncludedTax(menuCategory, shift, date, date2, userType, terminal, session);
    }

    private double getReturnAmountIncludedTax(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_TAX));
        this.buildCriteriaForTicketItem(criteria, menuCategory, shift, date, date2, Boolean.TRUE, userType, terminal);
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
        return Math.abs(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private double getReturnAmount(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
        this.buildCriteriaForTicketItem(criteria, menuCategory, shift, date, date2, Boolean.TRUE, userType, terminal);
        return Math.abs(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private double getItemCount(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
        this.buildCriteriaForTicketItem(criteria, menuCategory, shift, date, date2, null, userType, terminal);
        return Math.abs(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private double getIncludedTaxAmount(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_TAX));
        this.buildCriteriaForTicketItem(criteria, menuCategory, shift, date, date2, Boolean.FALSE, userType, terminal);
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
        return Math.abs(POSUtil.getDoubleAmount(criteria.uniqueResult()));
    }

    private double getDiscountAmount(MenuCategory menuCategory, Shift shift, Date date, Date date2, UserType userType, Terminal terminal, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_DISCOUNT));
        this.buildCriteriaForTicketItem(criteria, menuCategory, shift, date, date2, null, userType, terminal);
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    private void buildCriteriaForTicketItem(Criteria criteria, MenuCategory menuCategory, Shift shift, Date date, Date date2, Boolean bl, UserType userType, Terminal terminal) {
        criteria.createAlias(TicketItem.PROP_TICKET, "t");
        if (menuCategory.getId() == null) {
            criteria.add(Restrictions.isNull((String)TicketItem.PROP_CATEGORY_ID));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_CATEGORY_ID, (Object)menuCategory.getId()));
        }
        criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TREAT_AS_SEAT, (Object)Boolean.FALSE));
        if (bl != null) {
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ITEM_RETURNED, (Object)bl));
        }
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        if (shift != null) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SHIFT_ID), (Object)shift.getId()));
        }
        if (userType != null) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_TYPE_ID), (Object)userType.getId()));
        }
        if (terminal != null) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesStatistics findKeyStatistics(Date date, Date date2, Terminal terminal, List<OrderType> list, boolean bl) {
        Session session = null;
        if (list == null) {
            list = Application.getInstance().getOrderTypes();
        }
        List<String> list2 = POSUtil.getStringIds(list, OrderType.class);
        try {
            SalesStatistics salesStatistics = new SalesStatistics();
            session = this.createNewSession();
            Object object = session.createCriteria(ShopTable.class);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)ShopTable.PROP_CAPACITY));
            object.setProjection((Projection)projectionList);
            this.addDeletedFilter((Criteria)object);
            Object object2 = object.list();
            if (object2.size() > 0) {
                Object[] objectArray = (Object[])object2.get(0);
                salesStatistics.setTableCount(((Number)objectArray[0]).intValue());
                if (objectArray.length > 1 && objectArray[1] != null) {
                    salesStatistics.setCapacity(((Number)objectArray[1]).intValue());
                }
            }
            object = new SalesReportUtil(date, date2);
            double d = ((SalesReportUtil)object).calculateGrossSalesWithOutIncludedTax(session);
            double d2 = ((SalesReportUtil)object).calculateDiscountAmount(session);
            double d3 = ((SalesReportUtil)object).calculateReturnAmountWithOutIncludedTax(session);
            salesStatistics.setGrossSales(d);
            salesStatistics.setDiscount(d2);
            salesStatistics.setReturnAmount(d3);
            object = session.createCriteria(Ticket.class);
            ProjectionList projectionList2 = Projections.projectionList();
            projectionList2.add(Projections.rowCount(), "rowCount");
            projectionList2.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS), "guestCount");
            object.setProjection((Projection)projectionList2);
            this.createCommonCriteria(date, date2, list2, Boolean.FALSE, (Criteria)object);
            object2 = object.list();
            if (object2.size() > 0) {
                Object[] objectArray = (Object[])object2.get(0);
                salesStatistics.setCheckCount(((Number)objectArray[0]).intValue());
                if (objectArray.length > 1 && objectArray[1] != null) {
                    salesStatistics.setGuestCount(((Number)objectArray[1]).intValue());
                }
            }
            object = session.createCriteria(Ticket.class, "ticket");
            projectionList2 = Projections.projectionList();
            projectionList2.add(Projections.rowCount());
            projectionList2.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
            object.setProjection((Projection)projectionList2);
            object.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            this.createCommonCriteria(date, date2, list2, false, (Criteria)object);
            object2 = object.list();
            if (object2.size() > 0) {
                Object[] objectArray = (Object[])object2.get(0);
                salesStatistics.setOpenChecks(((Number)objectArray[0]).intValue());
                if (objectArray.length > 1 && objectArray[1] != null) {
                    salesStatistics.setOpenAmount(((Number)objectArray[1]).doubleValue());
                }
            }
            object = session.createCriteria(Ticket.class, "ticket");
            projectionList2 = Projections.projectionList();
            projectionList2.add(Projections.rowCount());
            projectionList2.add((Projection)Projections.sum((String)Ticket.PROP_VOID_AMOUNT));
            object.setProjection((Projection)projectionList2);
            this.createCommonCriteria(date, date2, list2, Boolean.TRUE, (Criteria)object);
            object2 = object.list();
            if (object2.size() > 0) {
                Object[] objectArray = (Object[])object2.get(0);
                salesStatistics.setVoidChecks(((Number)objectArray[0]).intValue());
                if (objectArray.length > 1 && objectArray[1] != null) {
                    salesStatistics.setVoidAmount(((Number)objectArray[1]).doubleValue());
                }
            }
            object = session.createCriteria(Ticket.class, "ticket");
            projectionList2 = Projections.projectionList();
            projectionList2.add(Projections.rowCount());
            object.setProjection((Projection)projectionList2);
            object.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            this.createCommonCriteria(date, date2, list2, false, (Criteria)object);
            object2 = object.list();
            if (object2.size() > 0) {
                Object e = object2.get(0);
                double d4 = ((Number)e).doubleValue();
                salesStatistics.setClosedChecks(d4);
            }
            object = AttendenceHistoryDAO.getInstance().findAttendenceReport(date, date2);
            double d5 = 0.0;
            double d6 = 0.0;
            Serializable serializable = new HashSet<User>();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                AttendenceHistory timedModel = (AttendenceHistory)iterator.next();
                double d4 = 0.0;
                Date date3 = timedModel.getClockInTime();
                d4 = !timedModel.isClockedOut().booleanValue() || timedModel.getClockOutTime() == null ? (date3.before(date) ? (double)Math.abs(new Date().getTime() - date.getTime()) : (double)Math.abs(new Date().getTime() - date3.getTime())) : (double)Math.abs(timedModel.getClockOutTime().getTime() - timedModel.getClockInTime().getTime());
                double d7 = d4 * (2.77777778 * Math.pow(10.0, -7.0));
                d5 += d7;
                User user = timedModel.getUser();
                serializable.add(user);
                double d8 = 0.0;
                if (user != null) {
                    d8 = user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
                }
                d6 += d7 * d8;
            }
            salesStatistics.setLaborHour(d5);
            salesStatistics.setLaborCost(d6);
            salesStatistics.setLaborCount(serializable.size());
            object = session.createCriteria(Shift.class);
            List list3 = object.list();
            object2 = new Shift();
            ((BaseShift)object2).setName(Messages.getString("SalesSummaryDAO.1"));
            list3.add(object2);
            if (list.isEmpty()) {
                list = Application.getInstance().getOrderTypes();
            }
            if (bl) {
                for (OrderType orderType : list) {
                    this.findRecordByOrderType(date, date2, session, salesStatistics, null, orderType);
                }
            } else {
                for (Object e : list3) {
                    serializable = (Shift)e;
                    for (OrderType orderType : list) {
                        this.findRecordByOrderType(date, date2, session, salesStatistics, (Shift)serializable, orderType);
                    }
                }
            }
            salesStatistics.calculateOthers();
            object = salesStatistics;
            return object;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private void findRecordByOrderType(Date date, Date date2, Session session, SalesStatistics salesStatistics, Shift shift, OrderType orderType) {
        Criteria criteria = session.createCriteria(Ticket.class, "ticket");
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add(Projections.rowCount());
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
        criteria.setProjection((Projection)projectionList);
        if (shift != null) {
            if (StringUtils.isBlank((CharSequence)shift.getId())) {
                criteria.add(Restrictions.isNull((String)Ticket.PROP_SHIFT_ID));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)shift.getId()));
            }
        }
        List<String> list = orderType == null ? null : Arrays.asList(orderType.getId());
        this.createCommonCriteria(date, date2, list, false, criteria);
        List list2 = criteria.list();
        if (list2.size() > 0) {
            Object object;
            SalesStatistics.ShiftwiseSalesTableData shiftwiseSalesTableData = new SalesStatistics.ShiftwiseSalesTableData();
            shiftwiseSalesTableData.setOrderType(orderType.toString());
            Object[] objectArray = (Object[])list2.get(0);
            String string = POSConstants.ALL;
            if (shift != null) {
                string = "<html>" + shift.getName();
                if (StringUtils.isNotBlank((CharSequence)shift.getId())) {
                    object = ShiftUtil.buildShiftTimeRepresentation(shift.getStartTime());
                    String string2 = ShiftUtil.buildShiftTimeRepresentation(shift.getEndTime());
                    string = string + "<br>(" + (String)object + "-" + string2 + ")";
                }
                string = string + "</html>";
            }
            System.out.println(string);
            shiftwiseSalesTableData.setShiftName(string);
            shiftwiseSalesTableData.setCheckCount(((Number)objectArray[0]).intValue());
            if (objectArray.length > 1 && objectArray[1] != null) {
                shiftwiseSalesTableData.setGuestCount(((Number)objectArray[1]).intValue());
            }
            object = new SalesReportUtil(date, date2);
            ((SalesReportUtil)object).setShift(shift);
            ((SalesReportUtil)object).setOrderTypeIds(list);
            double d = ((SalesReportUtil)object).calculateGrossSalesWithOutIncludedTax(session);
            double d2 = ((SalesReportUtil)object).calculateDiscountAmount(session);
            double d3 = ((SalesReportUtil)object).calculateReturnAmountWithOutIncludedTax(session);
            shiftwiseSalesTableData.setGrossSales(d);
            shiftwiseSalesTableData.setDiscount(d2);
            shiftwiseSalesTableData.setReturnAmount(d3);
            shiftwiseSalesTableData.calculateOthers();
            shiftwiseSalesTableData.setPercentage(NumberUtil.isZero(salesStatistics.getGrossSales()) ? 0.0 : shiftwiseSalesTableData.getNetSales() * 100.0 / salesStatistics.getGrossSales());
            salesStatistics.addSalesTableData(shiftwiseSalesTableData);
        }
    }

    private void createCommonCriteria(Date date, Date date2, List<String> list, Boolean bl, Criteria criteria) {
        this.createCommonCriteria(date, date2, list, bl, null, criteria);
    }

    private void createCommonCriteria(Date date, Date date2, List<String> list, Boolean bl, Boolean bl2, Criteria criteria) {
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        if (!list.isEmpty()) {
            criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, list));
        }
        if (bl != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)bl));
        }
        if (bl2 != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)bl2));
        }
    }
}

