/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.BaseShopSeatDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ShopSeatDAO
extends BaseShopSeatDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public ShopSeat getShopSeatById(String string, Ticket ticket) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        ShopSeat shopSeat2 = null;
        try {
            shopSeat2 = this.get(string);
            if (shopSeat2 == null && ticket != null) {
                List<ShopSeat> list = ticket.getExtraSeats();
                if (!(list = list.stream().filter(shopSeat -> shopSeat.getId().equals(string)).collect(Collectors.toList())).isEmpty()) {
                    shopSeat2 = list.get(0);
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return shopSeat2;
    }

    public List<ShopSeat> getShopSeatsByTableId(Integer n) {
        List<ShopSeat> list = new ArrayList<ShopSeat>();
        if (n != null) {
            try (Session session = this.createNewSession();){
                Criteria criteria = session.createCriteria(this.getReferenceClass());
                criteria.add((Criterion)Restrictions.eq((String)ShopSeat.PROP_TABLE_ID, (Object)n));
                list = criteria.list();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        return list;
    }

    public List<ShopSeat> getShopSeatsByTableIds(List<Integer> list) {
        List<ShopSeat> list2 = new ArrayList<ShopSeat>();
        if (list != null && !list.isEmpty()) {
            try (Session session = this.createNewSession();){
                Criteria criteria = session.createCriteria(this.getReferenceClass());
                criteria.add(Restrictions.in((String)ShopSeat.PROP_TABLE_ID, list));
                list2 = criteria.list();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        return list2;
    }

    public boolean isShopSeatServing(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.createAlias("ticketItems", "ti");
            criteria.add((Criterion)Restrictions.eq((String)("ti." + TicketItem.PROP_TREAT_AS_SEAT), (Object)Boolean.TRUE));
            criteria.createAlias("ti.seat", "s");
            criteria.add((Criterion)Restrictions.eq((String)("s." + TicketItemSeat.PROP_SEAT_ID), (Object)string));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
    }
}

