/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.dao.BaseSlideShowImageDAO;
import com.floreantpos.swing.PaginatedTableModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SlideShowImageDAO
extends BaseSlideShowImageDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(SlideShowImage.class);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginatedTableModel paginatedTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(SlideShowImage.class);
            criteria.addOrder(Order.asc((String)SlideShowImage.PROP_ID));
            criteria.addOrder(Order.asc((String)SlideShowImage.PROP_SORT_ORDER));
            int n = paginatedTableModel.getCurrentRowIndex();
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            criteria.setProjection((Projection)Projections.property((String)SlideShowImage.PROP_IMAGE_ID));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                paginatedTableModel.setRows(null);
                return;
            }
            criteria = session.createCriteria(ImageResource.class);
            criteria.add(Restrictions.in((String)ImageResource.PROP_ID, (Collection)list));
            List list2 = criteria.list();
            paginatedTableModel.setRows(list2);
        }
        catch (Exception exception) {
            paginatedTableModel.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlideShowImage findByImageId(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(SlideShowImage.class);
            criteria.add((Criterion)Restrictions.eq((String)SlideShowImage.PROP_IMAGE_ID, (Object)string));
            List list = criteria.list();
            if (list.size() == 0) {
                SlideShowImage slideShowImage = null;
                return slideShowImage;
            }
            SlideShowImage slideShowImage = (SlideShowImage)list.get(0);
            return slideShowImage;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<ImageResource> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ImageResource imageResource : list) {
                SlideShowImage slideShowImage = new SlideShowImage();
                slideShowImage.setImageId(imageResource.getId());
                this.saveOrUpdate(slideShowImage, session);
            }
            transaction.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateSlideShowImage(List<SlideShowImage> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (SlideShowImage slideShowImage : list) {
                SlideShowImage slideShowImage2 = this.get(slideShowImage.getId());
                if (slideShowImage2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(slideShowImage.getLastUpdateTime(), slideShowImage2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), "Slide show image : " + slideShowImage.getImageId() + " already updated");
                        continue;
                    }
                    PropertyUtils.copyProperties((Object)slideShowImage2, (Object)slideShowImage);
                    slideShowImage2.setUpdateLastUpdateTime(bl);
                    slideShowImage2.setUpdateSyncTime(bl2);
                    this.update(slideShowImage2);
                    continue;
                }
                slideShowImage.setUpdateLastUpdateTime(bl);
                slideShowImage.setUpdateSyncTime(bl2);
                this.save(slideShowImage);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }
}

