/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableBookingInfo;
import com.floreantpos.model.base.BaseTableBookingInfo;
import com.floreantpos.model.dao.BaseTableBookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.util.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class TableBookingInfoDAO
extends BaseTableBookingInfoDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ShopTable> getBookedTables(Date date, Date date2) {
        Session session = null;
        try {
            Object object22;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)TableBookingInfo.PROP_TO_DATE, (Object)date)).add((Criterion)Restrictions.ne((String)TableBookingInfo.PROP_STATUS, (Object)"cancel")).add((Criterion)Restrictions.ne((String)TableBookingInfo.PROP_STATUS, (Object)"no appear")).add((Criterion)Restrictions.ne((String)TableBookingInfo.PROP_STATUS, (Object)"close"));
            List list = criteria.list();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object22 : list) {
                if (!DateUtil.between(((BaseTableBookingInfo)object22).getFromDate(), ((BaseTableBookingInfo)object22).getToDate(), date) && !DateUtil.between(((BaseTableBookingInfo)object22).getFromDate(), ((BaseTableBookingInfo)object22).getToDate(), date2)) continue;
                arrayList.add(object22);
            }
            HashSet hashSet = new HashSet();
            for (TableBookingInfo tableBookingInfo : arrayList) {
                List<ShopTable> list2 = tableBookingInfo.getTables();
                if (list2 == null) continue;
                hashSet.addAll(list2);
            }
            object22 = hashSet;
            return object22;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
        return null;
    }

    public List<ShopTable> getFreeTables(Date date, Date date2) {
        Collection<ShopTable> collection = this.getBookedTables(date, date2);
        List<ShopTable> list = ShopTableDAO.getInstance().findAll();
        list.removeAll(collection);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableBookingInfo> getAllOpenBooking() {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ne((String)TableBookingInfo.PROP_STATUS, (Object)"close"));
            List list2 = list = criteria.list();
            return list2;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void setBookingStatus(TableBookingInfo tableBookingInfo, String string, List<ShopTableStatus> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            tableBookingInfo.setStatus(string);
            this.saveOrUpdate(tableBookingInfo);
            if (string.equals("seat") || string.equals("delay")) {
                ShopTableDAO.getInstance().bookedTables(list);
            }
            if (string.equals("cancel") || string.equals("no appear") || string.equals("close")) {
                ShopTableDAO.getInstance().freeTables(list);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(TableBookingInfo.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTodaysBooking() {
        try (Session session = null;){
            List list;
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setLenient(false);
            calendar2.setTime(new Date());
            calendar2.set(11, 23);
            calendar2.set(12, 59);
            calendar2.set(13, 59);
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(TableBookingInfo.class);
            criteria.add((Criterion)Restrictions.ge((String)TableBookingInfo.PROP_FROM_DATE, (Object)calendar.getTime())).add((Criterion)Restrictions.le((String)TableBookingInfo.PROP_FROM_DATE, (Object)calendar2.getTime())).add((Criterion)Restrictions.eq((String)TableBookingInfo.PROP_STATUS, (Object)"open"));
            List list2 = list = criteria.list();
            return list2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllBookingByDate(Date date, Date date2) {
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(TableBookingInfo.class);
            criteria.add((Criterion)Restrictions.ge((String)TableBookingInfo.PROP_FROM_DATE, (Object)date)).add((Criterion)Restrictions.le((String)TableBookingInfo.PROP_FROM_DATE, (Object)date2)).add((Criterion)Restrictions.ne((String)TableBookingInfo.PROP_STATUS, (Object)"close"));
            List list2 = list = criteria.list();
            return list2;
        }
        return null;
    }
}

