/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.CacheRefreshListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

public abstract class DataProvider {
    public static final String DATA_PROVIDER_CLASS_NAME = "data.provider.class";
    private static DataProvider instance;
    private List<CacheRefreshListener> refreshListeners = new ArrayList<CacheRefreshListener>(5);
    private Ticket ticketToBeCreated;
    private OrderType selectedOrderType;

    public abstract void initialize();

    public abstract Store getStore();

    public abstract Outlet getOutlet();

    public abstract StoreSession getStoreSession();

    public String getStoreSessionId() {
        StoreSession storeSession = this.getStoreSession();
        if (storeSession != null) {
            return storeSession.getId();
        }
        return null;
    }

    public abstract void setStoreSession(StoreSession var1);

    public abstract InventoryUnit getInventoryUnitById(String var1);

    public IUnit getUnitByCode(String string) {
        return null;
    }

    public abstract TaxGroup getTaxGroupById(String var1);

    public abstract Tax getTaxById(String var1);

    public abstract ReportGroup getReportGroupById(String var1);

    public abstract PrinterGroup getPrinterGroupById(String var1);

    public abstract Department getDepartmentById(String var1);

    public abstract OrderType getOrderTypeById(String var1);

    public abstract InventoryLocation getInventoryLocationById(String var1);

    public abstract User getUserById(String var1);

    public abstract Terminal getTerminalById(Integer var1);

    public abstract Shift getShiftById(String var1);

    public abstract Terminal getCurrentTerminal();

    public abstract void setCloudTerminal(Terminal var1);

    public abstract OrderType getOrderType(String var1);

    public abstract List<OrderType> getOrderTypes();

    public abstract UserType getUserType(String var1);

    public abstract Currency getCurrency(String var1);

    public abstract Course getCourse(String var1);

    public abstract TerminalType getTerminalType(String var1);

    public abstract Multiplier getMultiplierById(String var1);

    public abstract List<Multiplier> getMultiplierList();

    public abstract InventoryLocation getDefaultInLocation();

    public abstract InventoryLocation getDefaultOutLocation();

    public abstract List<Course> getCourses();

    public abstract String getDefaultCourseId();

    public abstract void refreshStore();

    public abstract void refreshCurrentTerminal();

    public abstract SalesArea getSalesArea(String var1);

    public abstract String getRecipeMenuItemName(Recepie var1);

    public abstract PosPrinters getPrinters();

    public abstract MenuItemInventoryStatus getMenuItemStockStatus(MenuItem var1);

    public abstract Customer getCustomer(String var1);

    public abstract double getPriceFromPriceRule(MenuItem var1, OrderType var2, Department var3, SalesArea var4, CustomerGroup var5);

    public abstract List<DayPart> getDaryPartShifts();

    public abstract List<PriceShift> getPriceShifts();

    public abstract List<MenuShift> getMenuShifts();

    public abstract File getAppConfigFileLocation();

    public abstract Currency getMainCurrency();

    public abstract List<Currency> getCurrencies();

    public List<ShopFloor> getShopFloors() {
        return ShopFloorDAO.getInstance().findAll();
    }

    public static DataProvider get() {
        if (instance == null) {
            try {
                String string = System.getProperty(DATA_PROVIDER_CLASS_NAME);
                if (StringUtils.isEmpty((String)string)) {
                    string = "com.floreantpos.model.dao.util.PosCacheManager";
                }
                instance = (DataProvider)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                LogFactory.getLog(DataProvider.class).error((Object)"Could not initialize data provider", (Throwable)exception);
            }
        }
        return instance;
    }

    public static void set(DataProvider dataProvider) {
        instance = dataProvider;
    }

    public Object getObjectOf(Class clazz, Serializable serializable) {
        try (Session session = StoreDAO.getInstance().createNewSession();){
            Object object = session.get(clazz, serializable);
            return object;
        }
    }

    public ImageIcon getIconFromImageResource(String string) {
        try {
            if (string == null) {
                return null;
            }
            ImageResource imageResource = ImageResourceDAO.getInstance().findById(string);
            if (imageResource != null) {
                return imageResource.getImageIcon();
            }
        }
        catch (Exception exception) {
            PosLog.error(DataProvider.class, exception);
        }
        return null;
    }

    public ImageIcon getIconFromImageResource(String string, int n, int n2) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            ImageResource imageResource = ImageResourceDAO.getInstance().get(string);
            if (imageResource != null) {
                return imageResource.getScaledImage(n, n2);
            }
        }
        catch (Exception exception) {
            PosLog.error(DataProvider.class, exception);
        }
        return null;
    }

    public ImageResource getImageResource(String string) {
        try {
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            ImageResource imageResource = ImageResourceDAO.getInstance().findById(string);
            if (imageResource != null) {
                return imageResource;
            }
        }
        catch (Exception exception) {
            PosLog.error(DataProvider.class, exception);
        }
        return null;
    }

    public synchronized void addCacheRefreshListener(CacheRefreshListener cacheRefreshListener) {
        this.refreshListeners.add(cacheRefreshListener);
    }

    public synchronized void removeCacheRefreshListener(CacheRefreshListener cacheRefreshListener) {
        this.refreshListeners.remove(cacheRefreshListener);
    }

    public synchronized void fireCacheRefreshed() {
        for (CacheRefreshListener cacheRefreshListener : this.refreshListeners) {
            cacheRefreshListener.cacheRefreshed();
        }
    }

    public Ticket getTicketToBeCreated() {
        return this.ticketToBeCreated;
    }

    public void setTicketToBeCreated(Ticket ticket) {
        this.ticketToBeCreated = ticket;
    }

    public OrderType getSelectedOrderType() {
        return this.selectedOrderType;
    }

    public void setSelectedOrderType(OrderType orderType) {
        this.selectedOrderType = orderType;
    }

    public PrinterGroup getDefaultPrinterGroup() {
        return null;
    }

    public boolean isCaching(Class clazz) {
        return false;
    }

    public String getCurrentOutletId() {
        if (this.getOutlet() == null) {
            return null;
        }
        return this.getOutlet().getId();
    }

    public OrderType getDeliveryOrderType() {
        List<OrderType> list = this.getOrderTypes();
        for (OrderType orderType : list) {
            if (!orderType.isDelivery().booleanValue()) continue;
            return orderType;
        }
        return null;
    }
}

