/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.AttendanceReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class AttendanceReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JComboBox e;

    public AttendanceReportView() {
        this.setLayout(new BorderLayout());
        this.a();
    }

    private void a() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.b());
        this.e = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findActiveUsersForPayroll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.e.setModel(new DefaultComboBoxModel(vector));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"MMM dd, yyyy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"MMM dd, yyyy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.USER + ":"));
        jPanel.add(this.e);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    private void b() {
        try {
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
            calendar.clear();
            calendar2.setTime(date2);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            date2 = calendar.getTime();
            User user = null;
            if (!this.e.getSelectedItem().equals(POSConstants.ALL)) {
                user = (User)this.e.getSelectedItem();
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            List<AttendanceReportData> list = attendenceHistoryDAO.findAttendance(date, date2, user);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("EmployeeAttendanceReport"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap, true);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            AttendanceReportModel attendanceReportModel = new AttendanceReportModel();
            attendanceReportModel.setRows(list);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)attendanceReportModel));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("RTitle", Messages.getString("EmployeeAttendanceAction.1"));
        hashMap.put("colEID", Messages.getString("EmployeeId"));
        hashMap.put("colName", POSConstants.NAME);
        hashMap.put("colUserType", Messages.getString("colRole"));
        hashMap.put("colCITime", Messages.getString("ClockInTime"));
        hashMap.put("colCOTime", Messages.getString("AttendanceHistoryExplorer.10"));
        hashMap.put("colWTHRs", Messages.getString("WorkTimeHRS"));
    }
}

