/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.PayrollReportData;
import com.floreantpos.report.PayrollReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class PayrollReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private JComboBox f;

    public PayrollReportView() {
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list = terminalDAO.findAll();
        list.add(0, (Terminal)((Object)POSConstants.ALL));
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
            calendar.clear();
            calendar2.setTime(date2);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            date2 = calendar.getTime();
            Object object = this.f.getSelectedItem();
            User user = null;
            if (object instanceof User) {
                user = (User)object;
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            List<PayrollReportData> list = attendenceHistoryDAO.findPayroll(date, date2, user);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("PayrollReport"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap, false);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            Comparator<PayrollReportData> comparator = Comparator.comparing(PayrollReportData::getUserIdSortKey, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(PayrollReportData::getClockIn, Comparator.nullsLast(Comparator.naturalOrder()));
            list.sort(comparator);
            PayrollReportModel payrollReportModel = new PayrollReportModel();
            payrollReportModel.setRows(list);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)payrollReportModel));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("RTitle", Messages.getString("PayrollReport"));
        hashMap.put("colEID", Messages.getString("EmployeeId") + ":");
        hashMap.put("colEName", Messages.getString("EmployeeName") + ":");
        hashMap.put("colClockIn", Messages.getString("ClockInOutAction.5"));
        hashMap.put("colClockOut", Messages.getString("ClockInOutAction.6"));
        hashMap.put("colRole", Messages.getString("colRole"));
        hashMap.put("colReWoHour", Messages.getString("RegularH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colOvWoHour", Messages.getString("OvertimeH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colRegularPayment", Messages.getString("Regular") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colOverTimePayment", Messages.getString("OvertimeTH") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colCostPerHourRate", Messages.getString("PayrollReportView.0"));
        hashMap.put("colOverTimePerHourRate", Messages.getString("PayrollReportView.2"));
        hashMap.put("colTotalWorkHourDisplay", Messages.getString("TotalH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colTotalPayment", POSConstants.TOTAL + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("rowTotal", POSConstants.TOTAL + ":");
    }

    private void b() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.f = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findActiveUsersForPayroll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.e;
    }

    public static class LaborReportData {
        private String a;
        private int b;
        private int c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;

        public double getCheckPerMHr() {
            return this.i;
        }

        public void setCheckPerMHr(double d) {
            this.i = d;
        }

        public double getGuestsPerMHr() {
            return this.h;
        }

        public void setGuestsPerMHr(double d) {
            this.h = d;
        }

        public double getLabor() {
            return this.f;
        }

        public void setLabor(double d) {
            this.f = d;
        }

        public double getLaborCost() {
            return this.j;
        }

        public void setLaborCost(double d) {
            this.j = d;
        }

        public double getManHour() {
            return this.e;
        }

        public void setManHour(double d) {
            this.e = d;
        }

        public int getNoOfChecks() {
            return this.b;
        }

        public void setNoOfChecks(int n) {
            this.b = n;
        }

        public int getNoOfGuests() {
            return this.c;
        }

        public void setNoOfGuests(int n) {
            this.c = n;
        }

        public String getPeriod() {
            return this.a;
        }

        public void setPeriod(String string) {
            this.a = string;
        }

        public double getSales() {
            return this.d;
        }

        public void setSales(double d) {
            this.d = d;
        }

        public double getSalesPerMHr() {
            return this.g;
        }

        public void setSalesPerMHr(double d) {
            this.g = d;
        }
    }
}

