/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.EndOfDaySummaryReportModel;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class EndOfDayReportService {
    public static JasperPrint createEndOfDayReport(Date date, Date date2, User user) throws JRException {
        DateUtil.validateDate(date, date2);
        List<EndOfDayReportData> list = TicketItemDAO.getInstance().findEndOfDayReportData(date, date2, null);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("end_of_day_summary_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportTime(hashMap, date, date2);
        ReportUtil.populateReportFooter(hashMap);
        EndOfDayReportService.a(hashMap, null);
        EndOfDaySummaryReportModel endOfDaySummaryReportModel = new EndOfDaySummaryReportModel();
        endOfDaySummaryReportModel.setRows(list);
        return JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)endOfDaySummaryReportModel));
    }

    private static void a(HashMap<String, Object> hashMap, List<OrderType> list) {
        String string = POSUtil.createOrderTypeIdString(list);
        hashMap.put("reportTitle", Messages.getString("EndOfDaySummaryReport"));
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("orderType", ReportUtil.reportLabelWithBoldTag(Messages.getString("colOrderType") + ": ") + string);
        hashMap.put("colSubtotal", POSConstants.SUBTOTAL);
        hashMap.put("colMName", Messages.getString("MEMBER"));
        hashMap.put("colTID", POSConstants.TICKET_ID);
        hashMap.put("colTAmount", Messages.getString("EndOfDaySummaryReportView.2"));
        hashMap.put("colSC", POSConstants.S_C);
        hashMap.put("colTips", Messages.getString("GRATUITY"));
        hashMap.put("colTax", POSConstants.TAX);
        hashMap.put("colTotal", POSConstants.TOTAL);
        hashMap.put("colGrossSales", POSConstants.TOTAL);
        hashMap.put("colMCharge", Messages.getString("MEMBER") + "<br/>" + Messages.getString("CHARGE"));
        hashMap.put("colCCard", Messages.getString("colCredit") + "<br/>" + Messages.getString("CARD"));
        hashMap.put("colCPayment", Messages.getString("CashPayment"));
        hashMap.put("colOthersPymt", Messages.getString("OthersPayment"));
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("colRefund", Messages.getString("EndOfDaySummaryReportView.1"));
        hashMap.put("colTaxReceived", Messages.getString("EndOfDaySummaryReportView.3"));
        hashMap.put("colTotalReceived", POSConstants.TOTAL + " " + Messages.getString("EndOfDaySummaryReportView.4"));
        hashMap.put("colReturnAmount", POSConstants.RETURN);
        hashMap.put("colNetSalesAmount", POSConstants.NET_SALES);
    }
}

