/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.util.CurrencyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang.StringUtils;

public class ItemwiseSalesReportService {
    private SalesReportModel a;
    private SalesReportModel b;
    private Date c;
    private Date d;
    private Terminal e;
    private List<MenuGroup> f;
    private Boolean g;
    private boolean h;
    private boolean i;
    private boolean j;
    private boolean k;

    public ItemwiseSalesReportService(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl, boolean bl2, boolean bl3) {
        this(date, date2, terminal, list, bl, bl2, bl3, Boolean.TRUE);
    }

    public ItemwiseSalesReportService(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(date, date2, terminal, list, bl, bl2, bl3, Boolean.TRUE, Boolean.FALSE);
    }

    public ItemwiseSalesReportService(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.c = date;
        this.d = date2;
        this.e = terminal;
        this.f = list;
        this.g = bl;
        this.h = bl2;
        this.i = bl3;
        this.j = bl4;
        this.k = bl5;
    }

    public JasperPrint createJasperPrint() throws JRException {
        String string;
        this.a();
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("itemwise_sales_sub_report"));
        JasperReport jasperReport2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("itemwise_sales_sub_report"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, this.e, this.c, this.d, null);
        String string2 = string = this.k ? Messages.getString("ItemwiseSalesReportService.2") : POSConstants.ITEMWISE_SALES_REPORT;
        if (this.g != null) {
            string = this.g != false ? string + Messages.getString("ItemwiseSalesReportService.0") : string + Messages.getString("ItemwiseSalesReportService.1");
        }
        hashMap.put("reportTitle", string);
        hashMap.put("itemDataSource", new JRTableModelDataSource((TableModel)this.a));
        hashMap.put("modifierDataSource", new JRTableModelDataSource((TableModel)this.b));
        hashMap.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("itemReport", jasperReport);
        hashMap.put("isShowGroup", this.h);
        hashMap.put("isShowModifier", this.j);
        hashMap.put("modifierReport", jasperReport2);
        hashMap.put("colId", ReportUtil.reportLabelWithBoldTag(POSConstants.ID));
        hashMap.put("colName", ReportUtil.reportLabelWithBoldTag(POSConstants.NAME));
        hashMap.put("colQty", ReportUtil.reportLabelWithBoldTag(POSConstants.QTY));
        hashMap.put("colUnit", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT));
        hashMap.put("colSales", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT_PRICE));
        hashMap.put("colDiscount", ReportUtil.reportLabelWithBoldTag(POSConstants.DISCOUNT));
        hashMap.put("colCost", ReportUtil.reportLabelWithBoldTag(POSConstants.COST));
        hashMap.put("colCostPer", ReportUtil.reportLabelWithBoldTag(POSConstants.COST_PERCENTAGE));
        hashMap.put("colNetTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_SALES));
        hashMap.put("colTax", ReportUtil.reportLabelWithBoldTag(POSConstants.TAX));
        hashMap.put("colSC", ReportUtil.reportLabelWithBoldTag(POSConstants.S_C));
        hashMap.put("colGrossT", ReportUtil.reportLabelWithBoldTag(POSConstants.TOTAL));
        hashMap.put("groupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GROUP_TOTAL));
        hashMap.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.ITEM_TOTAL + ": "));
        hashMap.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.MODIFIER_TOTAL + ": "));
        hashMap.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        hashMap.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_SALES));
        hashMap.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag(Messages.getString("SalesReportService.0")));
        hashMap.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag(POSConstants.RETURN));
        hashMap.put("lblProfit", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_PROFIT));
        hashMap.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag(POSConstants.PROFIT + " %"));
        hashMap.put("itemSection", POSConstants.ITEMS);
        if (this.b.getItems().size() > 0) {
            hashMap.put("modifierSection", Messages.getString("SalesReportService.5"));
        }
        this.a(hashMap);
        JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("itemwise_sales_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private void a() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        LinkedHashMap<String, ReportItem> linkedHashMap = new LinkedHashMap<String, ReportItem>();
        LinkedHashMap<Object, Serializable> linkedHashMap2 = new LinkedHashMap<Object, Serializable>();
        TicketItemDAO ticketItemDAO = TicketItemDAO.getInstance();
        List<TicketItem> list = ticketItemDAO.findTicketItemWithinDate(this.c, this.d, this.e, this.f, this.g, null, this.k);
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        for (TicketItem serializable22 : list) {
            ComboTicketItem comboTicketItem;
            if (serializable22.getUnitPrice() == 0.0 && !this.i) continue;
            this.a(serializable22, null, linkedHashMap);
            this.a(serializable22, arrayList, false);
            if (!serializable22.isComboItem().booleanValue() || !(serializable22 instanceof ComboTicketItem) || (object4 = (comboTicketItem = (ComboTicketItem)serializable22).getComboItems()) == null || object4.size() <= 0) continue;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                serializable = (TicketItem)object3.next();
                ((BaseTicketItem)serializable).setUnitPrice(0.0);
                ((BaseTicketItem)serializable).setUnitCost(0.0);
                ((BaseTicketItem)serializable).setGroupId(serializable22.getGroupId());
                ((BaseTicketItem)serializable).setGroupName(serializable22.getGroupName());
                object2 = ((TicketItem)serializable).getTicketItemModifiers();
                if (object2 != null && object2.size() > 0) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        TicketItemModifier ticketItemModifier = object.next();
                        ticketItemModifier.setUnitPrice(0.0);
                        ticketItemModifier.setUnitCost(0.0);
                    }
                }
                ((TicketItem)serializable).calculatePrice();
                this.a((TicketItem)serializable, serializable22, linkedHashMap);
            }
        }
        ArrayList arrayList2 = new ArrayList(((HashMap)linkedHashMap).values());
        if (this.h) {
            Collections.sort(arrayList2, new Comparator<ReportItem>(){

                @Override
                public int compare(ReportItem reportItem, ReportItem reportItem2) {
                    if (reportItem.getGroupName() == reportItem2.getGroupName()) {
                        return 0;
                    }
                    if (reportItem.getGroupName() == null) {
                        return 1;
                    }
                    if (reportItem2.getGroupName() == null) {
                        return -1;
                    }
                    return reportItem.getGroupName().compareTo(reportItem2.getGroupName());
                }
            });
        }
        this.a = new SalesReportModel();
        this.a.setItems(arrayList2);
        this.a.calculateGrandTotal();
        for (TicketItemModifier ticketItemModifier : arrayList) {
            if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
            object4 = ticketItemModifier.getItemId();
            object3 = (String)(object4 == null ? ticketItemModifier.getName() : object4) + "-" + ticketItemModifier.getModifierType() + "-" + ticketItemModifier.getUnitPrice();
            serializable = (ReportItem)((HashMap)linkedHashMap2).get(object3);
            if (serializable == null) {
                serializable = new ReportItem();
                ((ReportItem)serializable).setId((String)object4);
                ((ReportItem)serializable).setPrice(ticketItemModifier.getUnitPrice());
                ((ReportItem)serializable).setName(ticketItemModifier.getName());
                if (ticketItemModifier.getGroupId() != null) {
                    object2 = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
                    ((ReportItem)serializable).setGroupName(object2 != null ? ((BaseMenuItemModifierSpec)object2).getName() : "");
                }
                ((ReportItem)serializable).setTaxRate(ticketItemModifier.getTotalTaxRate());
                ((ReportItem)serializable).setAdjustedPrice(ticketItemModifier.getAdjustedUnitPrice());
                ((ReportItem)serializable).calculate();
                linkedHashMap2.put(object3, serializable);
            }
            ((ReportItem)serializable).setCost(((ReportItem)serializable).getCost() + ticketItemModifier.getTotalCost());
            ((ReportItem)serializable).setQuantity(((ReportItem)serializable).getQuantity() + ticketItemModifier.getItemQuantity() * Math.abs(ticketItemModifier.getTicketItemQuantity()));
            ((ReportItem)serializable).setDiscount(((ReportItem)serializable).getDiscount() + -1.0 * ticketItemModifier.getAdjustedDiscount());
            ((ReportItem)serializable).setTaxTotal(((ReportItem)serializable).getTaxTotal() + ticketItemModifier.getAdjustedTax());
            ((ReportItem)serializable).setServiceCharge(((ReportItem)serializable).getServiceCharge() + ticketItemModifier.getServiceCharge());
            object2 = ticketItemModifier.getSubtotalAmount();
            object = ticketItemModifier.getTicketItem();
            if (((BaseTicketItem)object).isTaxIncluded().booleanValue()) {
                object2 = (Double)object2 - ticketItemModifier.getAdjustedTax();
            }
            if (((BaseTicketItem)object).isItemReturned().booleanValue()) {
                ((ReportItem)serializable).setReturnAmount(((ReportItem)serializable).getReturnAmount() + (Double)object2);
            } else {
                ((ReportItem)serializable).setGrossSale(((ReportItem)serializable).getGrossSale() + (Double)object2);
            }
            double d = ((ReportItem)serializable).getGrossSale() + ((ReportItem)serializable).getDiscount() + ((ReportItem)serializable).getReturnAmount();
            ((ReportItem)serializable).setNetTotal(d);
            ((ReportItem)serializable).setTotal(d + ((ReportItem)serializable).getServiceCharge() + ((ReportItem)serializable).getTaxTotal());
            ((ReportItem)serializable).calculate();
        }
        this.b = new SalesReportModel();
        ArrayList<ReportItem> arrayList3 = new ArrayList<ReportItem>(((HashMap)linkedHashMap2).values());
        arrayList3.sort(Comparator.comparing(ReportItem::getName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)));
        this.b.setItems(arrayList3);
        this.b.calculateGrandTotal();
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("gndTotalGrossSales", this.a.getGndTotalGrossSales() + this.b.getGndTotalGrossSales());
        hashMap.put("gndTotalDiscount", this.a.getGndTotalDiscount() + this.b.getGndTotalDiscount());
        hashMap.put("gndTotalReturn", this.a.getGndTotalReturn() + this.b.getGndTotalReturn());
        hashMap.put("gndTotalNetSales", this.a.getGndTotalNetSales() + this.b.getGndTotalNetSales());
        hashMap.put("gndTotalServCharge", this.a.getGndTotalServCharge() + this.b.getGndTotalServCharge());
        hashMap.put("gndTotalTax", this.a.getGndTotalTax() + this.b.getGndTotalTax());
        hashMap.put("gndTotalTotal", this.a.getGndTotalTotal() + this.b.getGndTotalTotal());
        hashMap.put("gndTotalCost", this.a.getGndTotalCost() + this.b.getGndTotalCost());
        hashMap.put("gndTotalProfit", this.a.getGndTotalProfit() + this.b.getGndTotalProfit());
    }

    private void a(TicketItem ticketItem, List<TicketItemModifier> list, boolean bl) {
        List<TicketItemModifier> list2 = ticketItem instanceof ModifiableTicketItem ? ((ModifiableTicketItem)ticketItem).getTicketItemModifiers() : ticketItem.getTicketItemModifiers();
        if (list2 == null) {
            return;
        }
        if (bl && list2 != null && list2.size() > 0) {
            for (TicketItemModifier ticketItemModifier : list2) {
                ticketItemModifier.setUnitPrice(0.0);
                ticketItemModifier.setUnitCost(0.0);
                ticketItemModifier.calculatePrice();
            }
        }
        list.addAll(list2);
    }

    private void a(TicketItem ticketItem, TicketItem ticketItem2, HashMap<String, ReportItem> hashMap) {
        List<TicketItemModifier> list;
        Object object;
        Object object2;
        String string = ticketItem.getMenuItemId();
        String string2 = string + "_" + ticketItem.getName() + "_" + ticketItem.getUnitPrice();
        if (ticketItem2 != null) {
            object2 = ticketItem2.getMenuItemId();
            string2 = string2 + "_" + (String)object2 + "_" + ticketItem2.getName() + "_" + ticketItem2.getUnitPrice();
            if (this.j && ticketItem.isHasModifiers().booleanValue() && ticketItem instanceof ModifiableTicketItem && (object = ((ModifiableTicketItem)ticketItem).getTicketItemModifiers()) != null) {
                list = object.iterator();
                while (list.hasNext()) {
                    TicketItemModifier ticketItemModifier = (TicketItemModifier)list.next();
                    string2 = string2 + "_" + ticketItemModifier.getId();
                }
            }
        }
        if ((object2 = hashMap.get(string2)) == null) {
            object2 = new ReportItem();
            ((ReportItem)object2).setId(string2);
            ((ReportItem)object2).setPrice(ticketItem.getUnitPrice());
            object = "";
            if (ticketItem2 != null) {
                if (this.j && ticketItem.isHasModifiers().booleanValue()) {
                    object = "    #" + ticketItem.getName();
                    if (ticketItem instanceof ModifiableTicketItem && (list = ((ModifiableTicketItem)ticketItem).getTicketItemModifiers()) != null) {
                        for (TicketItemModifier ticketItemModifier : list) {
                            object = (String)object + "\n     --" + ticketItemModifier.getName();
                        }
                    }
                } else {
                    object = "    #" + ticketItem.getName();
                }
            } else {
                object = ticketItem.getName();
            }
            ((ReportItem)object2).setName((String)object);
            list = ticketItem.getProperty("unit_display_name", "");
            if (StringUtils.isBlank((String)((Object)list))) {
                list = ticketItem.getUnitName();
            }
            ((ReportItem)object2).setUnit((String)((Object)list));
            ((ReportItem)object2).setTaxRate(ticketItem.getTotalTaxRate());
            ((ReportItem)object2).setGroupName(ticketItem.getGroupName());
            ((ReportItem)object2).setBarcode(string);
            ((ReportItem)object2).setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
            ((ReportItem)object2).setComboChildItem(ticketItem2 != null);
            ((ReportItem)object2).calculate();
            hashMap.put(string2, (ReportItem)object2);
        }
        ((ReportItem)object2).setQuantity(((ReportItem)object2).getQuantity() + ticketItem.getQuantity());
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.j) {
            d = ticketItem.getAdjustedDiscountWithoutModifiers();
            d2 = ticketItem.getTotalCostWithoutModifiers();
            d3 = ticketItem.getServiceChargeWithoutModifiers();
            d4 = ticketItem.getAdjustedTaxWithoutModifiers();
        } else {
            d = ticketItem.getAdjustedDiscount();
            d2 = ticketItem.getTotalCost();
            d3 = ticketItem.getServiceCharge();
            d4 = ticketItem.getAdjustedTax();
        }
        ((ReportItem)object2).setDiscount(((ReportItem)object2).getDiscount() + -1.0 * d);
        ((ReportItem)object2).setCost(((ReportItem)object2).getCost() + d2);
        ((ReportItem)object2).setTaxTotal(((ReportItem)object2).getTaxTotal() + d4);
        ((ReportItem)object2).setServiceCharge(((ReportItem)object2).getServiceCharge() + d3);
        Double d5 = 0.0;
        d5 = this.j ? (ticketItem.isTaxIncluded().booleanValue() ? Double.valueOf(ticketItem.getSubtotalAmountWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers()) : ticketItem.getSubtotalAmountWithoutModifiers()) : (ticketItem.isTaxIncluded() != false ? Double.valueOf(ticketItem.getSubtotalAmount() - ticketItem.getAdjustedTax()) : ticketItem.getSubtotalAmount());
        if (ticketItem.isItemReturned().booleanValue()) {
            ((ReportItem)object2).setReturnAmount(((ReportItem)object2).getReturnAmount() + d5);
        } else {
            ((ReportItem)object2).setGrossSale(((ReportItem)object2).getGrossSale() + d5);
        }
        double d6 = ((ReportItem)object2).getGrossSale() + ((ReportItem)object2).getDiscount() + ((ReportItem)object2).getReturnAmount();
        ((ReportItem)object2).setNetTotal(d6);
        ((ReportItem)object2).setTotal(d6 + ((ReportItem)object2).getServiceCharge() + ((ReportItem)object2).getTaxTotal());
        ((ReportItem)object2).calculate();
    }
}

