/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.TicketListView;
import com.floreantpos.ui.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXDatePicker;

public class OrderFilterPanel
extends JXCollapsiblePane {
    private ITicketList a;
    private TicketListView b;
    private POSToggleButton c;
    private POSToggleButton d;
    private JPanel e;
    private JXDatePicker f;
    private JXDatePicker g;
    private POSTextField h;
    private POSComboBox i;
    private POSToggleButton j;

    public OrderFilterPanel(ITicketList iTicketList) {
        this.a = iTicketList;
        this.b = (TicketListView)iTicketList;
        this.setCollapsed(false);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5", "fill,grow", ""));
        this.e = new JPanel();
        this.e.setLayout(new BorderLayout(5, 5));
        this.a();
        this.b();
        JPanel jPanel2 = this.e();
        jPanel.add((Component)this.e, "wrap");
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
    }

    private void a() {
        this.c = new POSToggleButton(PaymentStatusFilter.OPEN.getDisplayString());
        this.c.setActionCommand(PaymentStatusFilter.OPEN.name());
        this.d = new POSToggleButton(PaymentStatusFilter.CLOSED.getDisplayString());
        this.d.setActionCommand(PaymentStatusFilter.CLOSED.name());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.c);
        buttonGroup.add(this.d);
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        switch (paymentStatusFilter) {
            case OPEN: {
                this.c.setSelected(true);
                break;
            }
            case CLOSED: {
                this.d.setSelected(true);
            }
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                String string2 = string.replaceAll("\\s", "_");
                TerminalConfig.setPaymentStatusFilter(string2);
                OrderFilterPanel.this.i();
            }
        };
        this.c.addActionListener(actionListener);
        this.d.addActionListener(actionListener);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5", "fill, grow", ""));
        jPanel.setPreferredSize(PosUIManager.getSize(200, 60));
        jPanel.setBorder(new TitledBorder(Messages.getString("SwitchboardView.3")));
        jPanel.add(this.c);
        jPanel.add(this.d);
        this.e.add((Component)jPanel, "West");
    }

    private void b() {
        Serializable serializable;
        Serializable serializable22;
        OrderTypeFilterButton orderTypeFilterButton = new OrderTypeFilterButton(null);
        HorizontalTouchScrollPanel horizontalTouchScrollPanel = new HorizontalTouchScrollPanel((LayoutManager)new MigLayout("fill, ins 0", "fill, grow", ""));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(orderTypeFilterButton);
        ((Container)horizontalTouchScrollPanel).add(orderTypeFilterButton);
        List<OrderType> list = Application.getInstance().getOrderTypes();
        for (Serializable serializable22 : list) {
            serializable = new OrderTypeFilterButton((OrderType)serializable22);
            buttonGroup.add((AbstractButton)serializable);
            ((Container)horizontalTouchScrollPanel).add((Component)serializable);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        serializable22 = new TitledBorder(Messages.getString("SwitchboardView.4"));
        serializable = new EmptyBorder(5, 5, 5, 5);
        jPanel.setBorder(new CompoundBorder((Border)((Object)serializable22), (Border)((Object)serializable)));
        jPanel.add((Component)((Object)new HorizontalSimpleScrollPane(horizontalTouchScrollPanel)));
        this.e.add(jPanel);
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 3", "", ""));
        this.j = new POSToggleButton();
        this.j.setIcon(IconFactory.getIcon("/images/", "keyboard.png"));
        jPanel.add((Component)this.j, "w " + PosUIManager.getSize(100) + "! , h " + PosUIManager.getSize(35) + "!");
        this.j.addActionListener(actionEvent -> this.d());
        POSToggleButton pOSToggleButton = new POSToggleButton(POSConstants.MY_TICKETS);
        pOSToggleButton.setPreferredSize(PosUIManager.getSize(100, 35));
        jPanel.add(pOSToggleButton);
        pOSToggleButton.setSelected(TerminalConfig.isFilterByOwner());
        pOSToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    TerminalConfig.setFilterByOwner(true);
                    OrderFilterPanel.this.i();
                } else {
                    TerminalConfig.setFilterByOwner(false);
                    OrderFilterPanel.this.i();
                }
            }
        });
        return jPanel;
    }

    private void d() {
        this.b.setQwertyKeyPadCollapsed(!this.j.isSelected());
    }

    private JPanel e() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(new TitledBorder(Messages.getString("OrderFilterPanel.1")));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 3", "", ""));
        this.h = new POSTextField(13);
        this.h.setPreferredSize(PosUIManager.getSize(20, 35));
        jPanel2.add(new JLabel(Messages.getString("OrderFilterPanel.2")));
        jPanel2.add(this.h);
        this.h.addKeyListener(this.g());
        JLabel jLabel = new JLabel(POSConstants.START_DATE + ":");
        this.f = UiUtil.getCurrentMonthStart();
        this.f.setDate(null);
        this.f.setPreferredSize(PosUIManager.getSize(120, 35));
        jPanel2.add(jLabel);
        jPanel2.add((Component)this.f);
        this.f.getEditor().addKeyListener(this.g());
        JLabel jLabel2 = new JLabel(POSConstants.END_DATE + ":");
        this.g = UiUtil.getCurrentMonthEnd();
        this.g.setDate(null);
        this.g.setPreferredSize(PosUIManager.getSize(120, 35));
        jPanel2.add(jLabel2);
        jPanel2.add((Component)this.g);
        this.g.getEditor().addKeyListener(this.g());
        JLabel jLabel3 = new JLabel(Messages.getString("OrderFilterPanel.3"));
        this.i = new POSComboBox();
        this.i.setPreferredSize(PosUIManager.getSize(100, 35));
        this.i.setHeight(PosUIManager.getSize(35));
        this.i.addItem(10);
        this.i.addItem(25);
        this.i.addItem(50);
        this.i.addItem(100);
        this.i.addItem(300);
        this.i.setSelectedItem(TerminalConfig.getOrderViewPageSize());
        this.i.addKeyListener(this.g());
        jPanel2.add(jLabel3);
        jPanel2.add((Component)this.i, "h " + PosUIManager.getSize(35) + "!");
        PosButton posButton = new PosButton(Messages.getString("OrderFilterPanel.4"));
        posButton.addActionListener(actionEvent -> this.h());
        jPanel2.add(posButton);
        posButton.setPreferredSize(PosUIManager.getSize(60, 35));
        PosButton posButton2 = new PosButton(Messages.getString("OrderFilterPanel.5"));
        posButton2.setPreferredSize(PosUIManager.getSize(60, 35));
        posButton2.addActionListener(actionEvent -> this.f());
        jPanel2.add(posButton2);
        this.h.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    OrderFilterPanel.this.j.setSelected(true);
                    OrderFilterPanel.this.d();
                }
            }
        });
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.c(), "East");
        return jPanel;
    }

    private void f() {
        this.h.setText("");
        this.f.setDate(null);
        this.g.setDate(null);
        this.h();
    }

    private KeyListener g() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    OrderFilterPanel.this.j.setSelected(false);
                    OrderFilterPanel.this.d();
                    OrderFilterPanel.this.h();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
    }

    private void h() {
        try {
            Date date = this.f.getDate();
            Date date2 = this.g.getDate();
            if (date != null && date2 != null) {
                DateUtil.validateDate(date, date2);
            }
            TerminalConfig.setSwitchboradTicketIdFilter(this.h.getText());
            TerminalConfig.setSwitchboradFromDateFilter(date);
            TerminalConfig.setSwitchboradToDateFilter(date2);
            TerminalConfig.setOrderViewPageSize((Integer)this.i.getSelectedItem());
            this.i();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage(), posException);
        }
    }

    private void i() {
        this.a.updateTicketList();
        this.b.updateButtonStatus();
    }

    private class OrderTypeFilterButton
    extends POSToggleButton
    implements ActionListener {
        public OrderTypeFilterButton(OrderType orderType) {
            String string = TerminalConfig.getOrderTypeFilter();
            if (orderType != null) {
                if (string.equals(orderType.getId())) {
                    this.setSelected(true);
                }
                this.setText(orderType.getName());
                this.setActionCommand(orderType.getId());
            } else {
                if (string.equals(POSConstants.ALL)) {
                    this.setSelected(true);
                }
                this.setText(POSConstants.ALL);
                this.setActionCommand(POSConstants.ALL);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(true);
            String string = actionEvent.getActionCommand();
            TerminalConfig.setOrderTypeFilter(string);
            OrderFilterPanel.this.i();
        }
    }
}

