/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class ComboTicketItemSelectionDialog
extends OkCancelOptionDialog {
    private JPanel a;
    private JPanel b;
    private JPanel c;
    private Map<String, List<MenuItem>> d = new HashMap<String, List<MenuItem>>();
    private MenuItem e;
    private ComboTicketItem f;
    private ComboGroup g;
    private JTable h;
    private PosButton i;
    private PosButton j;
    private PosButton k;
    private PosButton l;
    private PosButton m;
    private TitledBorder n = BorderFactory.createTitledBorder("");

    public ComboTicketItemSelectionDialog(MenuItem menuItem, TicketItem ticketItem) {
        super((Frame)Application.getPosWindow(), true);
        this.f = (ComboTicketItem)ticketItem;
        this.e();
        this.e = menuItem;
        this.a();
        this.d();
    }

    private void a() {
        this.setOkButtonText(POSConstants.DONE);
        this.setCaption(this.e + Messages.getString("ComboTicketItemSelectionDialog.0"));
        this.getContentPanel().setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.a = new JPanel((LayoutManager)new MigLayout("fill"));
        this.b = new JPanel(new WrapLayout(1));
        PosScrollPane posScrollPane = new PosScrollPane(this.b, 20, 31);
        posScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(40, 0));
        posScrollPane.setBorder(null);
        this.n.setTitleJustification(2);
        this.a.setBorder(this.n);
        this.a.add((Component)posScrollPane, "grow,span");
        jPanel.add((Component)this.a, "Center");
        this.getContentPanel().add((Component)jPanel, "Center");
        this.h = new JTable();
        this.h.setRowHeight(40);
        this.h.setModel(new ComboTicketItemTableModel());
        this.h.setTableHeader(null);
        this.h.setDefaultRenderer(Object.class, new MultiLineTableCellRenderer());
        this.h.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TicketItem ticketItem = ComboTicketItemSelectionDialog.this.c();
                boolean bl = ComboTicketItemSelectionDialog.this.a(ticketItem);
                ComboTicketItemSelectionDialog.this.i.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.k.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.l.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.i.setText("...");
                ComboTicketItemSelectionDialog.this.i.setEnabled(bl);
                ComboTicketItemSelectionDialog.this.j.setEnabled(bl);
                if (ticketItem == null) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.m.setEnabled(ticketItem.isHasModifiers());
                double d = ticketItem.getQuantity();
                ComboTicketItemSelectionDialog.this.updateQuantity(d);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.h);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 2, 3), jScrollPane.getBorder()));
        jScrollPane.setPreferredSize(PosUIManager.getSize(250, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(Messages.getString("ComboTicketItemSelectionDialog.4"));
        titledBorder.setTitleJustification(2);
        jPanel2.setBorder(titledBorder);
        jPanel2.add(jScrollPane);
        this.getContentPanel().add((Component)jPanel2, "West");
        int n = PosUIManager.getSize(30);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new MigLayout("fillx,ins 2 0 2 0", "[" + n + "px][grow][" + n + "px]", "[" + n + "]"));
        this.k = new PosButton();
        this.k.addActionListener(actionEvent -> this.j());
        this.i = new PosButton("...");
        this.i.addActionListener(actionEvent -> this.i());
        this.l = new PosButton();
        this.l.addActionListener(actionEvent -> this.h());
        this.j = new PosButton();
        this.j.addActionListener(actionEvent -> this.b());
        Dimension dimension = PosUIManager.getSize(20, 20);
        this.i.setFont(new Font(this.i.getFont().getName(), 1, 20));
        this.j.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png", dimension));
        this.k.setIcon(IconFactory.getIcon("/ui_icons/", "plus_32.png", dimension));
        this.l.setIcon(IconFactory.getIcon("/ui_icons/", "minus_32.png", dimension));
        jPanel3.add(this.l);
        jPanel3.add((Component)this.i, "grow");
        jPanel3.add(this.k);
        jPanel3.add(this.j);
        jPanel2.add((Component)jPanel3, "South");
        this.c = new HorizontalTouchScrollPanel((LayoutManager)new MigLayout("fill, ins 0", "fill, grow", ""));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder titledBorder2 = new TitledBorder(Messages.getString("ComboTicketItemSelectionDialog.15"));
        titledBorder2.setTitleJustification(2);
        jPanel4.setBorder(titledBorder2);
        jPanel4.setPreferredSize(PosUIManager.getSize(0, 100));
        jPanel4.add((Component)((Object)new HorizontalSimpleScrollPane(this.c)), "grow");
        jPanel.add((Component)jPanel4, "North");
        this.m = new PosButton(Messages.getString("ComboTicketItemSelectionDialog.17"));
        this.m.setEnabled(false);
        this.m.addActionListener(actionEvent -> this.k());
        this.getButtonPanel().add((Component)this.m, 0);
    }

    private void b() {
        try {
            TicketItem ticketItem = this.c();
            if (ticketItem == null) {
                return;
            }
            if (!this.a(ticketItem)) {
                return;
            }
            int n = this.h.getSelectedRow();
            if (n == -1) {
                return;
            }
            int n2 = this.h.convertRowIndexToModel(n);
            ((ComboTicketItemTableModel)this.h.getModel()).deleteItem(n2);
            this.i.setText("...");
            this.h.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private boolean a(TicketItem ticketItem) {
        return ticketItem == null || ticketItem.getGroupId() != null;
    }

    private boolean a(TicketItem ticketItem, double d) {
        int n;
        Object object;
        if (ticketItem.getGroupId() == null) {
            return false;
        }
        if (this.e.getComboGroups() != null) {
            object = this.e.getComboGroups().iterator();
            while (object.hasNext()) {
                ComboGroup comboGroup = (ComboGroup)object.next();
                if (!comboGroup.getId().equals(ticketItem.getGroupId())) continue;
                this.b(comboGroup);
                break;
            }
        }
        if ((n = ((ComboTicketItemTableModel)(object = (ComboTicketItemTableModel)this.h.getModel())).getItemCountOfGroup(this.g)) > this.g.getMaxQuantity()) {
            ticketItem.setQuantity(d);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboTicketItemSelectionDialog.18") + this.g.getMaxQuantity());
            return false;
        }
        return true;
    }

    protected void updateQuantity(double d) {
        this.i.setText(NumberUtil.trimDecilamIfNotNeeded(d));
        this.h.repaint();
    }

    private TicketItem c() {
        int n = this.h.getSelectedRow();
        if (n == -1) {
            return null;
        }
        int n2 = this.h.convertRowIndexToModel(n);
        ITicketItem iTicketItem = (ITicketItem)((ComboTicketItemTableModel)this.h.getModel()).getRowData(n2);
        TicketItem ticketItem = null;
        if (iTicketItem instanceof TicketItem) {
            ticketItem = (TicketItem)iTicketItem;
        } else if (iTicketItem instanceof TicketItemModifier) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)iTicketItem;
            ticketItem = ticketItemModifier.getTicketItem();
        }
        return ticketItem;
    }

    public void openModifierDialog(TicketItem ticketItem) {
        try {
            ArrayList arrayList;
            Ticket ticket = ticketItem.getTicket();
            MenuItem menuItem = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize(menuItem);
            List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
            if (list == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            if (menuItem.isVariant().booleanValue()) {
                MenuItemDAO.getInstance().initialize(menuItem.getParentMenuItem());
                OrderController.loadVariantData(menuItem);
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void d() {
        try {
            Serializable serializable;
            Object object;
            List<TicketItem> list = this.f.getComboItems();
            ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    serializable = object.next();
                    comboTicketItemTableModel.addItem((ITicketItem)((Object)serializable));
                }
            }
            if (this.e.isVariant().booleanValue()) {
                this.e = this.e.getParentMenuItem();
                MenuItemDAO.getInstance().initialize(this.e);
            }
            if ((object = this.e.getComboGroups()) != null) {
                serializable = PosUIManager.getSize(115, 60);
                ButtonGroup buttonGroup = new ButtonGroup();
                boolean bl = true;
                Object object2 = object.iterator();
                while (object2.hasNext()) {
                    ComboGroup comboGroup = (ComboGroup)object2.next();
                    ComboGroupButton comboGroupButton = new ComboGroupButton(comboGroup);
                    comboGroupButton.setSelected(bl);
                    comboGroupButton.setPreferredSize((Dimension)serializable);
                    this.c.add(comboGroupButton);
                    this.c.putClientProperty(comboGroup.getId(), comboGroupButton);
                    List<MenuItem> list2 = comboGroup.getItems();
                    if (list2 != null) {
                        this.d.put(comboGroup.getId(), list2);
                    }
                    buttonGroup.add(comboGroupButton);
                    bl = false;
                }
                if (object != null && object.size() > 0) {
                    this.g = (ComboGroup)object.get(0);
                    this.a(this.g);
                    object2 = this.g.getName() + Messages.getString("ComboTicketItemSelectionDialog.19") + this.g.getMinQuantity() + Messages.getString("ComboTicketItemSelectionDialog.20") + this.g.getMaxQuantity();
                    this.n.setTitle((String)object2);
                } else {
                    this.n.setTitle("");
                }
            }
            comboTicketItemTableModel.fireTableDataChanged();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ComboGroup comboGroup) {
        try {
            this.b.removeAll();
            if (comboGroup == null) {
                return;
            }
            List<MenuItem> list = this.d.get(comboGroup.getId());
            if (list != null) {
                for (MenuItem menuItem : list) {
                    if (menuItem.isDeleted().booleanValue()) continue;
                    MenuItemButton menuItemButton = new MenuItemButton(menuItem);
                    menuItemButton.setPreferredSize(PosUIManager.getSize(120, 100));
                    menuItemButton.setEnabled(menuItem.isEnable());
                    this.b.add(menuItemButton);
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getLocalizedMessage(), posException);
        }
        finally {
            this.a.revalidate();
            this.a.repaint();
        }
    }

    @Override
    public void setCanceled(boolean bl) {
        this.restoreComboItemsQuantity();
        super.setCanceled(bl);
    }

    @Override
    public void doOk() {
        Object object;
        Object object2;
        if (!this.f()) {
            return;
        }
        List<TicketItem> list = this.f.getComboItems();
        double d = 0.0;
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TicketItem)object2.next();
                if (((BaseTicketItem)object).getGroupId() == null) {
                    d += ((BaseTicketItem)object).getUnitCost().doubleValue();
                    continue;
                }
                object2.remove();
            }
        }
        if ((object2 = ((ComboTicketItemTableModel)this.h.getModel()).getRows()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                ITicketItem iTicketItem = (ITicketItem)object.next();
                if (iTicketItem instanceof TicketItemModifier) continue;
                TicketItem ticketItem = (TicketItem)iTicketItem;
                if (list != null && list.contains(ticketItem)) continue;
                ticketItem.setComboChild(true);
                ticketItem.setParentTicketItem(this.f);
                ticketItem.setTicket(null);
                d += ticketItem.getUnitCost() * ticketItem.getQuantity();
                this.f.addTocomboItems(ticketItem);
            }
        }
        this.f.setUnitCost(d);
        this.setCanceled(false);
        this.dispose();
    }

    public void restoreComboItemsQuantity() {
        if (this.f.getQuantity() > 1.0 && this.f.getComboItems() != null && this.f.getComboItems().size() > 0) {
            for (TicketItem ticketItem : this.f.getComboItems()) {
                ticketItem.setQuantity(ticketItem.getQuantity() * this.f.getQuantity());
            }
        }
    }

    private void e() {
        if (this.f.getQuantity() > 1.0 && this.f.getComboItems() != null && this.f.getComboItems().size() > 0) {
            for (TicketItem ticketItem : this.f.getComboItems()) {
                ticketItem.setQuantity(ticketItem.getQuantity() / this.f.getQuantity());
            }
        }
    }

    public List<TicketItem> addedItems() {
        ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
        return comboTicketItemTableModel.getTicketItems();
    }

    private boolean f() {
        List<ComboGroup> list = this.e.getComboGroups();
        if (list == null) {
            return true;
        }
        ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
        for (ComboGroup comboGroup : list) {
            int n = comboTicketItemTableModel.getItemCountOfGroup(comboGroup);
            if (n >= comboGroup.getMinQuantity()) continue;
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboTicketItemSelectionDialog.22") + comboGroup.getMinQuantity() + Messages.getString("ComboTicketItemSelectionDialog.23") + comboGroup.getName());
            this.b(comboGroup);
            return false;
        }
        return true;
    }

    private void b(ComboGroup comboGroup) {
        Object object = this.c.getClientProperty(comboGroup.getId());
        if (object instanceof ComboGroupButton) {
            ComboGroupButton comboGroupButton = (ComboGroupButton)object;
            comboGroupButton.setSelected(true);
            this.c.revalidate();
            this.c.repaint();
        }
        this.g = comboGroup;
        this.a(comboGroup);
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    public Collection<TicketItem> getSelectedMenuItems() {
        ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
        return comboTicketItemTableModel.getTicketItems();
    }

    public boolean addComboItem(MenuItem menuItem) {
        TicketItem ticketItem;
        boolean bl;
        boolean bl2;
        OrderController orderController;
        if (menuItem.isVariant().booleanValue() && menuItem.getParentMenuItem() != null) {
            MenuItemDAO.getInstance().initialize(menuItem.getParentMenuItem());
        }
        if (!(orderController = OrderView.getInstance().getOrderController()).hasAvailableStock(menuItem, 1.0)) {
            return false;
        }
        ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
        double d = 1.0;
        if (this.e.isEnableComboQuantitySelection()) {
            double d2 = this.a(menuItem);
            if (Double.isNaN(d2)) {
                return false;
            }
            if (d2 + (double)comboTicketItemTableModel.getItemCountOfGroup(this.g) > (double)this.g.getMaxQuantity().intValue()) {
                POSMessageDialog.showMessage(Messages.getString("ComboTicketItemSelectionDialog.24") + this.g.getMaxQuantity());
                return false;
            }
            d = d2;
        }
        boolean bl3 = bl2 = (bl = this.a(ticketItem = comboTicketItemTableModel.getLastTicketItem())) && menuItem.isPizzaType() == false && !menuItem.hasModifiers();
        if (ticketItem != null && bl2 && ticketItem.getMenuItem().getId().equals(menuItem.getId())) {
            ticketItem.setQuantity(ticketItem.getQuantity() + d);
            comboTicketItemTableModel.fireTableDataChanged();
            return true;
        }
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        TicketItem ticketItem2 = menuItem.convertToTicketItem(ticket, d, false, null, false);
        ticketItem2.setMenuItem(menuItem);
        ticketItem2.setTicket(ticket);
        ticketItem2.setMenuItemId(menuItem.getId());
        ticketItem2.setGroupId(this.g.getId());
        ticketItem2.setName(menuItem.getDisplayName());
        ticketItem2.setQuantity(d);
        OrderController.loadVariantData(menuItem);
        if (menuItem.isPizzaType().booleanValue()) {
            PizzaModifierSelectionDialog pizzaModifierSelectionDialog = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem, false);
            pizzaModifierSelectionDialog.setAllowCreateMultiPizza(false);
            pizzaModifierSelectionDialog.openFullScreen();
            if (pizzaModifierSelectionDialog.isCanceled()) {
                return false;
            }
        } else if (menuItem.hasMandatoryModifiers()) {
            ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem));
            modifierSelectionDialog.open();
            if (modifierSelectionDialog.isCanceled()) {
                return false;
            }
        }
        comboTicketItemTableModel.addItem(ticketItem2);
        return true;
    }

    private boolean g() {
        ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
        int n = comboTicketItemTableModel.getItemCountOfGroup(this.g);
        return n < this.g.getMaxQuantity();
    }

    private double a(MenuItem menuItem) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
        numberSelectionDialog2.setTitle(Messages.getString("ComboTicketItemSelectionDialog.12"));
        numberSelectionDialog2.setFloatingPoint(false);
        numberSelectionDialog2.setValue(1.0);
        numberSelectionDialog2.setAllowNegativeInput(false);
        numberSelectionDialog2.setAllowZeroInput(false);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return Double.NaN;
        }
        double d = (int)numberSelectionDialog2.getValue();
        return d;
    }

    private void h() {
        try {
            TicketItem ticketItem = this.c();
            if (ticketItem == null) {
                return;
            }
            if (!this.a(ticketItem)) {
                return;
            }
            double d = ticketItem.getQuantity();
            if (d == 1.0) {
                return;
            }
            ticketItem.setQuantity(d - 1.0);
            if (!this.a(ticketItem, d)) {
                return;
            }
            this.updateQuantity(ticketItem.getQuantity());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void i() {
        try {
            TicketItem ticketItem = this.c();
            if (ticketItem == null) {
                return;
            }
            if (!this.a(ticketItem)) {
                return;
            }
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("ComboTicketItemSelectionDialog.12"));
            numberSelectionDialog2.setFloatingPoint(false);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            double d = (int)numberSelectionDialog2.getValue();
            if (d <= 0.0) {
                return;
            }
            double d2 = ticketItem.getQuantity();
            ticketItem.setQuantity(d);
            if (!this.a(ticketItem, d2)) {
                return;
            }
            this.updateQuantity(ticketItem.getQuantity());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void j() {
        try {
            TicketItem ticketItem = this.c();
            if (ticketItem == null) {
                return;
            }
            if (!this.a(ticketItem)) {
                return;
            }
            double d = ticketItem.getQuantity();
            ticketItem.setQuantity(d + 1.0);
            if (!this.a(ticketItem, d)) {
                return;
            }
            this.updateQuantity(ticketItem.getQuantity());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void k() {
        try {
            TicketItem ticketItem = this.c();
            if (ticketItem == null) {
                return;
            }
            ComboTicketItemTableModel comboTicketItemTableModel = (ComboTicketItemTableModel)this.h.getModel();
            ticketItem.setTicket(OrderView.getInstance().getCurrentTicket());
            if (ticketItem instanceof ModifiableTicketItem || ticketItem.isPizzaType().booleanValue()) {
                this.openModifierDialog(ticketItem);
                ticketItem.setTicket(null);
                comboTicketItemTableModel.getRows().set(this.h.getSelectedRow(), ticketItem);
                comboTicketItemTableModel.fireTableDataChanged();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public class ComboTicketItemTableModel
    extends ListTableModel<ITicketItem> {
        public ComboTicketItemTableModel() {
            super(new String[]{Messages.getString("ComboTicketItemSelectionDialog.27")});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ITicketItem iTicketItem = (ITicketItem)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return this.a(iTicketItem);
                }
            }
            return null;
        }

        @Override
        public void addItem(ITicketItem iTicketItem) {
            super.addItem(iTicketItem);
        }

        @Override
        public void deleteItem(int n) {
            super.deleteItem(n);
        }

        private String a(ITicketItem iTicketItem) {
            String string = "";
            String string2 = iTicketItem.getNameDisplay();
            if (iTicketItem instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
                if (ticketItem.isHasModifiers().booleanValue() && list != null) {
                    for (TicketItemModifier ticketItemModifier : list) {
                        string = string + "\n" + ticketItemModifier.getNameDisplay();
                    }
                }
                if (StringUtils.isNotBlank((String)string)) {
                    string2 = string2 + string;
                }
            }
            return string2;
        }

        public List<TicketItem> getTicketItems() {
            ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
            List list = this.getRows();
            for (ITicketItem iTicketItem : list) {
                if (iTicketItem instanceof TicketItemModifier) continue;
                TicketItem ticketItem = (TicketItem)iTicketItem;
                arrayList.add(ticketItem);
            }
            return arrayList;
        }

        public TicketItem getLastTicketItem() {
            int n;
            ITicketItem iTicketItem;
            List list = this.getRows();
            if (list != null && list.size() != 0 && (iTicketItem = (ITicketItem)list.get(n = list.size() - 1)) instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                return ticketItem;
            }
            return null;
        }

        public int getItemCountOfGroup(ComboGroup comboGroup) {
            int n = 0;
            List list = this.getRows();
            if (list != null && list.size() != 0) {
                for (ITicketItem iTicketItem : list) {
                    if (iTicketItem instanceof TicketItemModifier) continue;
                    TicketItem ticketItem = (TicketItem)iTicketItem;
                    String string = comboGroup.getId();
                    String string2 = ticketItem.getGroupId();
                    if (string == null || string2 == null || !string.equals(string2)) continue;
                    n = (int)((double)n + ticketItem.getQuantity());
                }
            }
            return n;
        }
    }

    private class ComboGroupButton
    extends POSToggleButton
    implements ActionListener {
        ComboGroup a;

        ComboGroupButton(ComboGroup comboGroup) {
            this.a = comboGroup;
            this.setText("<html><body><center>" + comboGroup.getName() + "</center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.a.getName() + Messages.getString("ComboTicketItemSelectionDialog.25") + this.a.getMinQuantity() + Messages.getString("ComboTicketItemSelectionDialog.26") + this.a.getMaxQuantity();
            ComboTicketItemSelectionDialog.this.n.setTitle(string);
            ComboTicketItemSelectionDialog.this.a(this.a);
            ComboTicketItemSelectionDialog.this.g = this.a;
        }
    }

    private class MenuItemButton
    extends PosButton
    implements ActionListener {
        private int e = PosUIManager.getSize(100);
        private int f = PosUIManager.getSize(120);
        MenuItem a;

        MenuItemButton(MenuItem menuItem) {
            Color color;
            this.a = menuItem;
            this.setFocusable(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            ImageIcon imageIcon = menuItem.getImage();
            if (imageIcon != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
            }
            Color color2 = menuItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.addActionListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width < this.f) {
                dimension.width = this.f;
            }
            if (dimension.height < this.e) {
                dimension.height = this.e;
            }
            return dimension;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ComboTicketItemSelectionDialog.this.g()) {
                POSMessageDialog.showMessage(Messages.getString("ComboTicketItemSelectionDialog.24") + ComboTicketItemSelectionDialog.this.g.getMaxQuantity());
                return;
            }
            try (Session session = MenuItemDAO.getInstance().createNewSession();){
                session.refresh((Object)this.a);
                if (!ComboTicketItemSelectionDialog.this.addComboItem(this.a)) {
                    return;
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage(), exception);
            }
        }
    }
}

