/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ServiceDataInputDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXDatePicker;

public class MembershipDataInputDialog
extends ServiceDataInputDialog {
    private POSTextField a = new POSTextField();
    private JXDatePicker b;
    private MenuItem c;
    private Customer d;
    private PosButton e;

    public MembershipDataInputDialog(Ticket ticket, MenuItem menuItem) {
        this.c = menuItem;
        this.d = ticket.getCustomer();
        this.a();
        this.b();
    }

    private void a() {
        this.setTitle(Messages.getString("ActivationOrRenewalMembership"));
        this.setCaption(this.c.getDisplayName());
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(PosUIManager.getSize(780, 350));
        this.e = new PosButton(Messages.getString("Generate"));
        this.e.addActionListener(actionEvent -> this.c());
        this.b = UiUtil.getDeafultDate();
        Date date = new Date();
        this.b.setDate(date);
        this.b.getMonthView().setLowerBound(date);
        this.a.setColumns(10);
        this.a.setFont(this.a.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.b.setFont(this.a.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        JLabel jLabel = new JLabel(Messages.getString("ActivationDate"));
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.22"));
        jLabel.setFont(jLabel.getFont().deriveFont(0, PosUIManager.getTitleFontSize()));
        jLabel2.setFont(jLabel2.getFont().deriveFont(0, PosUIManager.getTitleFontSize()));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3,ins 5 5 20 5", "[]10[]", ""));
        jPanel2.add((Component)jLabel2, "trailing,right");
        jPanel2.add((Component)this.a, "split 2,grow");
        jPanel2.add(this.e);
        jPanel2.add((Component)jLabel, "newline,trailing,right");
        jPanel2.add((Component)this.b, "h 40!,grow");
        jPanel.add((Component)jPanel2, "Center");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        jPanel.add((Component)((Object)qwertyKeyPad), "South");
    }

    private void b() {
        if (this.d != null && StringUtils.isNotBlank((String)this.d.getMemberId())) {
            this.a.setEnabled(false);
            this.a.setText(this.d.getMemberId());
            this.e.setVisible(false);
        }
    }

    private void c() {
        this.a.setText(this.d());
    }

    private String d() {
        String string = RandomStringUtils.randomNumeric((int)8);
        if (CustomerDAO.getInstance().findByMemberId(string, true) == null) {
            return string;
        }
        return this.d();
    }

    @Override
    public Date getServiceStartTime() {
        return DateUtil.startOfDay(this.b.getDate());
    }

    @Override
    public Date getServiceEndTime() {
        return this.c.getPaymentType().calculateEndDate(this.getServiceStartTime());
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    @Override
    public void doOk() {
        try {
            String string = this.a.getText();
            if (StringUtils.isBlank((String)string)) {
                throw new PosException(Messages.getString("PleaseEnterMemberId"));
            }
            if (this.b.getDate() == null) {
                throw new PosException(Messages.getString("SelectActivationDate"));
            }
            string = string.trim();
            if (StringUtils.isBlank((String)this.d.getMemberId())) {
                if (CustomerDAO.getInstance().findByMemberId(string, true) != null) {
                    throw new PosException(Messages.getString("MemberIdAlreadyExists"));
                }
                this.d.setMemberId(this.getMemberId());
                CustomerDAO.getInstance().update(this.d);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), new RefreshableView(){

                @Override
                public void refresh() {
                    CustomerDAO.getInstance().refresh(MembershipDataInputDialog.this.d);
                    MembershipDataInputDialog.this.b();
                }
            });
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public String getMemberId() {
        return this.a.getText().trim();
    }
}

