/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.base.BaseModifierMultiplierPrice;
import com.floreantpos.model.base.BaseMultiplier;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.ui.views.order.multipart.PizzaPriceTableModel;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PizzaModifierForm
extends BeanEditor {
    private MenuModifier a;
    private JCheckBox b;
    private JComboBox c;
    private JFormattedTextField d;
    private FixedLengthTextField e;
    private IntegerTextField f;
    private JButton g;
    private JButton h;
    private JTable i;
    private JTabbedPane j;
    private JTable k;
    private PizzaPriceTableModel l;
    private JCheckBox m;
    private JCheckBox n;
    private JRadioButton o;
    private JRadioButton p;
    private JLabel q;
    private JButton r;

    public PizzaModifierForm() throws Exception {
        this(new MenuModifier());
    }

    public PizzaModifierForm(MenuModifier menuModifier) throws Exception {
        this.a = menuModifier;
        MenuModifierDAO.getInstance().initialize(menuModifier);
        this.b();
        this.a();
        this.initData();
        this.setBean(menuModifier);
    }

    public void initData() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        TaxGroupDAO taxGroupDAO = new TaxGroupDAO();
        List<TaxGroup> list = taxGroupDAO.findAll();
        for (TaxGroup taxGroup : list) {
            comboBoxModel.addElement(taxGroup);
        }
        this.c.setModel(comboBoxModel);
    }

    private void a() {
        this.setLayout(new BorderLayout(0, 0));
        this.j = new JTabbedPane();
        this.d = new JFormattedTextField();
        this.e = new FixedLengthTextField();
        this.f = new IntegerTextField();
        this.c = new JComboBox();
        this.c.setVisible(Boolean.FALSE);
        this.r = new JButton();
        this.r.setVisible(Boolean.FALSE);
        this.b = new JCheckBox();
        this.n = new JCheckBox();
        JScrollPane jScrollPane = new JScrollPane();
        this.i = new JTable();
        JLabel jLabel = new JLabel(POSConstants.NAME + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("MenuModifierForm.0"));
        JLabel jLabel3 = new JLabel(Messages.getString("MenuModifierForm.15"));
        this.r.setText("...");
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierForm.this.a(actionEvent);
            }
        });
        this.b.setText(POSConstants.PRINT_TO_KITCHEN);
        this.b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.b.setMargin(new Insets(0, 0, 0, 0));
        this.n.setText(Messages.getString("PizzaModifierForm.3"));
        this.n.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.n.setMargin(new Insets(0, 0, 0, 0));
        this.m = new JCheckBox(Messages.getString("PizzaModifierForm.4"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.j.addTab(POSConstants.GENERAL, jPanel);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fill", "[60%][40%]", ""));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[90px][grow]", ""));
        transparentPanel2.add((Component)jLabel, "alignx left,aligny center");
        transparentPanel2.add((Component)this.d, "growx,aligny top");
        transparentPanel2.add((Component)jLabel2, "alignx left,aligny center");
        transparentPanel2.add((Component)this.e, "growx");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[90px][grow]", ""));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[200px][grow]"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(POSConstants.TAX));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.o = new JRadioButton(Messages.getString("MenuModifierForm.777"));
        this.p = new JRadioButton(Messages.getString("MenuModifierForm.888"));
        this.p.addItemListener(itemEvent -> this.a(itemEvent));
        buttonGroup.add(this.o);
        buttonGroup.add(this.p);
        this.q = new JLabel(Messages.getString("MenuModifierForm.13") + ":");
        this.q.setVisible(Boolean.FALSE);
        jPanel3.add((Component)this.o, "alignx left,aligny center,wrap");
        jPanel3.add((Component)this.p, "alignx left,aligny center,wrap");
        jPanel3.add((Component)this.q, "alignx left,aligny top,split 2");
        jPanel3.add((Component)this.c, "growx,aligny top,split 2,width 100!");
        jPanel3.add((Component)this.r, "alignx left,aligny top");
        jPanel2.add(jPanel3);
        jPanel2.add((Component)jLabel3, "newline,alignx left,aligny center,split 2");
        jPanel2.add((Component)this.f, "alignx left,growx,aligny top,width 150!");
        jPanel2.add((Component)this.b, "skip 1,alignx left,aligny top");
        jPanel2.add((Component)this.n, "skip 1");
        transparentPanel.add((Component)transparentPanel2, "grow");
        transparentPanel.add((Component)jPanel2, "grow");
        jPanel.add((Component)transparentPanel, "North");
        JLabel jLabel4 = new JLabel(Messages.getString("MenuModifierForm.1"));
        this.g = new JButton("");
        this.g.setPreferredSize(new Dimension(140, 40));
        JLabel jLabel5 = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.h = new JButton(Messages.getString("MenuModifierForm.29"));
        this.h.setPreferredSize(new Dimension(140, 40));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2"));
        jPanel4.add(jLabel4);
        jPanel4.add(this.g);
        jPanel4.add(jLabel5);
        jPanel4.add(this.h);
        this.j.addTab("Button Style", jPanel4);
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PizzaModifierForm.this, Messages.getString("MenuModifierForm.39"), PizzaModifierForm.this.g.getBackground());
                PizzaModifierForm.this.g.setBackground(color);
                PizzaModifierForm.this.h.setBackground(color);
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PizzaModifierForm.this, Messages.getString("MenuModifierForm.40"), PizzaModifierForm.this.h.getForeground());
                PizzaModifierForm.this.h.setForeground(color);
            }
        });
        this.i.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane.setViewportView(this.i);
        this.a(jPanel);
        this.add(this.j);
    }

    private void b() {
        Multiplier multiplier = MultiplierDAO.getInstance().get("Regular");
        if (multiplier != null && multiplier.isMain().booleanValue()) {
            return;
        }
        if (multiplier == null) {
            multiplier = new Multiplier("Regular");
            multiplier.setRate(0.0);
            multiplier.setSortOrder(0);
            multiplier.setTicketPrefix("");
            multiplier.setDefaultMultiplier(true);
            multiplier.setMain(true);
            MultiplierDAO.getInstance().save(multiplier);
        } else {
            multiplier.setMain(true);
            MultiplierDAO.getInstance().update(multiplier);
        }
    }

    private void a(JPanel jPanel) {
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("right,ins 5 0 0 0"));
        JButton jButton = new JButton(Messages.getString("MenuModifierForm.41"));
        jButton.addActionListener(actionEvent -> this.c());
        JButton jButton2 = new JButton(Messages.getString("PizzaModifierForm.2"));
        jButton2.addActionListener(actionEvent -> this.d());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        List<PizzaModifierPrice> list = this.a.getPizzaModifierPriceList();
        list = this.a(list);
        this.k = new JTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                PizzaModifierForm.this.k.editCellAt(n, n2);
                PizzaModifierForm.this.k.transferFocus();
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)PizzaModifierForm.this.k.getCellEditor(n, n2);
                if (n2 != 0) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                }
            }
        };
        this.k.setRowHeight(PosUIManager.getSize(22));
        this.k.setCellSelectionEnabled(true);
        this.k.setSelectionMode(0);
        this.k.setSurrendersFocusOnKeystroke(true);
        this.l = new PizzaPriceTableModel(list, MultiplierDAO.getInstance().findAll());
        this.k.setModel(this.l);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.k);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setPreferredSize(PosUIManager.getSize(600, 250));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add((Component)jPanel2, "South");
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel.add(jPanel3);
        DoubleTextField doubleTextField = new DoubleTextField(10);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.k.setDefaultEditor(this.k.getColumnClass(1), defaultCellEditor);
        DecimalFormatRenderer decimalFormatRenderer = new DecimalFormatRenderer();
        decimalFormatRenderer.setHorizontalAlignment(4);
        this.k.setDefaultRenderer(this.k.getColumnClass(1), decimalFormatRenderer);
    }

    private void c() {
        if (this.k.getCellEditor() != null) {
            this.k.getCellEditor().stopCellEditing();
        }
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        List<PizzaModifierPrice> list2 = this.l.getRows(this.a);
        if (list2 != null) {
            for (PizzaModifierPrice pizzaModifierPrice : list2) {
                Comparable comparable;
                List<ModifierMultiplierPrice> list3 = pizzaModifierPrice.getMultiplierPriceList();
                if (list3 == null) continue;
                Double d = 0.0;
                for (ModifierMultiplierPrice modifierMultiplierPrice : list3) {
                    comparable = modifierMultiplierPrice.getMultiplier();
                    if (!((BaseMultiplier)comparable).isDefaultMultiplier().booleanValue()) continue;
                    d = modifierMultiplierPrice.getPrice() * 100.0 / ((BaseMultiplier)comparable).getRate();
                    break;
                }
                for (Multiplier multiplier : list) {
                    comparable = this.a(list3, multiplier);
                    if (comparable != null) {
                        ((BaseModifierMultiplierPrice)comparable).setPrice(d * multiplier.getRate() / 100.0);
                        continue;
                    }
                    ModifierMultiplierPrice modifierMultiplierPrice = new ModifierMultiplierPrice();
                    modifierMultiplierPrice.setMultiplier(multiplier);
                    modifierMultiplierPrice.setPrice(d * multiplier.getRate() / 100.0);
                    list3.add(modifierMultiplierPrice);
                }
            }
        }
        this.l.setPriceList(list2, list);
        this.l.fireTableDataChanged();
    }

    private ModifierMultiplierPrice a(List<ModifierMultiplierPrice> list, Multiplier multiplier) {
        for (ModifierMultiplierPrice modifierMultiplierPrice : list) {
            if (!multiplier.equals(modifierMultiplierPrice.getMultiplier())) continue;
            return modifierMultiplierPrice;
        }
        return null;
    }

    private void d() {
        if (this.k.getCellEditor() != null) {
            this.k.getCellEditor().stopCellEditing();
        }
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        List<PizzaModifierPrice> list2 = this.l.getRows(this.a);
        if (list2 != null) {
            for (PizzaModifierPrice pizzaModifierPrice : list2) {
                List<ModifierMultiplierPrice> list3 = pizzaModifierPrice.getMultiplierPriceList();
                if (list3 == null) continue;
                Iterator<ModifierMultiplierPrice> iterator = list3.iterator();
                while (iterator.hasNext()) {
                    ModifierMultiplierPrice modifierMultiplierPrice = iterator.next();
                    if (modifierMultiplierPrice.getMultiplier().isDefaultMultiplier().booleanValue()) continue;
                    iterator.remove();
                }
            }
        }
        this.l.setPriceList(list2, list);
        this.l.fireTableDataChanged();
    }

    private List<PizzaModifierPrice> a(List<PizzaModifierPrice> list) {
        List<MenuItemSize> list2 = MenuItemSizeDAO.getInstance().findAll();
        ArrayList<MenuItemSize> arrayList = new ArrayList<MenuItemSize>();
        if (list == null || list.isEmpty()) {
            list = new ArrayList<PizzaModifierPrice>();
            for (int i = 0; i < list2.size(); ++i) {
                PizzaModifierPrice pizzaModifierPrice = new PizzaModifierPrice();
                pizzaModifierPrice.setSize(list2.get(i));
                pizzaModifierPrice.setPrice(0.0);
                pizzaModifierPrice.setExtraPrice(0.0);
                list.add(pizzaModifierPrice);
            }
            return list;
        }
        for (PizzaModifierPrice pizzaModifierPrice : list) {
            arrayList.add(pizzaModifierPrice.getSize());
        }
        list2.removeAll(arrayList);
        for (int i = 0; i < list2.size(); ++i) {
            PizzaModifierPrice pizzaModifierPrice;
            pizzaModifierPrice = new PizzaModifierPrice();
            pizzaModifierPrice.setSize(list2.get(i));
            pizzaModifierPrice.setPrice(0.0);
            pizzaModifierPrice.setExtraPrice(0.0);
            list.add(pizzaModifierPrice);
        }
        return list;
    }

    private void a(ActionEvent actionEvent) {
        try {
            TaxForm taxForm = new TaxForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.c.getModel();
            comboBoxModel.setDataList(TaxGroupDAO.getInstance().findAll());
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuModifier menuModifier = (MenuModifier)this.getBean();
            MenuModifierDAO.getInstance().saveMenuModifierFormData(menuModifier);
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.SAVE_ERROR, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        boolean bl;
        Color color;
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier == null) {
            this.d.setText("");
            return;
        }
        this.d.setText(menuModifier.getName());
        this.e.setText(menuModifier.getTranslatedName());
        this.b.setSelected(menuModifier.isShouldPrintToKitchen());
        this.n.setSelected(menuModifier.isShouldSectionWisePrice());
        this.m.setSelected(menuModifier.isFixedPrice());
        if (menuModifier.getSortOrder() != null) {
            this.f.setText(menuModifier.getSortOrder().toString());
        }
        if (menuModifier.getButtonColor() != null) {
            color = new Color(menuModifier.getButtonColor());
            this.g.setBackground(color);
            this.h.setBackground(color);
        }
        if (menuModifier.getTextColor() != null) {
            color = new Color(menuModifier.getTextColor());
            this.h.setForeground(color);
        }
        if ((bl = POSUtil.getBoolean(menuModifier.getProperty("tax.same.as.item"))) || menuModifier.getId() == null) {
            this.o.setSelected(true);
        } else {
            this.p.setSelected(true);
        }
        if (menuModifier.getTaxGroup() != null) {
            this.c.setSelectedItem(menuModifier.getTaxGroup());
        }
    }

    @Override
    protected boolean updateModel() {
        Object object;
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        String string = this.d.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        menuModifier.setName(string.trim());
        if (this.o.isSelected()) {
            menuModifier.addProperty("tax.same.as.item", String.valueOf(Boolean.TRUE));
            menuModifier.setTaxGroup(null);
            menuModifier.setTaxable(true);
        } else {
            menuModifier.addProperty("tax.same.as.item", String.valueOf(Boolean.FALSE));
            object = (TaxGroup)this.c.getSelectedItem();
            menuModifier.setTaxGroup((TaxGroup)object);
            menuModifier.setTaxable(object != null);
        }
        menuModifier.setShouldPrintToKitchen(this.b.isSelected());
        menuModifier.setShouldSectionWisePrice(this.n.isSelected());
        menuModifier.setTranslatedName(this.e.getText());
        menuModifier.setButtonColor(this.g.getBackground().getRGB());
        menuModifier.setTextColor(this.h.getForeground().getRGB());
        menuModifier.setSortOrder(this.f.getInteger());
        menuModifier.setFixedPrice(this.m.isSelected());
        menuModifier.setMultiplierPriceList(null);
        menuModifier.setPizzaModifier(true);
        this.e();
        object = this.l.getRows(menuModifier);
        menuModifier.setPizzaModifierPriceList((List<PizzaModifierPrice>)object);
        return true;
    }

    private void a(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.q.setVisible(Boolean.TRUE);
            this.c.setVisible(Boolean.TRUE);
            this.r.setVisible(Boolean.TRUE);
        } else {
            this.q.setVisible(Boolean.FALSE);
            this.c.setVisible(Boolean.FALSE);
            this.r.setVisible(Boolean.FALSE);
        }
    }

    private void e() {
        try {
            if (!this.k.isEditing()) {
                return;
            }
            this.k.editingStopped(null);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @Override
    public String getDisplayText() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier.getId() == null) {
            return Messages.getString("MenuModifierForm.45");
        }
        return Messages.getString("MenuModifierForm.46");
    }

    public static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof BigDecimal) {
                object = NumberUtil.formatAmount((BigDecimal)object);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

