/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceTableItemSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PriceTableForm
extends BeanEditor<PriceTable> {
    private PriceTableItemSelectionView c;
    private FixedLengthTextField d = new FixedLengthTextField();
    private JTextArea e = new JTextArea();
    private boolean f;
    List<PriceTableItem> a = new ArrayList<PriceTableItem>();
    List<PriceTableItem> b = new ArrayList<PriceTableItem>();

    public PriceTableForm(PriceTable priceTable) {
        this(priceTable, false);
    }

    public PriceTableForm(PriceTable priceTable, boolean bl) {
        this.f = bl;
        this.setBean(priceTable);
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        this.d.setLength(30);
        jPanel.add(new JLabel(Messages.getString("NAME")));
        jPanel.add((Component)this.d, "growx,wrap");
        PriceTable priceTable = (PriceTable)this.getBean();
        this.e.setLineWrap(true);
        this.e.setDocument(new FixedLengthDocument(255));
        this.e.setText(priceTable.getDescription());
        jPanel.add((Component)new JLabel(Messages.getString("PriceTableForm.6")), "growx,aligny top");
        JScrollPane jScrollPane = new JScrollPane(this.e);
        jPanel.add((Component)jScrollPane, "growx,h 70!,top,wrap");
        this.add((Component)jPanel, "North");
        this.c = new PriceTableItemSelectionView(this.a, this.f);
        this.c.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("PriceTableForm.0"), 1, 2));
        this.add((Component)this.c, "Center");
    }

    private void b() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.a = PriceTableItemDAO.getInstance().getItemsByPriceTable(priceTable);
    }

    @Override
    public boolean save() {
        try {
            if (this.f) {
                return true;
            }
            if (!this.updateModel()) {
                return false;
            }
            PriceTable priceTable = (PriceTable)this.getBean();
            List<PriceTableItem> list = this.c.getSelectedMenuItemList();
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, list);
            Collection collection = CollectionUtils.subtract(this.a, list);
            for (PriceTableItem priceTableItem : collection) {
                PriceTableItemDAO.getInstance().delete(priceTableItem);
            }
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), illegalModelStateException.getMessage());
        }
        return false;
    }

    @Override
    protected void updateView() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.d.setText(priceTable.getName());
        this.e.setText(priceTable.getDescription());
        if (priceTable.getId() == null) {
            return;
        }
        this.b();
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PriceTable priceTable = (PriceTable)this.getBean();
        String string = this.d.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PriceTableForm.28"));
            return false;
        }
        string = string.trim();
        GenericDAO.getInstance().checkIdOrNameExists(priceTable.getId(), string, PriceTable.class);
        priceTable.setName(string);
        priceTable.setDescription(this.e.getText());
        priceTable.setLastUpdateTime(new Date());
        priceTable.setLastUpdatedBy(Application.getCurrentUser().getId());
        priceTable.setOutletId(DataProvider.get().getCurrentOutletId());
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.f) {
            return Messages.getString("PriceTableForm.29");
        }
        if (((PriceTable)this.getBean()).getId() == null) {
            return Messages.getString("PriceTableForm.30");
        }
        return Messages.getString("PriceTableForm.31");
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.f = !bl;
        if (this.f) {
            this.e.setEditable(false);
            this.d.setEditable(false);
        }
    }
}

