/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.POSConstants;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.model.Course;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.CourseOrganizeTableView;
import com.floreantpos.ui.order.TableDataTransferHandler;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class CourseOrganizeDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private final TableDataTransferHandler a = new TableDataTransferHandler();
    private JPanel b;
    private long c;
    private Ticket d;

    public CourseOrganizeDialog(Ticket ticket) {
        this.c = ticket.getVersion();
        this.d = ticket;
        this.c = ticket.getVersion();
        this.setDefaultCloseOperation(2);
        this.setCaption(POSConstants.ORGANIZE_COURSE);
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.b = new JPanel();
        this.a(ticket);
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.b);
        PosButton posButton = new PosButton(POSConstants.SEND_TO_KITCHEN + " " + POSConstants.ALL);
        posButton.addActionListener(actionEvent -> this.a());
        this.getButtonPanel().add((Component)posButton, 0);
    }

    private void a(Ticket ticket) {
        Object object;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        List<Course> list = DataProvider.get().getCourses();
        int n = list.size();
        if (list != null && n > 0) {
            Collections.sort(list, new Comparator<Course>(){

                @Override
                public int compare(Course course, Course course2) {
                    return course.getSortOrder().compareTo(course2.getSortOrder());
                }
            });
            for (Course object2 : list) {
                linkedHashMap.put(object2.getId(), new ArrayList());
            }
        }
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.isPrintedToKitchen().booleanValue()) continue;
            String string = ticketItem.getCourseId();
            if (StringUtils.isEmpty((String)string)) {
                object = (List)linkedHashMap.get(list.get(0).getId());
                object.add(ticketItem);
                continue;
            }
            object = (List)linkedHashMap.get(string);
            if (object != null) {
                object.add(ticketItem);
                continue;
            }
            List list2 = (List)linkedHashMap.get(list.get(0).getId());
            list2.add(ticketItem);
        }
        int n2 = 5;
        if (n == 6 || n == 5) {
            n2 = 3;
        } else if (n == 8 || n == 7) {
            n2 = 4;
        }
        this.b.setLayout((LayoutManager)new MigLayout("fill,wrap " + n2, "sg,fill", ""));
        this.b.removeAll();
        for (String string : linkedHashMap.keySet()) {
            object = new CourseOrganizeTableView(DataProvider.get().getCourse(string), (List)linkedHashMap.get(string));
            ((CourseOrganizeTableView)object).setDataTransferHandler(this.a);
            ((CourseOrganizeTableView)object).setTicket(ticket);
            this.b.add((Component)object, "grow");
        }
        this.b.revalidate();
        this.b.repaint();
    }

    private void a() {
        try {
            CourseOrganizeTableView courseOrganizeTableView;
            SendToKitchenAction sendToKitchenAction = new SendToKitchenAction();
            if (!sendToKitchenAction.isPrintableToKitchen(this.d)) {
                return;
            }
            for (Component component : this.b.getComponents()) {
                courseOrganizeTableView = (CourseOrganizeTableView)component;
                courseOrganizeTableView.updateModel();
            }
            OrderController.saveOrder(this.d);
            sendToKitchenAction.doSendNewItemsToKitchen(this.d);
            for (Component component : this.b.getComponents()) {
                courseOrganizeTableView = (CourseOrganizeTableView)component;
                courseOrganizeTableView.removeRows();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void doOk() {
        for (Component component : this.b.getComponents()) {
            CourseOrganizeTableView courseOrganizeTableView = (CourseOrganizeTableView)component;
            courseOrganizeTableView.updateModel();
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        if (this.d.getVersion() > this.c) {
            this.setCanceled(false);
        } else {
            this.setCanceled(true);
        }
        this.dispose();
    }

    static Image a(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public Ticket getTicket() {
        return this.d;
    }

    @Override
    public void refresh() {
        this.d = TicketDAO.getInstance().loadFullTicket(this.d.getId());
        this.a(this.d);
    }
}

