/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginatedTableModel;
import java.util.Date;
import javax.swing.JTable;
import org.apache.commons.lang.StringUtils;

public class TicketListTableModel
extends PaginatedTableModel<Ticket> {
    private JTable a;

    public TicketListTableModel(JTable jTable) {
        super(new String[]{POSConstants.TICKET_LIST_COLUMN_ID, Messages.getString("TicketListTableModel.0"), POSConstants.TICKET_LIST_COLUMN_TABLE, POSConstants.TICKET_LIST_COLUMN_SERVER, POSConstants.TICKET_LIST_COLUMN_CREATE_DATE, POSConstants.TICKET_LIST_COLUMN_CUSTOMER, POSConstants.TICKET_LIST_COLUMN_DELIVERY_ADDRESS, POSConstants.TICKET_LIST_COLUMN_DELIVERY_DATE, POSConstants.TICKET_LIST_COLUMN_TICKET_TYPE, POSConstants.TICKET_LIST_COLUMN_STATUS, POSConstants.TICKET_LIST_COLUMN_TOTAL, POSConstants.TICKET_LIST_COLUMN_DUE});
        this.a = jTable;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Ticket ticket = (Ticket)this.rows.get(n);
        switch (n2) {
            case 0: {
                return ticket.getId();
            }
            case 1: {
                return ticket.getTokenNo();
            }
            case 2: {
                return ticket.getTableNameDisplay();
            }
            case 3: {
                String string = ticket.getOwnerNameFromProperty();
                if (StringUtils.isBlank((String)string)) {
                    string = ticket.getOwnerId();
                }
                return string;
            }
            case 4: {
                Date date = ticket.getCreateDate();
                if (date == null) {
                    return "";
                }
                if (DateUtil.isToday(date)) {
                    return DateUtil.formatAsTodayDate(date);
                }
                return DateUtil.formatDateWithTime(date);
            }
            case 5: {
                String string = ticket.getCustomerNameByProperty();
                if (StringUtils.isBlank((String)string)) {
                    return Messages.getString("GUEST");
                }
                String string2 = "<html><body>" + string;
                string2 = string2 + "</body></html>";
                return string2;
            }
            case 6: {
                return ticket.getFullDeliveryAddress();
            }
            case 7: {
                Date date = ticket.getDeliveryDate();
                if (date == null) {
                    return "";
                }
                if (DateUtil.isToday(date)) {
                    return DateUtil.formatAsTodayDate(date);
                }
                return DateUtil.formatDateWithTime(date);
            }
            case 8: {
                return ticket.getOrderType();
            }
            case 9: {
                String string = "";
                string = ticket.isPaid() != false ? Messages.getString("TicketListView.8") : Messages.getString("TicketListView.9");
                if (ticket.isVoided().booleanValue()) {
                    string = Messages.getString("TicketListView.12");
                } else if (ticket.isClosed().booleanValue()) {
                    string = Messages.getString("TicketListView.13");
                }
                return string;
            }
            case 10: {
                return ticket.getTotalAmountWithTips();
            }
            case 11: {
                return ticket.getDueAmount();
            }
        }
        return null;
    }

    public JTable getTable() {
        return this.a;
    }
}

