/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.actions.ItemReorderAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.BarTabButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.floorplan.UiRenderer;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.views.TableLayoutView;
import com.floreantpos.util.CurrencyUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class BarTabSelectionView
extends JPanel
implements UiRenderer {
    private Map<Ticket, BarTabButton> a = new HashMap<Ticket, BarTabButton>();
    private JPanel b;
    private OrderType c;
    private TableSelectionView d;

    public BarTabSelectionView() {
        this((TableSelectionView)null);
    }

    public BarTabSelectionView(TableSelectionView tableSelectionView) {
        this.d = tableSelectionView;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        this.b = new JPanel(new WrapLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("BarTabSelectionView.0"), 2, 0);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        VerticalSimpleScrollPane verticalSimpleScrollPane = new VerticalSimpleScrollPane(this.b);
        jPanel.add((Component)((Object)verticalSimpleScrollPane), "Center");
        this.add((Component)jPanel, "Center");
    }

    private void b() {
        List<Ticket> list = TicketDAO.getInstance().findBarTabOpenTickets(this.c);
        if (list != null && list.size() > 0) {
            for (Ticket ticket : list) {
                BarTabButton barTabButton = new BarTabButton(ticket);
                barTabButton.setPreferredSize(PosUIManager.getSize(157, 138));
                barTabButton.setFont(new Font(barTabButton.getFont().getName(), 1, 14));
                barTabButton.setText(barTabButton.getText());
                barTabButton.addActionListener(actionEvent -> this.a((BarTabButton)actionEvent.getSource()));
                barTabButton.update();
                this.b.add(barTabButton);
                this.a.put(ticket, barTabButton);
                String string = barTabButton.getTicket().getProperty("CUSTOMER_NAME");
                if (string == null) {
                    string = Messages.getString("GUEST");
                }
                barTabButton.setText("<html><center>" + string + "<br><h4 style='margin:0px;'>" + ticket.getOwner().getFirstName() + "<br>Chk#" + ticket.getId() + "</h4>" + CurrencyUtil.getCurrencySymbol() + ticket.getTotalAmountWithTips() + "<br><small style='margin:0px;'>Due: " + CurrencyUtil.getCurrencySymbol() + ticket.getDueAmount() + "</small></center></html>");
                if (!ticket.getOwner().getId().equals(Application.getCurrentUser().getId())) {
                    barTabButton.setBackground(new Color(139, 0, 139));
                    barTabButton.setForeground(Color.WHITE);
                }
                barTabButton.setTicket(ticket);
                barTabButton.setUser(ticket.getOwner());
            }
        }
    }

    private boolean c() {
        return this.d != null && this.d.shouldReorder();
    }

    private void a(BarTabButton barTabButton) {
        if (!barTabButton.hasUserAccess()) {
            return;
        }
        this.a(false);
        TableLayoutView tableLayoutView = TableLayoutView.getInstance();
        Ticket ticket = barTabButton.getTicket();
        if (tableLayoutView.shouldGuestCheck()) {
            new ShowOrderInfoAction(ticket).actionPerformed(null);
            tableLayoutView.clearSelection();
            return;
        }
        if (tableLayoutView.shouldSettle()) {
            new SettleTicketAction(ticket).actionPerformed(null);
            tableLayoutView.clearSelection();
            return;
        }
        if (this.c()) {
            ItemReorderAction itemReorderAction = new ItemReorderAction(ticket);
            itemReorderAction.execute();
            this.d.clearSelection();
        } else {
            new TicketEditAction(ticket).actionPerformed(null);
            tableLayoutView.clearSelection();
        }
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(false);
            window.dispose();
        }
    }

    public void updateView(OrderType orderType) {
        this.c = orderType;
        this.b.removeAll();
        this.a.clear();
        this.b();
        this.b.revalidate();
        this.b.repaint();
    }

    @Override
    public void render() {
        this.updateView(this.c);
    }

    public void setOrderType(OrderType orderType) {
        this.c = orderType;
    }
}

