/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.PrintException;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.bo.actions.TicketPrintAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TicketStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JPanel;
import org.hibernate.StaleStateException;

public class OrderInfoDialog
extends POSDialog {
    private OrderInfoView a;
    private boolean b = false;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private JPanel i;

    public OrderInfoDialog(OrderInfoView orderInfoView) {
        this.a = orderInfoView;
        this.setTitle(Messages.getString("OrderInfoDialog.0"));
        this.createUI();
        this.a();
    }

    public void createUI() {
        this.add(this.a);
        this.i = new JPanel();
        this.getContentPane().add((Component)this.i, "South");
        this.h = new PosButton(POSConstants.CONFIRM);
        this.h.setBackground(Color.GREEN);
        this.h.setVisible(false);
        this.h.addActionListener(actionEvent -> this.doConfirmOrder());
        this.i.add(this.h);
        this.c = new PosButton(Messages.getString("OrderInfoDialog.5"));
        this.c.addActionListener(actionEvent -> this.d());
        this.g = new PosButton(Messages.getString("OrderInfoDialog.6"));
        this.g.addActionListener(actionEvent -> this.doSentEmail());
        this.i.add(this.g);
        this.i.add(this.c);
        this.d = new PosButton();
        this.d.setText(Messages.getString("OrderInfoDialog.3"));
        this.d.addActionListener(actionEvent -> this.c());
        this.i.add(this.d);
        this.e = new PosButton();
        this.e.addActionListener(actionEvent -> this.doPrint(actionEvent));
        this.e.setText(Messages.getString("OrderInfoDialog.1"));
        this.i.add(this.e);
        this.f = new PosButton();
        this.f.addActionListener(actionEvent -> this.b());
        this.f.setText(Messages.getString("OrderInfoDialog.2"));
        this.f.setVisible(false);
        this.i.add(this.f);
        PosButton posButton = new PosButton();
        posButton.addActionListener(actionEvent -> this.dispose());
        posButton.setText(Messages.getString("Close"));
        this.i.add(posButton);
    }

    public void doPrint(ActionEvent actionEvent) {
        new TicketPrintAction(this.a, null, this.a.getTickets()).actionPerformed(actionEvent);
    }

    public void doSentEmail() {
        try {
            new EmailSendAction(){

                @Override
                public Ticket getTicket() {
                    return OrderInfoDialog.this.a.getTickets().get(0);
                }
            }.execute();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public void doConfirmOrder() {
        Ticket ticket = this.a.getTickets().get(0);
        try {
            int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("OrderInfoDialog.7"));
            if (n != 0) {
                return;
            }
            Ticket ticket2 = TicketDAO.getInstance().load(ticket.getId());
            if (ticket.getVersion() != ticket2.getVersion()) {
                this.a(ticket2);
                this.dispose();
                return;
            }
            int n2 = 20;
            try {
                n2 = Integer.parseInt(DataProvider.get().getOutlet().getProperty("deliveryConfig.preperationTime"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Store store = DataProvider.get().getStore();
            ticket.setEstimatedDeliveryTime(String.valueOf(n2));
            ticket.setTicketStatus(TicketStatus.Confirmed);
            if (store.isAutoSendOrdersToKitchen() && store.getSendOrderBeforeTime() == 0) {
                SendToKitchenAction.doSendNewItemsToKitchen(ticket, false);
            }
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (exception instanceof StaleStateException || throwable instanceof StaleStateException) {
                Ticket ticket3 = TicketDAO.getInstance().load(ticket.getId());
                this.a(ticket3);
                this.dispose();
            }
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket) {
        String string = Messages.getString("OrderInfoDialog.8");
        TicketStatus ticketStatus = ticket.getTicketStatus();
        if (ticketStatus != TicketStatus.Pending && ticketStatus != TicketStatus.Canceled) {
            string = Messages.getString("OrderInfoDialog.10");
        } else if (ticketStatus == TicketStatus.Canceled) {
            string = Messages.getString("OrderInfoDialog.11");
        }
        POSMessageDialog.showError(string);
    }

    private void a() {
        try {
            Store store = DataProvider.get().getStore();
            boolean bl = POSUtil.getBoolean(store.getProperty("hide_print_button.in_order_info_view"));
            if (bl) {
                this.e.setVisible(Boolean.FALSE);
            } else {
                this.e.setVisible(Boolean.TRUE);
            }
            List<Ticket> list = this.a.getTickets();
            if (list.size() == 1) {
                Ticket ticket = list.get(0);
                this.h.setVisible(ticket.isSourceOnline() && ticket.getTicketStatus() == TicketStatus.Pending);
            } else {
                this.h.setVisible(false);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void b() {
        try {
            if (ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            this.a.printCopy("Driver Copy");
        }
        catch (PrintException printException) {
            POSMessageDialog.showError(Application.getPosWindow(), printException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    public void updateView() {
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.f.setVisible(true);
        this.e.setText(Messages.getString("OrderInfoDialog.9"));
    }

    public void setReorder(boolean bl) {
        this.b = bl;
    }

    public boolean isReorder() {
        return this.b;
    }

    public void showOnlyPrintButton() {
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.f.setVisible(false);
    }

    public OrderInfoView getOrderInfoView() {
        return this.a;
    }

    public JPanel getButtonPanel() {
        return this.i;
    }

    private void c() {
        try {
            TicketTransferAction ticketTransferAction = new TicketTransferAction(this.a.getTickets().get(0), Application.getCurrentUser());
            ticketTransferAction.execute();
            if (!ticketTransferAction.isTransfered()) {
                return;
            }
            this.a.getReportPanel().removeAll();
            this.a.createReport();
            this.a.revalidate();
            this.a.repaint();
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("MessageDialog.0"));
            PosLog.error(this.getClass(), exception);
        }
    }

    private void d() {
        try {
            TicketReorderAction ticketReorderAction = new TicketReorderAction(this.a.getTickets().get(0), UserPermission.CREATE_TICKET);
            ticketReorderAction.execute();
            if (!ticketReorderAction.isReorder()) {
                return;
            }
            this.b = true;
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public void showReorderButton(boolean bl) {
        this.c.setVisible(bl);
    }

    public void showTransferButton(boolean bl) {
        this.d.setVisible(bl);
    }
}

