/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.JDBCConnectionException;

public class MenuItemView
extends SelectionView {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private Vector<ItemSelectionListener> a = new Vector();
    private MenuGroup b;
    private boolean c;

    public MenuItemView() {
        super(POSConstants.ITEMS, new FlowLayout(), PosUIManager.getSize(TerminalConfig.getMenuItemButtonWidth()), PosUIManager.getSize(TerminalConfig.getMenuItemButtonHeight()));
        this.dataModel = new PaginatedListModel();
        this.btnPrev.setText("<< " + Messages.getString("MenuItemView.1"));
        this.btnNext.setText(Messages.getString("MenuItemView.2") + ">>");
    }

    public MenuGroup getMenuGroup() {
        return this.b;
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.b = menuGroup;
        this.setQuickMenuMode(false);
        this.reset();
        if (menuGroup == null) {
            return;
        }
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            MenuPageDAO.getInstance().loadItems(terminal, menuGroup, this.getOrderType(), null, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    protected void renderItems() {
        this.reset();
        if (this.c) {
            this.a();
        } else {
            this.b();
        }
    }

    private void a() {
        this.setTitle(Messages.getString("MenuItemView.0"));
        PosButton posButton = new PosButton(Messages.getString("MenuItemView.3"));
        VerticalTouchScrollPanel verticalTouchScrollPanel = new VerticalTouchScrollPanel(new GridLayout(0, 2, 5, 5));
        List list = this.dataModel.getDataList();
        for (MenuItem menuItem : list) {
            verticalTouchScrollPanel.add(this.createItemButton(menuItem));
        }
        Object object = new VerticalSimpleScrollPane(verticalTouchScrollPanel);
        this.selectionButtonsPanel.setBorder(null);
        this.selectionButtonsPanel.setLayout(new BorderLayout(5, 5));
        this.selectionButtonsPanel.add((Component)object);
        this.selectionButtonsPanel.add((Component)posButton, "South");
        posButton.addActionListener(actionEvent -> SwingUtilities.invokeLater(() -> {
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            if (ticket == null) {
                return;
            }
            OrderType orderType = ticket.getOrderType();
            if (orderType == null) {
                return;
            }
            OrderTypeDAO.getInstance().refresh(orderType);
            this.setQuickMenus(MenuItemDAO.getInstance().getMenuItemByIDs(orderType.getQuickMenuIds()));
        }));
        this.revalidate();
        this.repaint();
    }

    private void b() {
        if (this.dataModel.getSize() == 0) {
            this.setTitle(POSConstants.ITEMS);
            this.revalidate();
            this.repaint();
            return;
        }
        this.btnPrev.setText("<< " + POSConstants.CAPITAL_PREV);
        MenuPage menuPage = (MenuPage)this.dataModel.getElementAt(0);
        this.setTitle(menuPage.getName());
        int n = menuPage.getRows();
        int n2 = menuPage.getCols();
        double d = 100.0 / (double)n;
        double d2 = 100.0 / (double)n2;
        MigLayout migLayout = new MigLayout("hidemode 0, center,wrap " + n2);
        if (menuPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
            this.selectionButtonsPanel.setLayout(new GridLayout(n, n2, 5, 5));
            this.selectionButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    AbstractButton abstractButton;
                    MenuPageItem menuPageItem = menuPage.getItemForCell(j, i);
                    if (menuPageItem == null) {
                        this.selectionButtonsPanel.add(new JLabel());
                        continue;
                    }
                    if (!menuPageItem.isVisible().booleanValue() || (abstractButton = this.createItemButton(menuPageItem)) == null) continue;
                    this.selectionButtonsPanel.add(abstractButton);
                }
            }
        } else {
            this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    AbstractButton abstractButton;
                    String string = String.format("cell %s %s", j, i);
                    string = menuPage.isFlixibleButtonSize() != false ? string + String.format(", w %s, h %s", d, d2) : string + String.format(", w %s!, h %s!", menuPage.getButtonWidth(), menuPage.getButtonHeight());
                    MenuPageItem menuPageItem = menuPage.getItemForCell(j, i);
                    if (menuPageItem == null) {
                        this.selectionButtonsPanel.add((Component)new JLabel(), string);
                        continue;
                    }
                    if (!menuPageItem.isVisible().booleanValue() || (abstractButton = this.createItemButton(menuPageItem)) == null) continue;
                    this.selectionButtonsPanel.add((Component)abstractButton, string);
                }
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    public void rendererVariants(MenuItem menuItem2) {
        List<MenuItem> list = menuItem2.getVariants();
        List<Object> list2 = new ArrayList();
        if (list != null) {
            list2 = list.stream().filter(menuItem -> menuItem.isDeleted() == false).collect(Collectors.toList());
        }
        this.reset();
        Dimension dimension = PosUIManager.getSize(120, 120);
        JPanel jPanel = new JPanel(new WrapLayout());
        this.selectionButtonsPanel.setLayout(new BorderLayout());
        for (MenuItem menuItem3 : list2) {
            AbstractButton abstractButton = this.createItemButton(menuItem3);
            if (abstractButton == null) continue;
            abstractButton.setPreferredSize(dimension);
            jPanel.add(abstractButton);
        }
        PosScrollPane posScrollPane = new PosScrollPane(jPanel);
        posScrollPane.setBorder(null);
        this.selectionButtonsPanel.add(posScrollPane);
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(true);
        this.btnPrev.setText(Messages.getString("MenuItemView.10"));
        this.setTitle(menuItem2.getName());
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        if (object instanceof MenuPageItem) {
            return new PageItemButton((MenuPageItem)object);
        }
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            if (!menuItem.isVisible().booleanValue()) {
                return null;
            }
            menuItem.setMenuGroup(this.b);
            ItemButton itemButton = new ItemButton(menuItem);
            return itemButton;
        }
        return null;
    }

    public void addItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.a.add(itemSelectionListener);
    }

    public void removeItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.a.remove(itemSelectionListener);
    }

    private void a(MenuItem menuItem) {
        for (ItemSelectionListener itemSelectionListener : this.a) {
            itemSelectionListener.itemSelected(menuItem);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        if (this.btnPrev.getText().equals(Messages.getString("MenuItemView.10"))) {
            this.renderItems();
            return;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    public void setQuickMenus(List<MenuItem> list) {
        this.dataModel.setData(list);
        this.dataModel.setCurrentRowIndex(0);
        this.dataModel.setPageSize(list.size());
        this.setQuickMenuMode(true);
        this.renderItems();
    }

    public boolean isQuickMenuMode() {
        return this.c;
    }

    public void setQuickMenuMode(boolean bl) {
        this.c = bl;
    }

    public void renderUnitWiseItem(MenuItem menuItem) {
        Optional<List<IUnit>> optional = Optional.ofNullable(menuItem.getUnits(false, false));
        List<Object> list = new ArrayList();
        if (optional.isPresent()) {
            list = optional.get().stream().map(iUnit -> {
                if (iUnit.hideFromSalesScreen()) {
                    return null;
                }
                MenuItem menuItem2 = new MenuItem();
                menuItem2.setId(menuItem.getId());
                menuItem2.setName(iUnit.getName());
                menuItem2.setTranslatedName(iUnit.getName());
                menuItem2.setShowChildUnits(false);
                menuItem2.setUnitWiseSelection(false);
                menuItem2.setUnit((InventoryUnit)iUnit);
                menuItem2.setUnitWiseItem(true);
                return menuItem2;
            }).collect(Collectors.toList());
        }
        this.reset();
        Dimension dimension = PosUIManager.getSize(120, 120);
        JPanel jPanel = new JPanel(new WrapLayout());
        this.selectionButtonsPanel.setLayout(new BorderLayout());
        for (MenuItem menuItem2 : list) {
            AbstractButton abstractButton = this.createItemButton(menuItem2);
            if (abstractButton == null) continue;
            abstractButton.setPreferredSize(dimension);
            jPanel.add(abstractButton);
        }
        PosScrollPane posScrollPane = new PosScrollPane(jPanel);
        posScrollPane.setBorder(null);
        this.selectionButtonsPanel.add(posScrollPane);
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(true);
        this.btnPrev.setText(Messages.getString("MenuItemView.10"));
        this.setTitle(menuItem.getName());
    }

    private class PageItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem a;
        MenuPageItem b;

        PageItemButton(MenuPageItem menuPageItem) {
            Color color;
            this.b = menuPageItem;
            if (menuPageItem == null) {
                this.setVisible(false);
                return;
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            String string = "<html><body><center>" + menuPageItem.getDisplayName() + "</center></body></html>";
            this.setText(string);
            Color color2 = menuPageItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuPageItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            MenuItem menuItem = this.b.getMenuItem();
            this.setEnabled(menuItem != null && menuItem.isEnable() != false);
        }

        public void setItemImage() {
            Dimension dimension = this.getSize();
            if (dimension.width <= 0 || dimension.height <= 0) {
                return;
            }
            ImageResource imageResource = DataProvider.get().getImageResource(this.b.getImageId());
            if (imageResource != null) {
                int n;
                int n2 = n = dimension.height < dimension.width ? dimension.height : dimension.width;
                if (!this.b.isShowImageOnly().booleanValue()) {
                    n = n <= 100 ? (n /= 2) : (n -= 60);
                }
                ImageIcon imageIcon = imageResource.getImageOfHeight(n);
                this.setIcon(imageIcon);
                if (this.b.isShowImageOnly().booleanValue()) {
                    this.setText("");
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                if (this.a == null) {
                    this.a = new MenuItem(this.b.getMenuItemId());
                }
                MenuItemView.this.a(this.a);
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                MenuItem menuItem;
                menuItem.setEnable((menuItem = this.b.getMenuItem()).isEnable() == false);
                this.setEnabled(menuItem.isEnable());
                MenuItemDAO.getInstance().update(menuItem);
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            Rectangle rectangle = super.getBounds();
            if (rectangle.x == n && rectangle.y == n2 && rectangle.width == n3 && rectangle.height == n4) {
                return;
            }
            super.setBounds(n, n2, n3, n4);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PageItemButton.this.setItemImage();
                }
            });
        }
    }

    private class ItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem a;

        ItemButton(MenuItem menuItem) {
            Color color;
            this.a = menuItem;
            if (menuItem == null) {
                this.setVisible(false);
                return;
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            ImageIcon imageIcon = menuItem.getImage();
            String string = "<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>";
            if (imageIcon != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText(string);
                }
            } else {
                this.setText(string);
            }
            Color color2 = menuItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                MenuItemView.this.a(this.a);
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            try {
                if (this.a.isUnitWiseItem()) {
                    return;
                }
                if (OrderView.getInstance().is_86Mode()) {
                    this.a.setEnable(this.a.isEnable() == false);
                    this.setEnabled(this.a.isEnable());
                    MenuItemDAO.getInstance().update(this.a);
                    return;
                }
            }
            catch (PosException posException) {
                POSMessageDialog.showError(posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

