/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.InginicoPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.TicketDetailView;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ConfirmPayDialog;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.GroupPaymentView;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.ManualGiftCardEntryDialog;
import com.floreantpos.ui.views.payment.PosPaymentWaitDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class GroupSettleTicketDialog
extends POSDialog
implements CardInputListener {
    public static final String LOYALTY_DISCOUNT_PERCENTAGE = "loyalty_discount_percentage";
    public static final String LOYALTY_POINT = "loyalty_point";
    public static final String LOYALTY_COUPON = "loyalty_coupon";
    public static final String LOYALTY_DISCOUNT = "loyalty_discount";
    public static final String LOYALTY_ID = "loyalty_id";
    public static final String VIEW_NAME = "PAYMENT_VIEW";
    private GroupPaymentView a;
    private List<Ticket> b;
    private TicketDetailView c;
    private JScrollPane d;
    private double e;
    private PaymentType f;
    private JTextField g;
    private JTextField h;
    private JTextField i;
    private JTextField j;
    private JTextField k;
    private JTextField l;
    private JTextField m;
    private JTextField n;
    private JTextField o = new JTextField();
    private String p = "";
    private List<Integer> q = new ArrayList<Integer>();
    private String r = "";
    private double s;
    private JLabel t;
    private JLabel u;
    private JLabel v;
    private JLabel w;
    private JLabel x;
    public static PosPaymentWaitDialog waitDialog = new PosPaymentWaitDialog();
    private User y;
    private JLabel z;
    private JLabel A;
    private JLabel B;
    private JLabel C;

    public GroupSettleTicketDialog(List<Ticket> list, User user) {
        this.b = list;
        this.y = user;
        for (Ticket ticket : list) {
            OrderType orderType = ticket.getOrderType();
            if (orderType == null || !orderType.isConsolidateItemsInReceipt().booleanValue()) continue;
            ticket.consolidateTicketItems();
        }
        this.setTitle(Messages.getString("SettleTicketDialog.6"));
        this.getContentPane().setLayout(new BorderLayout());
        this.c = new TicketDetailView();
        this.d = new PosScrollPane(this.c);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        jPanel.add((Component)this.a(), "North");
        jPanel.add((Component)this.d, "Center");
        jPanel.add((Component)this.b(), "South");
        this.a = new GroupPaymentView(this);
        this.a.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.a, "East");
        this.setSize(Application.getPosWindow().getSize());
        this.updateView();
        this.a.updateView();
        this.a.setDefaultFocus();
    }

    public void updateView() {
        if (this.b == null && !this.b.isEmpty()) {
            this.g.setText("");
            this.h.setText("");
            this.i.setText("");
            this.j.setText("");
            this.k.setText("");
            this.o.setText("");
            this.m.setText("");
            this.n.setText("");
            this.l.setText("");
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        for (Ticket ticket : this.b) {
            Object object;
            d += ticket.getSubtotalAmount().doubleValue();
            d2 += ticket.getDiscountAmount().doubleValue();
            d3 += ticket.getDeliveryCharge().doubleValue();
            d5 += ticket.getServiceCharge().doubleValue();
            d6 += ticket.getRefundAmount().doubleValue();
            d4 += ticket.getTaxAmount().doubleValue();
            if (ticket.getGratuity() != null) {
                d7 += ticket.getGratuity().getAmount().doubleValue();
            }
            d8 += ticket.getTotalAmountWithTips().doubleValue();
            d9 += ticket.getPaidAmount().doubleValue();
            this.s += ticket.getDueAmount().doubleValue();
            this.p = this.p + "[" + (ticket.getId() == null ? "New Ticket" : ticket.getId()) + "], ";
            List<Integer> list = ticket.getTableNumbers();
            if (list != null && list.size() > 0) {
                object = list.iterator();
                while (object.hasNext()) {
                    Integer n = object.next();
                    if (list.contains(n)) continue;
                    list.add(n);
                }
            }
            if (POSUtil.isBlankOrNull((String)(object = ticket.getProperty("CUSTOMER_NAME", "") + " " + ticket.getProperty("CUSTOMER_LAST_NAME", "")))) continue;
            this.r = this.r + (String)object + ", ";
        }
        this.g.setText(NumberUtil.formatNumber(d));
        this.h.setText(NumberUtil.formatNumber(d2));
        if (Application.getInstance().isPriceIncludesTax()) {
            this.j.setText(Messages.getString("TicketView.35"));
        } else {
            this.j.setText(NumberUtil.formatNumber(d4));
        }
        if (d3 > 0.0) {
            this.i.setText(NumberUtil.formatNumber(d3));
        } else {
            this.z.setVisible(false);
            this.i.setVisible(false);
        }
        if (d5 > 0.0) {
            this.m.setText(NumberUtil.formatNumber(d5));
        } else {
            this.A.setVisible(false);
            this.m.setVisible(false);
        }
        if (d6 > 0.0) {
            this.n.setText(NumberUtil.formatNumber(d6));
        } else {
            this.B.setVisible(false);
            this.n.setVisible(false);
        }
        if (d7 > 0.0) {
            this.l.setText(NumberUtil.formatNumber(d7));
        } else {
            this.C.setVisible(false);
            this.l.setVisible(false);
        }
        this.k.setText(NumberUtil.formatNumber(d8));
        this.o.setText(NumberUtil.formatNumber(d9));
        this.v.setText(this.p.substring(0, this.p.length() - 2));
        this.w.setText(this.q.toString());
        if (this.q.isEmpty()) {
            this.w.setVisible(false);
            this.u.setVisible(false);
        }
        if (this.r.length() > 2) {
            this.r = this.r.substring(0, this.r.length() - 2);
        }
        this.x.setText(this.r);
        if (this.r == null) {
            this.x.setVisible(false);
            this.t.setVisible(false);
        }
        this.c.setTickets(this.b);
    }

    private JPanel a() {
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("SettleTicketDialog.0"));
        this.v = new JLabel();
        this.u = new JLabel();
        this.u.setText(POSConstants.TABLES);
        this.w = new JLabel();
        this.t = new JLabel();
        this.t.setText("Customer:");
        this.x = new JLabel();
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,fill, hidemode 3", "[][grow]", ""));
        transparentPanel.add(jLabel);
        transparentPanel.add((Component)this.v, "grow");
        transparentPanel.add(this.u);
        transparentPanel.add((Component)this.w, "grow");
        transparentPanel.add(this.t);
        transparentPanel.add((Component)this.x, "grow");
        return transparentPanel;
    }

    private JPanel b() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.g = new JTextField(10);
        this.g.setHorizontalAlignment(11);
        this.g.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.h = new JTextField(10);
        this.h.setHorizontalAlignment(11);
        this.h.setEditable(false);
        this.z = new JLabel();
        this.z.setHorizontalAlignment(4);
        this.z.setText("Delivery Charge: " + CurrencyUtil.getCurrencySymbol());
        this.z.setVisible(true);
        this.i = new JTextField(10);
        this.i.setHorizontalAlignment(11);
        this.i.setEditable(false);
        this.i.setVisible(true);
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.j = new JTextField();
        this.j.setEditable(false);
        this.j.setHorizontalAlignment(11);
        this.A = new JLabel();
        this.A.setHorizontalAlignment(4);
        this.A.setText("Service Charge: " + CurrencyUtil.getCurrencySymbol());
        this.A.setVisible(true);
        this.m = new JTextField();
        this.m.setEditable(false);
        this.m.setVisible(true);
        this.m.setHorizontalAlignment(11);
        this.B = new JLabel();
        this.B.setHorizontalAlignment(4);
        this.B.setText("Refund: " + CurrencyUtil.getCurrencySymbol());
        this.B.setVisible(true);
        this.n = new JTextField();
        this.n.setEditable(false);
        this.n.setVisible(true);
        this.n.setHorizontalAlignment(11);
        this.C = new JLabel();
        this.C.setHorizontalAlignment(4);
        this.C.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.C.setVisible(true);
        this.l = new JTextField();
        this.l.setEditable(false);
        this.l.setVisible(true);
        this.l.setHorizontalAlignment(11);
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(jLabel4.getFont().deriveFont(1, 18.0f));
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.k = new JTextField(10);
        this.k.setFont(this.k.getFont().deriveFont(1, 18.0f));
        this.k.setHorizontalAlignment(11);
        this.k.setEditable(false);
        this.o.setEditable(false);
        this.o.setHorizontalAlignment(11);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 2 2 3 2,alignx trailing,fill", "[grow][]", ""));
        transparentPanel.add((Component)jLabel, "growx,aligny center");
        transparentPanel.add((Component)this.g, "growx,aligny center");
        transparentPanel.add((Component)jLabel2, "newline,growx,aligny center");
        transparentPanel.add((Component)this.h, "growx,aligny center");
        transparentPanel.add((Component)jLabel3, "newline,growx,aligny center");
        transparentPanel.add((Component)this.j, "growx,aligny center");
        transparentPanel.add((Component)this.z, "newline,growx,aligny center");
        transparentPanel.add((Component)this.i, "growx,aligny center");
        transparentPanel.add((Component)this.A, "newline,growx,aligny center");
        transparentPanel.add((Component)this.m, "growx,aligny center");
        transparentPanel.add((Component)this.B, "newline,growx,aligny center");
        transparentPanel.add((Component)this.n, "growx,aligny center");
        transparentPanel.add((Component)this.C, "newline,growx,aligny center");
        transparentPanel.add((Component)this.l, "growx,aligny center");
        transparentPanel.add((Component)jLabel4, "newline,growx,aligny center");
        transparentPanel.add((Component)this.k, "growx,aligny center");
        transparentPanel.add((Component)new JLabel(Messages.getString("SettleTicketDialog.36") + CurrencyUtil.getCurrencySymbol(), 11), "newline,growx,aligny center");
        transparentPanel.add((Component)this.o, "growx,aligny center");
        return transparentPanel;
    }

    public void doGroupSettle(PaymentType paymentType) throws Exception {
        if (this.b == null) {
            return;
        }
        this.f = paymentType;
        this.e = this.a.getTenderedAmount();
        this.s = NumberUtil.roundToTwoDigit(this.s);
        if (this.e < this.s) {
            POSMessageDialog.showMessage("Partial payment not allowed.");
            return;
        }
        PosTransaction posTransaction = null;
        switch (paymentType) {
            case CASH: {
                if (!this.c()) {
                    return;
                }
                posTransaction = paymentType.createTransaction();
                posTransaction.setCaptured(true);
                this.settleTicket(posTransaction);
                break;
            }
            case CUSTOM_PAYMENT: {
                CustomPaymentSelectionDialog customPaymentSelectionDialog = new CustomPaymentSelectionDialog();
                customPaymentSelectionDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                customPaymentSelectionDialog.pack();
                customPaymentSelectionDialog.open();
                if (customPaymentSelectionDialog.isCanceled()) {
                    return;
                }
                if (!this.c()) {
                    return;
                }
                posTransaction = paymentType.createTransaction();
                CustomPaymentTransaction customPaymentTransaction = (CustomPaymentTransaction)posTransaction;
                customPaymentTransaction.setCustomPaymentFieldName(customPaymentSelectionDialog.getPaymentFieldName());
                customPaymentTransaction.setCustomPaymentId(customPaymentSelectionDialog.getCustomPaymentId());
                customPaymentTransaction.setCustomPaymentName(customPaymentSelectionDialog.getPaymentName());
                customPaymentTransaction.setCustomPaymentRef(customPaymentSelectionDialog.getPaymentRef());
                customPaymentTransaction.setCaptured(true);
                this.settleTicket(customPaymentTransaction);
                break;
            }
            case CREDIT_CARD: 
            case DEBIT_CARD: {
                this.a(this.e);
                break;
            }
            case GIFT_CERTIFICATE: {
                this.b(this.e);
                break;
            }
        }
    }

    private boolean c() {
        if (!TerminalConfig.isUseSettlementPrompt()) {
            return true;
        }
        ConfirmPayDialog confirmPayDialog = new ConfirmPayDialog();
        confirmPayDialog.setAmount(this.e);
        confirmPayDialog.open();
        return !confirmPayDialog.isCanceled();
    }

    public void settleTicket(PosTransaction posTransaction) {
        this.settleTicket(posTransaction, null);
    }

    public void settleTicket(PosTransaction posTransaction, GiftCardProcessor giftCardProcessor) {
        try {
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            this.e = this.a.getTenderedAmount();
            for (Ticket ticket : this.b) {
                PosTransaction posTransaction2 = null;
                if (this.e < 0.0) break;
                posTransaction2 = (PosTransaction)SerializationUtils.clone((Serializable)posTransaction);
                posTransaction2.setTicket(ticket);
                this.a(posTransaction2);
                PosTransactionService posTransactionService = PosTransactionService.getInstance();
                posTransactionService.settleTicket(ticket, posTransaction2, this.y, giftCardProcessor, null);
                arrayList.add(posTransaction2);
                if (!DataProvider.get().getCurrentTerminal().isAutoPrintReceipt() || !NumberUtil.isZero(ticket.getDueAmount())) continue;
                GroupSettleTicketDialog.printTicket(ticket, posTransaction2);
            }
            this.showTransactionCompleteMsg(this.s, this.e, this.b, arrayList);
            this.setCanceled(false);
            this.dispose();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void showTransactionCompleteMsg(double d, double d2, List<Ticket> list, List<PosTransaction> list2) {
        TransactionCompletionDialog transactionCompletionDialog = new TransactionCompletionDialog(list2);
        transactionCompletionDialog.setTickets(list);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (PosTransaction comparable : list2) {
            d3 += comparable.getAmount().doubleValue();
            transactionCompletionDialog.setCard(comparable.isCard());
            d5 += comparable.getChangeAmount().doubleValue();
            d6 += comparable.getTipsAmount().doubleValue();
        }
        transactionCompletionDialog.setGratuityAmount(d6);
        transactionCompletionDialog.setTenderedAmount(d2);
        transactionCompletionDialog.setTotalAmount(d);
        transactionCompletionDialog.setPaidAmount(d3);
        for (Ticket ticket : list) {
            d4 += ticket.getDueAmount().doubleValue();
        }
        transactionCompletionDialog.setDueAmount(d4);
        transactionCompletionDialog.setChangeAmount(d5);
        transactionCompletionDialog.updateView();
        transactionCompletionDialog.pack();
        transactionCompletionDialog.open();
    }

    public static void printTicket(Ticket ticket, PosTransaction posTransaction) {
        try {
            if (ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket);
            }
            ReceiptPrintService.printTransaction(posTransaction);
            if (posTransaction instanceof CashTransaction) {
                DrawerUtil.kickDrawer();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.PRINT_ERROR, exception);
        }
    }

    private void a(double d) throws Exception {
        try {
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (paymentGatewayPlugin instanceof ExternalPaymentGatewayPlugin) {
                AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this, this.f);
                authorizationCodeDialog.pack();
                authorizationCodeDialog.open();
                return;
            }
            if (paymentGatewayPlugin instanceof InginicoPlugin) {
                waitDialog.setVisible(true);
                if (!waitDialog.isCanceled()) {
                    this.dispose();
                }
                return;
            }
            if (!paymentGatewayPlugin.shouldShowCardInputProcessor()) {
                PosTransaction posTransaction = this.f.createTransaction();
                if (!this.c()) {
                    return;
                }
                Ticket ticket = this.b.get(0);
                posTransaction.setTenderAmount(this.e);
                if (this.e >= this.getDueAmount()) {
                    posTransaction.setAmount(this.getDueAmount());
                } else {
                    posTransaction.setAmount(this.e);
                }
                posTransaction.setTicket(ticket);
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    paymentGatewayPlugin.getProcessor().preAuth(posTransaction);
                } else {
                    paymentGatewayPlugin.getProcessor().chargeAmount(posTransaction);
                }
                this.settleTicket(posTransaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case SWIPE: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, this.f);
                    swipeCardDialog.pack();
                    swipeCardDialog.open();
                    break;
                }
                case MANUAL: {
                    ManualCardEntryDialog manualCardEntryDialog = new ManualCardEntryDialog(this, this.f);
                    manualCardEntryDialog.pack();
                    manualCardEntryDialog.open();
                    break;
                }
                case EXTERNAL_TERMINAL: {
                    AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this, this.f);
                    authorizationCodeDialog.pack();
                    authorizationCodeDialog.open();
                    break;
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    @Override
    public void cardInputted(final CardInputProcessor cardInputProcessor, final PaymentType paymentType, final String string) {
        final BusyDialog busyDialog = new BusyDialog();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                switch (paymentType) {
                    case GIFT_CERTIFICATE: {
                        GroupSettleTicketDialog.this.b(cardInputProcessor, paymentType, string);
                        break;
                    }
                    case CREDIT_CARD: 
                    case DEBIT_CARD: {
                        GroupSettleTicketDialog.this.a(cardInputProcessor, paymentType, string);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void a(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) {
        PosTransaction posTransaction = this.f.createTransaction();
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        if (paymentGatewayPlugin == null) {
            throw new PosException(Messages.getString("GroupSettleTicketDialog.1"));
        }
        CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
        if (cardInputProcessor instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
            String string2 = swipeCardDialog.getCardString();
            if (StringUtils.isEmpty((String)string2) || string2.length() < 16) {
                throw new PosException(Messages.getString("SettleTicketDialog.16"));
            }
            if (!this.c()) {
                return;
            }
            posTransaction.setCardType(string);
            posTransaction.setCardTrack(string2);
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
            posTransaction.setCardReader(CardReader.SWIPE.name());
            this.a(cardProcessor, posTransaction);
        } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardNumber(manualCardEntryDialog.getCardNo());
            posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
            posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
            this.a(cardProcessor, posTransaction);
        } else if (cardInputProcessor instanceof AuthorizationCodeDialog) {
            PosTransaction posTransaction2 = paymentType.createTransaction();
            AuthorizationCodeDialog authorizationCodeDialog = (AuthorizationCodeDialog)cardInputProcessor;
            String string3 = authorizationCodeDialog.getAuthorizationCode();
            if (StringUtils.isEmpty((String)string3)) {
                throw new PosException(Messages.getString("SettleTicketDialog.17"));
            }
            posTransaction2.setCardType(string);
            posTransaction2.setCaptured(true);
            posTransaction2.setAuthorizable(false);
            posTransaction2.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
            posTransaction2.setCardAuthCode(string3);
            this.settleTicket(posTransaction2);
        }
    }

    private void b(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) throws Exception {
        PosTransaction posTransaction = this.f.createTransaction();
        GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
        if (giftCardPaymentPlugin == null) {
            throw new PosException(Messages.getString("GroupSettleTicketDialog.2"));
        }
        GiftCardProcessor giftCardProcessor = giftCardPaymentPlugin.getProcessor();
        if (cardInputProcessor instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
            String string2 = swipeCardDialog.getCardString();
            giftCardProcessor.validateCardNo(string2);
            GiftCard giftCard = giftCardProcessor.getCard(string2);
            double d = giftCardProcessor.getBalance(giftCard.getCardNumber());
            if (this.e > d) {
                POSMessageDialog.showMessage(Messages.getString("GroupSettleTicketDialog.3"));
                return;
            }
            posTransaction.setCardType(string);
            posTransaction.setGiftCertNumber(giftCard.getCardNumber());
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.SWIPE.name());
            posTransaction.setTenderAmount(this.e);
            giftCardProcessor.chargeAmount(posTransaction);
            this.settleTicket(posTransaction, giftCardProcessor);
        } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
            String string3 = manualCardEntryDialog.getCardNo();
            giftCardProcessor.validateCardNo(string3);
            double d = giftCardProcessor.getBalance(string3);
            if (this.e > d) {
                POSMessageDialog.showMessage(Messages.getString("GroupSettleTicketDialog.3"));
                return;
            }
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setGiftCertNumber(string3);
            posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
            posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
            posTransaction.setTenderAmount(this.e);
            giftCardProcessor.chargeAmount(posTransaction);
            this.settleTicket(posTransaction);
        } else if (cardInputProcessor instanceof ManualGiftCardEntryDialog) {
            ManualGiftCardEntryDialog manualGiftCardEntryDialog = (ManualGiftCardEntryDialog)cardInputProcessor;
            giftCardProcessor.validateCard(manualGiftCardEntryDialog.getCardNo(), manualGiftCardEntryDialog.getPinNo());
            GiftCard giftCard = giftCardProcessor.getCard(manualGiftCardEntryDialog.getCardNo());
            double d = giftCardProcessor.getBalance(giftCard.getCardNumber());
            if (this.e > d) {
                POSMessageDialog.showMessage(Messages.getString("GroupSettleTicketDialog.3"));
                return;
            }
            Calendar calendar = Calendar.getInstance();
            Date date = giftCard.getExpiryDate();
            if (date != null) {
                calendar.setTime(date);
                posTransaction.setCardExpMonth("" + calendar.get(2) + 1);
                posTransaction.setCardExpYear("" + calendar.get(1));
            }
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName(giftCard.getOwnerName());
            posTransaction.setGiftCertNumber(giftCard.getCardNumber());
            giftCardProcessor.chargeAmount(posTransaction);
            this.settleTicket(posTransaction, giftCardProcessor);
        } else {
            throw new PosException(Messages.getString("GroupSettleTicketDialog.5"));
        }
    }

    private void a(CardProcessor cardProcessor, PosTransaction posTransaction) {
        try {
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            this.e = this.a.getTenderedAmount();
            for (Ticket ticket : this.b) {
                PosTransaction posTransaction2 = new PosTransaction();
                double d = ticket.getDueAmount();
                if (ticket.isPaid().booleanValue()) continue;
                if (this.e <= 0.0) break;
                posTransaction2 = (PosTransaction)SerializationUtils.clone((Serializable)posTransaction);
                posTransaction2.setId(null);
                posTransaction2.setTicket(ticket);
                this.a(posTransaction2);
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(posTransaction2);
                } else {
                    cardProcessor.chargeAmount(posTransaction2);
                }
                PosTransactionService posTransactionService = PosTransactionService.getInstance();
                posTransactionService.settleTicket(ticket, posTransaction2, this.y);
                arrayList.add(posTransaction2);
                GroupSettleTicketDialog.printTicket(ticket, posTransaction2);
                SettleTicketProcessor.showTransactionCompleteMsg(d, posTransaction2.getTenderAmount(), ticket, posTransaction);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
            this.setCanceled(false);
            this.dispose();
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(PosTransaction posTransaction) {
        if (this.b.get(this.b.size() - 1).getId() == posTransaction.getTicket().getId()) {
            if (this.e > this.s) {
                posTransaction.setTenderAmount(this.e - this.s + posTransaction.getTicket().getDueAmount());
                posTransaction.setAmount(posTransaction.getTicket().getDueAmount());
            } else {
                posTransaction.setTenderAmount(posTransaction.getTicket().getDueAmount());
                posTransaction.setAmount(posTransaction.getTicket().getDueAmount());
            }
            String string = "";
            for (Ticket ticket : this.b) {
                string = string + "[" + ticket.getId() + "]";
            }
            string = string.substring(0, string.length() > 215 ? 215 : string.length());
            string = string + (string.length() == 215 ? "...." : "");
            posTransaction.getTicket().addProperty("GROUP_SETTLE_TICKETS", "#CHK " + string);
        } else {
            posTransaction.setTenderAmount(posTransaction.getTicket().getDueAmount());
            posTransaction.setAmount(posTransaction.getTicket().getDueAmount());
        }
    }

    public List<Ticket> getTickets() {
        return this.b;
    }

    public double getDueAmount() {
        return this.s;
    }

    private void b(double d) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException(Messages.getString("GroupSettleTicketDialog.8"));
            }
            for (Ticket ticket : this.b) {
                if (!ticket.hasGiftCard()) continue;
                POSMessageDialog.showMessage(Messages.getString("PaymentView.3"));
                return;
            }
            SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, this.f);
            swipeCardDialog.pack();
            swipeCardDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }
}

