/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.TaxExemptAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ButtonColumnWithLabel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.UpdatableView;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.StaleStateException;

public class SettleTicketDialog
extends POSDialog
implements RefreshableView,
UpdatableView,
TicketViewerTableChangeListener,
PaymentListener {
    private PaymentView b;
    private TicketViewerTable c;
    private JScrollPane d;
    private Ticket e;
    private JTextField f;
    private JTextField g;
    private JTextField h = new JTextField();
    private JTextField i = new JTextField();
    private JTextField j;
    private JTextField k;
    private JTextField l;
    private JTextField m;
    private JTextField n;
    private JTextField o;
    private JPanel p;
    private JPanel q;
    private JScrollPane r;
    private JPanel s;
    private SettleTicketProcessor t = null;
    private JTable u;
    private TicketDiscountTableModel v;
    private JPanel w;
    private JTable x;
    private TransactionDataTableModel y;
    private JLabel z;
    private JLabel A;
    private JLabel B;
    private JLabel C;
    private JButton D;
    JLabel a;

    public SettleTicketDialog(Ticket ticket, User user) {
        this.e = ticket;
        this.t = new SettleTicketProcessor(user, this);
        if (ticket.getOrderType().isConsolidateItemsInReceipt().booleanValue()) {
            ticket.consolidateTicketItems();
        }
        this.setTitle(Messages.getString("SettleTicketDialog.6"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.s = new JPanel(new BorderLayout(5, 5));
        this.s.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 5));
        this.c = new TicketViewerTable(ticket);
        this.c.getModel().addTicketDataChangeListener(this);
        this.c.setVisibleDeleteButton(0);
        this.c.getModel().setEditable(true);
        this.d = new PosScrollPane(this.c);
        TitledSeparator titledSeparator = new TitledSeparator((JComponent)this.a(), 0);
        this.d.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.c.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.p = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.p.add((Component)jPanel2, "Center");
        this.q = new JPanel((LayoutManager)new MigLayout("fill"));
        this.r = new JScrollPane(this.q);
        this.r.setPreferredSize(PosUIManager.getSize(0, 70));
        this.r.setVisible(false);
        this.p.add((Component)this.r, "North");
        this.s.add((Component)titledSeparator, "North");
        this.s.add((Component)this.d, "Center");
        this.s.add((Component)this.p, "South");
        this.b = new PaymentView(this.t, this);
        jPanel2.add((Component)this.g(), "East");
        this.getContentPane().add((Component)this.s, "Center");
        this.getContentPane().add((Component)this.b, "East");
        this.createTicketDiscountPanel();
        this.createTransactionListPanel();
        jPanel2.add((Component)this.w, "Center");
        this.t.addPaymentListener(this);
        this.updateView();
        this.b.setTicket(ticket);
        this.t.setTicket(ticket);
        this.b.setDefaultFocus();
        this.b.updateView();
    }

    @Override
    public void updateView() {
        if (this.e == null) {
            this.f.setText("");
            this.g.setText("");
            this.j.setText("");
            this.k.setText("");
            this.l.setText("");
            this.h.setText("");
            this.i.setText("");
            this.m.setText("");
            this.n.setText("");
            this.o.setText("");
            return;
        }
        this.b();
        this.f.setText(NumberUtil.formatNumber(this.e.getSubtotalAmount(), true));
        this.g.setText(NumberUtil.formatNumber(this.e.getDiscountAmount(), true));
        this.j.setText(NumberUtil.formatNumber(this.e.getDeliveryCharge()));
        this.l.setText(NumberUtil.formatNumberAcceptNegative(this.e.getServiceCharge()));
        Store store = DataProvider.get().getStore();
        if (POSUtil.getBoolean(store.getProperty("show_tax_exempt_button.in_settlement_screen"))) {
            this.D.setVisible(Boolean.TRUE);
            if (this.e.isTaxExempt().booleanValue()) {
                this.D.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.UNDO, (float)15.0f));
            } else {
                this.D.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
            }
        } else {
            this.D.setVisible(Boolean.FALSE);
        }
        if (this.e.isTaxIncluded().booleanValue()) {
            this.k.setText(Messages.getString("TicketView.35"));
        } else {
            this.k.setText(NumberUtil.formatNumber(this.e.getTaxAmount(), true));
        }
        if (this.e.getGratuity() != null) {
            this.n.setText(NumberUtil.formatNumber(this.e.getGratuity().getAmount()));
        } else {
            this.n.setText(NumberUtil.formatNumber(0));
        }
        double d = this.e.getRoundedAmount();
        this.o.setVisible(d != 0.0);
        this.a.setVisible(d != 0.0);
        this.n.setVisible(this.e.getGratuity() != null);
        this.C.setVisible(this.e.getGratuity() != null);
        this.l.setVisible(this.e.getServiceCharge() != 0.0);
        this.B.setVisible(this.e.getServiceCharge() != 0.0);
        this.o.setText(NumberUtil.formatNumber(d));
        Double d2 = this.e.getRefundAmount();
        this.h.setText(NumberUtil.formatNumber(d2));
        this.i.setText(NumberUtil.formatNumber(this.e.getPaidAmount()));
        this.m.setText(NumberUtil.formatNumber(this.e.getTotalAmountWithTips(), true));
        this.z.setVisible(d2 > 0.0);
        this.h.setVisible(d2 > 0.0);
        this.e();
        this.f();
        OrderView.getInstance().getOrderController().fireTicketEdited(this.e);
    }

    private JPanel a() {
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont().deriveFont(1);
        this.A = new JLabel();
        Font font2 = this.A.getFont().deriveFont(1);
        this.A.setFont(font2);
        jLabel.setFont(font);
        jLabel.setText(" " + Messages.getString("SettleTicketDialog.3"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(font2);
        if (!this.i().isShowTableNumber()) {
            jLabel2.setText(" " + this.e.getTableNames());
        } else {
            jLabel2.setText(" " + this.e.getTableNameDisplay());
            if (this.e.getTableNumbers() == null || this.e.getTableNumbers().isEmpty()) {
                jLabel2.setVisible(false);
                jLabel.setVisible(false);
            }
        }
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(font);
        jLabel3.setText(", " + Messages.getString("SettleTicketDialog.10") + ": ");
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(font2);
        String string = this.e.getCustomerNameByProperty();
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        jLabel4.setText(string);
        if (this.e.getProperty("CUSTOMER_NAME") == null) {
            jLabel4.setVisible(false);
            jLabel3.setVisible(false);
        }
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 0", "[]0[]0[]0[]0[]0[]", "[]"));
        transparentPanel.add(this.A);
        transparentPanel.add(jLabel);
        transparentPanel.add(jLabel2);
        transparentPanel.add(jLabel3);
        transparentPanel.add(jLabel4);
        Color color = UIManager.getColor("TitledBorder.titleColor");
        this.A.setForeground(color);
        jLabel.setForeground(color);
        jLabel2.setForeground(color);
        jLabel3.setForeground(color);
        jLabel4.setForeground(color);
        return transparentPanel;
    }

    private void b() {
        if (this.e.getTokenNo() > 0) {
            this.A.setText(String.valueOf(Messages.getString("SettleTicketDialog.0") + "# " + this.e.getTokenNo()));
        } else {
            this.A.setText(Messages.getString("SettleTicketDialog.13"));
        }
    }

    public void createTransactionListPanel() {
        this.w = new JPanel(new BorderLayout());
        this.x = new JTable();
        this.x.setGridColor(Color.LIGHT_GRAY);
        this.x.setCellSelectionEnabled(false);
        this.x.setColumnSelectionAllowed(false);
        this.x.setRowSelectionAllowed(false);
        this.x.setAutoscrolls(true);
        this.x.setRowHeight(PosUIManager.getSize(40));
        this.x.setShowVerticalLines(false);
        this.x.setIntercellSpacing(new Dimension(0, 2));
        this.x.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.x.setFocusable(false);
        this.x.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.x.getTableHeader().setVisible(false);
        this.x.setAutoResizeMode(4);
        this.y = new TransactionDataTableModel();
        this.x.setModel(this.y);
        this.a(1, PosUIManager.getSize(80), this.x);
        this.a(2, PosUIManager.getSize(50), this.x);
        this.a(3, PosUIManager.getSize(50), this.x);
        this.d();
        this.j();
        this.c();
        PosScrollPane posScrollPane = new PosScrollPane(this.x);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SettleTicketDialog.24")), BorderFactory.createEmptyBorder(0, 5, 0, 5));
        posScrollPane.setBorder(compoundBorder);
        this.w.add(posScrollPane);
        posScrollPane.setPreferredSize(PosUIManager.getSize(0, 130));
        this.w.setVisible(false);
        this.f();
    }

    private void c() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.y.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                SettleTicketDialog.this.b(posTransaction);
            }
        };
        posAction.setRequiredPermission(UserPermission.AUTHORIZE_TICKETS);
        ButtonColumn buttonColumn = new ButtonColumn(this.x, posAction, 1){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.y.getRowData(n);
                if (posTransaction.isCard() && posTransaction.isAuthorizable().booleanValue() && !posTransaction.isCaptured().booleanValue()) {
                    posButton.setText(Messages.getString("SettleTicketDialog.15"));
                    posButton.setHorizontalAlignment(0);
                    jTable.setRowHeight(n, jTable.getRowHeight(0));
                    return posButton;
                }
                return new JLabel("");
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.y.getRowData(n);
                if (posTransaction.isCard() && posTransaction.isAuthorizable().booleanValue() && !posTransaction.isCaptured().booleanValue()) {
                    return super.getTableCellEditorComponent(jTable, object, false, n, n2);
                }
                return new JLabel("");
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.x.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void d() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                if (!POSUtil.checkDrawerAssignment()) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.y.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                SettleTicketDialog.this.a(posTransaction);
            }
        };
        posAction.setRequiredPermission(UserPermission.VOID_PAYMENTS);
        ButtonColumn buttonColumn = new ButtonColumn(this.x, posAction, 3){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                posButton.setText("X");
                posButton.setHorizontalAlignment(0);
                jTable.setRowHeight(n, jTable.getRowHeight(0));
                return posButton;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.x.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void a(final PosTransaction posTransaction) {
        if (this.e.isRefunded().booleanValue()) {
            POSMessageDialog.showError(this, Messages.getString("SettleTicketDialog.25"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.26"), POSConstants.CONFIRM) != 0) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketDialog.18"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                TicketDAO.getInstance().reversePayment(SettleTicketDialog.this.e, posTransaction);
                ActionHistoryDAO.saveHistory(SettleTicketDialog.this.e, "Void payment", POSConstants.CHECK + "#:" + SettleTicketDialog.this.e.getId() + "," + Messages.getString("voided_payment") + posTransaction.getId() + "," + Messages.getString("voided_amount") + posTransaction.getAmount() + "," + Messages.getString("transaction_type") + posTransaction.buildPaymentTypeDisplayName());
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    busyDialog.dispose();
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.27"));
                    SettleTicketDialog.this.ticketDataChanged();
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketDialog.this.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void b(PosTransaction posTransaction) {
        try {
            if (!this.c(posTransaction)) {
                return;
            }
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            arrayList.add(posTransaction);
            AuthorizationDialog authorizationDialog = new AuthorizationDialog(this, arrayList);
            authorizationDialog.setVisible(true);
            this.e.closeIfApplicable();
            TicketDAO.getInstance().update(this.e);
            this.updateView();
        }
        catch (Exception exception) {
            this.e = TicketDAO.getInstance().loadFullTicket(this.e.getId());
            this.updateView();
            POSMessageDialog.showError(this, exception.getMessage());
            PosLog.error(this.getClass(), exception);
        }
    }

    private boolean c(PosTransaction posTransaction) {
        double d = posTransaction.getTipsAmount();
        double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), d, true);
        if (d2 == -1.0) {
            return false;
        }
        posTransaction.setTipsAmount(NumberUtil.round(d2));
        posTransaction.setAmount(NumberUtil.round(posTransaction.getAmount() - d + d2));
        if (this.e.hasGratuity()) {
            double d3 = this.e.getGratuity().getAmount();
            double d4 = this.e.getPaidAmount();
            double d5 = d3 - d + d2;
            double d6 = d4 - d + d2;
            this.e.setGratuityAmount(NumberUtil.round(d5));
            this.e.setPaidAmount(NumberUtil.round(d6));
        } else {
            this.e.setGratuityAmount(NumberUtil.round(d2));
            this.e.setPaidAmount(NumberUtil.round(this.e.getPaidAmount() + d2));
        }
        this.e.calculatePrice();
        return true;
    }

    public void createTicketDiscountPanel() {
        this.q = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 2 0 0 0"));
        this.u = new JTable();
        this.u.setGridColor(Color.LIGHT_GRAY);
        this.u.setCellSelectionEnabled(false);
        this.u.setColumnSelectionAllowed(false);
        this.u.setRowSelectionAllowed(false);
        this.u.setAutoscrolls(true);
        this.u.setRowHeight(PosUIManager.getSize(40));
        this.u.setShowGrid(true);
        this.u.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.u.setFocusable(false);
        this.u.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.u.getTableHeader().setVisible(false);
        this.u.setAutoResizeMode(4);
        this.v = new TicketDiscountTableModel();
        this.u.setModel(this.v);
        this.u.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                this.setHorizontalAlignment(4);
                if (bl) {
                    return component;
                }
                component.setBackground(jTable.getBackground());
                return component;
            }

            @Override
            protected void setValue(Object object) {
                if (object == null) {
                    this.setText("");
                    return;
                }
                String string = object.toString();
                if (object instanceof Double || object instanceof Float) {
                    string = NumberUtil.formatNumberAcceptNegative(((Number)object).doubleValue());
                }
                this.setText(string);
            }
        });
        this.a(1, PosUIManager.getSize(50), this.u);
        this.a(2, PosUIManager.getSize(175), this.u);
        this.u.removeColumn(this.u.getColumnModel().getColumn(1));
        JLabel jLabel = new JLabel(Messages.getString("SettleTicketDialog.30"));
        this.q.add((Component)jLabel, "wrap");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                TicketDiscount ticketDiscount = (TicketDiscount)SettleTicketDialog.this.v.getRowData(n);
                List<TicketDiscount> list = SettleTicketDialog.this.e.getDiscounts();
                if (list != null) {
                    Iterator<TicketDiscount> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TicketDiscount ticketDiscount2 = iterator.next();
                        if (ticketDiscount2 != ticketDiscount) continue;
                        iterator.remove();
                        ActionHistoryDAO.addDiscountRemovedActionHistory(SettleTicketDialog.this.e, ticketDiscount2);
                        break;
                    }
                    SettleTicketDialog.this.ticketDataChanged();
                }
                SettleTicketDialog.this.e.setDiscounts(list);
            }
        };
        new ButtonColumnWithLabel(this.u, abstractAction, 0, "delete-icon.png", false){

            @Override
            public boolean hasButtonAction(int n) {
                return true;
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.u);
        this.q.add((Component)jScrollPane, "newline,grow,span");
        jScrollPane.setPreferredSize(PosUIManager.getSize(0, 70));
        this.q.setVisible(false);
        this.p.add((Component)this.q, "North");
        this.e();
    }

    private void a(int n, int n2, JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void e() {
        List<TicketDiscount> list = this.e.getDiscounts();
        this.v.setRows(list);
        this.q.setVisible(list != null && list.size() > 0);
        this.s.revalidate();
        this.s.repaint();
        this.repaint();
    }

    private void f() {
        Set<PosTransaction> set = this.e.getTransactions();
        if (set == null || set.size() == 0) {
            return;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        for (PosTransaction posTransaction : set) {
            if (posTransaction.isVoided().booleanValue()) continue;
            arrayList.add(posTransaction);
        }
        Collections.sort(arrayList, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                if (posTransaction == null || posTransaction.getTransactionTime() == null) {
                    return -1;
                }
                if (posTransaction2 == null || posTransaction2.getTransactionTime() == null) {
                    return 1;
                }
                return posTransaction.getTransactionTime().compareTo(posTransaction2.getTransactionTime());
            }
        });
        this.y.setRows(arrayList);
        this.w.setVisible(arrayList.size() > 0);
        this.s.revalidate();
        this.s.repaint();
        this.repaint();
    }

    private JPanel g() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.f = new JTextField(10);
        this.f.setHorizontalAlignment(11);
        this.f.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.g = new JTextField(10);
        this.g.setHorizontalAlignment(11);
        this.g.setEditable(false);
        this.g.setText(this.e.getDiscountAmount().toString());
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText(Messages.getString("SettleTicketDialog.1") + " " + CurrencyUtil.getCurrencySymbol());
        this.j = new JTextField(10);
        this.j.setHorizontalAlignment(11);
        this.j.setEditable(false);
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.D = new JButton();
        this.D.setVisible(false);
        this.D.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
        this.D.addActionListener(actionEvent -> this.h());
        this.k = new JTextField(10);
        this.k.setEditable(false);
        this.k.setHorizontalAlignment(11);
        this.B = new JLabel();
        this.B.setHorizontalAlignment(4);
        this.B.setText(Messages.getString("SettleTicketDialog.2") + " " + CurrencyUtil.getCurrencySymbol());
        this.l = new JTextField(10);
        this.l.setEditable(false);
        this.l.setHorizontalAlignment(11);
        this.h.setEditable(false);
        this.h.setHorizontalAlignment(11);
        this.i.setEditable(false);
        this.i.setHorizontalAlignment(11);
        this.C = new JLabel();
        this.C.setHorizontalAlignment(4);
        this.C.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.a = new JLabel();
        this.a.setHorizontalAlignment(4);
        this.a.setText(Messages.getString("SettleTicketDialog.21") + ": " + CurrencyUtil.getCurrencySymbol());
        this.n = new JTextField(10);
        this.n.setEditable(false);
        this.n.setHorizontalAlignment(11);
        this.o = new JTextField(10);
        this.o.setEditable(false);
        this.o.setHorizontalAlignment(11);
        JLabel jLabel5 = new JLabel();
        jLabel5.setFont(jLabel5.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.m = new JTextField(10);
        this.m.setFont(this.m.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.m.setHorizontalAlignment(11);
        this.m.setEditable(false);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx,hidemode 3,ins 2 10 3 2,alignx trailing", "[grow]2[]", ""));
        transparentPanel.add((Component)jLabel, "growx,aligny center");
        transparentPanel.add((Component)this.f, "growx,aligny center");
        transparentPanel.add((Component)jLabel2, "newline,growx,aligny center");
        transparentPanel.add((Component)this.g, "growx,aligny center");
        transparentPanel.add((Component)this.B, "newline,growx,aligny center");
        transparentPanel.add((Component)this.l, "growx,aligny center");
        transparentPanel.add((Component)jLabel4, "newline,growx,aligny center");
        transparentPanel.add((Component)this.D, "growx,aligny center,split 2");
        transparentPanel.add((Component)this.k, "growx,aligny center");
        if (this.e.getDeliveryCharge() > 0.0) {
            transparentPanel.add((Component)jLabel3, "newline,growx,aligny center");
            transparentPanel.add((Component)this.j, "growx,aligny center");
        }
        transparentPanel.add((Component)this.C, "newline,growx,aligny center");
        transparentPanel.add((Component)this.n, "growx,aligny center");
        transparentPanel.add((Component)jLabel5, "newline,growx,aligny center");
        transparentPanel.add((Component)this.m, "growx,aligny center");
        transparentPanel.add((Component)this.a, "newline,growx,aligny center");
        transparentPanel.add((Component)this.o, "growx,aligny center");
        transparentPanel.add((Component)new JLabel(Messages.getString("SettleTicketDialog.36") + CurrencyUtil.getCurrencySymbol(), 11), "newline,growx,aligny center");
        transparentPanel.add((Component)this.i, "growx,aligny center");
        this.z = new JLabel(Messages.getString("SettleTicketDialog.37") + CurrencyUtil.getCurrencySymbol(), 11);
        transparentPanel.add((Component)this.z, "newline,growx,aligny center");
        transparentPanel.add((Component)this.h, "growx,aligny center");
        return transparentPanel;
    }

    private void h() {
        try {
            if (this.e.getPaidAmount() > 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CANNOT_CHENGED_TAX_EXAMPT"));
                return;
            }
            Boolean bl = this.e.isTaxExempt();
            String string = bl != false ? Messages.getString("SettleTicketDialog.19") : Messages.getString("SettleTicketDialog.4");
            int n = POSMessageDialog.showYesNoQuestionDialog(this, string, POSConstants.CONFIRM);
            if (n != 0) {
                return;
            }
            new TaxExemptAction(this.e, this, this.b).actionPerformed(null);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    @Override
    public void open() {
        super.open();
    }

    public Ticket getTicket() {
        return this.e;
    }

    public void setTicket(Ticket ticket) {
        this.e = ticket;
        this.t.setTicket(ticket);
        this.c.setTicket(ticket);
        this.b.setTicket(ticket);
    }

    @Override
    public void paymentCanceled() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void paymentDone() {
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
        this.b.updateView();
        this.c.updateView();
    }

    @Override
    public void discountUpdated() {
        this.updateView();
        this.b.updateView();
        this.c.updateView();
    }

    @Override
    public void gratuityUpdated() {
        this.updateView();
        this.b.updateView();
        this.c.updateView();
    }

    public SettleTicketProcessor getTicketProcessor() {
        return this.t;
    }

    public String getTransAmountInActualCurrency(PosTransaction posTransaction) {
        StringBuilder stringBuilder = new StringBuilder();
        if (ReceiptPrintService.isEnabledMulticurrency(this.e) && posTransaction != null && posTransaction.getPaymentType() != null && posTransaction.getPaymentType() == PaymentType.CASH) {
            String string = posTransaction.getProperty("paymentCurrencies");
            if (StringUtils.isNotBlank((String)string)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                List<MultiCurrencyTenderDialog.PaymentByCurrency> list = CurrencyUtil.createPaymentByCurrencies(string);
                for (MultiCurrencyTenderDialog.PaymentByCurrency object : list) {
                    if (object.tenderedAmount == 0.0 && object.cashBackAmount == 0.0) continue;
                    String string2 = object.currency.getSymbol();
                    if (object.paidAmount <= 0.0) continue;
                    arrayList.add(string2 + NumberUtil.formatNumber(object.paidAmount));
                }
                if (arrayList.size() > 0) {
                    Iterator<MultiCurrencyTenderDialog.PaymentByCurrency> iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)((Object)iterator.next());
                        stringBuilder.append(string3);
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(" + ");
                    }
                }
            } else {
                String string4;
                List<Currency> list = CurrencyUtil.getAllCurrency();
                Iterator<Currency> iterator = list.iterator();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Currency currency = iterator.next();
                    string4 = currency.getId() + "_TENDERED";
                    String string5 = currency.getId() + "_CASH_BACK";
                    String string6 = currency.getId() + "_PAID";
                    double d = 0.0;
                    String string7 = posTransaction.getProperty(string6);
                    d = StringUtils.isNotBlank((String)string7) ? NumberUtil.parseDouble(string7) : NumberUtil.parseDouble(posTransaction.getProperty(string4)) - NumberUtil.parseDouble(posTransaction.getProperty(string5));
                    if (d <= 0.0) continue;
                    arrayList.add(currency.getSymbol() + NumberUtil.formatNumber(d));
                }
                if (arrayList.size() > 0) {
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        string4 = (String)iterator2.next();
                        stringBuilder.append(string4);
                        if (!iterator2.hasNext()) continue;
                        stringBuilder.append(" + ");
                    }
                }
            }
        } else {
            stringBuilder.append(NumberUtil.getCurrencyFormat(posTransaction.getAmount()));
        }
        return stringBuilder.toString();
    }

    @Override
    public void ticketDataChanged() {
        this.e.calculatePrice();
        this.updateView();
        this.c.updateView();
        this.b.updateView();
    }

    private Terminal i() {
        return Application.getInstance().getTerminal();
    }

    @Override
    public void refresh() {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.getTicket().getId());
        this.setTicket(ticket);
        this.ticketDataChanged();
    }

    public void settleBartab() throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        int n;
        PosTransaction posTransaction = this.e.getBartabTransaction();
        if (posTransaction != null && !posTransaction.isCaptured().booleanValue() && !posTransaction.isVoided().booleanValue() && (n = POSMessageDialog.showYesNoQuestionDialog(this, string4 = Messages.getString("SettleTicketDialog.53"), string3 = Messages.getString("SettleTicketDialog.54"), string2 = Messages.getString("SettleTicketDialog.55"), string = Messages.getString("SettleTicketDialog.56"))) == 0) {
            this.d(posTransaction);
            return;
        }
        int n2 = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("SettleTicketDialog.57"), Messages.getString("SettleTicketDialog.58"), Messages.getString("SettleTicketDialog.59"), Messages.getString("Cancel"));
        if (n2 != 0) {
            POSMessageDialog.showMessage(Messages.getString("SettleTicketDialog.61"));
            this.setCanceled(true);
            this.dispose();
            return;
        }
        this.doVoidBartab(posTransaction);
    }

    private void d(PosTransaction posTransaction) throws Exception {
        OrderType orderType;
        ReceiptPrintService.printTicket(this.e);
        double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), 0.0);
        if (d > 0.0) {
            this.e.setGratuityAmount(d);
            this.e.calculatePrice();
            posTransaction.setTipsAmount(d);
        }
        Double d2 = this.e.getDueAmount();
        posTransaction.setTenderAmount(d2);
        posTransaction.setAmount(d2);
        this.t.setTenderAmount(d2);
        this.captureBartabTransaction(this.e, posTransaction);
        this.e.setPaidAmount(this.e.getPaidAmount() + posTransaction.getAmount());
        this.e.calculatePrice();
        d2 = this.e.getDueAmount() + posTransaction.getAmount();
        if (this.e.getDueAmount() == 0.0) {
            this.e.setPaid(true);
            orderType = this.e.getOrderType();
            if (orderType.isCloseOnPaid().booleanValue()) {
                this.e.setClosed(true);
                this.e.setClosingDate(new Date());
            }
        }
        orderType = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            orderType = session.beginTransaction();
            PosTransactionService.markItemsAsPaid(this.e);
            PosTransactionService.adjustMulticurrencyBalance(session, this.i(), Application.getCurrentUser().getActiveCashDrawer(), null, posTransaction);
            TicketDAO.getInstance().update(this.e, session);
            orderType.commit();
            this.t.doAfterSettleTask(posTransaction, d2, true);
        }
        catch (Exception exception) {
            if (orderType != null) {
                orderType.rollback();
            }
            throw exception;
        }
    }

    public boolean captureBartabTransaction(Ticket ticket, PosTransaction posTransaction) throws Exception {
        CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
        cardProcessor.captureAuthAmount(posTransaction);
        ticket.removeProperty("bartab.transaction.id");
        return true;
    }

    public void doVoidBartab(final PosTransaction posTransaction) throws Exception, PosException {
        if (posTransaction == null || posTransaction.isVoided().booleanValue() || posTransaction.isCaptured().booleanValue()) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketDialog.18"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                TicketDAO.getInstance().reversePreAuthorizedTabPayment(SettleTicketDialog.this.e, posTransaction);
                ActionHistoryDAO.saveHistory(SettleTicketDialog.this.e, "Void payment", POSConstants.CHECK + "#:" + SettleTicketDialog.this.e.getId() + "," + Messages.getString("voided_payment") + posTransaction.getId() + "," + Messages.getString("voided_amount") + posTransaction.getAmount() + "," + Messages.getString("transaction_type") + posTransaction.buildPaymentTypeDisplayName());
                return null;
            }

            @Override
            protected void done() {
                try {
                    busyDialog.dispose();
                    POSMessageDialog.showMessage(Messages.getString("SettleTicketDialog.62"));
                    SettleTicketDialog.this.ticketDataChanged();
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketDialog.this.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void j() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.y.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                SettleTicketDialog.this.e(posTransaction);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.x, posAction, 2){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                posButton.setText("Print");
                posButton.setHorizontalAlignment(0);
                jTable.setRowHeight(n, jTable.getRowHeight(0));
                return posButton;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.x.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void e(PosTransaction posTransaction) {
        if (ReceiptPrintService.hasNoReceiptPrinters()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
            return;
        }
        ReceiptPrintService.printTransaction(posTransaction, false);
    }

    public class TransactionDataTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionDataTableModel() {
            super(new String[]{"Payment", "Capture", "Print", "Void"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
            switch (n2) {
                case 0: {
                    Object object;
                    String string = " ";
                    if (posTransaction instanceof CustomPaymentTransaction) {
                        object = (CustomPaymentTransaction)posTransaction;
                        string = string + object.getCustomPaymentName();
                    } else {
                        string = string + (Object)((Object)posTransaction.getPaymentType());
                        object = posTransaction.getPaymentType();
                        if ((object == PaymentType.CREDIT_CARD || object == PaymentType.DEBIT_CARD) && StringUtils.isNotBlank((String)posTransaction.getCardNumber())) {
                            string = string + " [" + posTransaction.getCardNumber().replace("X", "") + "]";
                        }
                    }
                    object = posTransaction.getAmount();
                    if (posTransaction instanceof RefundTransaction) {
                        object = (Double)object * -1.0;
                        string = string + "   " + NumberUtil.getCurrencyFormat(object);
                        return Messages.getString("REFUND_BUTTON_TEXT") + " - " + string;
                    }
                    String string2 = CurrencyUtil.getCurrencySymbol() + NumberUtil.format(0);
                    if (!StringUtils.isEmpty((String)SettleTicketDialog.this.getTransAmountInActualCurrency(posTransaction))) {
                        string2 = SettleTicketDialog.this.getTransAmountInActualCurrency(posTransaction);
                    }
                    string = string + "   " + string2;
                    return string;
                }
                case 1: {
                    return Messages.getString("SettleTicketDialog.51");
                }
                case 2: {
                    return "Print";
                }
                case 3: {
                    return "X";
                }
            }
            return null;
        }
    }

    public class TicketDiscountTableModel
    extends ListTableModel<TicketDiscount> {
        public TicketDiscountTableModel() {
            super(new String[]{"name", "qty", "subtotal"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketDiscount ticketDiscount = (TicketDiscount)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return ticketDiscount.getNameDisplay();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return -ticketDiscount.getTotalDiscountAmount().doubleValue();
                }
            }
            return null;
        }
    }
}

