/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.util.NumberUtil;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonUtil {
    public static String getString(JsonObject jsonObject, String string) {
        if (!jsonObject.containsKey((Object)string)) {
            return null;
        }
        return jsonObject.getString(string);
    }

    public static Boolean getBoolean(JsonObject jsonObject, String string) {
        if (!jsonObject.containsKey((Object)string)) {
            return null;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return Boolean.valueOf(jsonValue.toString());
    }

    public static Integer getInt(JsonObject jsonObject, String string) {
        if (!jsonObject.containsKey((Object)string)) {
            return null;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).intValue();
            }
        }
        return Integer.parseInt(jsonValue.toString());
    }

    public static Double getDouble(JsonObject jsonObject, String string) {
        if (!jsonObject.containsKey((Object)string)) {
            return null;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).doubleValue();
            }
        }
        return NumberUtil.parseDouble(jsonValue.toString());
    }

    public static String getStringValue(JsonValue jsonValue) {
        if (jsonValue == JsonValue.NULL || jsonValue == null) {
            return null;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
        }
        return jsonValue.toString().replaceAll("\"", "");
    }

    public static int getIntValue(JsonValue jsonValue) {
        if (jsonValue == null) {
            return 0;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).intValue();
            }
        }
        return Integer.parseInt(jsonValue.toString().replaceAll("\"", ""));
    }

    public static double getDoubleValue(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.toString().equals("null")) {
            return 0.0;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).doubleValue();
            }
        }
        String string = jsonValue.toString().replaceAll("\"", "");
        return NumberUtil.parseDouble(string);
    }
}

